<?php
/**
 * @since jeans 1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title>
<?php
	global $page, $paged;

	wp_title( '|', true, 'right' );
	bloginfo( 'name' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'jeans' ), max( $paged, $page ) );

	?>
</title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<script type="text/javascript" src="http://code.jquery.com/jquery-latest.js"></script>
<script type="text/javascript" src="<?php echo get_template_directory_uri('template_url'); ?>/js/sidebar.js"></script>
<?php
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );
	wp_head();
?>
</head>

<body <?php body_class(); ?>>
<div id="header">
  <div id="headerContent">
    <h1><a href="<?php echo home_url();?>">
      <?php bloginfo('name');?>
      </a></h1>
    <div id="description">
      <?php bloginfo('description');?>
    </div>
    <div id="searchTop">
      <form method="get" id="searchform" action="<?php echo home_url(); ?>/">
        <input type="submit" id="searchsubmit" class="btnSearch" value="GO" />
        <input type="text" value="<?php the_search_query(); ?>" name="s" id="s" class="txtField" />
      </form>
    </div>
  </div>
  <!-- #headerContent -->
  
  <div id="menu">
    <div id="menuLeft"></div>
    <div id="menuRight"></div>
    <div id="nav">
      <?php wp_nav_menu( array('container_class' => 'menu-header', 'theme_location' => 'primary' ) ); ?>
    </div>
    <!-- #nav  --> 
  </div>
  <!-- #menu  --> 
  
</div>
<!-- #header -->

<div id="headerImg">
 <?php
					// Check if this is a post or page, if it has a thumbnail, and if it's a big one
					if ( is_singular() &&
							has_post_thumbnail( $post->ID ) &&
							( /* $src, $width, $height */ $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'post-thumbnail' ) ) &&
							$image[1] >= HEADER_IMAGE_WIDTH ) :
						// Houston, we have a new header image!
						echo get_the_post_thumbnail( $post->ID, 'post-thumbnail' );
					else : ?>
						<img src="<?php header_image(); ?>" width="<?php echo HEADER_IMAGE_WIDTH; ?>" height="<?php echo HEADER_IMAGE_HEIGHT; ?>" alt="" />
					<?php endif; ?>
</div>
<div id="content">