jQuery(document).ready(function($){
	
	/*check word*/
	var sTitleNum = $('#DXC-title-num b').html();
	CheckTitleNum( '#DXC-title', sTitleNum, '#DXC-title-num b' );
	
	var sContentNum = $('#DXC-content-num b').html();

	/*CheckContentNum( '#DXC-content', sContentNum, '#DXC-content-num b' );*/


	
	/*check title num*/
	function CheckTitleNum( obj, maxlen, num){
		$(obj).bind("keyup change",function(){
			var v = $(this).val();
			var curlen = v.length;
			if( curlen <= maxlen ){
				var sRemain = maxlen - parseInt(curlen);
				$(num).html(sRemain);
			}else{
			  var sStrSub = v.substring(0,maxlen);
			  $(this).val(sStrSub);
			}    
		})
	}
	
	/*check content num*/
	function CheckContentNum( obj, maxlen, num){
		$(obj).bind("keyup change",function(){
			var v = check_content();
			var curlen = v.length;
			if( curlen <= maxlen ){
				var sRemain = maxlen - parseInt(curlen);
				$(num).html(sRemain);
			}else{
			  var sStrSub = v.substring(0,maxlen);
			  $(this).val(sStrSub);
			}    
		})
	}
	
	/*check url*/
	function CheckUrl(str) {
		var RegUrl = new RegExp();
		RegUrl.compile("^[A-Za-z]+://[A-Za-z0-9-_]+\\.[A-Za-z0-9-_%&\?\/.=]+$");
		if ( RegUrl.test(str) ) {
			return str;
		}
		else if( str == '' ){
			return true;
		}
		else return false;
	}	

	/*ajax submit*/
	$('#DXC-submit').click(function(){
		var sTitle = check_title('#DXC-title');		/*get title*/		
		var sEmail = check_email("#DXC-email");		/*get email*/
		var sContent = check_content();				/*get content*/
		var sTags = $('#DXC-tags').val();			/*get tags*/
		var sUser = $('#DXC-user').val();			/*get user*/
		var sSite = CheckUrl( $('#DXC-site').val() );						/*get site url*/
		var sContent_num = $('#DXC-content-num b').html();
		
		/*check data*/
		if(!sTitle){
			alert('标题不能为空！');
		}
		else if(!sUser){
			alert('昵称不能为空！');
		}
		else if(!sEmail){
			alert('email格式不正确！');
		}
		else if( !sSite ){
			alert('站点url格式不正确！');
		}		
		else if(!sContent){
			alert('内容不能为空！');
		}
		else if( sContent.length > sContent_num ){
			alert('内容不能超过'+sContent_num+'字！');
		}
		else{
			$('#DXC-loading').css('display','block').html('提交中，请稍候...');
			ajax_get(sTitle,sTags,sEmail,sContent,sUser,sSite);
		}

	});
	
	/*get function*/
	function ajax_get(sTitle,sTags,sEmail,sContent,sUser,sSite){
		var sGetUrl = $('#blog-url').val()+'/?DX-Contribute=submit';
		var sMessage = $('#success-message').val();
		var sCat = $('#DXC-cat').val();
		$.get(
			sGetUrl,
			{
				DXC_title : sTitle,
				DXC_tags : sTags,
				DXC_email : sEmail,
				DXC_content : sContent,
				DXC_user : sUser,
				DXC_site : sSite,
				DXC_cat : sCat
			},
			function(data){
				$('#DXC-loading').css('display','none');
				if( data.substr( 0, 4 ) == 'stop' ){
						var sInterval = data.substr( 4 );
						alert('很抱歉，你提交太频繁了，请在 '+sInterval+' 秒后再提交！');
				}
				else if( data ){
					alert( sMessage );
				}
				else alert( 'ERROR!' );
			}
		);
	}
	
	/*check email function*/
	function check_email(obj){
		var search_str = /^[\w\-\.]+@[\w\-\.]+(\.\w+)+$/;
		var email_val = $(obj).val();
		if(!search_str.test(email_val)){
			return false;
		}else{
			return email_val;
		}
	}
	
	/*check title function*/
	function check_title(obj){
		var title = $(obj).val();
		if( title ) return title;
		else return false;
	}
	
	/*check content function*/
	function check_content(){
		if ($("#wp-DXC-content-wrap").hasClass("tmce-active")){
			var sContent = tinyMCE.activeEditor.getContent();
		}else{
			var sContent = $('#DXC-content').val();
		}
		return 	sContent;	
	}
	
});