<?php 
/*
Plugin Name: DX-Contribute
Plugin URI: http://www.daxiawp.com/dx-contribute.html
Description: The shortcut Submission wordpress plugin. 快捷投稿插件。
Version: 1.4.0
Author: 大侠wp
Author URI: http://www.daxiawp.com/dx-contribute.html

Copyright: daxiawp开发的原创插件，任何个人或团体不可擅自更改版权。

*/


//dx-contribute plugin class
class DX_Contribute{
	
	//hook
	function __construct(){
		add_shortcode( 'DX-Contribute', array( $this, 'contribute_page' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'init', array( $this, 'contribute' ) );
		add_action( 'init', array( $this, 'theme' ), 9999 );
		add_action( 'DXC_form_bottom', array( $this, 'contact' ) );
		add_filter( 'the_content', array( $this, 'contribute_metadata' ) );
		add_action ( 'publish_post', array( $this, 'publish' ) );
	}
	
	//contribute page content
	function contribute_page( $atts, $content ){
		include( 'contribute-page.php' );
		return $content;
	}
	
	//plugin menu page
	function menu_page(){
		add_menu_page( 'DX-Contribute','投稿', 'manage_options', 'DX-Contribute', array( $this, 'options_form' ), plugins_url( 'icon.png', __FILE__ ) );
	}
	
	//menu page options form
	function options_form(){
		include( 'options-form.php' );
	}
	
	//contribute form submit
	function contribute(){
		if( $_GET['DX-Contribute']=='submit' ){
			
			$DXC_options = get_option( 'DX-Contribute-options' );
			global $user_ID;
			$author = ( is_user_logged_in() ) ? $user_ID : $DXC_options['user'];
			session_start();
			$interval = abs( $_SESSION['DXC-interval'] - time() );
			
			if( $interval > $DXC_options['interval'] || empty( $_SESSION['DXC-interval'] ) ){
				$cat = ($DXC_options['select-cat']=='on') ? $_GET['DXC_cat'] : $DXC_options['category'];
				$cat = wp_filter_nohtml_kses( $cat );
				$args = array(
						'post_author' => $author,
						'post_category' => array( (int)$cat ), 
						'post_status' => 'pending',
						'post_type' => 'post',
						'tags_input' => wp_filter_nohtml_kses( $_GET['DXC_tags'] ),
						'post_title' => wp_filter_nohtml_kses( $_GET['DXC_title'] ),
						'post_content' => wp_filter_post_kses( $_GET['DXC_content'] )
				);
				$insert_id = wp_insert_post( $args );
				$_SESSION['DXC-interval'] = time();
				echo $insert_id;
				$meta_data = array(
					'user' => wp_filter_nohtml_kses( $_GET[ 'DXC_user' ] ),
					'email' => wp_filter_nohtml_kses( $_GET[ 'DXC_email' ] ),
					'site' => wp_filter_nohtml_kses( $_GET[ 'DXC_site' ] )
				);
				update_post_meta( $insert_id, '_DX_Contribute', $meta_data );
				wp_mail( get_option('admin_email'), '文章审核：'.wp_filter_nohtml_kses( $_GET['DXC_title'] ), wp_filter_post_kses( $_GET['DXC_content'] ) );	
			}
			else{
				echo 'stop'.abs( $DXC_options['interval']-$interval );					
			}
			exit;
		}
	}
	
	function theme(){
		if( !function_exists('_daxiawp_theme_menu_page') ) include_once( 'theme.php' );
	}
	
	function contact(){
?>
	<div class="daxiawp-contact">
		<p>插件介绍：<a href="http://www.daxiawp.com/dx-contribute.html" target="_blank">http://www.daxiawp.com/dx-contribute.html</a></p>
		<p>wordpress主题请访问<a href="http://www.daxiawp.com" target="_blank">daxiawp</a>，大量大侠wp制作的主题供选择。wordpress定制、仿站、插件开发请联系：<a target="_blank" href="http://wpa.qq.com/msgrd?v=3&uin=1683134075&site=qq&menu=yes"><img border="0" src="http://wpa.qq.com/pa?p=2:1683134075:44" alt="点击这里给我发消息" title="点击这里给我发消息">1683134075</a></p>
	</div>
<?php
	}
	
	//show contribute meta data
	function contribute_metadata( $content ){
		if( is_single() ){
			$DXC_options = get_option( 'DX-Contribute-options' );
			$pid = get_the_ID();
			$metas = get_post_meta( $pid, '_DX_Contribute', true );
			if( $DXC_options['meta-on'] = 'on' && $metas ){
				$avatar = get_avatar( $metas['email'], 25 );
				$url = ($metas['site'] == 'true') ? '' : $metas['site'];
				$user = $metas['user'];
				$site = ( $url ) ? '<a href="'.$url.'" rel="external nofollow" target="_blank">'.$user.'</a>' : '<a rel="nofollow">'.$user.'</a>';
				$style = '<style type="text/css">#contribute-metadata{line-height:25px;margin:10px 0;} #contribute-metadata img{display:block;float:left;margin-right:5px;}</style>';
				$meta_code = '<div id="contribute-metadata">'.$avatar.'<div id="contribute-site">'.$site.' 提交于'.get_the_time( 'Y-m-d H:i:s' ).'</div></div><div style="clear:both;"></div>';
				if( $DXC_options[ 'metapo' ]=='head' ){
					$content = $style.$meta_code.$content;
				}
				else $content .= $style.$meta_code;			
			}
		}
		return $content;
	}
	
	//publish and email
	function publish( $pid ){
		$metas = get_post_meta( $pid, '_DX_Contribute', true );
		$DXC_options = get_option( 'DX-Contribute-options' );
		if( $metas && $DXC_options['mail']=='send' ){
			$email = $metas[ 'email' ];
			$title = esc_attr( get_the_title( $pid ) );
			$url = get_permalink( $pid );
			$subject = $title. ' 审核通过！';
			$message = '您提交的文章”'.$title.'“已经审核通过，请通过以下链接浏览：'.$url;
			wp_mail( $email, $subject, $message );
		}
	}
	
}


new DX_contribute();