<?php
// 文章形式
add_theme_support( 'post-formats', array( 'aside','image','quote','video','audio' ) );

//支持外链缩略图
if (get_option('swt_suoluetu') == 'Display'){
if ( function_exists('add_theme_support') )
 add_theme_support('post-thumbnails');
function catch_first_image() {global $post, $posts;$first_img = '';
	ob_start();
	ob_end_clean();
	$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
	$first_img = $matches [1] [0];
	if(empty($first_img)){
		$random = mt_rand(1, 10);
		echo get_bloginfo ( 'stylesheet_directory' );
		echo '/images/random/'.$random.'.jpg';
		}
  return $first_img;};}

//分页
function par_pagenavi($range = 9){
	global $paged, $wp_query;
	if ( !$max_page ) {$max_page = $wp_query->max_num_pages;}
	if($max_page > 1){if(!$paged){$paged = 1;}
	if($paged != 1){echo "<a href='" . get_pagenum_link(1) . "' class='extend' title='跳转到首页'> 返回首页 </a>";}
	previous_posts_link(' 上一页 ');
    if($max_page > $range){
		if($paged < $range){for($i = 1; $i <= ($range + 1); $i++){echo "<a href='" . get_pagenum_link($i) ."'";
		if($i==$paged)echo " class='current'";echo ">$i</a>";}}
    elseif($paged >= ($max_page - ceil(($range/2)))){
		for($i = $max_page - $range; $i <= $max_page; $i++){echo "<a href='" . get_pagenum_link($i) ."'";
		if($i==$paged)echo " class='current'";echo ">$i</a>";}}
	elseif($paged >= $range && $paged < ($max_page - ceil(($range/2)))){
		for($i = ($paged - ceil($range/2)); $i <= ($paged + ceil(($range/2))); $i++){echo "<a href='" . get_pagenum_link($i) ."'";if($i==$paged) echo " class='current'";echo ">$i</a>";}}}
    else{for($i = 1; $i <= $max_page; $i++){echo "<a href='" . get_pagenum_link($i) ."'";
    if($i==$paged)echo " class='current'";echo ">$i</a>";}}
	next_posts_link(' 下一页 ');
    if($paged != $max_page){echo "<a href='" . get_pagenum_link($max_page) . "' class='extend' title='跳转到最后一页'> 最后一页 </a>";}}
};

//访问计数
function record_visitors(){
	if (is_singular()) {global $post;
	 $post_ID = $post->ID;
	  if($post_ID) 
	  {
		  $post_views = (int)get_post_meta($post_ID, 'views', true);
		  if(!update_post_meta($post_ID, 'views', ($post_views+1))) 
		  {
			add_post_meta($post_ID, 'views', 1, true);
		  }
	  }
	}
}
add_action('wp_head', 'record_visitors');  
function post_views($before = '(点击 ', $after = ' 次)', $echo = 1)
{
  global $post;
  $post_ID = $post->ID;
  $views = (int)get_post_meta($post_ID, 'views', true);
  if ($echo) echo $before, number_format($views), $after;
  else return $views;
};

//自定义头像
add_filter( 'avatar_defaults', 'fb_addgravatar' );
function fb_addgravatar( $avatar_defaults ) {
$myavatar = get_bloginfo('template_directory') . '/avatar/default.jpg';
  $avatar_defaults[$myavatar] = '使用jishuzh主题提供的默认头像';
  return $avatar_defaults;
};

//自定义HTML编辑器按钮
add_action('admin_print_scripts', 'my_quicktags');
function my_quicktags() {
    wp_enqueue_script(
        'my_quicktags',
        get_bloginfo('template_directory') . '/js/my-quicktags.js',
        array('quicktags')
    );
}

//评论回调函数
if ( ! function_exists( 'jishuzh_comment' ) ) :
function jishuzh_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case 'pingback' :
		case 'trackback' :
		// Display trackbacks differently than normal comments.
	?>
	<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
		<p><?php _e( 'Pingback:', 'jishuzh' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( __( '(Edit)', 'jishuzh' ), '<span class="edit-link">', '</span>' ); ?></p>
	<?php
			break;
		default :
		// Proceed with normal comments.
		global $post;
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>" class="comment item">
			<div class="comment-meta comment-author fl">
				<?php echo get_avatar( $comment, 44 );?>
			</div><!-- .comment-meta -->

			<div class="comment-content comment">
			<?php 
					printf( '<span class="myfn reviewer">%1$s %2$s</span>',
					get_comment_author_link(),
						// If current post author is also comment author, make it known visually.
					( $comment->user_id === $post->post_author ) ? '<span style="font-weight: normal;"> ' . __( '(Post author)　', 'jishuzh' ) . '</span>' : ''
					);
					edit_comment_link( __( 'Edit', 'jishuzh' ), '<span class="edit-link">', '</span>' );
			?>
				<span class="description"><?php comment_text(); ?></span>
			<?php if ( '0' == $comment->comment_approved ) : ?>
				<p class="comment-awaiting-moderation"><?php _e( '评论正在审核中...', 'jishuzh' ); ?></p>
			<?php endif; ?>
				<?php  
					printf( '<span class="datetime dtreviewed"><time class="value-title" title="%1$s" datetime="%1$s">%2$s</time></span>',
						get_comment_time( 'c' ),
						/* translators: 1: date, 2: time */
						sprintf( __( '%1$s　%2$s', 'jishuzh' ), get_comment_date(), get_comment_time() )
					);
				?>
				<span class="reply">
					<?php comment_reply_link( array_merge( $args, array( 'reply_text' => __( '　Reply', 'jishuzh' ),'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
				</span><!-- .reply -->
			</div><!-- .comment-content -->
		</div><!-- #comment-## -->
	<?php
		break;
	endswitch; // end comment_type check
}
endif;

//自定义表情地址并加入评论框
function custom_smilies_src($src, $img){return get_bloginfo('template_directory').'/images/smilies/' . $img;}
add_filter('smilies_src', 'custom_smilies_src', 10, 2);
add_filter( 'comment_form_logged_in_after', 'pmg_comment_tut_fields' );
add_filter( 'comment_form_after_fields', 'pmg_comment_tut_fields' );
function pmg_comment_tut_fields()
{
   include(TEMPLATEPATH . '/includes/smiley.php');
}

//avatar头像缓存
if (get_option('swt_type') == 'Display'){
function jishuzh_validate_gravatar($hashkey) {
	$uri = 'http://www.gravatar.com/avatar/' . $hashkey . '?d=404';
	$data = wp_cache_get($hashkey);
	if (false === $data) {
		$response = wp_remote_head($uri);
		if( is_wp_error($response) ) {
			$data = 'not200';
		} else {
			$data = $response['response']['code'];
		}
	    wp_cache_set($hashkey, $data, $group = '', $expire = 60*5);
	}		
	if ($data == '200'){
		return true;
	} else {
		return false;
	}
}
function jishuzh_get_cavatar($source) {
	$time = 1209600; //The time of cache(seconds)
	preg_match('/avatar\/([a-z0-9]+)\?s=(\d+)/',$source,$tmp);
	$abs = ABSPATH.'wp-content/themes/jishuzh/avatar/'.$tmp[1].'.jpg';
	$url = get_bloginfo('wpurl').'/wp-content/themes/jishuzh/avatar/'.$tmp[1].'.jpg';
	$default = get_bloginfo('wpurl').'/wp-content/themes/jishuzh/avatar/default.jpg';
	$hashkey=$tmp[1];
	if (!is_file($abs)||(time()-filemtime($abs))>$time){
		if(jishuzh_validate_gravatar($hashkey)){
		copy('http://www.gravatar.com/avatar/'.$tmp[1].'?s=32&d='.$default.'&r=G',$abs);}
		else {$url=$default;}
	}
	//if (filesize($abs)<500) { copy($default,$abs); }
	return '<img alt="" src="'.$url.'" class="avatar avatar-'.$tmp[2].'" width="'.$tmp[2].'" height="'.$tmp[2].'" />';
}
add_filter('get_avatar','jishuzh_get_cavatar');
}

//读者排行
function jishuzh_readers($out,$timer,$limit,$case){
	global $wpdb;    
	$query="SELECT COUNT(comment_ID) AS cnt, comment_author, comment_author_url, comment_author_email FROM (SELECT * FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->posts.ID=$wpdb->comments.comment_post_ID) WHERE comment_date > date_sub( NOW(), INTERVAL $timer MONTH ) AND user_id='0' AND comment_author_email != '".$out."' AND post_password='' AND comment_approved='1' AND comment_type='') AS tempcmt GROUP BY comment_author_email ORDER BY cnt DESC LIMIT $limit";
	$wall = $wpdb->get_results($query);
	foreach ($wall as $comment)
	{
	if( $comment->comment_author_url )
	$url = $comment->comment_author_url;
	else $url="#";
	$avatar = get_avatar( $comment, 36 );
	if ($case=='sidebar')
		$tmp = "<li><a rel=\"nofollow\" target=\"_blank\" title=\"".$comment->comment_author."\" href=\"".$comment->comment_author_url."\">".$avatar."<strong>".mb_strimwidth($comment->comment_author, 0, 10,"...")."</strong> <br/><em>+ ".$comment->cnt."个脚印</em><div class='clearfloat'></div></a></li>";
	else
		$tmp = "<li><a rel=\"nofollow\" target=\"_blank\" title=\"".$comment->comment_author."\" href=\"".$comment->comment_author_url."\">".$avatar."<em>".$comment->comment_author."</em> <strong>+".$comment->cnt."</strong><br/>".$comment->comment_author_url."</a></li>";
	$output .= $tmp;
	}
	if ($case=='sidebar')
		$output = "<ul class=\"sidebar-list\">".$output."<div class='clearfloat'></div></ul>";
	else
		$output = "<ul class=\"readers-list\">".$output."</ul>";
	echo $output ;
    }

//lightbox 自动对图片链接添加rel=lightbox属性
if (get_option('swt_lightbox') == 'Display'){
add_filter('the_content', 'pirobox_gall_replace',12);
function pirobox_gall_replace ($content)
{ global $post;
$pattern = "/<a(.*?)href=('|\")([^>]*).(bmp|gif|jpeg|jpg|png)('|\")(.*?)>(.*?)<\/a>/i";
$replacement = '<a$1href=$2$3.$4$5 rel="lightbox"$6>$7</a>';
$content = preg_replace($pattern, $replacement, $content);
return $content;
};}

//自动替换img for lazyload
function jishuzh_lazyload ($content)
{
	$placeholder = get_bloginfo('template_url')."/images/grey.gif"; //占位符图片
	$content = preg_replace( '#<img([^>]+?)src=[\'"]?([^\'"\s>]+)[\'"]?([^>]*)>#', sprintf( '<img${1}src="%s" data-original="${2}"${3}><noscript><img${1}src="${2}"${3}></noscript>', $placeholder ), $content );
	return $content;
};
add_filter('the_content', 'jishuzh_lazyload', 99);
add_filter('get_avatar', 'jishuzh_lazyload', 99);
add_filter('post_thumbnail_html', 'jishuzh_lazyload', 99);

//自动加nofollow
add_filter('the_content', 'my_nofollow',11);
function my_nofollow($content) {
    return preg_replace_callback('/<a[^>]+/', 'my_nofollow_callback', $content);
}
function my_nofollow_callback($matches) {
    $link = $matches[0];
    $site_link = get_bloginfo('url');

    if (strpos($link, 'rel') === false) {
        $link = preg_replace("%(href=\S(?!$site_link))%i", 'rel="nofollow" $1', $link);
    } elseif (preg_match("%href=\S(?!$site_link)%i", $link)) {
        $link = preg_replace('/rel=\S(?!nofollow)\S*/i', 'rel="nofollow"', $link);
    }
    return $link;
}

//文章目录
if (get_option('swt_mulu') == 'Display'){
function article_index($content) 
{
    $matches = array();
    $ul_li = '';
    $r = "/<(h[2-5])>([^<]+)<\/(h[2-5])>/im";
    if(preg_match_all($r, $content, $matches)) 
	{
        foreach($matches[2] as $num => $title) 
		{
			//if($num==0)
			if(true)
			{
				$content = str_replace($matches[0][$num], '<'.$matches[1][$num].' id="title-'.$num.'">'.$title.'</'.$matches[3][$num].'>', $content);
			}
			else
			{
				$content = str_replace($matches[0][$num], '<div id="content_title"><'.$matches[1][$num].' id="title-'.$num.'">'.$title.'</'.$matches[3][$num].'><span id="article-index-top"><a href="#article-index">top</a></span></div>', $content);
			}
			if($matches[1][$num] == 'h2')
				$ul_li .= '<li class="level2"><a href="#title-'.$num.'" title="'.$title.'">'.$title."</a></li>\n";
			else if($matches[1][$num] == 'h3')
				$ul_li .= '<li class="level3"><a href="#title-'.$num.'" title="'.$title.'">'.$title."</a></li>\n";
        }
        $content = '<div id="article-index">
					<div id="index-title"><span id="the-index-title">正文索引</span><span id="show-index">[ 隐藏 ]</span></div>
					<div id="index-ul"><ul>' . $ul_li . '</ul></div></div>' . $content;
    }
    return $content;
}
add_filter( "the_content", "article_index" );
}

//评论邮件提醒
if (get_option('swt_email') == 'Display'){
function comment_mail_notify($comment_id) {
  $comment = get_comment($comment_id);
  $parent_id = $comment->comment_parent ? $comment->comment_parent : '';
  $spam_confirmed = $comment->comment_approved;
  if (($parent_id != '') && ($spam_confirmed != 'spam')) {
    $wp_email = 'no-reply@' . preg_replace('#^www\.#', '', strtolower($_SERVER['SERVER_NAME'])); //e-mail 发出点, no-reply 可改为可用的 e-mail.
    $to = trim(get_comment($parent_id)->comment_author_email);
    $subject = '您在 [' . get_option("blogname") . '] 的留言有了回复';
    $message = '
    <div style="background-color:#eef2fa; border:1px solid #d8e3e8; color:#111; padding:0 15px; -moz-border-radius:5px; -webkit-border-radius:5px; -khtml-border-radius:5px;">
      <p>' . trim(get_comment($parent_id)->comment_author) . ', 您好!</p>
      <p>您曾在《' . get_the_title($comment->comment_post_ID) . '》的留言:<br />'
       . trim(get_comment($parent_id)->comment_content) . '</p>
      <p>' . trim($comment->comment_author) . ' 给您的回复:<br />'
       . trim($comment->comment_content) . '<br /></p>
      <p>您可以点击 <a href="' . htmlspecialchars(get_comment_link($parent_id)) . '">查看回复完整內容</a></p>
      <p>欢迎再度光临 <a href="' . get_option('home') . '">' . get_option('blogname') . '</a></p>
      <p>(由于服务器原因,我是不能收到您直接回复的邮件的,如果您还有问题,就到我的网站进行留言.)</p>
    </div>';
    $from = "From: \"" . get_option('blogname') . "\" <$wp_email>";
    $headers = "$from\nContent-Type: text/html; charset=" . get_option('blog_charset') . "\n";
    wp_mail( $to, $subject, $message, $headers );
    //echo 'mail to ', $to, '<br/> ' , $subject, $message; // for testing
  }
}
add_action('comment_post', 'comment_mail_notify');}

//归档函数
function jishuzh_archives_list() {
     if( !$output = get_option('jishuzh_archives_list') ){
         $output = '<div id="archives"><p>[<a id="al_expand_collapse" href="#">全部展开/收缩</a>] <em>(注: 点击月份可以展开)</em></p>';
         $the_query = new WP_Query( 'posts_per_page=-1&ignore_sticky_posts=1' ); //update: 加上忽略置顶文章
         $year=0; $mon=0; $i=0; $j=0;
         while ( $the_query->have_posts() ) : $the_query->the_post();
             $year_tmp = get_the_time('Y');
             $mon_tmp = get_the_time('m');
             $y=$year; $m=$mon;
             if ($mon != $mon_tmp && $mon > 0) $output .= '</ul></li>';
             if ($year != $year_tmp && $year > 0) $output .= '</ul>';
             if ($year != $year_tmp) {
                 $year = $year_tmp;
                 $output .= '<h3 class="al_year">'. $year .' 年</h3><ul class="al_mon_list">'; //输出年份
             }
             if ($mon != $mon_tmp) {
                 $mon = $mon_tmp;
                 $output .= '<li><span class="al_mon">'. $mon .' 月</span><ul class="al_post_list">'; //输出月份
             }
             $output .= '<li>'. get_the_time('d日: ') .'<a href="'. get_permalink() .'">'. get_the_title() .'</a> <em>('. get_comments_number('0', '1', '%') .')</em></li>'; //输出文章日期和标题
         endwhile;
         wp_reset_postdata();
         $output .= '</ul></li></ul></div>';
         update_option('jishuzh_archives_list', $output);
     }
     echo $output;
 }
 function clear_zal_cache() {
     update_option('jishuzh_archives_list', ''); // 清空 jishuzh_archives_list
 }
 add_action('save_post', 'clear_zal_cache'); // 新发表文章/修改文章时

//自定义摘要长度
function custom_excerpt_length( $length ) {
	return 400;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

//恢复链接管理
add_filter( 'pre_option_link_manager_enabled', '__return_true' );

//自定义菜单
   register_nav_menus(
      array(
         'header-menu' => __( '导航自定义菜单' ),
         'footer-menu' => __( '页脚自定义菜单' )
      )
   );

//小工具
if( function_exists('register_sidebar') ) {
	register_sidebar(array(
		'name' => __( '首页侧边栏' ),
		'before_widget' => '<div class="widget">',
		'after_widget' => '</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	));

		register_sidebar(array(
		'name' => __( '其他页侧边栏' ),
		'before_widget' => '<div class="widget">',
		'after_widget' => '</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	));

	register_sidebar(array(
		'name' => __( '滑动侧边栏' ),
		'before_widget' => '<div class="widget">',
		'after_widget' => '</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	));

	register_sidebar(array(
		'name' => __( '友情链接' ),
		'before_widget' => '<div class="link">',
		'after_widget' => '</div>',
		'before_title' => '<b>',
		'after_title' => '</b>',
	));

		register_sidebar(array(
		'name' => __( '正文右上广告位' ),
		'before_widget' => '<div class="adright fr">',
		'after_widget' => '</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	));
	
		register_sidebar(array(
		'name' => __( '正文下方广告位' ),
		'before_widget' => '<div class="ad">',
		'after_widget' => '</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	));
	
			register_sidebar(array(
		'name' => __( '头部logo右方广告位' ),
		'before_widget' => '<div class="adtop fr">',
		'after_widget' => '</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	));
};

include('includes/theme_options.php');
include('includes/mywidgets.php');
include('includes/shortcode.php');
//所有设置结束
?>