<?php   
//hotbyviews  
class hotbyviews extends WP_Widget{   
    function hotbyviews(){   
        $widget_ops = array('classname'=>'widget_hotbyviews','description'=>'按浏览量显示文章');   
        $this->WP_Widget(false,'主题工具 热门文章',$widget_ops);   
    }   
	
    function form($instance){   
        $instance = wp_parse_args((array)$instance,array( 'title'=>'热门文章','showPosts'=>10));   		
?>   
<p> 标题：<input class="widefat" id= "<?php echo $this->get_field_id('title'); ?>" name= "<?php echo $this->get_field_name('title'); ?>" value= "<?php echo $instance['title']; ?>" type= "text"  /> </p>   
<p> 显示文章数量：<input class="widefat" id= "<?php echo $this->get_field_id('showPosts'); ?>" name= "<?php echo $this->get_field_name('showPosts'); ?>" value= "<?php echo $instance['showPosts']; ?>" type= "text" /> </p>
<?php   
    }   
       
    function update($new_instance,$old_instance){   
        $instance = $old_instance;   
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['showPosts'] = strip_tags( $new_instance['showPosts'] );
        return $instance;   
    }   
       
    function widget($args,$instance){   
        extract($args);   
		$title = apply_filters('widget_title',empty($instance['title']) ? '热门文章' : $instance['title']);   
		$showPosts = empty($instance['showPosts']) ? 10 : $instance['showPosts']; 
        echo $before_widget;   
        echo $before_title . $title . $after_title;   
        echo '<ul>';   
?>
<?php $mostviewsPosts = new WP_Query();//实例化
		function filter_where( $where = '' ) {
		$where .= " AND post_date > '" . date('Y-m-d', strtotime('-90 days')) . "'";
		return $where;
		}
		add_filter( 'posts_where', 'filter_where' );
		$mostviewsPosts->query(array('orderby'=>'meta_value_num','meta_key'=>'views','showposts'=>$showPosts));
		remove_filter( 'posts_where', 'filter_where' );?>
		<?php while ($mostviewsPosts->have_posts()) : $mostviewsPosts->the_post(); ?>
			<li>
			<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo mb_strimwidth(get_the_title(), 0, 38,"..."); ?></a>
			</li>
		<?php endwhile; wp_reset_query();?>

<?php
        echo '</ul>';   
        echo $after_widget;   
    }   
}   

//randompost
class randompost extends WP_Widget{   
    function randompost(){   
        $widget_ops = array('classname'=>'widget_randompost','description'=>'随机显示文章');   
        $this->WP_Widget(false,'主题工具 随机推荐',$widget_ops);   
    }   
	
    function form($instance){   
        $instance = wp_parse_args((array)$instance,array( 'title'=>'随机推荐','showPosts'=>10));   		
?>   
<p> 标题：<input class="widefat" id= "<?php echo $this->get_field_id('title'); ?>" name= "<?php echo $this->get_field_name('title'); ?>" value= "<?php echo $instance['title']; ?>" type= "text"  /> </p>   

<p> 显示文章数量：<input class="widefat" id= "<?php echo $this->get_field_id('showPosts'); ?>" name= "<?php echo $this->get_field_name('showPosts'); ?>" value= "<?php echo $instance['showPosts']; ?>" type= "text" /> </p>     
<?php   
    }   
       
    function update($new_instance,$old_instance){   
        $instance = $old_instance;   
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['showPosts'] = strip_tags( $new_instance['showPosts'] );
        return $instance;   
    }   
       
    function widget($args,$instance){   
        extract($args);   
		$title = apply_filters('widget_title',empty($instance['title']) ? '随机推荐' : $instance['title']);   
		$showPosts = empty($instance['showPosts']) ? 10 : $instance['showPosts']; 
        echo $before_widget;   
        echo $before_title . $title . $after_title;   
        echo '<ul>';   
?>
<?php $randompost = new WP_Query();//实例化
		$randompost->query(array('orderby'=>'rand','showposts'=>$showPosts));?>
		<?php while ($randompost->have_posts()) : $randompost->the_post(); ?>
			<li>
			<a href="<?php the_permalink(); ?>" title="<?php the_title();?>"><?php echo mb_strimwidth(get_the_title(), 0, 38,"..."); ?></a>
			</li>
		<?php endwhile; wp_reset_query();?>

<?php
        echo '</ul>';   
        echo $after_widget;   
    }       
}   


//recentcomment
class recentcomment extends WP_Widget{   
    function recentcomment(){   
        $widget_ops = array('classname'=>'widget_recentcomment','description'=>'显示最新的评论');   
        $this->WP_Widget(false,'主题工具 最新评论',$widget_ops);   
    }   
	
    function form($instance){   
        $instance = wp_parse_args((array)$instance,array( 'title'=>'最新评论','showPosts'=>10));   		
?>   
<p> 标题：<input class="widefat" id= "<?php echo $this->get_field_id('title'); ?>" name= "<?php echo $this->get_field_name('title'); ?>" value= "<?php echo $instance['title']; ?>" type= "text"  /> </p>   
<p> 显示评论数量：<input class="widefat" id= "<?php echo $this->get_field_id('showPosts'); ?>" name= "<?php echo $this->get_field_name('showPosts'); ?>" value= "<?php echo $instance['showPosts']; ?>" type= "text" /> </p>     
<?php   
    }   
       
    function update($new_instance,$old_instance){   
        $instance = $old_instance;   
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['showPosts'] = strip_tags( $new_instance['showPosts'] );
        return $instance;   
    }   
       
    function widget($args,$instance){
        extract($args);   
		$title = apply_filters('widget_title',empty($instance['title']) ? '最新评论' : $instance['title']);   
		$showPosts = empty($instance['showPosts']) ? 10 : $instance['showPosts'];  
?>
<div class="r_comments">
<h3><?php echo $title; ?></h3>
	<ul>
		<?php
			$comments = get_comments( apply_filters( 'widget_comments_args', array( 'number' => $showPosts, 'status' => 'approve', 'post_status' => 'publish', 'user_id'=>'0', 'type'=>'comment' ) ) );
			$output = '';
			foreach ((array) $comments as $comment) {$output .= "\n<li>".get_avatar( $comment->comment_author_email, 32 )."<b><a href=\"" . esc_url( get_comment_link($comment->comment_ID) ) . "\" title=\"发表在： " .get_the_title($comment->comment_post_ID) . "\">" .$comment->comment_author."：</b><br />".mb_strimwidth(strip_tags($comment->comment_content), 0, 36,"...")."</a></li>";}
			echo $output;
		?>
	</ul>
</div>
<?php 
    }     
}   


//myrss
class myrss extends WP_Widget{   
    function myrss(){   
        $widget_ops = array('classname'=>'widget_myrss','description'=>'显示rss、联系方式和微博等');   
        $this->WP_Widget(false,'主题工具 rss等',$widget_ops);   
    }   
	
    function form($instance){   
        $instance=wp_parse_args((array)$instance,array('qq'=>'306242610','email'=>'306242610@qq.com','twitter'=>'https://twitter.com/unclezhou','tengxun'=>'http://t.qq.com/iamunclezhou','sina'=>'http://weibo.com/iamunclezhou','feed'=>'http://www.jishuzh.com/feed','feedid'=>'3e4b837b8f3e5e9941b72abb034d60e40fc62a693ed31717'));   		
?> 
<p> QQ：<input class="widefat" id= "<?php echo $this->get_field_id('qq'); ?>" name= "<?php echo $this->get_field_name('qq'); ?>" value= "<?php echo $instance['qq']; ?>" type= "text"  /> </p>   
<p> 邮箱：<input class="widefat" id= "<?php echo $this->get_field_id('email'); ?>" name= "<?php echo $this->get_field_name('email'); ?>" value= "<?php echo $instance['email']; ?>" type= "text" /> </p>  
<p> Twitter地址：<input class="widefat" id= "<?php echo $this->get_field_id('twitter'); ?>" name= "<?php echo $this->get_field_name('twitter'); ?>" value= "<?php echo $instance['twitter']; ?>" type= "text" /> </p>
<p> 腾讯微博地址：<input class="widefat" id= "<?php echo $this->get_field_id('tengxun'); ?>" name= "<?php echo $this->get_field_name('tengxun'); ?>" value= "<?php echo $instance['tengxun']; ?>" type= "text"  /> </p>   
<p> 新浪微博地址：<input class="widefat" id= "<?php echo $this->get_field_id('sina'); ?>" name= "<?php echo $this->get_field_name('sina'); ?>" value= "<?php echo $instance['sina']; ?>" type= "text" /> </p>
<p> 订阅地址：<input class="widefat" id= "<?php echo $this->get_field_id('feed'); ?>" name= "<?php echo $this->get_field_name('feed'); ?>" value= "<?php echo $instance['feed']; ?>" type= "text" /> </p>
<p> 腾讯邮件订阅ID：<input class="widefat" id= "<?php echo $this->get_field_id('feedid'); ?>" name= "<?php echo $this->get_field_name('feedid'); ?>" value= "<?php echo $instance['feedid']; ?>" type= "text"  /> </p>   
<?php   
    }   
       
    function update($new_instance,$old_instance){   
        $instance = $old_instance;
		$instance['qq'] =  $new_instance['qq'] ;
		$instance['email'] =  $new_instance['email'] ;
		$instance['twitter'] =  $new_instance['twitter'] ;
		$instance['tengxun'] =  $new_instance['tengxun'] ;
		$instance['sina'] =  $new_instance['sina'] ;
		$instance['feed'] =  $new_instance['feed'] ;
		$instance['feedid'] =  $new_instance['feedid'] ;
        return $instance;   
    }   
       
    function widget($args,$instance){
        extract($args); 
?>
<div class="feed-mail">
		<ul id="contact-li">
			<li class="qq"><a rel="nofollow" target="_blank" href="http://wpa.qq.com/msgrd?V=1&Menu=yes&Uin=<?php echo $instance['qq']; ?>" title="有急事请Q我">QQ联系</a></li>
			<li class="email"><a rel="nofollow" target="_blank" href="mailto:<?php echo $instance['email']; ?>" title="发邮件给我">邮件</a></li>
			<li class="twitter"><a rel="nofollow" target="_blank" href="<?php echo $instance['twitter']; ?>" title="收听我的Twitter微博">Twitter微博</a></li>
			<li class="qqmblog"><a rel="nofollow" target="_blank" href="<?php echo $instance['tengxun']; ?>" title="收听我的腾讯微博">腾讯微博</a></li>
			<li class="sinamblog"><a rel="nofollow" target="_blank" href="<?php echo $instance['sina']; ?>" title="收听我的新浪微博">新浪微博</a></li>
			<li class="rss"><a rel="nofollow" target="_blank" href="<?php echo $instance['feed']; ?>" title="通过RSS订阅我的博客">RSS订阅</a></li>
		</ul>
		<form action="http://list.qq.com/cgi-bin/qf_compose_send" target="_blank" method="post">
			<input type="hidden" name="t" value="qf_booked_feedback">
			<input type="hidden" name="id" value="<?php echo $instance['feedid']; ?>">
			<input id="to" onfocus="if (this.value == '输入邮箱 订阅本站') {this.value = '';}" onblur="if (this.value == '') {this.value = '输入邮箱 订阅本站';}" value="输入邮箱 订阅本站" name="to" type="text" class="feed-mail-input"><input class="feed-mail-btn" type="submit" value="订阅">
		</form>
</div>
<?php 
    }     
}   

//tjinfo  
class tjinfo extends WP_Widget{   
    function tjinfo(){   
        $widget_ops = array('classname'=>'widget_tjinfo','description'=>'显示博客统计信息');   
        $this->WP_Widget(false,'主题工具 统计信息',$widget_ops);   
    }   
	
    function form($instance){   
        $instance = wp_parse_args((array)$instance,array( 'title'=>'统计信息','showPosts'=>'2012-05-13'));   		
?>   
<p> 标题：<input class="widefat" id= "<?php echo $this->get_field_id('title'); ?>" name= "<?php echo $this->get_field_name('title'); ?>" value= "<?php echo $instance['title']; ?>" type= "text"  /> </p>
<p> 博客建立日期(例：2013-01-01)：<input class="widefat" id= "<?php echo $this->get_field_id('showPosts'); ?>" name= "<?php echo $this->get_field_name('showPosts'); ?>" value= "<?php echo $instance['showPosts']; ?>" type= "text" /> </p>
<?php   
    }   
       
    function update($new_instance,$old_instance){   
        $instance = $old_instance;   
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['showPosts'] = strip_tags( $new_instance['showPosts'] );
        return $instance;   
    }   
       
    function widget($args,$instance){   
        extract($args);   
		$title = apply_filters('widget_title',empty($instance['title']) ? '统计信息' : $instance['title']);   
		$showPosts = empty($instance['showPosts']) ? '2013-01-01' : $instance['showPosts'];  
?>
	<div class="widget r_tj">
		<h3>统计信息</h3>
			<ul>
			<li>博客运行： <?php echo floor((time()-strtotime($showPosts))/86400);?> 天</li>
			<li>发表文章： <?php $count_posts = wp_count_posts(); echo $published_posts = $count_posts->publish;?> 篇</li>
			<li>创建标签： <?php echo $count_tags = wp_count_terms('post_tag'); ?> 个</li>
			<li>网友评论： <?php $total_comments = get_comment_count(); echo $total_comments['approved'];?> 条</li>
			<li>访问页面： <?php global $wpdb; $views=$wpdb->get_results("SELECT SUM(meta_value) AS totalviews FROM $wpdb->postmeta WHERE meta_key = 'views'");echo $views[0]->totalviews; ?> 次</li>
			<li>最近更新： <?php global $wpdb; $last = $wpdb->get_results("SELECT MAX(post_modified) AS MAX_m FROM $wpdb->posts WHERE (post_type = 'post' OR post_type = 'page') AND (post_status = 'publish' OR post_status = 'private')");$last = date('Y年n月j日', strtotime($last[0]->MAX_m));echo $last; ?></li>
			</ul>
	</div>		
<?php 
    }   
}

//readers  
class readers extends WP_Widget{   
    function readers(){   
        $widget_ops = array('classname'=>'widget_readers','description'=>'显示活跃的读者');   
        $this->WP_Widget(false,'主题工具 读者墙',$widget_ops);   
    }   
	
    function form($instance){   
        $instance = wp_parse_args((array)$instance,array( 'title'=>'读者墙','showPosts'=>10,'time'=>3));   		
?>   
<p> 标题：<input class="widefat" id= "<?php echo $this->get_field_id('title'); ?>" name= "<?php echo $this->get_field_name('title'); ?>" value= "<?php echo $instance['title']; ?>" type= "text"  /> </p>   
<p> 时间范围：<input class="widefat" id= "<?php echo $this->get_field_id('time'); ?>" name= "<?php echo $this->get_field_name('time'); ?>" value= "<?php echo $instance['time']; ?>" type= "text" />个月内 </p>
<p> 显示数量：<input class="widefat" id= "<?php echo $this->get_field_id('showPosts'); ?>" name= "<?php echo $this->get_field_name('showPosts'); ?>" value= "<?php echo $instance['showPosts']; ?>" type= "text" /> </p>
<?php   
    }   
       
    function update($new_instance,$old_instance){   
        $instance = $old_instance;   
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['showPosts'] = strip_tags( $new_instance['showPosts'] );
		$instance['time'] = strip_tags( $new_instance['time'] );
        return $instance;   
    }   
       
    function widget($args,$instance){   
        extract($args);   
		$title = apply_filters('widget_title',empty($instance['title']) ? '读者墙' : $instance['title']);   
		$showPosts = empty($instance['showPosts']) ? 10 : $instance['showPosts']; 
		$time = empty($instance['time']) ? 3 : $instance['time']; 
        echo "<div class='sdreaders'>";   
        echo $before_title . $title . $after_title;   
        jishuzh_readers(get_bloginfo('admin_email'),$time,$showPosts,'sidebar');
        echo "</div>";   
    }   
}  

add_action('widgets_init', create_function('', 'return register_widget("hotbyviews");'));   
add_action('widgets_init', create_function('', 'return register_widget("randompost");'));   
add_action('widgets_init', create_function('', 'return register_widget("recentcomment");'));   
add_action('widgets_init', create_function('', 'return register_widget("myrss");'));   
add_action('widgets_init', create_function('', 'return register_widget("tjinfo");'));
add_action('widgets_init', create_function('', 'return register_widget("readers");'));
?>