<?php

class youku{
	public function __construct(){

		$this->config = get_option('ykv_config');
		$this->videos = get_option('ykv_videos') ? get_option('ykv_videos') : array();
		$this->notice = array();
		$this->base_dir = WP_PLUGIN_URL.'/'.dirname(plugin_basename(__FILE__));
		
		/**
		** 事件绑定
		**/
		
		add_action('init', array($this,'init'));
		add_action('admin_menu', array($this, 'admin_menu'));
		add_filter('plugin_action_links', array($this, 'plugin_action_link'), 10, 4);
	}

	/**
	 * 初始化
	 */
	 
	public function init(){
		if(is_user_logged_in() && is_admin()){
			$this->action_quest();
		}	
		if(empty($this->config)){
			$this->initialize_config();
		}
	}
	
	/**
	 * 显示后台菜单
	 */
	 
	public function admin_menu(){
		add_menu_page('优酷视频收藏设置', '优酷视频收藏', 'administrator', 'youku-videos', array($this,'youku_page'), $this->base_dir.'/images/youku.png');
		add_submenu_page('youku-videos', '添加视频', '添加视频', 'administrator', 'youku-newvideo', array($this,'youku_newvideo'));
		add_submenu_page('youku-videos', '插件设置', '插件设置', 'administrator', 'youku-option', array($this,'youku_option'));
	}
	
	public function youku_page(){
		@include 'class.wplisttable.php';
		@include 'youkumanage.php';
	}
	
	public function youku_newvideo(){
		@include 'youkunewvideo.php';
	}
	
	public function youku_option(){
		@include 'youkuoption.php';
	}	
	
	public function plugin_action_link($actions, $plugin_file, $plugin_data){
		if(strpos($plugin_file,'youku-videos')!==false && is_plugin_active($plugin_file)){
			unset($actions['edit']);$myactions = array('newvideo'=>'<a href="'.$this->get_menupage_url('youku-newvideo').'">添加视频</a>','option'=>'<a href="'.$this->get_menupage_url('youku-option').'">设置</a>');$actions = array_merge($myactions,$actions);
		}
		return $actions;
	}
	
	public function message(){
		$notice = $this->notice;
		if(!empty($notice)){
			switch ($notice["type"])
			{
				case "msg":
					echo '<div class="updated"><p>'.$notice["msg"].'</p></div>';
					break;  
				case "err":
					echo '<div id="message" class="error"><p>'.$notice["msg"].'</p></div>';
					break;
			}
		}
	}
	
	public function action_quest(){

		if( isset($_COOKIE['ykv_msg_'.COOKIEHASH]) ){
			$this->notice = array("type" => "msg","msg" => $_COOKIE['ykv_msg_'.COOKIEHASH]);setcookie('ykv_msg_'.COOKIEHASH, '', time()- 60*60*24, COOKIEPATH,COOKIE_DOMAIN);	
		}else if( isset($_COOKIE['ykv_err_'.COOKIEHASH]) ){
			$this->notice = array("type" => "err","msg" => $_COOKIE['ykv_msg_'.COOKIEHASH]);setcookie('ykv_err_'.COOKIEHASH, '', time()- 60*60*24, COOKIEPATH,COOKIE_DOMAIN);
		}else{
			$this->notice = array();
		}
	
		if( $_POST["action"]=="ykv-new-video" ){
			if( !wp_verify_nonce($_POST['ykvnonce'], "ykv-newvideo") ){
				setcookie('ykv_err_'.COOKIEHASH, '非法的请求！', time()+60, COOKIEPATH, COOKIE_DOMAIN);wp_safe_redirect($this->get_menupage_url("youku-newvideo"));exit();
			}
			
			$url = $_POST['new-url'];
			$title = trim(strip_tags($_POST['title']));
			preg_match("#https?://v\.youku\.com/v_show/id_(?<video_id>[a-z0-9_=\-]+)#i", $url, $match);
			
			if(empty($match)){
				setcookie('ykv_err_'.COOKIEHASH, '请输入正确的优酷视频地址！', time()+300, COOKIEPATH, COOKIE_DOMAIN);wp_safe_redirect($this->get_menupage_url("youku-newvideo"));exit();
			}
			
			$detail = $this->get_video_detail($match['video_id']);
			
			if(!$detail){
				setcookie('ykv_err_'.COOKIEHASH, '无法从优酷获取相关视频信息！', time()+300, COOKIEPATH, COOKIE_DOMAIN);wp_safe_redirect($this->get_menupage_url("youku-newvideo"));exit();
			}

			$videos = $this->videos;
			
			$new_video = array("ID" => "","title" => ($title? $title : $detail["title"]),"created" => (time()  + (60*60*get_settings("gmt_offset"))),"thumbnail" => $detail["thumbnail"],"youkuid" => $detail["youkuid"],"strtime" => $detail["seconds"]);
			
			$videos[] = $new_video;
			$this->update_videos($videos);
			
			setcookie('ykv_msg_'.COOKIEHASH, '已经成功添加  《'.$detail["title"].'》', time()+300, COOKIEPATH, COOKIE_DOMAIN);
			wp_safe_redirect($this->get_menupage_url("youku-videos"));
			exit();			
		}
		
		if( $_POST["action"]=="ykv-update-config" ){
			if( !wp_verify_nonce($_POST['ykvnonce'], "ykv-updateconfig") ){
				setcookie('ykv_err_'.COOKIEHASH, '非法的请求！', time()+60, COOKIEPATH, COOKIE_DOMAIN);wp_safe_redirect($this->get_menupage_url("youku-option"));exit();
			}
			
			$this->update_config(array("url" => trim($_POST["url"]),"number" => $_POST["number"],"time" => $_POST["time"],"css" => $_POST["css"],"js" => $_POST["js"]));
			
			setcookie('ykv_msg_'.COOKIEHASH, '已保存设置！', time()+300, COOKIEPATH, COOKIE_DOMAIN);
			wp_safe_redirect($this->get_menupage_url("youku-option"));
			exit();				
		}
		
		if( $_REQUEST["action"]=="ykv-delete"){
			if( !wp_verify_nonce($_REQUEST['ykvnonce'], "ykv-manage") ){
				setcookie('ykv_err_'.COOKIEHASH, '非法的请求！', time()+60, COOKIEPATH, COOKIE_DOMAIN);wp_safe_redirect($this->get_menupage_url("youku-videos"));exit();
			}
			$videos = $this->videos;
			$number = 1;
			if( is_array( $_REQUEST['videoid']) ){
				foreach($_REQUEST['videoid'] as $val){
					array_splice($videos, intval($val), 1);
				}
				$number = count($_REQUEST['videoid']);
			}else{
				array_splice($videos, intval($_REQUEST['videoid']), 1);
			}
			$this->update_videos($videos);
			
			setcookie('ykv_msg_'.COOKIEHASH, '成功删除'.$number.'个视频！', time()+300, COOKIEPATH, COOKIE_DOMAIN);
			wp_safe_redirect($this->get_menupage_url("youku-videos"));
			exit();				
		}
	}
	
	public function display(){
		$config = $this->config;
		$per_page = $config["number"];
		
		$videos = $this->videos;
		$videos = $this->reverse_array($videos);
		$count  = count($videos);
		$max_page = ceil($count/$per_page);

		$paged = get_query_var('paged') ? get_query_var('paged') : 1;
		$result = array_slice( $videos,( ( $paged-1 )* $per_page ), $per_page );
		
		$index = 0;
		echo "<!-- Start Youku Videos V1.0.0 --><div id='ykv_youku-video'><div class='ykv_video-group'><div class='ykv_video-clearfix'>";
		foreach($result as $val){
			$index++;
			$class = $index%3 == 0 ? "ykv_video ykv_video-last" : "ykv_video";
			?><a href="#<?php echo $val["youkuid"];?>" class="<?=$class;?>" title="<?php echo $val["title"];?>" youkuid="<?php echo $val["youkuid"];?>"><img class="ykv_video-image" src="<?php echo $val["thumbnail"];?>" alt="<?php echo $val["title"];?>" /><span class="ykv_video-text"><?php echo $val["title"];?></span><?php if($config["time"]) echo "<span class='ykv_video-date'>{$val["strtime"]}</span>";?></a><?php
			if( $index%3==0 && $index < $per_page) echo "</div></div><div class='ykv_video-group'><div class='ykv_video-clearfix'>";
		}
		echo "</div></div></div><div id='ykv_youku-pagenavi'>";
		$this->pagenavi($max_page, $paged);
		echo "</div><!-- End Youku Videos V1.0.0 -->";
	}
	
	// pagenavi
	private function pagenavi($max_page, $paged, $plus = 3){
		if ( $max_page == 1 ) return false;
		if ( $paged > 1 ) $this->page_link( $paged - 1, '« Previous');
		if ( $paged > $plus + 2 ) echo '... ';
		for( $i = $paged - $plus; $i <= $paged + $plus; $i++ ) { // 中间页
			if ( $i > 0 && $i <= $max_page ) $i == $paged ? print "<span class='ykv_page-youku current'>{$i}</span> " : $this->page_link( $i );
		}
		if ( $paged < $max_page - $plus - 1 ) echo '<span class="ykv_page-youku">...</span>';
		if ( $paged < $max_page ) $this->page_link( $paged + 1,'Next »');			
	}
	
	private function page_link($i, $title = ""){
		$config = $this->config;
		$page_link = $config["url"];
		if ( $title == '' ){$title = "第 {$i} 页";$linktext = $i;}else{$linktext = $title;}
		$link = $i > 1 ? (strpos($page_link, "?page_id") ? ($page_link."&paged=".$i): ($page_link.'/page/'.$i)) : $page_link;
		echo '<a class="ykv_page-youku" href="'.$link.'" title="'.$title.'">'.$linktext.'</a>';
	}	
	
	
	
	public function initialize_config(){
		$config = array(
			"url" => "",
			"number" => 12,
			"time" => 1,
			"css" => 0,
			"js" => 0
		);
		$this->update_config($config);
		$this->update_videos(array());
	}
	
	private function get_video_detail($youku_id){
		$link = "http://v.youku.com/player/getPlayList/VideoIDS/{$youku_id}/timezone/+08/version/5/source/out?password=&ran=2513&n=3";
		$ch=@curl_init($link);
		@curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$cexecute=@curl_exec($ch);
		@curl_close($ch);
		if ($cexecute) {
			$result = json_decode($cexecute,true);
			$json = $result['data'][0];
			$hour = floor( $json["seconds"]/3600 );
			$hour = $hour > 0 ? "{$hour}:" : "";
			$ltime = $hour . gmstrftime('%M:%S', $json["seconds"]);			
			$array = array("created" => time(),"thumbnail" => $json['logo'],"title" => $json['title'],"youkuid" => $youku_id,"seconds" => $ltime);
			return $array;
		} else {
			return false;
		}		
	}

	public function notice(){
		if( isset($_COOKIE['ykv_msg_'.COOKIEHASH]) ){
			$msg = $_COOKIE['ykv_msg_'.COOKIEHASH];
			echo '<div class="updated"><p>'.$msg.'</p></div>';
			setcookie('ykv_msg_'.COOKIEHASH, '', time()- 60*60*24, COOKIEPATH,COOKIE_DOMAIN);
		}
		if( isset($_COOKIE['ykv_err_'.COOKIEHASH]) ){
			$err = $_COOKIE['ykv_err_'.COOKIEHASH];
			echo '<div id="message" class="error"><p>'.$err.'</p></div>';
			setcookie('ykv_err_'.COOKIEHASH, '', time()- 60*60*24, COOKIEPATH,COOKIE_DOMAIN);
		}		
	}
	
	public function is_admin_access(){
		return current_user_can('manage_options');
	}
	
	public function get_menupage_url($pageslug){
		return site_url('/wp-admin/admin.php?page='.$pageslug);
	}

	public function update_config($config){
		$this->config = $config;
		update_option('ykv_config', $config);
	}

	public function update_videos($videos){
		$videos = $this->inset_array_id($videos);
		update_option('ykv_videos', $videos);
	}
	
	public function reverse_array($array){
		$new_array = array();
		$count = count($array);
		for($index=$count-1; $index>=0; $index--){
			$new_array[] = $array[$index];
		}		
		return $new_array;
	}
	
	public function inset_array_id($array){
		foreach($array as $key => $val){
			$array[$key]["ID"] = $key;
		}
		$this->videos = $array;
		return $array;
	}	
	
}

?>