<?php
// Translations can be filed in the /languages/ directory
load_theme_textdomain( 'themejunkie', TEMPLATEPATH . '/languages' );	

// Load functions.
require_once(TEMPLATEPATH . '/functions/theme-options.php');
require_once(TEMPLATEPATH . '/functions/social-bookmarks.php');
require_once(TEMPLATEPATH . '/functions/meta-box.php');
require_once(TEMPLATEPATH . '/functions/widget-ad125.php');
require_once(TEMPLATEPATH . '/functions/widget-ads.php');
require_once(TEMPLATEPATH . '/functions/widget-author.php');
require_once(TEMPLATEPATH . '/functions/widget-flickr.php');
require_once(TEMPLATEPATH . '/functions/widget-tabs.php');
require_once(TEMPLATEPATH . '/functions/widget-social.php');
require_once(TEMPLATEPATH . '/functions/widget-twitter.php');

if (function_exists('create_initial_post_types')) create_initial_post_types(); //fix for wp 3.0
if (function_exists('add_custom_background')) add_custom_background();
if (function_exists('add_post_type_support')) add_post_type_support( 'page', 'excerpt' );

/* MENUS */
add_action( 'init', 'tj_register_my_menu' );
if (function_exists('create_initial_post_types')) create_initial_post_types(); //fix for wp 3.0
if (function_exists('add_post_type_support')) add_post_type_support( 'page', 'excerpt' );
if(function_exists('add_theme_support')) add_theme_support( 'post-thumbnails' );


function tj_register_my_menu() {
   register_nav_menus(
      array(
         'header-pages' => __( 'Header Pages', 'themejunkie' ),
         'header-cats' => __( 'Header Categories', 'themejunkie' ),
      )
   );
}
/* MENUS END */

// Filter to new excerpt length
function tj_excerpt_length( $length ) {
	return 30;
}
add_filter( 'excerpt_length', 'tj_excerpt_length' );

// Filter to new excerpt more text
function tj_excerpt_more($post) {
	return '... <span class="meta-more"><a href="'. get_permalink($post->ID) . '">'.__('Read more &raquo;','themejunkie').'</a></span>';
}
add_filter('excerpt_more', 'tj_excerpt_more');

// Filter to fix first page redirect
add_filter('redirect_canonical', 'fixpageone');

function fixpageone($redirect_url) {
	if(get_query_var('paged') == 1)
		$redirect_url = '';
	return $redirect_url;
}

// Register Widgets
function tj_widgets_init() {
	
	
	// General Sidebar
	register_sidebar( array (
		'name' => __( 'Sidebar', 'themejunkie' ),
		'id' => 'sidebar',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => "</div>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// Sidebar Left
	register_sidebar( array (
		'name' => __( 'Sidebar Left', 'themejunkie' ),
		'id' => 'sidebar-left',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => "</div>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// Sidebar Right
	register_sidebar( array (
		'name' => __( 'Sidebar Right', 'themejunkie' ),
		'id' => 'sidebar-right',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => "</div>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
		
	
	// Footer Widget Area 1
	register_sidebar( array (
		'name' => __( 'Footer Widget Area 1', 'themejunkie' ),
		'id' => 'footer-widget-area-1',
		'description' => __( 'The bottom widget area', 'themejunkie' ),
		'before_widget' => '<div id="%1$s" class="fwidget %2$s">',
		'after_widget' => "</div>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// Footer Widget Area 2
	register_sidebar( array (
		'name' => __( 'Footer Widget Area 2', 'themejunkie' ),
		'id' => 'footer-widget-area-2',
		'description' => __( 'The bottom widget area', 'themejunkie' ),
		'before_widget' => '<div id="%1$s" class="fwidget %2$s">',
		'after_widget' => "</div>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// Footer Widget Area 3
	register_sidebar( array (
		'name' => __( 'Footer Widget Area 3', 'themejunkie' ),
		'id' => 'footer-widget-area-3',
		'description' => __( 'The bottom widget area', 'themejunkie' ),
		'before_widget' => '<div id="%1$s" class="fwidget %2$s">',
		'after_widget' => "</div>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// Footer Widget Area 4
	register_sidebar( array (
		'name' => __( 'Footer Widget Area 4', 'themejunkie' ),
		'id' => 'footer-widget-area-4',
		'description' => __( 'The bottom widget area', 'themejunkie' ),
		'before_widget' => '<div id="%1$s" class="fwidget %2$s">',
		'after_widget' => "</div>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}
add_action( 'init', 'tj_widgets_init' );


// Register and deregister Stylesheet and Scripts files	
if(!is_admin()) {
	add_action( 'wp_print_styles', 'my_deregister_styles', 100 );
	add_action( 'wp_print_scripts', 'my_deregister_scripts', 100 );
}

// add_filter('pre_get_posts', 'custom_post_filter');	
function custom_post_filter($query) {
	if(is_home()) {
		$postnum = get_theme_mod('home_postnum');
		$postnumb = !empty($postnum) ? $postnum : 6;
		$query->set('posts_per_page', $postnum);
	}
}

function my_deregister_styles() {
	$color_scheme = get_theme_mod('color_scheme');
	if($color_scheme == 'Blue') 
		wp_enqueue_style('blue',get_bloginfo('template_url').'/skins/blue.css');
	elseif($color_scheme == 'Brown') 
		wp_enqueue_style('brown',get_bloginfo('template_url').'/skins/brown.css');
	elseif($color_scheme == 'Red')
		wp_enqueue_style('red',get_bloginfo('template_url').'/skins/red.css');
	elseif($color_scheme == 'Green')
		wp_enqueue_style('green',get_bloginfo('template_url').'/skins/green.css');
	elseif($color_scheme == 'Yellow')
		wp_enqueue_style('blue',get_bloginfo('template_url').'/skins/blue.css');
	elseif($color_scheme == 'Aqua')
		wp_enqueue_style('aqua',get_bloginfo('template_url').'/skins/aqua.css');
	elseif($color_scheme == 'Gray')
		wp_enqueue_style('gray',get_bloginfo('template_url').'/skins/gray.css');
	elseif($color_scheme == 'Pink')
		wp_enqueue_style('pink',get_bloginfo('template_url').'/skins/pink.css');
	elseif($color_scheme == 'Purple')
		wp_enqueue_style('purple',get_bloginfo('template_url').'/skins/purple.css');
	elseif($color_scheme == 'Orange')
		wp_enqueue_style('orange',get_bloginfo('template_url').'/skins/orange.css');
 }
 	
function my_deregister_scripts() {
		wp_deregister_script( 'jquery' );
		
		wp_enqueue_script('jquery', get_bloginfo('template_url').'/js/jquery.min.js', true, '1.4.3');
		wp_enqueue_script('jquery-cookie', get_bloginfo('template_url').'/js/jcookie.js', array('jquery'), '0.1');
		wp_enqueue_script('jquery-superfish', get_bloginfo('template_url').'/js/superfish.js', array('jquery'), '1.0');
		wp_enqueue_script('jquery-global', get_bloginfo('template_url').'/js/global.js', array('jquery'), '1.0');
		wp_enqueue_script('jquery-nivo', get_bloginfo('template_url').'/js/jquery.nivo.slider.pack.js', array('jquery'), '1.0');
		wp_enqueue_script('scrolltopcontrol', get_bloginfo('template_url').'/js/scrolltopcontrol.js', array('jquery'), '1.1');

		if ( is_singular() && get_option('thread_comments') ) wp_enqueue_script( 'comment-reply' );
	}

// Pagenavi
function tj_pagenavi($range = 4) {
	global $paged, $wp_query;
	if ( !$max_page ) { $max_page = $wp_query->max_num_pages;}
	if($max_page > 1){
		echo '<div class="pagenavi clear">';
		if(!$paged){$paged = 1;}
		echo '<span class="pages">'.$paged.' / '.$max_page.'</span>';
		previous_posts_link('&laquo; Previous');
		if($max_page > $range){
			if($paged < $range){
				for($i = 1; $i <= ($range + 1); $i++){
					echo "<a href='" . get_pagenum_link($i) ."'";
					if($i==$paged) echo " class='current'";
					echo ">$i</a>";

				}
			} elseif($paged >= ($max_page - ceil(($range/2)))){
				for($i = $max_page - $range; $i <= $max_page; $i++){
					echo "<a href='" . get_pagenum_link($i) ."'";
					if($i==$paged) echo " class='current'";
					echo ">$i</a>";
				}
			} elseif($paged >= $range && $paged < ($max_page - ceil(($range/2)))){
				for($i = ($paged - ceil($range/2)); $i <= ($paged + ceil(($range/2))); $i++){
					echo "<a href='" . get_pagenum_link($i) ."'";
					if($i==$paged) echo " class='current'";
					echo ">$i</a>";
				}
			}
		} else {
			for($i = 1; $i <= $max_page; $i++){
				echo "<a href='" . get_pagenum_link($i) ."'";
				if($i==$paged) echo " class='current'";
				echo ">$i</a>";
			}
		}
		next_posts_link('Next &raquo;');
		echo '</div>';
	}
}

// Breadcrumb
function tj_breadcrumb() {
	 $delimiter = '';
  $name = 'Home'; //text for the 'Home' link
  $currentBefore = '<span class="current">';
  $currentAfter = '</span>';
	echo '<span class="tip">Browse:</span>';
 
    global $post;
    $home = get_bloginfo('url');
   
	if(is_home() && get_query_var('paged') == 0) 
		echo '<span class="home">' . $name . '</span>';
	else
		echo '<a class="home" href="' . $home . '">' . $name . '</a> '. $delimiter . ' ';
 
    if ( is_category() ) {
      global $wp_query;
      $cat_obj = $wp_query->get_queried_object();
      $thisCat = $cat_obj->term_id;
      $thisCat = get_category($thisCat);
      $parentCat = get_category($thisCat->parent);
      if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
      echo $currentBefore;
      single_cat_title();
      echo $currentAfter;
 
    } elseif ( is_day() ) {
      echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
      echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';
      echo $currentBefore . get_the_time('d') . $currentAfter;
 
    } elseif ( is_month() ) {
      echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
      echo $currentBefore . get_the_time('F') . $currentAfter;
 
    } elseif ( is_year() ) {
      echo $currentBefore . get_the_time('Y') . $currentAfter;
 
    } elseif ( is_single() ) {
      $cat = get_the_category(); $cat = $cat[0];
      echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
      echo $currentBefore;
      the_title();
      echo $currentAfter;
 
    } elseif ( is_page() && !$post->post_parent ) {
      echo $currentBefore;
      the_title();
      echo $currentAfter;
 
    } elseif ( is_page() && $post->post_parent ) {
      $parent_id  = $post->post_parent;
      $breadcrumbs = array();
      while ($parent_id) {
        $page = get_page($parent_id);
        $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
        $parent_id  = $page->post_parent;
      }
      $breadcrumbs = array_reverse($breadcrumbs);
      foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
      echo $currentBefore;
      the_title();
      echo $currentAfter;
 
    } elseif ( is_search() ) {
      echo $currentBefore . 'Search for ' . get_search_query() . $currentAfter;
 
    } elseif ( is_tag() ) {
      echo $currentBefore;
      single_tag_title();
      echo $currentAfter;
 
    } elseif ( is_author() ) {
       global $author;
      $userdata = get_userdata($author);
      echo $currentBefore. $userdata->display_name . $currentAfter;
 
    } elseif ( is_404() ) {
      echo $currentBefore . 'Error 404' . $currentAfter;
    }
 
    if ( get_query_var('paged') )
      echo $currentBefore . __('Page') . ' ' . get_query_var('paged') . $currentAfter;
 

}

if ( function_exists( 'add_image_size' ) ) { 
	add_image_size(get_theme_mod('thumb_key'),get_theme_mod('thumb_width'), get_theme_mod('thumb_height'),true);
	add_image_size(get_theme_mod('featured_thumb_key'),get_theme_mod('featured_thumb_width'),get_theme_mod('featured_thumb_height'),true);
}

// Get image attachment (sizes: thumbnail, medium, full)
function get_thumbnail($postid=0, $size='full',$thumb_key='') {
	if ($postid<1) 
	$postid = get_the_ID();
	
	if($thumb_key)
		$thumb_key = $thumb_key;
	else
		$thumb_key = 'thumb';
	$thumb = get_post_meta($postid, $thumb_key, TRUE); // Declare the custom field for the image
	
	if(version_compare(get_bloginfo('version'), '2.9') >= 0) {
		if(!$thumb && has_post_thumbnail($postid) && function_exists( 'the_post_thumbnail' ) ) {
			$post_thumbnail_id = get_post_thumbnail_id( $post_id );
			$image = wp_get_attachment_image_src( $post_thumbnail_id, $size );
			$thumb = $image[0];
		}
	}

	if ($thumb != null or $thumb != '') {
		return $thumb; 
	} elseif ($images = get_children(array(
		'post_parent' => $postid,
		'post_type' => 'attachment',
		'numberposts' => '1',
		'post_mime_type' => 'image', ))) {
		foreach($images as $image) {
			$thumbnail=wp_get_attachment_image_src($image->ID, $size);
			return $thumbnail[0]; 
		}
	} else {
		if($default)
			return $default;
	}
	
}

// Automatically display/resize thumbnail
function tj_thumbnail($width, $height) {
	echo '<a href="'.get_permalink($post->ID).'" rel="bookmark"><img src="'.get_bloginfo('template_url').'/timthumb.php?src='.get_thumbnail($post->ID, 'full').'&amp;h='.$height.'&amp;w='.$width.'&amp;a=t&amp;zc=1" alt="'.get_the_title().'" /></a>';
}

// Get limit excerpt
function tj_content_limit($max_char, $more_link_text = '', $stripteaser = 0, $more_file = '') {
    $content = get_the_content($more_link_text, $stripteaser, $more_file);
    $content = apply_filters('the_content', $content);
    $content = str_replace(']]>', ']]&gt;', $content);
    $content = strip_tags($content);

   if (strlen($_GET['p']) > 0) {
      echo "";
      echo $content;
      echo "...";
   }
   else if ((strlen($content)>$max_char) && ($espacio = strpos($content, " ", $max_char ))) {
        $content = substr($content, 0, $espacio);
        $content = $content;
        echo "";
        echo $content;
        echo "...";
   }
   else {
      echo "";
      echo $content;
   }
}


add_filter('post_class', 'custom_post_class');
function custom_post_class($classes) {	
	global $wp_query;
	$classes[] = ( ($wp_query->current_post+1) % 2 ) ? 'odd' : 'even alt';
	
	return $classes;
}

// Return number of posts in a Archive Page
function tj_current_postnum() {
	global $wp_query;
	$request = $wp_query->request;
	$posts_per_page = intval(get_query_var('posts_per_page'));
	$paged = intval(get_query_var('paged'));
	$numposts = $wp_query->found_posts;
	$max_page = $wp_query->max_num_pages;
	if(empty($paged) || $paged == 0) $paged = 1;
	if (!is_404()) 
		$begin_postnum = (($paged-1)*$posts_per_page)+1; 
	else 
		$begin_postnum = '0';
	if ($paged*$posts_per_page < $numposts) 
		$end_postnum = $paged*$posts_per_page; 
	else 
		$end_postnum = $numposts;
	$current_page_postnum = $end_postnum-$begin_postnum+1;
	return $current_page_postnum;
}

// Tabber: Get Most Popular Posts
function tj_tabs_popular( $posts = 5, $size = 48 ) {
wp_reset_query();
if(empty($posts)) $posts = 5;
if(empty($size)) $size = 48;
	$popular = new WP_Query('caller_get_posts=1&orderby=comment_count&posts_per_page='.$posts);
	while ($popular->have_posts()) : $popular->the_post();
?>
<li class="clear">
 	<?php
				$thumb = get_thumbnail($post->ID, get_theme_mod('thumb_key'),get_theme_mod('thumb_key'));
										
				if(!$thumb)	
					$thumb = get_bloginfo('template_url').'/images/default-thumb.gif';
					
				$url = get_bloginfo('template_url').'/timthumb.php?src='.$thumb.'&amp;h='.$size.'&amp;w='.$size.'&amp;a=t&amp;zc=1';
				echo '<a  class="entry-thumb"href="'.get_permalink().'" title="'.the_title_attribute( 'echo=0' ).'"><img width="'.$size.'" height="'.$size.'" src="'.$url.'" alt="'.get_the_title().'" /></a>';
			?>
 	<div class="info">
 	<a title="<?php the_title(); ?>" href="<?php the_permalink() ?>"><?php the_title(); ?></a>
 	<span class="meta"><?php comments_popup_link('0 Comment', '1 Comment', '% Comments', 'comments-link', ''); ?></span>
	</div> <!--end .info-->
</li>
<?php endwhile; 
}

function tj_tabs_latest( $posts = 5, $size = 48 ) {
if(empty($posts)) $posts = 5;
if(empty($size)) $size = 48;
	$the_query = new WP_Query('caller_get_posts=1&showposts='. $posts .'&orderby=post_date&order=desc');	
	while ($the_query->have_posts()) : $the_query->the_post(); 
?>
<li class="clear">
	<?php if ($size <> 0) ?>
	<?php
				$thumb = get_thumbnail($post->ID, get_theme_mod('thumb_key'),get_theme_mod('thumb_key'));
										
				if(!$thumb)	
					$thumb = get_bloginfo('template_url').'/images/default-thumb.gif';
					
				$url = get_bloginfo('template_url').'/timthumb.php?src='.$thumb.'&amp;h='.$size.'&amp;w='.$size.'&amp;a=t&amp;zc=1';
				echo '<a  class="entry-thumb"href="'.get_permalink().'" title="'.the_title_attribute( 'echo=0' ).'"><img width="'.$size.'" height="'.$size.'" src="'.$url.'" alt="'.get_the_title().'" /></a>';
			?>
	<div class="info">
	<a title="<?php the_title(); ?>" href="<?php the_permalink() ?>"><?php the_title(); ?></a>
	<span class="meta"><?php the_time('F j, Y'); ?></span>
	</div> <!--end .info-->
</li>
<?php endwhile; 
}

// Tabber: Get Recent Comments
function tj_tabs_comments( $posts = 5, $size = 48 ) {
if(empty($posts)) $posts = 5;
if(empty($size)) $size = 48;
	global $wpdb;
	$sql = "SELECT DISTINCT ID, post_title, post_password, comment_ID,
	comment_post_ID, comment_author, comment_author_email, comment_date_gmt, comment_approved,
	comment_type,comment_author_url,
	SUBSTRING(comment_content,1,65) AS com_excerpt
	FROM $wpdb->comments
	LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID =
	$wpdb->posts.ID)
	WHERE comment_approved = '1' AND comment_type = '' AND
	post_password = ''
	ORDER BY comment_date_gmt DESC LIMIT ".$posts;
	
	$comments = $wpdb->get_results($sql);
	
	foreach ($comments as $comment) {
	?>
	<li class="clear">
		<?php echo get_avatar( $comment, $size ); ?>
	
		<a href="<?php echo get_permalink($comment->ID); ?>#comment-<?php echo $comment->comment_ID; ?>" title="<?php _e('on ', 'themejunkie'); ?> <?php echo $comment->post_title; ?>">
			<span class="comment-author"><?php echo strip_tags($comment->comment_author); ?>:</span> <span class="comment-excerpt"><?php echo strip_tags($comment->com_excerpt); ?>...</span>
		</a>
	</li>
	<?php 
	}
}

function tj_related_posts() {
	global $post, $wpdb;
	$backup = $post;  // backup the current object
	$tags = wp_get_post_tags($post->ID);
	$tagIDs = array();
	if ($tags) {
	  $tagcount = count($tags);
	  for ($i = 0; $i < $tagcount; $i++) {
	    $tagIDs[$i] = $tags[$i]->term_id;
	  }
	  
	  $showposts = get_theme_mod('related_postnum');
	  $showposts = !empty($showposts) ? $showposts : 4;
	  
	  $args=array(
	    'tag__in' => $tagIDs,
	    'post__not_in' => array($post->ID),
	    'showposts'=>$showposts,
	    'caller_get_posts'=>1
	  );
	  $my_query = new WP_Query($args);
	  if( $my_query->have_posts() ) { $related_post_found = true; ?>
		<h3>You might like:</h3>

	    <?php while ($my_query->have_posts()) : $my_query->the_post(); ?>
		<div class="related-post">

						<?php
				$thumb = get_thumbnail($post->ID, get_theme_mod('thumb_key'),get_theme_mod('thumb_key'));
				$width = get_theme_mod('thumb_width');
				$height = get_theme_mod('thumb_height');
				$auto = get_theme_mod('thumb_auto');
										
				if($thumb) {	
					if($auto == 'Yes')
						$url = get_bloginfo('template_url').'/timthumb.php?src='.$thumb.'&amp;h='.$height.'&amp;w='.$width.'&amp;a=t&amp;zc=1';
					else
						$url = $thumb;
					
				} else {
					$url = get_bloginfo('template_url').'/images/default-thumb.gif';
				}
				
				echo '<a href="'.get_permalink().'" title="'.the_title_attribute( 'echo=0' ).'"><img width="125" height="80" src="'.$url.'" alt="'.get_the_title().'" /></a>';
			?>					<a class="title" href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a>
		</div>

	    <?php endwhile; ?>
	  <?php }
	}
	
	//show recent posts if no related found
	if(!$related_post_found){ ?>
			<h3>You might like:</h3>

		<?php
		$posts = get_posts('numberposts=4');
		foreach($posts as $post) { ?>
		<div class="related-post">
		
						<?php
				$thumb = get_thumbnail($post->ID, get_theme_mod('thumb_key'),get_theme_mod('thumb_key'));
				$width = get_theme_mod('thumb_width');
				$height = get_theme_mod('thumb_height');
				$auto = get_theme_mod('thumb_auto');
										
				if($thumb) {	
					if($auto == 'Yes')
						$url = get_bloginfo('template_url').'/timthumb.php?src='.$thumb.'&amp;h='.$height.'&amp;w='.$width.'&amp;a=t&amp;zc=1';
					else
						$url = $thumb;
					
				} else {
					$url = get_bloginfo('template_url').'/images/default-thumb.gif';
				}
				
				echo '<a href="'.get_permalink().'" title="'.the_title_attribute( 'echo=0' ).'"><img width="125" height="80" src="'.$url.'" alt="'.get_the_title().'" /></a>';
			?>
				<a class="title" href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a>
				
		</div>
		<?php } ?>
		
		<?php 
	}
	wp_reset_query();
}

?>