<?php
/**
 * Theme Junkie Social Widget
 */
 
class TJ_Widget_Social extends WP_Widget {

	function TJ_Widget_Social() {
		$widget_ops = array('classname' => 'widget_social', 'description' => __('Display Social Profiles'));
		$control_ops = array('width' => 400, 'height' => 350);
		$this->WP_Widget('social', __('ThemeJunkie - Social'), $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
		extract($args);
		$feedburner_id = $instance['feedburner_id'];
		$twitter_id = $instance['twitter_id'];
		$facebook_id = $instance['facebook_id'];
		?>
		
<div id="tab-social">

	<div class="widget tab-widget" id="subscribe-rss">
		<h3 class="widget-title"><?php _e('Stay Connected', 'themejunkie'); ?></h3>
					<ul class="widget-social">
				<li><a class="widget-rss yellow" title="Subscribe to our RSS feed" href="http://feeds.feedburner.com/<?php echo $feedburner_id; ?>" rel="nofollow" target="_blank"><?php _e('RSS feeds', 'themejunkie') ?></a></li>
				<li><a class="widget-email" href="http://feedburner.google.com/fb/a/mailverify?uri=<?php echo $feedburner_id; ?>&amp;loc=en_US" rel="nofollow" target="_blank"><?php _e('RSS via Email', 'themejunkie') ?></a></li>
				<li><a class="widget-twitter" href="http://twitter.com/<?php echo $twitter_id; ?>" rel="nofollow" target="_blank"><?php _e('Follow on Twitter', 'themejunkie') ?></a></li>
				<li><a class="widget-facebook" href="http://www.facebook.com/<?php echo $facebook_id; ?>" rel="nofollow" target="_blank"><?php _e('Become our fan', 'themejunkie') ?></a></li>
			</ul>
	 </div> <!--end #social-->
		       
	<div class="widget tab-widget" id="subscribe-email"> 
		<h3 class="widget-title"><?php _e('Join Newsletter', 'themejunkie'); ?></h3>
		<p>
		If you would like to receive our RSS updates via email, simply enter your email address below & click <strong>subscribe</strong>.
		</p>
<form id="subscribeform" action="http://feedburner.google.com/fb/a/mailverify" method="post" target="popupwindow" onsubmit="window.open('http://feedburner.google.com/fb/a/mailverify?uri=<?php echo $feedburner_id; ?>', 'popupwindow', 'scrollbars=yes,width=550,height=520');return true">
        <div id="subscribe">
          <input class="subscribe-input" name="feed" id="input" value="<?php _e('Enter your email...', 'themejunkie') ?>" onfocus="if (this.value == '<?php _e('Enter your email...', 'themejunkie') ?>') {this.value = '';}" onblur="if (this.value == '') {this.value = '<?php _e('Enter your email...', 'themejunkie') ?>';}" />
          <input type="hidden" value="<?php echo $feedburner_id; ?>" name="uri"/>
          <input type="hidden" name="loc" value="en_US"/>
          <input type="submit" class="subscribe-submit" value="Subscribe"/>
        </div>
      </form>

	</div> <!--end #social-->

</div><!--end #tab-sidebar-->

		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['feedburner_id'] = $new_instance['feedburner_id'];
		$instance['twitter_id'] =  $new_instance['twitter_id'];
		$instance['facebook_id'] =  $new_instance['facebook_id'];
		return $instance;
	}

	function form( $instance ) { 
		$instance = wp_parse_args( (array) $instance, array( 'feedburner_id' => 'themejunkie', 'twitter_id' => 'theme_junkie', 'facebook_id' => 'themejunkie' ) );
		$feedburner_id = $instance['feedburner_id'];
		$twitter_id = format_to_edit($instance['twitter_id']);
		$facebook_id = format_to_edit($instance['facebook_id']);
	?>
		<p><label for="<?php echo $this->get_field_id('feedburner_id'); ?>"><?php _e('Enter your Feedburner ID:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('feedburner_id'); ?>" name="<?php echo $this->get_field_name('feedburner_id'); ?>" type="text" value="<?php echo $feedburner_id; ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('twitter_id'); ?>"><?php _e('Enter your Twitter ID:'); ?></label>
		<input class="widefat" type="text" id="<?php echo $this->get_field_id('twitter_id'); ?>" name="<?php echo $this->get_field_name('twitter_id'); ?>" value="<?php echo $twitter_id; ?>" /></p>
		<p><label for="<?php echo $this->get_field_id('facebook_id'); ?>"><?php _e('Enter your Facebook ID:'); ?></label>
		<input class="widefat" type="text" id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('facebook_id'); ?>" value="<?php echo $facebook_id; ?>" /></p>
		<?php }
}

register_widget('TJ_Widget_Social');

