<?php get_header(); ?>

<div id="container">
	<div id="content">
	<div id="breadcrumb">
		<?php tj_breadcrumb(); ?>
	</div><!--end #breadcrumb-->
		<?php the_post(); ?>
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						
			<h1 class="entry-title"><?php the_title(); ?></h1>
			
			<div class="entry-meta">
				<span class="meta-author"><?php _e('Published by','themejunkie'); ?> <?php the_author_posts_link(); ?></span>
				<span class="meta-date"><?php _e( 'on ', 'themejunkie' ); ?><?php the_time(get_option('date_format')); ?></span> 
				<span class="meta-sep">|</span>
				<?php comments_popup_link('0 Comment','1 Comment','% Comments'); ?>
				<?php edit_post_link( __( 'Edit', 'themejunkie' ), '<span class="meta-sep">|</span> <span class="meta-edit">', '</span>' ); ?>
			</div> <!--end .entry-meta-->
			
			<!--BEGIN OF POST TOP CODE-->
			<?php if(get_theme_mod('post_top_code_status') == "Yes") echo stripslashes(get_theme_mod('post_top_code')); ?>
			<!--END OF POST TOP CODE-->

			<div class="entry entry-content">
				<?php the_content(); ?>
				<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'themejunkie' ), 'after' => '</div>' ) ); ?>
			</div> <!--end .entry-->
			
			<div id="entry-bottom">
			<strong><?php _e( 'Filed in: ', 'themejunkie' ); ?></strong><?php the_category( ', ' ); ?> 
			<?php printf(the_tags(__('<span id="entry-tags"><strong>Tags:</strong>&nbsp;','themejunkie'),', ','</span>')); ?>
			</div>
			
			<!--BEGIN OF POST BOTTOM CODE-->
			<?php if(get_theme_mod('post_bottom_code_status') == "Yes") echo stripslashes(get_theme_mod('post_bottom_code')); ?>
			<!--END OF POST BOTTOM CODE-->

			<?php if(get_theme_mod('display_author_info') == 'Yes') { ?>
			<div id="entry-author" class="clear">
				<div class="entry-author-content clear">
				<div id="author-avatar">
					<?php echo get_avatar( get_the_author_meta( 'user_email' ), apply_filters( 'themejunkie_author_bio_avatar_size', 60 ) ); ?>
				</div> <!--end .author-avatar-->
				<div id="author-description">
					<h3><?php _e('About','themejunkie'); ?> <?php the_author(); ?></h3>
					<?php the_author_meta( 'description' ); ?>
					<div id="author-link">
						<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" title="<?php printf( esc_attr__( 'View all posts by %s', 'themejunkie' ), get_the_author() ); ?>"><?php _e( 'View all posts by ', 'themejunkie' ); ?><?php the_author(); ?> &rarr;</a>
					</div> <!--end .author-link-->
				</div> <!--end .author-description-->
				</div>
			</div> <!--end .entry-author-->
			<?php } ?>
			
			<?php if(get_theme_mod('display_related_posts') == 'Yes') { ?>
			<div class="entry-related">
				<?php echo tj_related_posts(); ?>
				<div class="clear"></div>
			</div>
			<?php } ?>
			
			<?php if(get_theme_mod('display_social_bookmarks') == 'Yes') { ?>

			<?php } ?>

			<div class="clear"></div>
			</div><!--end .entry-bottom-->
		
		<?php comments_template( '', true ); ?>
	</div><!--end #content -->
</div><!--end #container -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
