<?php
/**
 * Theme Junkie Social Widget
 */
 
class TJ_Widget_Social extends WP_Widget {

	function TJ_Widget_Social() {
		$widget_ops = array('classname' => 'widget_social', 'description' => __('Display Social Profiles'));
		$control_ops = array('width' => 400, 'height' => 350);
		$this->WP_Widget('social', __('ThemeJunkie - Social'), $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
		extract($args);
		$feedburner_id = $instance['feedburner_id'];
		$twitter_id = $instance['twitter_id'];
		$facebook_id = $instance['facebook_id'];
		?>
		
<div id="tab-social">

	<div class="widget tab-widget" id="subscribe-rss">
<h3 class="widget-title"><?php _e('Join Newsletter', 'themejunkie'); ?></h3>
		<p>
<div class="bshare-custom"><a title="分享到Facebook" class="bshare-facebook" href="javascript:void(0);"></a><a href="javascript:void(0);" title="分享到QQ空间" class="bshare-qzone"></a><a title="分享到Google书签" class="bshare-bgoogle" href="javascript:void(0);"></a><a href="javascript:void(0);" title="分享到人人网" class="bshare-renren"></a><a title="分享到腾讯微博" class="bshare-qqmb" href="javascript:void(0);"></a><a title="分享到复制网址" class="bshare-clipboard" href="javascript:void(0);"></a><a href="javascript:void(0);" title="更多平台" class="bshare-more bshare-more-icon"></a></div><script language="javascript" type="text/javascript" src="http://static.bshare.cn/b/buttonLite.js#style=-1&amp;uuid=77a145fc-5030-4e65-83e9-4cb659be33b5&amp;pophcol=3&amp;lang=zh"></script><script language="javascript" type="text/javascript" src="http://static.bshare.cn/b/bshareC2P.js"></script>
		If you would like to receive our RSS updates via email, simply enter your email address below & click <strong>subscribe</strong>.
		</p>
<form id="subscribeform" action="http://feedburner.google.com/fb/a/mailverify" method="post" target="popupwindow" onsubmit="window.open('http://feedburner.google.com/fb/a/mailverify?uri=<?php echo $feedburner_id; ?>', 'popupwindow', 'scrollbars=yes,width=550,height=520');return true">
        <div id="subscribe">
          <input class="subscribe-input" name="feed" id="input" value="<?php _e('Enter your email...', 'themejunkie') ?>" onfocus="if (this.value == '<?php _e('Enter your email...', 'themejunkie') ?>') {this.value = '';}" onblur="if (this.value == '') {this.value = '<?php _e('Enter your email...', 'themejunkie') ?>';}" />
          <input type="hidden" value="<?php echo $feedburner_id; ?>" name="uri"/>
          <input type="hidden" name="loc" value="en_US"/>
          <input type="submit" class="subscribe-submit" value="Subscribe"/>
        </div>
      </form>
	 </div> <!--end #social-->
		       
	<div class="widget tab-widget" id="subscribe-email"> 
		<h3 class="widget-title"><?php _e('Stay Connected', 'themejunkie'); ?></h3>
					<ul class="widget-social">
				<li><a class="widget-rss yellow" title="Subscribe to our RSS feed" href="http://feed.iesay.com" rel="nofollow" target="_blank"><?php _e('RSS feeds', 'themejunkie') ?></a></li>
				<li><a class="widget-email" href="http://feedburner.google.com/fb/a/mailverify?uri=<?php echo $feedburner_id; ?>&amp;loc=en_US" rel="nofollow" target="_blank"><?php _e('RSS via Email', '99839') ?></a></li>
				<li><a class="widget-twitter" href="http://t.qq.com/jerray" rel="nofollow" target="_blank"><?php _e('Follow on QQ', '99839') ?></a></li>
				<li><a class="widget-facebook" href="http://t.qq.com/invite/u/jerray" rel="nofollow" target="_blank"><?php _e('Become our fan', '99839') ?></a></li>
			</ul>

	</div> <!--end #social-->

</div><!--end #tab-sidebar-->

		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['feedburner_id'] = $new_instance['feedburner_id'];
		$instance['twitter_id'] =  $new_instance['twitter_id'];
		$instance['facebook_id'] =  $new_instance['facebook_id'];
		return $instance;
	}

	function form( $instance ) { 
		$instance = wp_parse_args( (array) $instance, array( 'feedburner_id' => 'themejunkie', 'twitter_id' => 'theme_junkie', 'facebook_id' => 'themejunkie' ) );
		$feedburner_id = $instance['feedburner_id'];
		$twitter_id = format_to_edit($instance['twitter_id']);
		$facebook_id = format_to_edit($instance['facebook_id']);
	?>
		<p><label for="<?php echo $this->get_field_id('feedburner_id'); ?>"><?php _e('Enter your Feedburner ID:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('feedburner_id'); ?>" name="<?php echo $this->get_field_name('feedburner_id'); ?>" type="text" value="<?php echo $feedburner_id; ?>" /></p>
		
		<p><label for="<?php echo $this->get_field_id('twitter_id'); ?>"><?php _e('Enter your Twitter ID:'); ?></label>
		<input class="widefat" type="text" id="<?php echo $this->get_field_id('twitter_id'); ?>" name="<?php echo $this->get_field_name('twitter_id'); ?>" value="<?php echo $twitter_id; ?>" /></p>
		<p><label for="<?php echo $this->get_field_id('facebook_id'); ?>"><?php _e('Enter your Facebook ID:'); ?></label>
		<input class="widefat" type="text" id="<?php echo $this->get_field_id('image'); ?>" name="<?php echo $this->get_field_name('facebook_id'); ?>" value="<?php echo $facebook_id; ?>" /></p>
		<?php }
}

register_widget('TJ_Widget_Social');

