<div id="post-<?php the_ID(); ?>" <?php post_class('clear'); ?>>
		<?php
				$thumb = get_thumbnail($post->ID, get_theme_mod('thumb_key'),get_theme_mod('thumb_key'));
				$width = get_theme_mod('thumb_width');
				$height = get_theme_mod('thumb_height');
				$auto = get_theme_mod('thumb_auto');
										
				if($thumb) {	
					if($auto == 'Yes')
						$url = get_bloginfo('template_url').'/timthumb.php?src='.$thumb.'&amp;h='.$height.'&amp;w='.$width.'&amp;a=t&amp;zc=1';
					else
						$url = $thumb;
					
				} else {
					$url = get_bloginfo('template_url').'/images/default-thumb.gif';
				}
				
				echo '<a class="entry-thumb" href="'.get_permalink().'" title="'.the_title_attribute( 'echo=0' ).'"><img width="'.$width.'" height="'.$height.'" src="'.$url.'" alt="'.get_the_title().'" /></a>';
			?>
	
	<h2 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'themejunkie' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
	
	<div class="entry-meta">
		<span class="date"><?php _e( 'Category: ', 'themejunkie' ); ?><?php the_category( ', ' ); ?></span>
		<span class="meta-comments"><?php the_time(get_option('date_format')); ?> <?php if(function_exists('the_views')) { the_views(); } ?></span>
	</div> <!--end .entry-meta-->
	
	<div class="entry-excerpt">
		<?php echo mb_strimwidth(strip_tags(apply_filters('the_content', $post->post_content)), 0, 260,"…"); ?>
                <span class="meta-more"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'themejunkie' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark">Read more »</a></span>
	</div> <!--end .entry-excerpt-->
	
</div> <!--end #post-->