/***************************************************************************
 *
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  			Built by Darcy Clarke. http://themify.me
 * 				Extended by Elio Rivero
 *
 *  			Copyright (C) 2010 Themify
 *
 ***************************************************************************/
jQuery(document).ready(function($){
	
	// Themify Directory
	app_url = themify_js_vars.app_url;
	// URL for the parent theme
	theme_url = themify_js_vars.theme_url;
	// site url
	blog_url = themify_js_vars.blog_url;
	complete_status = true;
	current_obj = "";
	
	/*******************************************************************************/
	/* Tab Events */
	
	//
	// Create Tabs
	//
	$('#maintabnav a').click(function(event){
		event.preventDefault();
		window.location.hash = this.hash;
		return false;
	});
	$('#content, .maintab').tabs(
		{
			fx: { opacity: 'toggle', duration: 200 },
			cache: true,
			select: function(event, ui) {
                jQuery(this).css('height', jQuery(this).height());
                jQuery(this).css('overflow', 'hidden');
        },
        show: function(event, ui) {
                jQuery(this).css('height', 'auto');
                jQuery(this).css('overflow', 'visible');
        }
		}
	);
	
	/*******************************************************************************/
	/* Global Events  */

	//
	// Validation of Numbers
	//
	$('.valid_num').keyup(function(e){
		if(!is_numeric($(this).val())){
			$(this).val($(this).val().substring(0,($(this).val().length-1)));	
		}
	}).live("input paste", function(e){
		$(this).trigger("keyup");
	});
	
	/**
	 * Save user settings
	 * Uses nonces for security
	 */
	$('.save-button').click(function(e){
		e.preventDefault();						 
		showAlert();
		var data = $('#themify').serialize();
		$.post(
			ajaxurl,
			{
				'action': 'themify_save',
				'data': data,
				'nonce' : themify_js_vars.nonce
			},
			function(data) {
				hideAlert();
			}
		);
		return false;
	});
	/**
	 * Reset user styling
	 */
	$("#reset-styling").live('click', function(e){
		e.preventDefault();
		var reply = confirm(themify_lang.confirm_reset_styling);
		if(reply){
			showAlert();
			var data = $('#themify').serialize();
			$.post(
				ajaxurl,
				{
					'action': 'themify_reset_styling',
					'data'  : data,
					'nonce' : themify_js_vars.nonce
				},
				function(data){
					hideAlert();
					window.location.reload(true);
				}
			);									   
		}
	});
	/**
	 * Reset user settings
	 */
	$("#reset-setting").live('click', function(e){
		e.preventDefault();
		var reply = confirm(themify_lang.confirm_reset_settings);
		if(reply){
			showAlert();
			var data = $('#themify').serialize();
			$.post(
				ajaxurl,
				{
					'action': 'themify_reset_setting',
					'data'  : data,
					'nonce' : themify_js_vars.nonce
				},
				function(data){
					hideAlert();
					window.location.reload(true);
				}
			);									   
		}
	});
	//
	// Upgrade Theme / Framework
	//
	$(".upgrade-framework, .upgrade-theme").live('click', function(e){
		e.preventDefault();
		var reply = confirm(themify_lang.check_backup), 
			el = $(this);
		if($(this).hasClass('upgrade-theme')){
			var type = "theme";
		} else {
			var type = "framework";	
		}
		if($(this).parent().hasClass('login')){
			var login = true;	
		} else {
			var login = false;	
		}
		if(reply){
			if(login){
				showLogin();
			} else {
				//showAlert();
				window.location = blog_url + "wp-admin/admin.php?page=themify&action=upgrade&type=" + type + "&login=false";
			}
		}
	});
	
	//
	// Login Validation
	//
	$(".upgrade-login").live('click', function(e){
		e.preventDefault();										   
		var el = $(this), 
			username = el.parent().parent().find('.username').val(),
			password = el.parent().parent().find('.password').val(),
			login = $(".upgrade-theme").parent().hasClass('login');
		if(username != "" && password != ""){
			hideLogin();
			showAlert();
			$.post(
				ajaxurl,
				{
					'action':'themify_validate_login',
					'type':'theme',
					'login':login,
					'username':username,
					'password':password
				},
				function(data){
					data = jQuery.trim(data);
					if(data == 'true'){
						hideAlert();
						jQuery('#themify_update_form').submit();
					} else if(data == 'false') {
						hideAlert('error');	
						showLogin('error');
					}
				}
			);																					
		} else {
			hideAlert('error');	
			showLogin('error');							   
		}
	});
	//
	// Hide Overlay
	//
	$(".overlay").live('click', function(){
		hideLogin();
	});
	
	/*******************************************************************************/
	/* Uploadify Events */
	
	//
	// Create Instances for Upload
	//
	$(".upload-image").each(function(){
		var el = $(this), folder = el.parent().parent().find(".target").text();
		if(folder == "" || folder == undefined){
			folder = "uploads/";	
		}
		$("#" + $(this).attr('id')).uploadify({
			"uploader"      : app_url + "js/uploadify.swf",
			"script"        : app_url + "themify-ajax.php?upload=true",
			"cancelImg"     : app_url + "img/cancel.png",
			"folder"        : "",
			"scriptData"	: {"target":folder},
			"cancelImg"		: "cancel.png",
			"height"		: "16",
			"width"			: "80",
			"method"		: "POST",
			"hideButton"	: true,
			"wmode"			: "transparent",
			"fileDesc"		: "Image Files",
			"fileExt"		: "*.jpg;*.jpeg;*.gif;*.png",
			"multi"			: true,
			"sizeLimit"		: 100 * 1024 * 1024,
			"auto"          : true
		});
		$("#" + $(this).attr('id')).bind({
			"uploadifySelect" : function(event, id, file){
				complete_status = false;
				showAlert();
			},
			"uploadifyOpen" : function(event, id, file){
			},
			"uploadifyError" : function(event, id, file, error){
			},
			"uploadifyProgress" : function(event, id, file, data){
			},
			"uploadifyCancel" : function(event, id, file, data){
				hideAlert('error');
			},
			"uploadifyComplete" : function(event, id, file, response, data){
				if(!response || response == false){
					hideAlert('error');
					complete_status = true;
				} else {
					if(complete_status == false){
						hideAlert();
						response = response.replace("%uFEFF","");
						var path = theme_url + folder + $.trim(decodeURI(response));
						var title = folder + $.trim(decodeURI(response));
						var el = $('<a href="#" style="display:none;" title="' + title + '"><span title="' + title + '"></span><img src="' + path + '" width="50" height="50" alt="' + path + '" class="backgroundThumb selected"  /></a>').fadeIn(1000);
						if($(this).hasClass('favicon')){
							$(this).parent().parent().parent().find('input').val(path);
						} else if($(this).hasClass('simple')) {
							$(this).parent().parent().find('input.feature_box_img').val(path);
						} else if($(this).hasClass('logo')) {
							$(this).parent().parent().find('.image:first input').val(path);
						} else {
							$(this).parent().parent().parent().find('.backgroundThumb.selected').removeClass('selected');
							$(this).parent().parent().parent().find('.preset').prepend(el);
							$(this).parent().parent().parent().find('.background_image input').removeAttr('disabled').val(path);
							$(this).parent().parent().parent().find('.background_image input:checkbox').attr('checked', false);
						}
						complete_status = true;
					}
				}
			}
		});
	});
	
	//
	// Cancel Upload
	//
	$(".upload-action-cancel").bind("click", function (event){
		event.preventDefault();
		$(".upload-file").uploadifyClearQueue();
	});

	
	/*******************************************************************************/
	/* Style Module Events */
	
	//
	// Padding / Margin
	//
	$('.padding-switch, .margin-switch').click(function(){
		var parent = $(this).parent().parent().parent();
		var num = 0;
		if($(this).is(":checked")){
			if(parent.find(".individuals input:first").val() != ''){
				num = parent.find(".individuals input:first").val();
			}
			parent.find(".individuals").fadeOut(200, function(){ 
				parent.find(".same").fadeIn(200).find("input").val(num); 
			}).find("input").val('');
		} else {
			if(parent.find(".same input").val() != ''){
				num = parent.find(".same input").val();
			}
			parent.find(".same").fadeOut(200, function(){
				parent.find(".individuals").fadeIn(200).find("input").val(num);					
			}).find("input").val('');
		}
	});
	//
	// Border
	//
	$('.border-switch').click(function(){
		var parent = $(this).parent().parent();
		var color = '';
		var num = 0;
		if($(this).is(":checked")){
			if(parent.parent().find(".individuals input[type=text]:nth-child(1)").val() != ''){
				color = parent.parent().find(".individuals input[type=text]:nth-child(1)").val();
			}
			if(parent.parent().find(".individuals input:nth-child(2)").val() != ''){
				num = parent.parent().find(".individuals input:nth-child(2)").val();
			}
			var true_color = parent.parent().find(".individuals .colorSelect").css('background-color');
			parent.parent().find(".individuals .colorSelect").css('background-color','#ffffff');
			parent.parent().find(".individuals input[type=text]").val('');
			parent.parent().find(".individuals").fadeOut(200, function(){
				parent.parent().find(".same input[type=text]:nth-child(1)").val(color);
				parent.parent().find(".same .colorSelect").css("background-color",true_color);
				parent.parent().find(".same").fadeIn(200).find("input[type=text]:nth-child(2)").val(num);
				parent.parent().find(".same select").val(parent.parent().find('.individuals select:first option:selected').val());
			});
	
		} else {
			if(parent.parent().find(".same input[type=text]:nth-child(1)").val() != ''){
				color = parent.parent().find(".same input[type=text]:nth-child(1)").val();
			}
			if(parent.parent().find(".same input:nth-child(2)").val() != ''){
				num = parent.parent().find(".same input:nth-child(2)").val();
			}
			var true_color = parent.parent().find(".same .colorSelect").css('background-color');
			parent.parent().find(".same .colorSelect").css('background-color','#ffffff');
			parent.parent().find(".same input").val('');
			parent.parent().find(".same").fadeOut(200, function(){
				parent.parent().find(".individuals select").val(parent.parent().find('.same select:first option:selected').val());
				parent.parent().find(".individuals").fadeIn(200).find("input[type=text]:nth-child(2)").val(num);
				parent.parent().find(".individuals .borders input[type=text]:nth-child(1)").val(color);
				parent.parent().find(".individuals .borders .colorSelect").css("background-color",true_color);
			});
		}
	});
	//
	// Background-Color Transparent
	//
	$('.colorTransparent').click(function(){
		if($(this).is(":checked")){
			$(this).parent().find("input[type=text]").attr('disabled', true).val('').parent().find(".colorSelect").css('background-color','#ffffff');
		} else {
			$(this).parent().find("input[type=text]").removeAttr('disabled');	
		}
	});
	//
	// Background-Position 
	//
	$('.background_position.positionX').change(function(){
		$(this).parent().find('.valueX').val($('option:selected', this).val());
	});
	$('.background_position.positionY').change(function(){
		$(this).parent().find('.valueY').val($('option:selected', this).val());
	});
	//
	// Background-Image Thumb
	//
	$('.backgroundThumb').live("click",function(e){
		e.preventDefault();
		var alt = $(this).attr("alt");
		$(this).parent().parent().find('.backgroundThumb.selected').removeClass('selected');
		$(this).addClass('selected');
		$(this).parent().parent().parent().find('.background_image input').removeAttr('disabled').val(alt);
		$(this).parent().parent().parent().find('.background_image input:checkbox').attr('checked', false);
	});
	//
	// Background-Image Remove Selection on Blur
	//
	$('.background_image .upload-file').live("blur",function(e){
		if($(this).val() == ''){
			$(this).parent().parent().find('.backgroundThumb.selected').removeClass('selected');
		}
	});
	//
	// Background-Image None
	//
	$('.background_image input:checkbox').live("click",function(){
		if($(this).is(":checked")){
			$(this).parent().parent().find('.backgroundThumb.selected').removeClass('selected');
			$(this).parent().parent().find('.background_image input[type=text]').attr('disabled', true).val('');							  
		} else {
			$(this).parent().parent().find('.background_image input[type=text]').removeAttr('disabled');
		}
	});
	//
	// Delete Image
	//
	$('.preset a span').live("click",function(e){
		e.preventDefault();
		el = $(this);
		var reply = confirm(themify_lang.confirm_delete_image);
		if(reply){
			$.post(app_url + "themify-ajax.php?delete-image=true", { "file": el.attr("title") }, function(data){
				
				if(el.parent().parent().parent().find('.background_image input[type=text]').val() == el.parent().find("img").attr("alt")){
					el.parent().parent().parent().find('.background_image input[type=text]').val('');	
				}
				el.parent().remove();
			});	
		}
	});
	//
	// Position
	//
	$('.select_position').change(function(){
		var val = $('option:selected', this).val();
		if(val == 'absolute' || val == 'fixed'){
			$(this).parent().parent().find('.position_display').show(200);	
		} else {
			$(this).parent().parent().find('.position_display').hide(200);	
		}	
	});
	//
	// Color Picker
	//
	$('.colorSelectInput').live('blur', function(){
		var temp = $(this);
		if(temp.val() == ''){
			var color = "#ffffff";	
		} else {
			var color = "#"+temp.val();	
		}
		temp.parent().find(".colorSelect").ColorPickerSetColor(temp.val()).css('background-color',color);
	});
	$('.colorSelect').ColorPicker({
		onBeforeShow: function(hsb, hex, rgb){
			current_obj = this;
			$(this).ColorPickerSetColor($(this).parent().find(".colorSelectInput").val());
		},
		onShow: function (colpkr) {
			$(colpkr).fadeIn(200);
			return false;
		},
		onHide: function (colpkr) {
			var temp = $(current_obj);
			var val = $(colpkr).find(".colorpicker_hex input[type=text]").val();
			temp.css({'background-color':"#"+val});
			temp.parent().find("input[type=text]:first").val(val);
			$(colpkr).fadeOut(200);
			return false;
		}
	});
	//
	// Font-Family
	//
	$('.fontFamily').change(function(){
		if($('option:selected', this).val() == 'custom'){
			$(this).parent().find('.value').show();
			$(this).parent().find('.value input').val('');
		} else {
			$(this).parent().find('.value').hide();
			$(this).parent().find('.value input').val($('option:selected', this).val());
		}
	});
	//
	// Site-Logo
	//
	$("input[name='setting-site_logo']").change(function(){
		if($(this).val() == "image"){
			$(this).parent().parent().find(".image").fadeIn(200);
			$(this).parent().parent().find(".image").css("display","block");
		} else {
			$(this).parent().parent().find(".image").fadeOut();
		}
	});
	//
	// Feature Box Image / Posts Display
	//
	$(".feature-box-display").click(function(){
		if($(this).val() == "images"){
			$(this).parent().parent().find(".feature_box_posts").fadeOut(200, function(){
				$(this).parent().parent().find(".feature_box_images").fadeIn(200);																		
			});
		} else {
			$(this).parent().parent().find(".feature_box_images").fadeOut(200, function(){
				$(this).parent().parent().find(".feature_box_posts").fadeIn(200);																			
			});
		}
	});
	//
	// Feature Box Enabled Display
	//
	$(".feature_box_enabled_check").click(function(){
		if($(this).is(":checked")){
			$(this).parent().parent().find(".feature_box_enabled_display").fadeIn(200);
		} else {
			$(this).parent().parent().find(".feature_box_enabled_display").fadeOut(200);
		}
	});
	
	/**
	 * Display box if checkbox is checked
	 * Markup required
	 * 	<div class="row">
	 * 		<input type="checkbox" class="box_enabled_check" />
	 * 		<*tag* class="box_enabled_display">
	 * 			<select>
	 */
	$(".box_enabled_check").click(function(){
		if($(this).is(":checked")){
			$(this).parent().find(".box_enabled_display").fadeIn(200);
		} else {
			$(this).parent().find(".box_enabled_display").fadeOut(200);
		}
	});
	if($('.box_enabled_check').is(":checked")){
		$('.box_enabled_check').parent().find(".box_enabled_display").show();
	}
	
	/**
	 * Display matched boxes if checkbox is checked
	 * Markup required
	 * <input type="checkbox" class="box_enabled_check" />
	 * <span class="box_enabled_display">
	 */
	$(".disable_img_php").click(function(){
		if($('.disable_img_php').is(":checked")){
			$( '.show_if_disabled_img_php' ).fadeIn(200);
			$( '.show_if_enabled_img_php' ).fadeOut(200);
		} else {
			$( '.show_if_disabled_img_php' ).fadeOut(200);
			$( '.show_if_enabled_img_php' ).fadeIn(200);
		}
	});
	if($('.disable_img_php').is(":checked")){
		$(".show_if_disabled_img_php").show();
	}
	else{
		if($('.disable_img_php').not(":checked")){
			$(".show_if_enabled_img_php").show();
		}
	}
	
	//
	// Layout Options 
	//
	$(".preview-icon").click(function(e){
		e.preventDefault();
		$(this).parent().find(".selected").removeClass("selected");
		$(this).addClass("selected");
		$(this).parent().find(".val").val($(this).find("img").attr("alt"));
	});
	
	/*******************************************************************************/
	/* Skin CSS Load */
	
	//
	// Skins Load
	//
	$(".skin-preview").click(function(e){
		e.preventDefault();
		$(".skin-preview img.selected").removeClass();
		$(this).find("img").addClass('selected');
		$("input[name='skin']").val($(this).find("img").attr('id'));
	});
	
	
	/*******************************************************************************/
	/* Exporting Events */
	
	//
	// Export Download
	//
	$("#download-export").click(function(){
		window.open(app_url + "themify-ajax.php?export=true");
		return false;								 
	});
	
	/*******************************************************************************/
	/* Importing Events */
	
	//
	// Importing
	$("#download-import").uploadify({
		"uploader"      : app_url + "js/uploadify.swf",
		"script"        : app_url + "themify-ajax.php?import=true",
		"cancelImg"     : app_url + "img/cancel.png",
		"folder"        : "temp",
		"cancelImg"		: "cancel.png",
		"height"		: "60",
		"width"			: "174",
		"method"		: "POST",
		"hideButton"	: true,
		"wmode"			: "transparent",
		"multi"			: true,
		"sizeLimit"		: 100 * 1024 * 1024
	});
	
	$("#download-import").bind({
		"uploadifySelect" : function(event, id, file){
			var reply = confirm(themify_lang.confirm_import);
			if(reply){
				$("#download-import").uploadifyUpload();
				complete_status = false;
				showAlert();
			}
		},
		"uploadifyOpen" : function(event, id, file){
		},
		"uploadifyError" : function(event, id, file, error){
		},
		"uploadifyProgress" : function(event, id, file, data){
		},
		"uploadifyCancel" : function(event, id, file, data){
			hideAlert();
		},
		"uploadifyComplete" : function(event, id, file, response, data){
			if(complete_status == false){
				hideAlert();
				complete_status = true;
				window.location.reload(true);
			}
		}
	});
	
	/*******************************************************************************/
	/*	Display Alerts */
	
	function showLogin(status){
		$('.prompt-box .show-login').show();
		$('.prompt-box .show-error').hide();
		if(status == 'error'){
			if($('.prompt-box .prompt-error').length == 0){
				$('.prompt-box .prompt-msg').after('<p class="prompt-error">' + themify_lang.invalid_login + '</p>');
			}
		} else {
			$('.prompt-box .prompt-error').remove();
		}
		$(".overlay, .prompt-box").fadeIn(500);	
	}	
	function hideLogin(){
		$(".overlay, .prompt-box").fadeOut(500);
	}
	function showAlert(){
		$(".alert").addClass("busy").fadeIn(800);
	}
	function hideAlert(status){
		if(status == 'error'){
			status = 'error';
			showErrors();
		} else {
			status = 'done';	
		}
		$(".alert").removeClass("busy").addClass(status).delay(800).fadeOut(800, function(){
			$(this).removeClass(status);											   
		});
	}
	function showErrors(verbose){
		$(".overlay, .prompt-box").delay(900).fadeIn(500);	
		$('.prompt-box .show-error').show();
		$('.prompt-box .show-error p').remove();
		$('.prompt-box .error-msg').after('<p class="prompt-error">' + verbose + '</p>');
		$('.prompt-box .show-login').hide();
	}
	
	/*******************************************************************************/
	/*	Is Numeric Function */
	
	function is_numeric(string){
		var ValidChars = " 0123456789.+-";
		var IsNumber = true;
		var Char;
		for (i = 0; i < string.length && IsNumber == true; i++){ 
			Char = string.charAt(i); 
			if(ValidChars.indexOf(Char) == -1){
				IsNumber = false;
			}
		}
		return IsNumber;
	}
	
	/**
	 * Group drop down containing Featured Image sizes with the Featured Image field
	 * .featimgdropdown
	 */
	if( $('.featimgcontrol').length > 0 && $('.featimgdropdown').length > 0 )
		$('.featimgcontrol').append($('.featimgdropdown'));
	
}); 
