<?php



/***************************************************************************

 *

 * 	----------------------------------------------------------------------

 * 						DO NOT EDIT THIS FILE

 *	----------------------------------------------------------------------

 * 

 *  			Original built by Darcy Clarke. http://themify.me

 * 				Extended by Elio Rivero.

 *  				Copyright (C) 2010 Themify

 * 

 *	----------------------------------------------------------------------

 *

 ***************************************************************************/



	

/* 	Set Error Reporting

 ***************************************************************************/

	error_reporting(E_ERROR);

	

	

/* 	Global Vars

 ***************************************************************************/



	global $wpdb, $config, $data, $theme, $version, $notifications;



/*	Activate Theme

 ***************************************************************************/



	if(isset($_GET['activated']) && $pagenow == "themes.php")

		header('Location: '.admin_url().'admin.php?page=themify');



/* 	Theme Config

 ***************************************************************************/

	$version = "1.2.1";

	$theme = get_theme_data(TEMPLATEPATH . '/style.css');



/* 	Themify Framework Path and URI

 ***************************************************************************/

	define( 'THEME_DIR', get_template_directory() );

	define( 'THEME_URI', get_template_directory_uri() );

	define( 'THEMIFY_DIR', THEME_DIR . '/themify' );

	define( 'THEMIFY_URI', THEME_URI . '/themify' );

	define( 'THEMIFYMIN', defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min' );

	define( 'THEMIFY_VERSION', $version );



/* 	Data Config

 ***************************************************************************/

	$data = get_data();

	

/*	Generate Config from XML

 ***************************************************************************/

	/**

	 *  @var String $the_config_file

	 */ 

	$the_config_file = (is_file(TEMPLATEPATH."/custom-config.xml"))? 'custom-config.xml' : 'theme-config.xml';

	$the_config_file = TEMPLATEPATH . "/" . $the_config_file;

	

	$file = fopen($the_config_file, 'r');

	$config = fread($file, filesize($the_config_file));

	fclose($file);

	

	$config = themify_xml2array($config);

	$config = $config['config']['_c'];

		

	/*	Dynamic panel creation

	/**************************************************/

	

	$panels = $config['panel'];

	unset($config['panel']);

	if(is_array($panels)){

		foreach($panels as $panel){

			$config['panel'][strtolower($panel['_a']['title'])] = $panel['_c'];

		}

	}

	

/**

 * Load Shortcodes

 * @since 1.1.3

 */

require_once(TEMPLATEPATH . '/themify/themify-shortcodes.php');



/**

 * Load Regenerate Thumbnails plugin if the corresponding class doesn't exist.

 * @since 1.1.5

 */

if(!class_exists('RegenerateThumbnails'))

	require_once(THEMIFY_DIR . '/regenerate-thumbnails/regenerate-thumbnails.php' );

 

/**

 * Remove featured image metabox

 * @since 1.1.5

 */

add_action('do_meta_boxes', 'customposttype_image_box');



/**

 * Themify - CSS Header

 */

add_action('wp_head', 'themify_get_css');



/**

 * Themify - Insert settings page link in WP Admin Bar

 * @since 1.1.2

 */

add_action('wp_before_admin_bar_render', 'themify_admin_bar');



/**

 * Add support for feeds on the site

 */

add_theme_support( 'automatic-feed-links' );

	

/**

 * Admin Only code follows

 ******************************************************/

if( is_admin() ){

	

	/**

	 * Remove Themify themes from upgrade check

	 * @since 1.1.8

	 */

	add_filter( 'http_request_args', 'themify_hide_themes', 5, 2);

	

	if( current_user_can('manage_options') ){

		/**

	 	* Themify - Admin Menu

	 	*******************************************************/

		add_action('admin_menu', 'themify_admin_nav');

		

		/**

	 	* Themify Updater

	 	*******************************************************/

		require_once(TEMPLATEPATH . '/themify/themify-updater.php');

	}

	

	/**

 	* Add buttons to TinyMCE

 	*******************************************************/

	require_once(THEMIFY_DIR . '/tinymce/class-themify-tinymce.php');

	add_action('init', create_function('', '$Themify_TinyMCE = new Themify_TinyMCE();'));

	

	/**

 	* Enqueue jQuery and other scripts

 	*******************************************************/

	add_action('admin_enqueue_scripts', 'themify_enqueue_scripts');

	

	/**

	 * Display additional ID column in categories list

	 * @since 1.1.8

	 */

	add_filter('manage_edit-category_columns', 'themify_custom_category_header', 10, 2);

	add_filter('manage_category_custom_column', 'themify_custom_category', 10, 3);

	

	/**

 	* Ajaxify admin

 	*******************************************************/

	require_once(THEMIFY_DIR . '/themify-wpajax.php');

}



/**

 * Enqueue JS and CSS for Themify settings page and meta boxes

 * @param String $page

 * @since 1.1.1

 *******************************************************/

function themify_enqueue_scripts($page){

	global $version;

	

	$post = get_post( $_GET['post'] );

	$typenow = $post->post_type;

	$pagenow = $_GET['page'];

	$types = themify_post_types();

	if( $page == 'post.php' || $page == 'post-new.php' ){

		wp_enqueue_script( 'meta-box-tabs', get_template_directory_uri() . '/themify/js/meta-box-tabs.js', array('jquery'), '1.0', true );	

	}

	if( $page == 'post.php' || $page == 'post-new.php' || $page == 'toplevel_page_themify' ){

		//Enqueue styles

		wp_enqueue_style( 'themify-ui',  THEMIFY_URI . '/css/themify-ui.css', array(), $version );

		wp_enqueue_style( 'colorpicker', THEMIFY_URI . '/css/colorpicker.css' );

		

		//Enqueue scripts

		wp_enqueue_script( 'jquery' );

		wp_enqueue_script( 'jquery-ui-core' );

		wp_enqueue_script( 'jquery-ui-tabs' );

		wp_enqueue_script( 'swfobject' );

		wp_enqueue_script( 'validate', THEMIFY_URI . '/js/jquery.validate.pack.js', array('jquery') );

		wp_enqueue_script( 'uploadify', THEMIFY_URI . '/js/jquery.uploadify.min.js', array('jquery') );

		wp_enqueue_script( 'colorpicker-js', THEMIFY_URI . '/js/colorpicker.js', array('jquery') );

		if( in_array($typenow, $types) || 'themify' == $pagenow ){

			//Don't include Themify JavaScript if we're not in one of the Themify-managed pages

			wp_enqueue_script( 'themify-scripts', THEMIFY_URI . '/js/scripts.js', array('jquery'), $version );

		}

	}

	//Inject variable values to scripts.js previously enqueued

	wp_localize_script('themify-scripts', 'themify_js_vars', array(

			'themify' 	=> THEMIFY_URI,

			'nonce' 	=> wp_create_nonce('ajax-nonce'),

			'admin_url' => admin_url( 'admin.php?page=themify' ),

			'ajax_url' 	=> admin_url( 'admin-ajax.php' ),

			'app_url'	=> get_template_directory_uri() . '/themify/',

			'theme_url'	=> get_template_directory_uri() . '/',

			'blog_url'	=> site_url() . '/'

		)

	);

	

	wp_localize_script('themify-scripts', 'themify_lang', array(

			'confirm_reset_styling'	=> __('你确定要重置您的主题风格?', 'themify'),

			'confirm_reset_settings' => __('你确定要重置您的主题设置?', 'themify'),

			'check_backup' => __('请在升级前务必备份。可能会丢失或更改的文件和设置.', 'themify'),

			'confirm_delete_image' => __('你想永久删除此图片?', 'themify'),

			'confirm_import' => __('导入将覆盖所有的设置和配置。按"确定"继续，取消 停止.', 'themify'),

			'invalid_login' => __('无效的用户名或密码。<br/>Contact <a href="http://themify.me/contact">Themify</a>登录问题.', 'themify')

		)

	);

}

/**

 * Add Themify Settings link to admin bar

 * @since 1.1.2

 */

function themify_admin_bar() {

	global $wp_admin_bar;

	if ( !is_super_admin() || !is_admin_bar_showing() )

		return;

	$wp_admin_bar->add_menu( array(

		'id' => 'themify-settings',

		'parent' => 'appearance',

		'title' => __( 'Themify设置', 'themify' ),

		'href' => admin_url( 'admin.php?page=themify' )

	));

}

/**

 * Remove WordPress' Post Thumbnail metabox. This functionality is handled by Themify

 * @since 1.1.5

 */

function customposttype_image_box() {

	$types = themify_post_types();

	foreach( $types as $type )

		remove_meta_box( 'postimagediv', $type, 'side' );

	

}

?>