<?php

/***************************************************************************/
/*
/* 	----------------------------------------------------------------------
/* 						DO NOT EDIT THIS FILE
/*	----------------------------------------------------------------------
/* 
/*  			Built by Darcy Clarke. http://themify.me
/*  				Copyright (C) 2010 Themify
/*
/***************************************************************************/

/* 	Setting Modules
/***************************************************************************/
	
	///////////////////////////////////////////
	// Site Logo
	///////////////////////////////////////////
	function themify_site_logo($data=array()){
		if($data['attr']['target'] != ''){
			$target = "<span class='hide target'>".$data['attr']['target']."</span>";	
		}
		$data = get_data();
		if($data['setting-site_logo'] == "image"){
			$image = "checked='checked'";
			$image_display = "style='display:block;'";
			$text_display = "style='display:none;'";
		} else {
			$text = "checked='checked'";	
			$text_display = "style='display:block;'";
			$image_display = "style='display:none;'";
		}
		return '<p>
					<span class="label">'. __('显示', 'themify') .'</span> 
						<input name="setting-site_logo" type="radio" value="text" '.$text.' /> ' . __('设置标题', 'themify') . ' 
						<input name="setting-site_logo" type="radio" value="image" '.$image.' /> ' . __('图片', 'themify') . '
					</span>
					'.$target.'
					<span class="pushlabel image" '.$image_display.'>
						<input type="text" class="width10" name="setting-site_logo_image_value" value="'.$data['setting-site_logo_image_value'].'" />
					</span>
					<span class="pushlabel image" '.$image_display.'>
						' . themify_has_quota('<a href="#" id="setting-'.$data['category'].'-'.$data['title'].'-site_logo" class="upload-btn upload-image logo">' . __('+ 上传', 'themify') . '</a>') . '
					</span>
					<span class="pushlabel clear image" '.$image_display.'>
						<input type="text" name="setting-site_logo_width" class="width2" value="'.$data['setting-site_logo_width'].'" /> ' . __('宽度', 'themify') . ' 
						<input type="text" name="setting-site_logo_height" class="width2" value="'.$data['setting-site_logo_height'].'" /> ' . __('高度', 'themify') . '
					</span>
				</p>';
	}
	
	///////////////////////////////////////////
	// Favicon Module
	///////////////////////////////////////////
	function themify_favicon($data=array()){
		if($data['attr']['target'] != ''){
			$target = "<span class='hide target'>".$data['attr']['target']."</span>";	
		}
		$data = get_data();
		return '<p>
					<span class="label">'. __('自定义Favicon', 'themify') . '</span> <input type="text" class="width10" name="setting-favicon" value="'.$data['setting-favicon'].'" /> <br />
					'.$target.'
					<span class="pushlabel" style="display:block;">
						' . themify_has_quota('<a href="#" class="upload-btn upload-image favicon" id="setting-'.$data['category'].'-'.$data['title'].'">' . __('+ 上传', 'themify') . '</a>') . '
					</span>
				</p>';
	}

	///////////////////////////////////////////
	// Favicon Module - Action
	///////////////////////////////////////////
	function themify_favicon_action($data=array()){
		$data = get_data();
		if($data['setting-favicon'] != ""){
			$favurl = themify_https_esc($data['setting-favicon']);
			echo "\n\n".'<link href="'.$favurl.'" rel="shortcut icon" /> ';
		}
	}
	add_action('wp_head', 'themify_favicon_action');
	add_action('admin_head', 'themify_favicon_action');
	
	///////////////////////////////////////////
	// Custom Feed URL Module
	///////////////////////////////////////////
	function themify_custom_feed_url($data=array()){
		$data = get_data();
		return '<p><span class="label">' . __('自定义Feed地址', 'themify') . '</span> <input type="text" class="width10" name="setting-custom_feed_url" value="'.$data['setting-custom_feed_url'].'" /> <br />
					<span class="pushlabel"><small>e.g. http://feedburner.com/userid</small></span></p>';
	}
	
	///////////////////////////////////////////
	// Custom Feed URL Module - Action
	///////////////////////////////////////////
	function themify_custom_feed_url_action($data=array()){
		$data = get_data();
		if($data['setting-custom_feed_url'] != ""){
			echo "\n\n".'<meta name="description" content="'.$data['setting-custom_feed_url'].'" /> ';
		}
	}
	add_action('wp-admin','themify_custom_feed_url_action');
	
	///////////////////////////////////////////
	// Meta Description Module
	///////////////////////////////////////////
	function themify_meta_description($data=array()){
		$data = get_data();
		return '<p><textarea type="text" name="setting-meta_description" class="widthfull" rows="4">'.$data['setting-meta_description'].'</textarea></p>';	
	}
	
	///////////////////////////////////////////
	// Meta Description Module - Action
	///////////////////////////////////////////
	function themify_meta_description_action($data=array()){
		$data = get_data();
		if($data['setting-meta_description'] != ""){
			echo "\n\n".'<meta name="description" content="'.$data['setting-meta_description'].'" /> ';
		}
	}
	add_action('wp-admin','themify_meta_description_action');
	
	///////////////////////////////////////////
	// Header HTML Module
	///////////////////////////////////////////
	function themify_header_html($data=array()){
		$data = get_data();
		return '<p>' . __('下面的代码添加到 &lt;head&gt; tag.', 'themify') . '</p>
					<p><textarea class="widthfull" rows="10" name="setting-header_html">'.$data['setting-header_html'].'</textarea><br />
					<small>' . __('有用的，如果你需要添加额外的脚本，如CSS或JS。', 'themify') . '</small></p>';	
	}
	
	///////////////////////////////////////////
	// Header HTML Module - Action
	///////////////////////////////////////////
	function themify_header_html_action($data=array()){
		$data = get_data();
		if( $data['setting-header_html'] )
			echo "\n<!-- Themify Header Code -->\n".$data['setting-header_html']."\n<!-- End Themify Header Code -->\n";
	}
	add_action('wp_head','themify_header_html_action');
	
	///////////////////////////////////////////
	// Footer HTML Module
	///////////////////////////////////////////
	function themify_footer_html($data=array()){
		$data = get_data();
		return '<p>' . __('结束前，下面的代码将被添加到页脚&lt;/body&gt; tag.', 'themify') . '</p>
					<p><textarea type="text" class="widthfull" rows="10" name="setting-footer_html">'.$data['setting-footer_html'].'</textarea><br />
					<small>' . __('有用的，如果你需要使用Javascript或跟踪代码。', 'themify') . '</small></p>';
	}
	
	///////////////////////////////////////////
	// Footer HTML Module - Action
	///////////////////////////////////////////
	function themify_footer_html_action($data=array()){
		$data = get_data();
		if( $data['setting-footer_html'] )
			echo "\n<!-- Themify Footer Code -->\n".$data['setting-footer_html']."\n<!-- End Themify Footer Code -->\n";
	}
	add_action('wp_footer','themify_footer_html_action');
	
		
	///////////////////////////////////////////
	// Custom CSS Module
	///////////////////////////////////////////
	function themify_custom_css($data=array()){
		$data = get_data();
		return '<p><textarea class="widthfull" rows="35" name="setting-custom_css">'.$data['setting-custom_css'].'</textarea><br /></p>';	
	}
	///////////////////////////////////////////
	// Custom CSS Module - Action
	///////////////////////////////////////////
	function themify_custom_css_action($data=array()){
		$data = get_data();
		if( isset($data['setting-custom_css']) && ( '' != $data['setting-custom_css'] ) )
			echo "\n<!-- Themify Custom CSS -->\n<style type='text/css'>\n".$data['setting-custom_css']."\n</style>\n<!-- End Themify Custom CSS -->\n";
	}
	add_action('wp_head','themify_custom_css_action');
	
	///////////////////////////////////////////
	// Search Settings Module
	///////////////////////////////////////////
	function themify_search_settings($data=array()){
		$data = get_data();
		if($data['setting']['search_settings_exclude']){
			$checked = "checked='checked'";	
		}
		return '<p><span class="label">' . __('搜索类别ID', 'themify') . ' </span>
					   <input type="text" class="width6" name="setting-search_settings" value="'.$data['setting-search_settings'].'" />
					</p>
					<p>
						<span class="pushlabel"><small>' . __('使用减号（ - ）来排除类别。', 'themify') . '</small></span><br />
						<span class="pushlabel"><small>' . __('例如：（1,4，-7）=搜索，只在1和4类，并排除7类', 'themify') . '</small></span>
					</p>
					<p><span class="pushlabel"><input type="checkbox" name="setting-search_settings_exclude" '.$checked.'/> ' . __('排除在搜索结果的页面', 'themify') . '</span></p>';	
	}
	
	///////////////////////////////////////////
	// Search Settings Module - Action 
	///////////////////////////////////////////
	function themify_search_settings_action($query){
		$data = get_data();
		if($query->is_search){
			if($data['setting-search_settings'] != ""){
				$query->set('cat',$data['setting-search_settings']);
			}
			if($data['setting-search_settings_exclude']){
				$query->set('post_type','post');
			} 
		}
		return $query;
	}
	add_filter('pre_get_posts','themify_search_settings_action');
	
	///////////////////////////////////////////
	// RSS Feed Settings Module
	///////////////////////////////////////////
	function themify_feed_settings($data=array()){
		$data = get_data();
		if(themify_check('setting-exclude_img_rss')){
			$checked_use = "checked='checked'";
		}
		return '<p><span class="label">' . __('Feed分类', 'themify') . '</span> <input type="text" class="width6" name="setting-feed_settings" value="'.$data['setting-feed_settings'].'" /></p>
				<p>
					<span class="pushlabel"><small>' . __('使用减号（ - ）来排除类别。', 'themify') . '</small></span><br />
					<span class="pushlabel"><small>' . __('例：（2，-9）=第2类feed中不包括第9类。', 'themify') . '</small></span>
				</p>
				<p><span class="label">' . __('在RSS发布图片', 'themify') . '</span> <input type="checkbox" name="setting-exclude_img_rss" '.$checked_use.'/> ' . __('排除后的图像在RSS feed', 'themify') . '</p>
				<p>
					<span class="pushlabel"><small>' . __('检查排除后的图像在RSS feed', 'themify') . '</small></span>
				</p>
					';	
	}
	
	///////////////////////////////////////////
	// RSS Feed Settings Module - Action
	///////////////////////////////////////////
	function themify_feed_settings_action($query){
		$data = get_data();
		if($query->is_feed){
			if(isset($data['setting-feed_settings'])){
				$query->set('cat',$data['setting-feed_settings']);	
			}
		}
	}
	add_filter('pre_get_posts','themify_feed_settings_action');

	///////////////////////////////////////
	// Filter RSS Feed to include post image - Action
	///////////////////////////////////////
	if($data['setting-exclude_img_rss'] == ""){
       add_filter('the_content', 'themify_custom_fields_for_feeds');
       
       /* Firefox doesn't render images to feed when select full text from admin > Settings > Reading But IE does automatically for full text.
       So this below code will be use for firefox only to render/fetch images in feed. If we use for all then it will show images 2 times. */
       
       $useragent = $_SERVER['HTTP_USER_AGENT'];
       if(preg_match('|Firefox/([0-9\.]+)|',$useragent,$matched))
       {
           add_filter('the_excerpt_rss', 'themify_custom_fields_for_feeds');
           add_filter('the_content_feed', 'themify_custom_fields_for_feeds');
       }
       
       function themify_custom_fields_for_feeds( $content ) {
   
           global $post, $id, $themify_check;
           if(!is_feed() || $themify_check == true){
               return $content;
           }
   
           if(themify_check('post_image')) {
               $content .= "<p><img src='".themify_get('post_image')."'></p>";
           }
           $themify_check = false;
           return $content;
       }
     }
	
	///////////////////////////////////////////
	// Img Version / Settings
	///////////////////////////////////////////
	function themify_img_settings($data=array()){
		
		/*** Img.php Crop Option Array ***/
		$options = array(
			array("value" => "c", "name" => __('中间', 'themify')),
			array("value" => "t", "name" => __('顶部', 'themify')),
			array("value" => "tr",	"name" => __('顶部右', 'themify')),
			array("value" => "tl",	"name" => __('顶部左', 'themify')),
			array("value" => "b",	"name" => __('底部', 'themify')),
			array("value" => "br",	"name" => __('底部右', 'themify')),
			array("value" => "bl",	"name" => __('底部左', 'themify')),
			array("value" => "l",	"name" => __('左', 'themify')),
			array("value" => "r",	"name" => __('右', 'themify'))
		);
		$options_vertical = array(
			array('name'=> '',					 'value' => ''),
			array('name'=> __('是', 'themify'), 'value' => 'yes'),
			array('name'=> __('否', 'themify'),	 'value' => 'no')
		);
		$feature_sizes = array(
			array( 'value' => 'blank', 'name' => '' ),
			array( 'value' => 'thumbnail', 'name' => __('缩略图', 'themify') ),
			array( 'value' => 'medium', 'name' => __('中', 'themify') ),
			array( 'value' => 'large', 'name' => __('大', 'themify') ),
			array( 'value' => 'full', 'name' => __('原始图像', 'themify') )
		);
		if(themify_check('setting-img_settings_use')){
			$checked_use = "checked='checked'";
		}
		if(themify_check('setting-img_settings_legacy')){
			$checked_legacy = "checked='checked'";
		}
		$output = '<div class="module">
				<div class="label">img.php</div> 
				<div class="row">
					<input type="checkbox" class="disable_img_php" name="setting-img_settings_use" '.$checked_use.'/> ' . __('全局禁止img.php', 'themify') . '<br/>
					<small>' . __('(WordPress的特色图片或将使用原始图像)', 'themify') . '</small>
					<br/>
				</div>
				<div class="show_if_disabled_img_php">
				<div class="label">' . __('默认是特色图片尺寸', 'themify') . '</div>
				<div class="show_if_disabled_img_php row">
					<select name="setting-global_feature_size">';                                                                                              
					foreach($feature_sizes as $option){
						if($option['value'] == themify_get('setting-global_feature_size')){
							$output .= '<option value="'.$option['value'].'" selected="selected">';
								$output .= $option['name'];
							$output .= '</option>';
						} else {
							$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';
						}
					}
					$output .= '</select>
				</div>
				</div>
			<!-- BEGIN Show if img.php is enabled -->
			<div class="show_if_enabled_img_php">
				<div class="label">' . __('图像质量', 'themify') . '</div> 
				<div class="row">
					<input class="width2" type="text" name="setting-img_settings_quality" value="'.themify_get('setting-img_settings_quality').'"> <small>' . __('max 100 (higher = better quality, but bigger file size)', 'themify') . '</small>
				</div>

				<div class="label">' . __('裁剪对齐', 'themify') . '</div> 
				<div class="row">
					
					<select name="setting-img_settings_crop_option"><option></option>';
					foreach($options as $option){
						if($option['value'] == themify_get('setting-img_settings_crop_option')){
							$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';
						} else {
							$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';
						}
					}
		$output .= '</select></div>
				 <div class="label">' . __('垂直裁剪', 'themify') . '</div> 
				<div class="row">
					
					<select name="setting-img_settings_vertical_crop_option">';
					foreach($options_vertical as $option_vertical){
						if($option_vertical['value'] == themify_get('setting-img_settings_vertical_crop_option')){
							$output .= '<option value="'.$option_vertical['value'].'" selected="selected">'.$option_vertical['name'].'</option>';
						} else {
							$output .= '<option value="'.$option_vertical['value'].'">'.$option_vertical['name'].'</option>';
						}
					}
		$output .= '</select> <small>' . __('(选择\'no\' 来全局禁用垂直裁剪)', 'themify') . '</small></div>
		</div>
		<!-- END Show if img.php is enabled -->
				 </div>';
				 
		return $output;
	}

	
/* 	Styling Modules
/***************************************************************************/	
	
	///////////////////////////////////////////
	// Divider Module
	///////////////////////////////////////////
	function themify_divider($data=array()){
		return '<hr/>';
	}
	
	///////////////////////////////////////////
	// Image Preview Module
	///////////////////////////////////////////
	function themify_image_preview($data=array()){
		global $config;
		$temp = get_data();
		$output = '<div class="preset">';
		if($data['attr']['src'] != ""){
			$img_folders = array(0 => array('_a' => array('src' => $data['attr']['src']))); 	
		} else {
			$img_folders = $config['folders']['_c']['images'];	
		}
		if(is_array($img_folders)){
			if(isset($img_folders['_a']['src'])){
				$folder = $folder['_a']['src'];
				if(is_dir(TEMPLATEPATH.'/'.$folder)){
					if($handle = opendir(TEMPLATEPATH.'/'.$folder)) {
						while (false !== ($file = readdir($handle))) {
							$ext = substr(strrchr($file, '.'), 1);
							if($ext == 'jpg' || $ext == 'gif' || $ext == 'png'){
								$fullpath = get_bloginfo('template_directory')."/".$folder.$file;
								$savedpath = $temp['styling-'.$data['category'].'-'.$data['title'].'-background_image-value-value'];
								if(trim($fullpath) == trim($savedpath)){
									$output .= '<a href="#" title="'.$folder.$file.'"><span title="'.$folder.$file.'"></span>'.themify_get_image('w=50&h=50&src='.$fullpath.'&alt='.$fullpath.'&class=backgroundThumb selected').'</a>';				
								} else {
									$output .= '<a href="#" title="'.$folder.$file.'"><span title="'.$folder.$file.'"></span>'.themify_get_image('w=50&h=50&src='.$fullpath.'&alt='.$fullpath.'&class=backgroundThumb').'</a>';
								}
							}
						}		
						closedir($handle);
					}
				}
			} else {
				foreach($img_folders as $folder){
					$folder = $folder['_a']['src'];
					if(is_dir(TEMPLATEPATH.'/'.$folder)){
						if($handle = opendir(TEMPLATEPATH.'/'.$folder)) {
							while (false !== ($file = readdir($handle))) {
								$ext = substr(strrchr($file, '.'), 1);
								if($ext == 'jpg' || $ext == 'gif' || $ext == 'png'){
									$fullpath = get_bloginfo('template_directory')."/".$folder.$file;
									$savedpath = $temp['styling-'.$data['category'].'-'.$data['title'].'-background_image-value-value'];
									if(trim($fullpath) == trim($savedpath)){
										$output .= '<a href="#" title="'.$folder.$file.'"><span title="'.$folder.$file.'"></span><img alt="'.$fullpath.'" src="'.$fullpath.'" width="50" height="50" class="backgroundThumb selected" /></a>';
										//themify_get_image('w=50&h=50&src='.$fullpath.'&alt='.$fullpath.'&class=backgroundThumb selected')				
									} else {
										$output .= '<a href="#" title="'.$folder.$file.'"><span title="'.$folder.$file.'"></span><img alt="'.$fullpath.'" src="'.$fullpath.'" width="50" height="50" class="backgroundThumb" /></a>';
										//themify_get_image('w=50&h=50&src='.$fullpath.'&alt='.$fullpath.'&class=backgroundThumb')
									}
								}
							}		
							closedir($handle);
						}
					}
				}
			}
		}
		$output .= '</div>';	
		return $output;
	}
	
	///////////////////////////////////////////
	// Background Image Module
	///////////////////////////////////////////
	function themify_background_image($data=array()){	
		if($data['attr']['target'] != ''){
			$target = "<span class='hide target'>".$data['attr']['target']."</span>";	
		}
		$data['value'] = $data['value']['value'];
		$none_checked = "";
		if($data['value']['none']){
			$none_checked = "checked='checked'";
		}
		$output .= '<p class="background_image">
						<span class="label">' . __('背景图片', 'themify') . '</span> 
						'.$target.'
						<input type="text" name="styling-'.$data['category'].'-'.$data['title'].'-background_image-value-value" class="width8 upload-file" id="styling-'.$data['category'].'-'.$data['title'].'-background_image" value="'.$data['value']['value'].'" />
						<input type="checkbox" name="styling-'.$data['category'].'-'.$data['title'].'-background_image-value-none" '.$none_checked.' /> ' . __('无背景图片', 'themify') . '<br /> 
						<span class="pushlabel" style="display:block;">
							' . themify_has_quota('<a href="#" class="upload-btn upload-image" id="styling-'.$data['category'].'-'.$data['title'].'">' . __('+ 上传', 'themify') . '</a>') . '
						</span>
					</p>';		
		return $output;
	}
	
	///////////////////////////////////////////
	// Background Color Module
	///////////////////////////////////////////
	function themify_background_color($data=array()){
		$data['value'] = $data['value']['value'];
		if($data['value']['transparent']){
			$output = '<p class="background_color">
						<span class="label">' . __('背景颜色', 'themify') . '</span> 
						<span class="colorSelect" style=""><span></span></span> <input type="text" disabled name="styling-'.$data['category'].'-'.$data['title'].'-background_color-value-value" class="width4" /> 
						<input type="checkbox" checked="checked" name="styling-'.$data['category'].'-'.$data['title'].'-background_color-value-transparent" class="colorTransparent" /> ' . __('透明', 'themify') . '
					</p>';
		} else {
			$output = '<p>
						<span class="label">' . __('背景颜色', 'themify') . '</span> 
						<span class="colorSelect "style="background-color:#'.$data['value']['value'].';"><span></span></span> <input type="text" name="styling-'.$data['category'].'-'.$data['title'].'-background_color-value-value" value="'.$data['value']['value'].'" class="colorSelectInput width4" /> 
						<input type="checkbox" name="styling-'.$data['category'].'-'.$data['title'].'-background_color-value-transparent" class="colorTransparent" /> ' . __('透明', 'themify') . '
					</p>';
		}
		return $output;
	}
	
	///////////////////////////////////////////
	// Background Repeat Module
	///////////////////////////////////////////
	function themify_background_repeat($data=array()){
		$data['value'] = $data['value']['value'];
		//$options = array('repeat', 'repeat-x','repeat-y','no-repeat');
		$options = array(
				array(
					'value' => 'repeat',
					'name' => __('重复', 'themify')
				),
				array(
					'value' => 'repeat-x',
					'name' => __('重复 X', 'themify')
				),
				array(
					'value' => 'repeat-y',
					'name' => __('重复 Y', 'themify')
				),
				array(
					'value' => 'no-repeat',
					'name' => __('不重复', 'themify')
				)
			);
		$output = '<p><span class="label">' . __('背景重复', 'themify') . '</span>
					<select name="styling-'.$data['category'].'-'.$data['title'].'-background_repeat-value-value"><option> </option>';
		foreach($options as $option){
			if($option['value'] == $data['value']['value']){
				$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';
			} else {
				$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';
			}
		}
		$output .=	'</select></p>';	
		return $output;
	}
	
	///////////////////////////////////////////
	// Background Position Module
	///////////////////////////////////////////
	function themify_background_position($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array(
				array(
					'value' => 'left',
					'name' => __('左', 'themify')
				),
				array(
					'value' => 'center',
					'name' => __('中', 'themify')
				),
				array(
					'value' => 'right',
					'name' => __('右', 'themify')
				)
			);
		$output = '	<p><span class="label">' . __('背景位置', 'themify') . '</span> 
					<select class="background_position positionX"><option> </option>';
		foreach($options as $option){
			if($option['value'] == $data['value']['x']){
				$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
			} else {
				$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
			}
		}
		$output .= '</select>
					<span class="value" style="display:none;">
						<input type="text" name="styling-'.$data['category'].'-'.$data['title'].'-background_position-value-x" value="'.$data['value']['x'].'" class="valueX">
					</span>';
		
		$options = array(
			array(
				'value' => 'top',
				'name' => __('顶部', 'themify')
			),
			array(
				'value' => 'center',
				'name' => __('中间', 'themify')
			),
			array(
				'value' => 'bottom',
				'name' => __('底部', 'themify')
			)
		);
		$output .= '<select class="background_position positionY"><option> </option>';
		
		foreach($options as $option){
			if($option['value'] == $data['value']['y']){
				$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
			} else {
				$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
			}
		}
		$output .= '</select>
					<span class="value" style="display:none;">
						<input type="text" name="styling-'.$data['category'].'-'.$data['title'].'-background_position-value-y" value="'.$data['value']['y'].'" class="valueY">
					</span>
					</p>';
					
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Family Module
	///////////////////////////////////////////
	function themify_font_family($data=array()){
		$data['value'] = $data['value']['value'];
		$fonts = array("Arial, Helvetica, sans-serif",
						"Verdana, Geneva, sans-serif",
						"Georgia, \"Times New Roman\", Times, serif",
						"\"Times New Roman\", Times, serif",
						"Tahoma, Geneva, sans-serif",
						"\"Trebuchet MS\", Arial, Helvetica, sans-serif",
						"Palatino, \"Palatino Linotype\", \"Book Antiqua\", serif",
						"\"Lucida Sans Unicode\", \"Lucida Grande\", sans-serif");
		$output .= '<p><span class="label">' . __('字体', 'themify') . '</span> 
					<select class="fontFamily" name="styling-'.$data['category'].'-'.$data['title'].'-font_family-value-value"><option> </option>';
		foreach($fonts as $font){
			if($font == $data['value']['value']){
				$check = true;
				$output .= '<option value=\''.$font.'\' selected="selected">'.$font.'</option>';
			} else {
				$output .= '<option value=\''.$font.'\'>'.$font.'</option>';	
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Size Module
	///////////////////////////////////////////
	function themify_font_size($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array('px','em','%');
		$output .= '<p><span class="label">' . __('字体大小', 'themify') . '</span> 
					<input type="text" class="width2 valid_num" name="styling-'.$data['category'].'-'.$data['title'].'-font_size-value-value" value="'.$data['value']['value'].'" />
					<select name="styling-'.$data['category'].'-'.$data['title'].'-font_size-value-unit"><option> </option>';
		foreach($options as $option){
			if($option == $data['value']['unit']){
				$output .= '<option value="'.$option.'" selected="selected">'.$option.'</option>';
			} else {
				$output .= '<option value="'.$option.'">'.$option.'</option>';
			}
		}
		$output .=	'</select></p>';	
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Weight Module
	///////////////////////////////////////////
	function themify_font_weight($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array(
			array(
				'value' => 'normal',
				'name' => __('一般', 'themify')
			),
			array(
				'value' => 'bold',
				'name' => __('粗体', 'themify')
			)
		);
		$output = '<p><span class="label">' . __('字体粗细', 'themify') . '</span> <select  name="styling-'.$data['category'].'-'.$data['title'].'-font_weight-value-value"><option> </option>';
		foreach($options as $option){
			if($option['value'] == $data['value']['value']){
				$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
			} else {
				$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Style Module
	///////////////////////////////////////////
	function themify_font_style($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array(
			array(
				'value' => 'normal',
				'name' => __('一般', 'themify')
			),
			array(
				'value' => 'italic',
				'name' => __('斜体', 'themify')
			)
		);
		$output = '<p><span class="label">' . __('字体样式', 'themify') . '</span> <select name="styling-'.$data['category'].'-'.$data['title'].'-font_style-value-value"><option> </option>';
		foreach($options as $option){
			if($option['value'] == $data['value']['value']){
				$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
			} else {
				$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Variant Module
	///////////////////////////////////////////
	function themify_font_variant($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array(
			array(
				'value' => 'normal',
				'name' => __('一般', 'themify')
			),
			array(
				'value' => 'small-caps',
				'name' => __('小型大写字母', 'themify')
			)
		);
		$output = '<p><span class="label">' . __('字体转换', 'themify') . '</span> <select name="styling-'.$data['category'].'-'.$data['title'].'-font_variant-value-value"><option> </option>';
		foreach($options as $option){
			if($option['value'] == $data['value']['value']){
				$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
			} else {
				$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Line Height Module
	///////////////////////////////////////////
	function themify_line_height($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array('px','em','%');
		$output = '	<p><span class="label">' . __('Line-height', 'themify') . '</span>
					<input type="text" class="width2 valid_num"  name="styling-'.$data['category'].'-'.$data['title'].'-line_height-value-value" value="'.$data['value']['value'].'" /><select name="styling-'.$data['category'].'-'.$data['title'].'-line_height-value-unit"><option> </option>';
		foreach($options as $option){
			if($option == $data['value']['unit']){
				$output .= '<option value="'.$option.'" selected="selected">'.$option.'</option>';	
			} else {
				$output .= '<option value="'.$option.'">'.$option.'</option>';	
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Text Transform Module
	///////////////////////////////////////////
	function themify_text_transform($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array(
			array(
				'value' => 'capitalize',
				'name' => __('Capitalize', 'themify')
			),
			array(
				'value' => 'uppercase',
				'name' => __('大写', 'themify')
			),
			array(
				'value' => 'lowercase',
				'name' => __('小写', 'themify')
			),
			array(
				'value' => 'none',
				'name' => __('无', 'themify')
			)
		);
		$output = '	<p><span class="label">' . __('文本转换', 'themify') . '</span> <select name="styling-'.$data['category'].'-'.$data['title'].'-text_transform-value-value"><option> </option>';
		foreach($options as $option){
			if($option['value'] == $data['value']['value']){
				$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
			} else {
				$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Text Decoration Module
	///////////////////////////////////////////
	function themify_text_decoration($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array(
			array(
				'value' => 'underline',
				'name' => __('下划线', 'themify')
			),
			array(
				'value' => 'overline',
				'name' => __('上划线', 'themify')
			),
			array(
				'value' => 'line-through',
				'name' => __('中间划线', 'themify')
			),
			array(
				'value' => 'none',
				'name' => __('无', 'themify')
			)
		);
		$output = '	<p><span class="label">' . __('文本装饰', 'themify') . '</span> <select name="styling-'.$data['category'].'-'.$data['title'].'-text_decoration-value-value"><option> </option>';
		foreach($options as $option){
			if($option['value'] == $data['value']['value']){
				$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
			} else {
				$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Font Color Module
	///////////////////////////////////////////
	function themify_color($data=array()){
		$data['value'] = $data['value']['value'];
		return '<p><span class="label">' . __('颜色', 'themify') . '</span> <span class="colorSelect" style="background:#'.$data['value']['value'].';"><span></span></span> <input type="text" class="colorSelectInput width4" value="'.$data['value']['value'].'" name="styling-'.$data['category'].'-'.$data['title'].'-color-value-value" /></p>';
	}
	
	///////////////////////////////////////////
	// Padding Module
	///////////////////////////////////////////
	function themify_padding($data=array()){
		$data['value'] = $data['value']['value'];
		if($data['value']['checkbox']){
			$checked = "checked='checked'";
			$individuals = "style='display:none;'";	
		} else {
			$same = "style='display:none;'";
		}
		$output .= '<div>
						<p>
							<span class="label">' . __('填充', 'themify') . '</span>
							<span class="same" '.$same.'>
								<input type="text" class="width2 valid_num" name="styling-'.$data['category'].'-'.$data['title'].'-padding-value-same" value="'.$data['value']['same'].'" /> <small>px</small>
							</span>
							<span class="individuals" '.$individuals.'>
								<input type="text" class="width2 valid_num" name="styling-'.$data['category'].'-'.$data['title'].'-padding-value-top" value="'.$data['value']['top'].'" /> top 
								<input type="text" class="width2 valid_num" name="styling-'.$data['category'].'-'.$data['title'].'-padding-value-right" value="'.$data['value']['right'].'" /> right 
								<input type="text" class="width2 valid_num"  name="styling-'.$data['category'].'-'.$data['title'].'-padding-value-bottom" value="'.$data['value']['bottom'].'"/> bottom 
								<input type="text" class="width2 valid_num" name="styling-'.$data['category'].'-'.$data['title'].'-padding-value-left" value="'.$data['value']['left'].'" /> left <small>(px)</small>
							</span>
						</p>
						<p>
							<span class="pushlabel" style="display:block;">
								<input type="checkbox" name="styling-'.$data['category'].'-'.$data['title'].'-padding-value-checkbox" class="padding-switch" '.$checked.' /> ' . __('全部一样', 'themify') . ' 
							</span>
						</p>
					</div>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Margin Module
	///////////////////////////////////////////
	function themify_margin($data=array()){
		$data['value'] = $data['value']['value'];
		if($data['value']['checkbox']){
			$checked = "checked='checked'";
			$individuals = "style='display:none;'";	
		} else {
			$same = "style='display:none;'";
		}
		$output .= '<div>
						<p>
							<span class="label">' . __('边', 'themify') . '</span>';
		$output .= '<span class="same" '.$same.'>
						<input type="text" class="width2 valid_num" name="styling-'.$data['category'].'-'.$data['title'].'-margin-value-same" value="'.$data['value']['same'].'" /> <small>px</small>
					</span>
					<span class="individuals" '.$individuals.'>
						<input type="text" class="width2 valid_num" name="styling-'.$data['category'].'-'.$data['title'].'-margin-value-top" value="'.$data['value']['top'].'" /> top 
						<input type="text" class="width2 valid_num" name="styling-'.$data['category'].'-'.$data['title'].'-margin-value-right" value="'.$data['value']['right'].'" /> right 
						<input type="text" class="width2 valid_num"  name="styling-'.$data['category'].'-'.$data['title'].'-margin-value-bottom" value="'.$data['value']['bottom'].'"/> bottom 
						<input type="text" class="width2 valid_num" name="styling-'.$data['category'].'-'.$data['title'].'-margin-value-left" value="'.$data['value']['left'].'" /> left <small>(px)</small>
					</span>
				</p>
				<p>
					<span class="pushlabel" style="display:block;">
						<input type="checkbox" name="styling-'.$data['category'].'-'.$data['title'].'-margin-value-checkbox" '.$checked.' class="margin-switch" /> ' . __('全部一样', 'themify') . ' 
					</span>
				</p>
			</div>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Height Module
	///////////////////////////////////////////
	function themify_height($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array('px','em','%');
		$output = '	<p><span class="label">' . __('高度', 'themify') . '</span> 
					<input type="text" class="width2 valid_num" value="'.$data['value']['value'].'" name="styling-'.$data['category'].'-'.$data['title'].'-height-value-value" />  
					<select name="styling-'.$data['category'].'-'.$data['title'].'-height-value-unit"><option> </option>';
		foreach($options as $option){
			if($option == $data['value']['unit']){
				$output .= '<option value="'.$option.'" selected="selected">'.$option.'</option>';	
			} else {
				$output .= '<option value="'.$option.'">'.$option.'</option>';	
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Width Module
	///////////////////////////////////////////
	function themify_width($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array('px','em','%');
		$output = '	<p><span class="label">' . __('宽度', 'themify') . '</span> 
					<input type="text" class="width2 valid_num" value="'.$data['value']['value'].'" name="styling-'.$data['category'].'-'.$data['title'].'-width-value-value" />  
					<select name="styling-'.$data['category'].'-'.$data['title'].'-width-value-unit"><option> </option>';
		foreach($options as $option){
			if($option == $data['value']['unit']){
				$output .= '<option value="'.$option.'" selected="selected">'.$option.'</option>';	
			} else {
				$output .= '<option value="'.$option.'">'.$option.'</option>';	
			}
		}
		$output .= '</select></p>';
		return $output;
	}
	
	///////////////////////////////////////////
	// Border Module
	///////////////////////////////////////////
	function themify_border($data=array()){
		$data['value'] = $data['value']['value'];
		if($data['value']['checkbox']){
			$checked = "checked='checked'";
			$individuals = "style='display:none;'";	
		} else {
			$same = "style='display:none;'";
		}
		$options = array(
			array(
				'value' => 'solid',
				'name' => __('实线', 'themify')
			),
			array(
				'value' => 'dashed',
				'name' => __('虚线', 'themify')
			),
			array(
				'value' => 'dotted',
				'name' => __('虚线Dotted', 'themify')
			),
			array(
				'value' => 'double',
				'name' => __('双点线', 'themify')
			)
		);
		$output = '<div><p>
						<span class="label">' . __('边框', 'themify') . '</span> 
						<span class="same" '.$same.'>
							<span class="colorSelect" style="background-color:#'.$data['value']['same_color'].'"><span></span></span>  <input type="text" value="'.$data['value']['same_color'].'" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-same_color" class="width4 colorSelectInput" /> 
							<input type="text" class="width2 valid_num" value="'.$data['value']['same'].'" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-same" /> <small>px</small> 
							<select name="styling-'.$data['category'].'-'.$data['title'].'-border-value-same_style"><option> </option>';
							foreach($options as $option){
								if($option['value'] == $data['value']['same_style']){
									$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
								} else {
									$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
								}
							}
		$output .= '		</select>
						</span>
						<span class="individuals" '.$individuals.'>
						<span class="borders">
							<span class="colorSelect" style="background-color:#'.$data['value']['top_color'].';"><span></span></span> <input type="text" value="'.$data['value']['top_color'].'" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-top_color" class="width4 colorSelectInput" /> 
							<input type="text" class="width2 valid_num" value="'.$data['value']['top'].'" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-top" /> <small>px</small>
							<select name="styling-'.$data['category'].'-'.$data['title'].'-border-value-top_style"><option> </option>';
							foreach($options as $option){
								if($option['value'] == $data['value']['top_style']){
									$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
								} else {
									$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
								}
							}
		$output .= '		</select> ' . __('顶部', 'themify') . '
						</span>
						<span class="pushlabel borders" style="display:block;">
							<span class="colorSelect" style="background-color:#'.$data['value']['right_color'].';"><span></span></span> <input type="text" value="'.$data['value']['right_color'].'" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-right_color" class="width4 colorSelectInput" /> 
							<input type="text" class="width2 valid_num" value="'.$data['value']['right'].'" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-right" /> <small>px</small>
							<select name="styling-'.$data['category'].'-'.$data['title'].'-border-value-right_style"><option> </option>';
							foreach($options as $option){
								if($option['value'] == $data['value']['right_style']){
									$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
								} else {
									$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
								}
							}
		$output .= '		</select> ' . __('右', 'themify') . '
						</span>
						<span class="pushlabel borders" style="display:block;">
							<span class="colorSelect" style="background-color:#'.$data['value']['bottom_color'].';"><span></span></span> <input type="text" value="'.$data['value']['bottom_color'].'" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-bottom_color" class="width4 colorSelectInput" /> 
							<input type="text" class="width2 valid_num" value="'.$data['value']['bottom'].'" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-bottom" /> <small>px</small>
							<select name="styling-'.$data['category'].'-'.$data['title'].'-border-value-bottom_style"><option> </option>';
							foreach($options as $option){
								if($option['value'] == $data['value']['bottom_style']){
									$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
								} else {
									$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
								}
							}
		$output .= '		</select> ' . __('底部', 'themify') . '
						</span>
						<span class="pushlabel borders" style="display:block;">
							<span class="colorSelect" style="background-color:#'.$data['value']['left_color'].';"><span></span></span> <input type="text" value="'.$data['value']['left_color'].'" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-left_color" class="width4 colorSelectInput" /> 
							<input type="text" class="width2 valid_num" value="'.$data['value']['left'].'" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-left" /> <small>px</small>
							<select name="styling-'.$data['category'].'-'.$data['title'].'-border-value-left_style"><option> </option>';
							foreach($options as $option){
								if($option['value'] == $data['value']['left_style']){
									$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
								} else {
									$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
								}
							}
		$output .= '		</select> ' . __('左', 'themify') . '
						</span>
					</span>
					</p>
					<p>
						<span class="pushlabel" style="display:block;">
							<input type="checkbox" class="border-switch" name="styling-'.$data['category'].'-'.$data['title'].'-border-value-checkbox" '.$checked.' /> ' . __('全部一样', 'themify') . '
						</span>
					</p>
				</div>';				
		return $output;
	}
	
	///////////////////////////////////////////
	// Position Module
	///////////////////////////////////////////
	function themify_position($data=array()){
		$data['value'] = $data['value']['value'];
		$options = array(
			array(
				'value' => 'static',
				'name' => __('静止', 'themify')
			),
			array(
				'value' => 'fixed',
				'name' => __('固定', 'themify')
			),
			array(
				'value' => 'relative',
				'name' => __('相对', 'themify')
			),
			array(
				'value' => 'absolute',
				'name' => __('绝对', 'themify')
			),
			
		);
		$options_x = array(
			array(
				'value' => 'top',
				'name' => __('顶部', 'themify')
			),
			array(
				'value' => 'bottom',
				'name' => __('底部', 'themify')
			),			
		);
		$options_y = array(
			array(
				'value' => 'left',
				'name' => __('左', 'themify')
			),
			array(
				'value' => 'right',
				'name' => __('右', 'themify')
			)
		);
		if($data['value']['value'] != 'fixed' && $data['value']['value'] != 'absolute'){
			$display = "style='display:none;'";	
		}
		$output = '	<p><span class="label">' . __('位置', 'themify') . '</span>
					<select name="styling-'.$data['category'].'-'.$data['title'].'-position-value-value" class="select_position"><option> </option>';
		foreach($options as $option){
			if($option['value'] == $data['value']['value']){
				$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
			} else {
				$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
			}
		}
		$output .= '</select></p>
					<p class="position_display" '.$display.'>
						<span class="pushlabel" style="display:block;">
						<select name="styling-'.$data['category'].'-'.$data['title'].'-position-value-x"><option> </option>';
						foreach($options_x as $option){
							if($option['value'] == $data['value']['x']){
								$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
							} else {
								$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
							}
						}	
		$output .=	'	</select>
						<input type="text" class="width2 valid_num" value="'.$data['value']['x_value'].'" name="styling-'.$data['category'].'-'.$data['title'].'-position-value-x_value" /> <small>px</small> 
						</span>
						<span class="pushlabel" >
						<select name="styling-'.$data['category'].'-'.$data['title'].'-position-value-y"><option> </option>';
						foreach($options_y as $option){
							if($option['value'] == $data['value']['y']){
								$output .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';	
							} else {
								$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';	
							}
						}	
		$output .=	'	</select>
						<input type="text" class="width2 valid_num" value="'.$data['value']['y_value'].'" name="styling-'.$data['category'].'-'.$data['title'].'-position-value-y_value" /> <small>px</small> 
						</span>
					</p>';
		return $output;	
	}

?>