<?php

/**

 * @package themify

 * @since 1.1.3

 * @author Elio Rivero

 * 

 * ----------------------------------------------------------------------

 * 					DO NOT EDIT THIS FILE

 * ----------------------------------------------------------------------

 * 				Themify Shortcodes

 *  			http://themify.me

 *  			Copyright (C) 2011 Themify

 *

 * Shortcodes:

 * 		button

 * 		col

 * 		img

 * 		hr

 * 		quote

 * 		is_logged_in

 * 		is_guest

 * 		map

 * 		video

 * 		flickr

 * 		post_slider

 * 		slider

 * 		list_posts

 * 		box

 * 		author-box

 * 

 * Functions:

 * 		themify_shortcodes_js_css

 * 		themify_shortcode

 * 		themify_shortcode_list_posts

 * 		themify_shortcode_flickr

 * 		themify_shortcode_slide

 * 		themify_shortcode_slider

 * 		themify_shortcode_post_slider

 * 		themify_shortcode_author_box

 * 		themify_shortcode_box

 *		themify_fix_shortcode_empty_paragraph

 * 

 * 

 ***************************************************************************/



/**

 * Enqueues JS, CSS and writes inline scripts

 */

add_action('wp_enqueue_scripts', 'themify_shortcodes_js_css');



/**

 * Add Themify Shortcodes

 */

add_shortcode('is_logged_in', 'themify_shortcode');

add_shortcode('is_guest', 'themify_shortcode');

add_shortcode('button', 'themify_shortcode');

add_shortcode('quote', 'themify_shortcode');

add_shortcode('col', 'themify_shortcode');

add_shortcode('img', 'themify_shortcode');

add_shortcode('hr', 'themify_shortcode');

add_shortcode('map', 'themify_shortcode');

add_shortcode('video', 'themify_shortcode');

add_shortcode('list_posts', 'themify_shortcode_list_posts');

add_shortcode('flickr', 'themify_shortcode_flickr');

add_shortcode('box', 'themify_shortcode_box');

add_shortcode('post_slider', 'themify_shortcode_post_slider');

add_shortcode('slider', 'themify_shortcode_slider');

add_shortcode('slide', 'themify_shortcode_slide');

add_shortcode('author_box', 'themify_shortcode_author_box');



/**

 * Fix empty auto paragraph in shortcodes

 */

add_filter('the_content', 'themify_fix_shortcode_empty_paragraph');

add_filter('the_excerpt', 'themify_fix_shortcode_empty_paragraph');

add_filter('widget_text', 'themify_fix_shortcode_empty_paragraph');



/**

 * Enable shortcode in excerpt

 */

add_filter('the_excerpt', 'do_shortcode');	

add_filter('the_excerpt', 'shortcode_unautop');



/**

 * Enable shortcode in text widget

 */

add_filter('widget_text', 'do_shortcode');	

add_filter('widget_text', 'shortcode_unautop');



/**

 * Enqueue JavaScript and stylesheets required by shortcodes

 * @since 1.1.2

 */	

function themify_shortcodes_js_css(){

	global $version;

	

	//Use expanded versions for development or minified versions for production

	$min = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

	

	//Enqueue general shortcodes style

	wp_enqueue_style( 'themify-shortcodes', THEMIFY_URI . '/css/shortcodes.css', array(), $version);

	

	//Enqueue general shortcodes script

	wp_register_script('themify-shortcodes-js', THEMIFY_URI . "/js/themify.shortcodes.js", array('jquery'), $version, true );



	//Register carousel script

	wp_register_script('themify-carousel-js', THEMIFY_URI . "/js/carousel$min.js", '', $version, true);

	

	//Register map scripts

	wp_register_script('themify-map-script', 'http://maps.google.com/maps/api/js?sensor=false', array(), $version, true);

	wp_register_script('themify-map-shortcode', THEMIFY_URI . '/js/themify.map.js', array(), $version, true);

	

	//Register video script

	wp_register_script('themify-video-script', THEMIFY_URI.'/js/flowplayer-3.2.4.min.js', array(), $version, true);



}



/**

 * Creates shortcodes

 * @param Object $atts

 * @param String $content

 * @param String $code

 * @return String

 */

function themify_shortcode($atts, $content=null, $code=""){

	switch($code){

		case 'is_logged_in':

			if(is_user_logged_in()){

				return do_shortcode($content);

			}

		break;

		case 'is_guest':

			if(!is_user_logged_in()){

				return do_shortcode($content);

			}

		break;

		case 'button':

			extract( shortcode_atts( array(	'color' => "",

										   	'size' 	=> "",

											'style'	=> "",

											'link' 	=> "#",

											'target'=> "",

											'text'	=> ""

											), $atts ) );	

			if($color != ''){

				$color = "background: $color;";

			}

			if($text != ''){

				$text = "color: $text;";	

			}

			return '<a href="'.$link.'" class="shortcode button '.$style.' '.$size.'" style="'.$color.$text.'" target="'.$target.'">'.do_shortcode($content).'</a>';

		break;

		case 'quote':

			return '<blockquote class="shortcode quote">'.do_shortcode($content).'</blockquote>';

		break;

		case 'col':

			wp_enqueue_script('themify-shortcodes-js');

			extract( shortcode_atts( array( 'grid' => ""), $atts));

			return "<div class='shortcode col".$grid."'>".do_shortcode($content)."</div>";

		break;

		case 'img':

			extract( shortcode_atts( array(	'class' => "",

											'src' 	=> "",

											'id'	=> "",

											'h'		=> "",

											'w'		=> "",

											'crop'	=> true

											), $atts ) );	

			return themify_get_image("class=$class&src=$src&id=$id&h=$h&w=$w&crop=$crop");

		break;

		case 'hr':

			extract( shortcode_atts( array( 'color' => '',

											'width' => '',

											'border_width' => ''

			), $atts));

			$hr = '<hr class="shortcode hr '.$color.'" ';

			if( '' != $width || '' != $border_width  ){

				$hrstyle = 'style="';

				if( '' != $width  ){

					$hrstyle .= 'width:' . $width . ';';

				}

				if( '' != $border_width  ){

					if( preg_match('/MSIE 7/i', $_SERVER['HTTP_USER_AGENT'] ) ){

						$hrstyle .= 'height:' . $border_width . ';';

					}
					$hrstyle .= 'border-width:' . $border_width . ';';

				}

				$hr .= $hrstyle . '"';

			}

			return $hr . ' />';

		break;

		case 'map':

			wp_enqueue_script('themify-map-script');

			wp_enqueue_script('themify-map-shortcode');

			extract( shortcode_atts( array( 'address' => '99 Blue Jays Way, Toronto, Ontario, Canada', 'width' => "500px", 'height' => "300px", 'zoom' => 15), $atts));

			$num = rand(0,10000);

			return '<script type="text/javascript">	

						jQuery(document).ready(function() {

					  		initialize("'.$address.'",'.$num.','.$zoom.');

						});

					</script>

					<div class="shortcode map">

						<div id="themify_map_canvas_'.$num.'" style="display: block;width:'.$width.';height:'.$height.';" class="map-container">&nbsp;</div>

					</div>';

		break;

		case 'video':

			wp_enqueue_script('themify-video-script');

			extract( shortcode_atts( array(	'width' => "500px", 

											'height' => "300px", 

											'src' => "#"), $atts));

			$num = rand(0,10000);

			return '<div class="shortcode video"><a href="'.$src.'" style="display:block;width:'.$width.';height:'.$height.'" id="themify_player_'.$num.'"></a></div>

			<script type="text/javascript">jQuery(document).ready(function(){ flowplayer("themify_player_'.$num.'", "'.THEMIFY_URI.'/js/flowplayer-3.2.5.swf", { clip: { autoPlay:false } }); });</script>';

		break;

	}

}



/**

 * List posts using get_posts

 * @param Object $atts

 * @param String $content

 * @return String

 */





function themify_shortcode_list_posts($atts, $content = null) {

	wp_enqueue_script('themify-shortcodes-js');

	extract(shortcode_atts(array(

		'title' => 'yes',

		'category' => '0',

		'limit' => '5',

		'more_text' => __('更多...', 'themify'),

		'excerpt_length' => '',

		'image' => 'no',

		'image_w' => '220',

		'image_h' => '150',

		'display' => 'none',

		'style' => 'list-post',

		'post_date' => 'no',

		'post_meta' => 'no',

		'unlink_title' => 'no',

		'unlink_image' => 'no',

		'image_size' => 'thumbnail',

		'post_type' => 'post',

		'order' => 'DESC',

		'orderby' => 'date'

	), $atts));

	global $wpdb, $post, $table_prefix;

	if ($category == 0) {

		$posts = get_posts(array(

			'numberposts' => $limit,

			'post_type' => $post_type,

			'order' => $order,

			'orderby' => $orderby

		));

	} //$category == 0

	else {

		$arraycat = array($category);

		$listcat  = $category;

		$arraycat = explode(',', $listcat);

		$posts    = get_posts('category='.$listcat.'&numberposts='.$limit.'&post_type=' . $post_type .

			'&order=' . $order . '&orderby=' . $orderby);

		

	}

	//dumpit($posts);

	if ($posts) {

		$customlistpoststr = '<!-- shortcode list_posts --> <div class="shortcode clearfix list-posts layout ' . $style . ' ">';

		foreach ($posts as $post){

			setup_postdata($post);

			global $more;

			$more = 0;

			$post_class = "";

			if ( themify_get('external_link') != '')

				$thislink = themify_get('external_link');

			else

				$thislink = get_permalink($post->ID);

			

			//Encode permalink for custom post types to avoid situations like 

			//http://localhost/themify/folo/?post_type=highlights&p=1106

			if( 'post' != $post_type)

				$thislink = urlencode($thislink);

			

			foreach(get_post_class() as $postclass){

				$post_class .= " ".$postclass;

			}

			$customlistpoststr .= '<div class="post clearfix ' . $post_class . '">';

			if ($image == "yes") {

				if( 'no' == $unlink_image ){

					$customlistpoststr .= themify_get_image('image_size='.$image_size.'&ignore=true&w='.$image_w.'&h='.$image_h.'&alt='.get_the_title().'&before=<p class="post-image"><a href="' . $thislink . '">&after=</a></p>');

				}

				else{

					$customlistpoststr .= themify_get_image('image_size='.$image_size.'&ignore=true&w='.$image_w.'&h='.$image_h.'&alt='.get_the_title().'&before=<p class="post-image">&after=</p>');

				}

			} //$image == "yes"

			$customlistpoststr .= '<div class="post-content">';

			if ($post_date == "yes") {

				$customlistpoststr .= '<p class="post-date">' . get_the_date() . '</p>';

			} //$post_date == "yes"

			if($title == "yes") {

				if( 'no' == $unlink_title ){

					$customlistpoststr .= '<h3 class="post-title"><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>';

				}

				else {

					$customlistpoststr .= '<h3 class="post-title">' . get_the_title() . '</h3>';

				}

			}

			if ($post_meta == "yes") {

				$customlistpoststr .= '<p class="post-meta">

				<span class="post-author">' . get_the_author() . '</span>

				<span class="post-category">' . get_the_category_list(', ') . '</span>';

				$num_comments = get_comments_number();

				if (comments_open()) {

					 ob_start();

					 comments_popup_link('0', '1', '%', 'comments-link', '');

					$write_comments = ob_get_contents();

					ob_clean(); 

				} //comments_open()

				else {

					$write_comments = '';

				}

				$customlistpoststr .= '<span class="post-comment">' . $write_comments . '</span>';

				if( has_tag() ) {

					$customlistpoststr .= '<span class="post-tag">' . get_the_tag_list('', ', ') . '</span>';

				}

			$customlistpoststr .= '</p>';	

			} //$post_meta == "yes"

			if ($display == "content") {

				$customlistpoststr .= themify_get_content($more_text);

			} //$display == "content"

			if ($display == "excerpt") {

				if($excerpt_length) {

					$customlistpoststr .= themify_excerpt($excerpt_length);

				}

				else {

					$customlistpoststr .= get_the_excerpt();

				}

				

			} //$display == "excerpt"

			$customlistpoststr .= '</div>

	</div>';

		} //endforeach

		wp_reset_postdata();

		$customlistpoststr .= '</div>

						<!-- /shortcode list_posts -->';

	} //$posts

	return $customlistpoststr;

}





/**

 * Insert Flickr Gallery by user, set or group

 * @param Object $atts

 * @param String $content

 * @return String

 */	

function themify_shortcode_flickr($atts, $content = null) {

	extract(shortcode_atts(array(

		'user' => '',

		'set' => '',

		'group' => '',

		'limit' => '8',

		'size' => 's',

		'display' => 'latest'

	), $atts));

	$flickrstr = "";

	if($user) {

		$flickrstr = '<!-- shortcode Flickr --> <div class="shortcode clearfix flickr"><script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count='.$limit.'&amp;display='.$display.'&amp;size='.$size.'&amp;layout=x&amp;source=user&amp;user='.$user.'"></script></div>';

	}

	

	if($set) {

		if($flickrstr == "") {

		$flickrstr = '<div class="shortcode clearfix flickr"><script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count='.$limit.'&amp;display='.$display.'&amp;size='.$size.'&amp;layout=x&amp;source=user_set&amp;set='.$set.'"></script></div>';

		}

	}

	if($group) {

		if($flickrstr == "") {

			$flickrstr = '<div class="shortcode clearfix flickr"><script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count='.$limit.'&amp;display='.$display.'&amp;size='.$size.'&amp;layout=x&amp;source=group&amp;group='.$group.'"></script></div> <!-- /shortcode Flickr -->';

		}

	}

	return $flickrstr;

}

/**

 * Creates one slide for the slider shortcode

 * @param Object $atts

 * @param String $content

 * @return String

 */

function themify_shortcode_slide($atts, $content = null)

{

	extract(shortcode_atts(array(), $atts));

	$output = '<li><div class="slide-wrap">'.do_shortcode($content).'</div></li>';

	return $output;

}



/**

 * Creates a slider using the slide shortcode

 * @param Object $atts

 * @param String $content

 * @return String

 */

function themify_shortcode_slider($atts, $content = null){

	wp_enqueue_script('themify-carousel-js');

	extract(shortcode_atts(array(

		'wrap' => 'yes',

		'visible' => '1',

		'scroll' => '1',

		'auto' => '0',

		'speed' => 'normal',

		'slider_nav' => 'yes',

		'pager' => 'yes',

		'class' => ''

	), $atts));

	$numsldrtemp = rand(0, 10000);

	$content = do_shortcode(shortcode_unautop($content));

	$strsldr = '';

	

	if( '0' == $auto )

		$play = 'false';

	else

		$play = 'true';

	switch($speed){

		case 'fast':

			$speed = '.5';

		break;

		case 'normal':

			$speed = '1';

		break;

		case 'slow':

			$speed = '4';

		break;

	}

	

	$wrapvar = 'false';

	if( 'yes' == $wrap ){

		$wrapvar = 'true';

	}

	

	$strsldr = '<!-- shortcode slider -->	<div id="slider-'.$numsldrtemp.'" class="shortcode clearfix slider '.$class.'">

	

	<ul class="slides">

	'.$content.'

	</ul>';

	

	$strsldr .= '</div><script type="text/javascript">

		

		jQuery(window).load(function() {

		

		jQuery("#slider-'.$numsldrtemp.' .slides").carouFredSel({

			responsive: true,';

				

		if ( 'yes' == $slider_nav ) {

			$strsldr .= '

				prev: "#slider-'.$numsldrtemp.' .carousel-prev",

				next: "#slider-'.$numsldrtemp.' .carousel-next",';

		}

		if( 'yes' == $pager ){

			$strsldr .= '

				pagination: "#slider-'.$numsldrtemp.' .carousel-pager",';

		}

		$strsldr .= '

			circular: '.$wrapvar.',

			infinite: '.$wrapvar.',

			auto: {

				play : '.$play.',

				pauseDuration: '.$auto.'*1000,

				duration: '.$speed.'*1000

			},

			scroll: {

				items: '.$scroll.',

				duration: '.$speed.'*1000,

				wipe: true

			},

			items: {

				visible: {

					min: 1,

					max: '.$visible.'

				},

				width: 120

			},

			onCreate : function (){

				jQuery(".slider").css( {

					"height": "auto",

					"visibility" : "visible"

				});

			}

		});

			

	});

	</script> <!-- /shortcode slider -->';

	return $strsldr;

}



/**

 * Create a slider with posts retrieved through get_posts

 * @param Object $atts

 * @param String $content

 * @return String

 */





function themify_shortcode_post_slider($atts, $content = null){

	wp_enqueue_script('themify-carousel-js');	

	extract(shortcode_atts(array(

		'visible' => '1',

		'scroll' => '1',

		'auto' => '0',

		'wrap' => 'yes',

		'excerpt_length' => '20',

		'speed' => 'normal',

		'slider_nav' => 'yes',

		'pager' => 'yes',

		'limit' => '5',

		'category' => '',

		'image' => 'yes',

		'image_w' => '240px',

		'image_h' => '180px',

		'more_text' => __('更多...', 'themify'),

		'title' => 'yes',

		'display' => 'none',

		'post_meta' => 'no',

		'post_date' => 'no',

		'width' => '',

		'height' => '',

		'class' => '',

		'unlink_title' => 'no',

		'unlink_image' => 'no',

		'image_size' => 'thumbnail'

	), $atts));

	

	$wrapvar = 'false';

	if( 'yes' == $wrap ){

		$wrapvar = 'true';

	}

	if( '0' == $auto )

		$play = 'false';

	else

		$play = 'true';

	

	switch($speed){

		case 'fast':

			$speed = '.5';

		break;

		case 'normal':

			$speed = '1';

		break;

		case 'slow':

			$speed = '4';

		break;

	}

	

	$numsldr = rand(0, 10000);

	$postsliderstr = '';

	global $wpdb, $post, $table_prefix;

	if ($category == 0) {

		$posts = get_posts(array(

			'numberposts' => $limit

		));

	} //$category == 0

	else {

		$arraycat = array(

			$category

		);

		$listcat  = $category;

		$arraycat = explode(',', $listcat);

		$posts    = get_posts('category='.$listcat.'&numberposts='.$show);



	}

	

	if ($posts) {

		$postsliderstr = '<!-- shortcode post_slider --> <div id="post-slider-' . $numsldr . '" style="width: ' . $width . '; height: ' . $height . ';" class="shortcode clearfix post-slider ' . $class . '">

		<ul class="slides">';

		foreach ($posts as $post):

			setup_postdata($post);

			global $more;

			$more       = 0;

			$post_class = "";

			if ( themify_get('external_link') != '')

				$thislink = themify_get('external_link');

			else

				$thislink = get_permalink();

			foreach (get_post_class() as $postclass) {

				$post_class .= " " . $postclass;

			} //get_post_class() as $postclass

			$postsliderstr .= '<li><div  class="slide-wrap ' . $post_class . '">';

			if ($image == "yes") {

				if( 'no' == $unlink_image ){

					$postsliderstr .= themify_get_image('image_size='.$image_size.'&ignore=true&w=' . $image_w . '&h=' . $image_h . '&alt=' . get_the_title() . '&before=<p class="post-image"><a href="' . $thislink . '">&after=</a></p>');

				}

				else{

					$postsliderstr .= themify_get_image('image_size='.$image_size.'&ignore=true&w=' . $image_w . '&h=' . $image_h . '&alt=' . get_the_title() . '&before=<p class="post-image">&after=</p>');

				}

			} //$image == "yes"

			if ($title == "yes") {

				if( 'no' == $unlink_title ){

					$postsliderstr .= '<h3 class="post-title"><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>';

				}

				else{

					$postsliderstr .= '<h3 class="post-title">' . get_the_title() . '</h3>';

				}

			} //$title == "yes"

			if ($post_date == "yes") {

				$postsliderstr .= '<p class="post-date">' . get_the_date() . '</p>';

			} //$post_date == "yes"

			if ($post_meta == "yes") {

				$postsliderstr .= '<p class="post-meta">

					<span class="post-author">' . get_the_author() . '</span>

					<span class="post-category">' . get_the_category_list(', ') . '</span>';

				$num_comments = get_comments_number();

				if (comments_open()) {

					ob_start();

					comments_popup_link('0', '1', '%', 'comments-link', '');

					$write_comments = ob_get_contents();

					ob_clean();

				} //comments_open()

				else {

					$write_comments = '';

				}

				$postsliderstr .= '<span class="post-comment">' . $write_comments . '</span>';

				if( has_tag() ){

					$postsliderstr .= '<span class="post-tag">' . get_the_tag_list('', ', ') . '</span>';

				}

				$postsliderstr .= '</p>';

			} //$post_meta == "yes"

			if ($display == "content") {

				$postsliderstr .= '<div class="post-content">' . themify_get_content($more_text) . '</div></div></li>

';

			} //$display == "content"

			if ($display == "excerpt") {

				

				$postsliderstr .= '<div class="post-content">' . themify_excerpt($excerpt_length) . '</div></div></li>

';

		

			} //$display == "excerpt"

		endforeach;

		$postsliderstr .= '</ul>';

		if ($slider_nav == "yes") {

			$nextbutton = "<div>&raquo;</div>";

			$prevbutton = "<div>&laquo;</div>";

		} else {

			$nextbutton = "null";

			$prevbutton = "null";				

		} //$slider_nav == "yes"

		$postsliderstr .= '</div><script type="text/javascript">

		

		jQuery(window).load(function() {

		

		jQuery("#post-slider-'.$numsldr.' .slides").carouFredSel({

			responsive: true,';

				

		if ( 'yes' == $slider_nav ) {

			$postsliderstr .= '

				prev: "#post-slider-'.$numsldr.' .carousel-prev",

				next: "#post-slider-'.$numsldr.' .carousel-next",';

		}

		if( 'yes' == $pager ){

			$postsliderstr .= '

				pagination: "#post-slider-'.$numsldr.' .carousel-pager",';

		}

		$postsliderstr .= '

			circular: '.$wrapvar.',

			infinite: '.$wrapvar.',

			auto: {

				play : '.$play.',

				pauseDuration: '.$auto.'*1000,

				duration: '.$speed.'*1000

			},

			scroll: {

				items: '.$scroll.',

				duration: '.$speed.'*1000,

				wipe: true

			},

			items: {

				visible: {

					min: 1,

					max: '.$visible.'

				},

				width: 120

			},

			onCreate : function (){

				jQuery(".post-slider").css( {

					"height": "auto",

					"visibility" : "visible"

				});

			}

		});

			

	});

	</script> <!-- /shortcode post_slider -->';

		wp_reset_postdata();

	} //$posts

	return $postsliderstr;

}





/**

 * Creates an author box to display your profile

 * @param Object $atts

 * @param String $content

 * @return String

 */

function themify_shortcode_author_box($atts, $content = null) {

	extract(shortcode_atts(array(

		'avatar' => 'yes',

		'avatar_size' => '48',

		'style' => '',

		'author_link' => 'no'

	), $atts));

	/** 

	 * Filtered name of author

	 * @var String */

	$nicename = get_the_author_meta('nicename');

	$authorboxstr = "<!-- shortcode author_box --> <div class=\"shortcode clearfix author-box $style $nicename \">";

	if($avatar == "yes") {

		$authorboxstr .= '<p class="author-avatar">'.get_avatar( get_the_author_meta('user_email'), $avatar_size, '' ).'</p>';

	}

	if(get_the_author_meta('user_url'))	{

		$authorboxstr .= '<div class="author-bio">

			<h4 class="author-name"><a href="'.get_the_author_meta('user_url').'">'.get_the_author_meta('first_name').' '.get_the_author_meta('last_name').'</a></h4>

		'.get_the_author_meta('description');

	}

	else {

		$authorboxstr .= '<div class="author-bio">

		<h4 class="author-name">'.get_the_author_meta('first_name').' '.get_the_author_meta('last_name').'</h4>

	'.get_the_author_meta('description');

	}

	if($author_link == "yes") {

		if(get_the_author_meta('user_url')) {

			$authorboxstr .= '<p class="author-link"><a href="'.get_the_author_meta('user_url').'">&rarr; '.get_the_author_meta('user_firstname').' '.get_the_author_meta('user_lastname').' </a></p>';

		}

		else {

			$authorboxstr .= '<p class="author-link">&rarr; '.get_the_author_meta('user_firstname').' '.get_the_author_meta('user_lastname').' </p>';

		}

	}

	$authorboxstr .= '</div>

	</div> <!-- /shortcode author_box -->';

	return $authorboxstr;

}



/**

 * Creates a box to enclose content

 * @param Object $atts

 * @param String $content

 * @return String

 */

function themify_shortcode_box($atts, $content = null) {

	extract(shortcode_atts(array(

		'style' => ''

	), $atts));

	$boxstr = '<!-- shortcode box --> <div class="shortcode clearfix box '.$style.'">'.do_shortcode($content).'</div> <!-- /shortcode box -->';

	return $boxstr;

}



/**

 * Fix empty auto paragraph in shortcodes

 * @param String $content

 * @return String

 */

function themify_fix_shortcode_empty_paragraph($content) {   

   $array = array (

	  '<p>[' => '[', 

	  ']</p>' => ']', 

	  ']<br />' => ']'

   );

   $content = strtr($content, $array);

   return $content;

}

?>