<?php



/***************************************************************************/

/*

/* 	----------------------------------------------------------------------

/* 						DO NOT EDIT THIS FILE

/*	----------------------------------------------------------------------

/* 

/*  			Built by Darcy Clarke. http://themify.me

/*  				Copyright (C) 2010 Themify

/*

/***************************************************************************/

/*  Nav

/***************************************************************************/

	

	///////////////////////////////////////////

	// Create Nav Options

	///////////////////////////////////////////

	function themify_admin_nav() {

		global $theme;		

		add_menu_page('themify', $theme['Name'], 'manage_options', 'themify', 'themify_page', get_template_directory_uri().'/themify/img/favicon.png', 50);

		add_submenu_page('themify', $theme['Name'], __('设置', 'themify'), 'manage_options', 'themify', 'themify_page');

		add_submenu_page('themify', $theme['Name'], __('文档', 'themify'), 'manage_options', 'themify_docs', 'themify_docs');

	}



/*  Pages

/***************************************************************************/	

	

	///////////////////////////////////////////

	// Themify Documentation

	///////////////////////////////////////////

	function themify_docs(){

		echo "<script type='text/javascript'>window.location='http://themify.me/docs';</script>";

	}

	

	///////////////////////////////////////////

	// Themify Page

	///////////////////////////////////////////

	function themify_page() {

		

		if ( ! current_user_can( 'manage_options' ) )

			wp_die( __( '您没有足够的权限来更新这个网站。', 'themify' ) );

		

		if (isset($_GET['action'])) {

			$action = 'upgrade';

			themify_updater();

		}

		

		global $data, $theme, $config, $version, $notifications;

		

		?>

        <!-- alerts -->

        <div class="alert"></div> 

        <!-- /alerts -->

        

        <!-- prompts -->

        <div class="prompt-box">

            <div class="show-login">

            	<form id="themify_update_form" method="post" action="admin.php?page=themify&action=upgrade&type=theme&login=true">

            	<p class="prompt-msg"><?php _e('输入您的登录信息升级', 'themify'); ?></p>

	            <p><label><?php _e('用户', 'themify'); ?></label> <input type="text" name="username" class="username" value=""/></p>

	            <p><label><?php _e('密码', 'themify'); ?></label> <input type="password" name="password" class="password" value=""/></p>

	            <input type="hidden" value="theme" name="type" />

	            <input type="hidden" value="true" name="login" />

	            <p class="pushlabel"><input name="login" type="submit" value="Login" class="button upgrade-login" /></p>

	            </form>

            </div>

            <div class="show-error">

            	<p class="error-msg"><?php _e('升级主题遇到问题', 'themify'); ?></p>

            </div>

        </div>

        <div class="overlay">&nbsp;</div>

        <!-- /prompts -->

        

        <!-- html -->

        <form id="themify" method="post" action="" enctype="multipart/form-data">

        <p id="theme-title"><?php echo $theme['Name']; ?> <em><?php echo $theme['Version']; ?> (<a href="http://themify.me/logs/<?php echo strtolower($theme['Name']); ?>-changelogs" class="themify_changelogs" target="_blank"><?php _e('更新日志', 'themify'); ?></a>)</em></p>

		<p class="top-save-btn"><a href="#" id="save-button" class="save-button"><?php _e('保存全部', 'themify'); ?></a></em></p>

		<div id="content">

        

            <!-- nav -->

            <ul id="maintabnav">

                <li class="setting"><a href="#setting"><?php _e('设置', 'themify'); ?></a></li>

                <li class="styling"><a href="#styling"><?php _e('样式', 'themify'); ?></a></li>

                <li class="skins"><a href="#skins"><?php _e('皮肤', 'themify'); ?></a></li>

                <li class="transfer"><a href="#transfer"><?php _e('转让', 'themify'); ?></a></li>

            </ul>

            <!-- /nav -->

    		

            <!------------------------------------------------------------------------------------>

            

            <!--setting tab -->

            <div id="setting" class="maintab">

                

                <ul class="subtabnav">

                    <?php 

                    $x = 1;

                    foreach($config['panel']['settings']['tab'] as $tab){

                        if($x){

                            echo '<li class="selected"><a href="#setting-'.themify_scrub_func($tab['_a']['title']).'">'.$tab['_a']['title'].'</a></li>';	

                            $x = 0;

                        } else {

                            echo '<li><a href="#setting-'.themify_scrub_func($tab['_a']['title']).'">'.$tab['_a']['title'].'</a></li>';	

                        }

                    } 

                    ?>

                </ul>

                

                 <?php foreach($config['panel']['settings']['tab'] as $tab){ ?>					

                    <!-- subtab: setting-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->

                    <div id="setting-<?php echo themify_scrub_func($tab['_a']['title']); ?>" class="subtab">

                        <?php 

						if(is_array($tab['_c']['custom-module'])){

							if(isset($tab['_c']['custom-module']['_a']['title']) && isset($tab['_c']['custom-module']['_a']['function'])){

								echo themify_fieldset($tab['_c']['custom-module']['_a']['title'], themify_scrub_func($tab['_c']['custom-module']['_a']['function']), $tab['_c']['custom-module']['_a']); 

							} else {

								foreach($tab['_c']['custom-module'] as $module){

									echo themify_fieldset($module['_a']['title'], themify_scrub_func($module['_a']['function']),$module['_a']); 

								}

							}

						}

                        ?>

                    </div>

                    <!-- /subtab: setting-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->

                <?php } ?>

            

            </div>

            <!--/setting tab -->

            

            <!------------------------------------------------------------------------------------>

            

            <!--styling tab -->

            <div id="styling" class="maintab">

            

                <ul class="subtabnav">

                    <?php 

                    $x = 1;

					if(isset($config['panel']['styling']['tab']['_a']['title'])){

						echo '<li class="selected"><a href="#styling-'.themify_scrub_func($config['panel']['styling']['tab']['_a']['title']).'">'.$config['panel']['styling']['tab']['_a']['title'].'</a></li>';	

					} else {

						foreach($config['panel']['styling']['tab'] as $tab){

							if($x){

								echo '<li class="selected"><a href="#styling-'.themify_scrub_func($tab['_a']['title']).'">'.$tab['_a']['title'].'</a></li>';	

								$x = 0;

							} else {

								echo '<li><a href="#styling-'.themify_scrub_func($tab['_a']['title']).'">'.$tab['_a']['title'].'</a></li>';	

							}

						}

					}

					?>

                </ul>

                

                <?php 

				if(isset($config['panel']['styling']['tab']['_a']['title'])){

				?>

					<!-- subtab: styling-<?php echo themify_scrub_func($config['panel']['styling']['tab']['_a']['title']); ?> -->

						<div id="styling-<?php echo themify_scrub_func($config['panel']['styling']['tab']['_a']['title']); ?>" class="subtab">

							<?php 

							if(is_array($config['panel']['styling']['tab']['_c']['element'])){

								if(isset($config['panel']['styling']['tab']['_c']['element']['_a']['title']) && isset($config['panel']['styling']['tab']['_c']['element']['_a']['selector'])){

									echo themify_container(themify_scrub_func($tab['_a']['title']), $config['panel']['styling']['tab']['_c']['element']); 

								} else {

									foreach($config['panel']['styling']['tab']['_c']['element'] as $element){

										echo themify_container(themify_scrub_func($config['panel']['styling']['tab']['_a']['title']), $element); 

									}

								}

							}

							?>

						</div>

						<!-- /subtab: styling-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->

				<?php 

				} else {

					foreach($config['panel']['styling']['tab'] as $tab){ ?>					

						<!-- subtab: styling-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->

						<div id="styling-<?php echo themify_scrub_func($tab['_a']['title']); ?>" class="subtab">

							<?php 

							if(is_array($tab['_c']['element'])){

								if(isset($tab['_c']['element']['_a']['title']) && isset($tab['_c']['element']['_a']['selector'])){

									echo themify_container(themify_scrub_func($tab['_a']['title']), $tab['_c']['element']); 

								} else {

									foreach($tab['_c']['element'] as $element){

										echo themify_container(themify_scrub_func($tab['_a']['title']), $element); 

									}

								}

							}

							?>

						</div>

						<!-- /subtab: styling-<?php echo themify_scrub_func($tab['_a']['title']); ?> -->

					<?php } 

				} 

				?>

                

            </div>

            <!--/styling tab -->

    

    		<!------------------------------------------------------------------------------------>

            

            <!--skins tab -->

            <div id="skins" class="maintab">

                <ul class="subtabnav">

                    <li class="selected"><a href="#setting-general"><?php _e('皮肤', 'themify'); ?></a></li>

                </ul>

               

                <div id="load-load" class="subtab">

                    <?php echo themify_get_skins(); ?>

                </div>

                

            </div>

            <!--/skins tab -->

    		

            <!------------------------------------------------------------------------------------>

            

            <!--import tab -->

            <div id="transfer" class="maintab">

                

                <ul class="subtabnav">

                    <li><a href="#import-import"><?php _e('输入/输出', 'themify'); ?></a></li>

                </ul>

                

                <div id="transfer-import" class="subtab">

                    <p class="biggest-transfer-btn">

                    <a href="#" class="import" id="download-import"><?php _e('输入', 'themify'); ?></a> <em>or</em>

                    <a href="#" class="export" id="download-export"><?php _e('输出', 'themify'); ?></a>

                	</p>

                </div>

            

            </div>

            <!--/import tab -->

            

            <!------------------------------------------------------------------------------------>

    

        </div>

        <!--/content -->

        

        <!-- footer -->

        <div id="bottomtab">

            <p id="logo"><span>Themify</span> v<?php echo $version; ?></p>

            <p class="reset">

                <strong><?php _e('复位:', 'themify'); ?></strong> 

                <a href="#" id="reset-setting" class="reset-button"><?php _e('设置', 'themify'); ?></a><a href="#" id="reset-styling" class="reset-button"><?php _e('样式', 'themify'); ?></a>

            </p>

            <p class="btm-save-btn">

            	<a href="#" class="save-button"><?php _e('保存全部', 'themify'); ?></a>

       		</p>

        </div>

        <!--/footer -->

        

   		</form>

    	<div class="clearBoth"></div>

        <!-- /html -->

        

		<?php 

	}

	

	

/*  Utilities

/***************************************************************************/



	///////////////////////////////////////////

	// Get Skins

	///////////////////////////////////////////

	function themify_get_skins(){

		global $db, $config, $theme;

		$data = get_data();

		$output = '<input type="hidden" name="skin" value="'.$data['skin'].'">';

		if($data['skin'] == '' || !isset($data['skin'])){

			$output .= '<div class="skin-preview"><a href="#"><img src="'.get_template_directory_uri().'/themify/img/non-skin.gif" alt="skin" id="" class="selected" /></a><br />' . __('无皮肤', 'themify') . '</div>';

		} else {

			$output .= '<div class="skin-preview"><a href="#"><img src="'.get_template_directory_uri().'/themify/img/non-skin.gif" alt="skin" id="" /></a><br />' . __('无皮肤', 'themify') . '</div>';

		}

		// Open Styles Folder

		$dir = dirname(__FILE__).'/../skins';

		if(is_dir($dir)){

			if($handle = opendir($dir)){

				// Grab Folders

				while (false !== ($dirTwo = readdir($handle))){

					if($dirTwo != '.' && $dirTwo != '..'){

						// Check For Folder

						if(is_dir(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo)){

							// Open Folders

							if($handleTwo = opendir(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo)){

								// Grab Files

								while(false !== ($file = readdir($handleTwo))){

									$ext = substr(strrchr($file, '.'), 1); // File Extension

									//echo $file;

									if($file == 'style.css'){

										$info = themify_get_skin_info(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo.'/'.$file);

										$fullpath = get_template_directory_uri().'/skins/'.$dirTwo.'/'.$file;

										if(is_file(str_replace('//','/',dirname(__FILE__).'/').'../skins/'.$dirTwo.'/screenshot.png')){

											$image = get_template_directory_uri().'/skins/'.$dirTwo.'/screenshot.png';

										} else {

											$image = get_template_directory_uri().'/themify/img/screenshot-na.png';	

										}

										if($fullpath == $data['skin']){

											$output .= '<div class="skin-preview"><a href="#"><img src="'.$image.'" alt="skin" class="selected" id="'.get_template_directory_uri().'/skins/'.$dirTwo.'/style.css" /></a><br />'.$info['Skin Name'].'</div>';

										} else {

											$output .= '<div class="skin-preview"><a href="#"><img src="'.$image.'" alt="skin" id="'.get_template_directory_uri().'/skins/'.$dirTwo.'/style.css" /></a><br />'.$info['Skin Name'].'</div>';

										}

									}

								}

								closedir($handleTwo);

							}

						}

					}

				}		

				closedir($handle);

			} 

		}

		return $output;

	}

	

	///////////////////////////////////////////

	// Get CSS

	///////////////////////////////////////////

	function themify_get_css(){

		$data = get_data();

		if($data['skin'] != ""){

			$output .= "\n<!-- Themify Skin -->\n".'<link href="'.themify_https_esc($data['skin']).'" rel="stylesheet" type="text/css" />'."\n<!-- End Themify Skin -->\n";

		}

		if(is_array($data)){

			foreach($data as $name => $value){

				$array = explode('-',$name);

				$path = "";

				foreach($array as $part){

					$path .= "['$part']";

				}

				eval("\$config".$path." = \$value;");

			}

			if( is_array($config['styling']) ){

				$output .= "\n<!-- Themify Styling -->\n";

				$output .= "<style type='text/css'>\n";

				foreach($config['styling'] as $nav => $value){

					foreach($value as $element => $val){

						$temp = "";

						foreach($val as $attribute => $v){

							$attribute = str_replace("_", "-", $attribute);

							if($v['value'] != '' && isset($v['value'])){

								switch($attribute){

									case "border":

										foreach($v['value'] as $key => $val){

											if($val == ''){

												if(strpos($key, "style") === false){

													if(strpos($key, "color") === false){

														$v['value'][$key] = 0;

													} else {

														$v['value'][$key] = '000000';

													}	

												} else {

													$v['value'][$key] = 'solid';

												}

											}

										}

										if($v['value']['checkbox']){

											$temp .= "border: ".$v['value']['same']."px ".$v['value']['same_style']." #".$v['value']['same_color'].";\n";

										} else {

											if($v['value']['top'] != '' && $v['value']['top_style'] != '' && $v['value']['top_color'] != ''){

												$temp .= "border-top: ".$v['value']['top']."px ".$v['value']['top_style']." #".$v['value']['top_color'].";\n";

											}

											if($v['value']['right'] != '' && $v['value']['right_style'] != '' && $v['value']['right_color'] != ''){

												$temp .= "border-right: ".$v['value']['right']."px ".$v['value']['right_style']." #".$v['value']['right_color'].";\n";

											}

											if($v['value']['bottom'] != '' && $v['value']['bottom_style'] != '' && $v['value']['bottom_color'] != ''){

											

												$temp .= "border-bottom: ".$v['value']['bottom']."px ".$v['value']['bottom_style']." #".$v['value']['bottom_color'].";\n";

											}

											if($v['value']['left'] != '' && $v['value']['left_style'] != '' && $v['value']['left_color'] != ''){

												$temp .= "border-left: ".$v['value']['left']."px ".$v['value']['left_style']." #".$v['value']['left_color'].";\n";

											}

										}

									break;

									case "background-position":

										if($v['value']['x'] != '' && $v['value']['y']){

											foreach($v['value'] as $key => $val){

												if($val == ''){

													$v['value'][$key] = 0;

												}

											}

											$temp .= $attribute.": ";

											$temp .= $v['value']['x']." ".$v['value']['y'].";\n";

										}

									break;

									case "padding":

										if($v['value']['checkbox']){

											$temp .= $attribute.": ";

											$temp .= $v['value']['same']."px".";\n";		

										} else {

											if($v['value']['top'] != '' || $v['value']['right'] != '' || $v['value']['bottom'] != '' || $v['value']['left'] != ''){

												if($v['value']['top'] != ''){

													$temp .= "padding-top: ".$v['value']['top']."px;\n";

												}

												if($v['value']['right'] != ''){

													$temp .= "padding-right: ".$v['value']['right']."px;\n";

												}

												if($v['value']['bottom'] != ''){

													$temp .= "padding-bottom: ".$v['value']['bottom']."px;\n";

												}

												if($v['value']['left'] != ''){

													$temp .= "padding-left: ".$v['value']['left']."px;\n";

												}

											}

										}

									break;

									case "margin":

										if($v['value']['checkbox']){

											$temp .= $attribute.": ";

											$temp .= $v['value']['same']."px".";\n";		

										} else {

											if($v['value']['top'] != '' || $v['value']['right'] != '' || $v['value']['bottom'] != '' || $v['value']['left'] != ''){

												if($v['value']['top'] != ''){

													$temp .= "margin-top: ".$v['value']['top']."px;\n";

												}

												if($v['value']['right'] != ''){

													$temp .= "margin-right: ".$v['value']['right']."px;\n";

												}

												if($v['value']['bottom'] != ''){

													$temp .= "margin-bottom: ".$v['value']['bottom']."px;\n";

												}

												if($v['value']['left'] != ''){

													$temp .= "margin-left: ".$v['value']['left']."px;\n";

												}

											}

										}

									break;

									case "color":

										if($v['value']['value'] != '' && $v['value']['value'] != ' '){

											$temp .= $attribute.": ";

											$temp .= "#".$v['value']['value'].";\n";

										}

									break;

									case "background-color":

										if($v['value']['transparent']){

											$temp .= $attribute.": transparent;\n";											

										} else {

											if($v['value']['value'] != '' && $v['value']['value'] != ' '){

												$temp .= $attribute.": ";

												$temp .= "#".$v['value']['value'].";\n";

											}

										}

									break;

									case "background-image":

										if($v['value']['value'] != '' && $v['value']['value'] != ' '){

											$temp .= $attribute.": ";

											$temp .= "url(".$v['value']['value'].")".";\n";

										} else if($v['value']['none'] == "on"){

											$temp .= $attribute.": ";

											$temp .= "none;\n";

										}

									break;

									case "background-repeat":

										if($v['value']['value'] != '' && $v['value']['value'] != ' '){

											$temp .= $attribute.": ";

											$temp .= $v['value']['value'].";\n";

										}

									break;

									case "font-family":

										if($v['value']['value'] != '' && $v['value']['value'] != ' '){

											$temp .= $attribute.": ";

											$temp .= $v['value']['value'].";\n";

										}

									break;

									case "line-height":

										if($v['value']['value'] != '' && $v['value']['value'] != ' '){

											$temp .= $attribute.": ";

											$temp .= $v['value']['value'].$v['value']['unit'].";\n";

										}

									break;

									case "position":

										if($v['value']['value'] != '' && $v['value']['value'] != ' '){

											$temp .= $attribute.": ";

											$temp .= $v['value']['value'].";\n";

											if($v['value']['value'] == 'absolute' || $v['value']['value'] == 'fixed'){

												if($v['value']['x_value'] != '' && $v['value']['x_value'] != ' '){

													$temp .= $v['value']['x'].": ".$v['value']['x_value']."px;\n";

												}

												if($v['value']['y_value'] != '' && $v['value']['y_value'] != ' '){

													$temp .= $v['value']['y'].": ".$v['value']['y_value']."px;\n";

												}

											}

										}

									break;

									default:

										if($v['value']['value'] != '' && $v['value']['value'] != ' '){

											$temp .= $attribute.": ";

											$temp .= $v['value']['value'];

											if(isset($v['value']['unit'])){

												$temp .= $v['value']['unit'];

											}

											$temp .= ";\n";

										}

									break;

								}

							}

						}	

						if($temp != '' && $temp != ' '){

							$output .= urldecode(themify_scrub_decode($element))." {\n";

							$output .= $temp;

							$output .= "}\n\n";

						}

					}

				}

				$output .= "</style>\n";

				$output .= "<!-- End Themify Styling -->\n";

			}

		} else {

			$output = '<style type="text/css">/* ' . __('没有数据库中的值', 'themify') . ' */</style>';

		}

		echo "\n".$output;

	}

	

	///////////////////////////////////////////

	// Get Skin Info

	///////////////////////////////////////////

	function themify_get_skin_info($file){

		$fh = fopen($file, 'r');

		$data = fread($fh, filesize($file));

		$tempArray = explode("\n",themify_strip("/*", "*/", $data, 0));

		$array = array();

		foreach($tempArray as $line){

			$tempLine = explode(":", $line);

			$array[$tempLine[0]] = $tempLine[1];

		}

		fclose($fh);

		return $array;

	}

	

	///////////////////////////////////////////

	// Strip

	///////////////////////////////////////////

	function themify_strip($startTag, $endTag, $text, $pos){

		if(!is_integer($pos)){

			$pos = false;

			return false;

		}	

		$pos1 = strpos($text,$startTag,$pos);

		if(!is_integer($pos1)){

			$pos = false;

			return false;

		}

		$pos1 += strlen($startTag);

		$pos2 = strpos($text,$endTag,$pos1);

		if(!is_integer($pos2)){

			$pos = false;return false;

		}

		$res = substr($text,$pos1,$pos2-$pos1);

		$pos = $pos2 + strlen($endTag);

		return $res;

	} 

	

	///////////////////////////////////////////

	// Scrub Function

	///////////////////////////////////////////

	function themify_scrub_func($string=""){

		return str_replace(array(' ', '/', ','), array('_', '_', '-'), strtolower($string));

	}

	

	///////////////////////////////////////////

	// Scrub

	///////////////////////////////////////////

	function themify_scrub($string=""){

		return str_replace(array('#','-',' ','.',':',',','[',']','=','<','>'), array('_id_','_dash_','_space_','_class_','_colon_','_comma_','_opensquare_','_closesquare_','_equal_','_openbracket_','_closebracket_'), $string);

	}

	

	///////////////////////////////////////////

	// Scrub Decode

	///////////////////////////////////////////

	function themify_scrub_decode($string=""){

		return str_replace(array('_id_','_dash_','_space_','_class_','_colon_','_comma_','_opensquare_','_closesquare_','_equal_','_openbracket_','_closebracket_'), array('#','-',' ','.',':',',','[',']','=','<','>'), $string);

	}

	

	///////////////////////////////////////////

	// Create Settings Fieldset

	///////////////////////////////////////////

	function themify_fieldset($title="", $module="", $attr=""){

		global $config;

		$data = get_data();

		if(function_exists("themify_".trim($module))){

			$output = '	<fieldset><legend>'.$title.'</legend>';

			$output .=	call_user_func("themify_".trim($module), array("data"=>$data['setting'][$title],"attr"=>$attr));

			$output .= '</fieldset>';	

		} else if(function_exists(trim($module))){

			$output = '	<fieldset><legend>'.$title.'</legend>';

			$output .=	call_user_func(trim($module), array("data"=>$data['setting'][$title],"attr"=>$attr));

			$output .= '</fieldset>';	

		}

		return $output;

	}

	

	///////////////////////////////////////////

	// Create Styles Container

	///////////////////////////////////////////

	function themify_container($category="", $element=array()){

		$data = get_data();

		$temp = array();

		if(is_array($data)){

			foreach($data as $name => $value){

				$array = explode('-',$name);

				$path = "";

				foreach($array as $part){

					$path .= "['$part']";

				}

				eval("\$temp".$path." = \$value;");

			}

		}

		if($element){

			$output = '	<fieldset><legend>'.$element['_a']['title'].'</legend>';

			if(is_array($element['_c']['module'])){

				if(isset($element['_c']['module']['_a']['name'])){

					$title = themify_scrub($element['_a']['selector']);

					$attr = $element['_c']['module']['_a'];

					$module = trim(str_replace(array(' ','-','|'),array('','_','hr'),$element['_c']['module']['_a']['name']));

					$value = $temp['styling'][$category][$title][$module];

					if(function_exists("themify_".$module)){

						$output .=	call_user_func("themify_".$module, array('category' => $category, 'title' => $title, 'value' => $value, 'attr' => $attr));

					} else {

						if(function_exists($module)){

							$output .=	call_user_func($module, array('category' => $category, 'title' => $title, 'value' => $value, 'attr' => $attr));	

						}

					}

				} else {

					foreach($element['_c']['module'] as $module){

						$title = themify_scrub($element['_a']['selector']);

						$attr = $module['_a'];

						$module = trim(str_replace(array(' ','-','|'),array('','_','hr'),$module['_a']['name']));

						$value = $temp['styling'][$category][$title][$module];

						if(function_exists("themify_".$module)){

							$output .=	call_user_func("themify_".$module, array('category' => $category, 'title' => $title, 'value' => $value, 'attr' => $attr));

						} else {

							if(function_exists($module)){

								$output .=	call_user_func($module, array('category' => $category, 'title' => $title, 'value' => $value, 'attr' => $attr));	

							}

						}

					}

				}

			}

			$output .= '</fieldset>';	

			return $output;

		}

	}

	

	///////////////////////////////////////////

	// XML 2 Array Function

	///////////////////////////////////////////

	function themify_xml2array(&$string) {

		$parser = xml_parser_create();

		xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);

		xml_parse_into_struct($parser, $string, $vals, $index);

		xml_parser_free($parser);

		$mnary=array();

		$ary=&$mnary;

		foreach ($vals as $r) {

			$t=$r['tag'];

			if ($r['type']=='open') {

				if (isset($ary[$t])) {

					if (isset($ary[$t][0])) $ary[$t][]=array(); else $ary[$t]=array($ary[$t], array());

					$cv=&$ary[$t][count($ary[$t])-1];

				} else $cv=&$ary[$t];

				if (isset($r['attributes'])) {foreach ($r['attributes'] as $k=>$v) $cv['_a'][$k]=$v;}

				$cv['_c']=array();

				$cv['_c']['_p']=&$ary;

				$ary=&$cv['_c'];

			} elseif ($r['type']=='complete') {

				if (isset($ary[$t])) { // same as open

					if (isset($ary[$t][0])) $ary[$t][]=array(); else $ary[$t]=array($ary[$t], array());

					$cv=&$ary[$t][count($ary[$t])-1];

				} else $cv=&$ary[$t];

				if (isset($r['attributes'])) {foreach ($r['attributes'] as $k=>$v) $cv['_a'][$k]=$v;}

				$cv['_v']=(isset($r['value']) ? $r['value'] : '');

	

			} elseif ($r['type']=='close') {

				$ary=&$ary['_p'];

			}

		}    

		_themify_del_p($mnary);

		return $mnary;

	}

	

	///////////////////////////////////////////

	// _Internal: Remove recursion in result array

	///////////////////////////////////////////

	function _themify_del_p(&$ary) {

		foreach ($ary as $k=>$v) {

			if ($k==='_p') unset($ary[$k]);

			elseif (is_array($ary[$k])) _themify_del_p($ary[$k]);

		}

	}

	

	///////////////////////////////////////////

	// Array to XML

	///////////////////////////////////////////

	function themify_ary2xml($cary, $d=0, $forcetag='') {

		$res=array();

		foreach ($cary as $tag=>$r) {

			if (isset($r[0])) {

				$res[]=themify_ary2xml($r, $d, $tag);

			} else {

				if ($forcetag) $tag=$forcetag;

				$sp=str_repeat("\t", $d);

				$res[]="$sp<$tag";

				if (isset($r['_a'])) {foreach ($r['_a'] as $at=>$av) $res[]=" $at=\"$av\"";}

				$res[]=">".((isset($r['_c'])) ? "\n" : '');

				if (isset($r['_c'])) $res[]=themify_ary2xml($r['_c'], $d+1);

				elseif (isset($r['_v'])) $res[]=$r['_v'];

				$res[]=(isset($r['_c']) ? $sp : '')."</$tag>\n";

			}

			

		}

		return implode('', $res);

	}

	

	///////////////////////////////////////////

	// Insert element into array

	///////////////////////////////////////////

	function themify_ins2ary(&$ary, $element, $pos) {

		$ar1=array_slice($ary, 0, $pos); $ar1[]=$element;

		$ary=array_merge($ar1, array_slice($ary, $pos));

	}

	

	///////////////////////////////////////////

	// Upload and Resize Image Function

	///////////////////////////////////////////

	function themify_imageHandler($file, $new_file, $width, $height, $ext = null){

		$source_path = $file;

		list( $source_width, $source_height, $source_type ) = getimagesize( $source_path );

		if($ext != null){

			$ext = pathinfo($ext);	

			$ext = strtolower($ext['extension']);

			switch ( $ext ){

				case "gif":

				$source_gdim = imagecreatefromgif( $source_path );

				break;

				case "jpeg":

				$source_gdim = imagecreatefromjpeg( $source_path );

				break;

				case "jpg":

				$source_gdim = imagecreatefromjpeg( $source_path );

				break;

				case "png";

				$source_gdim = imagecreatefrompng( $source_path );

				break;

			}

		} else {

			switch ( $source_type ){

				case IMAGETYPE_GIF:

				$source_gdim = imagecreatefromgif( $source_path );

				break;

				case IMAGETYPE_JPEG:

				$source_gdim = imagecreatefromjpeg( $source_path );

				break;

				case IMAGETYPE_PNG:

				$source_gdim = imagecreatefrompng( $source_path );

				break;

			}

		}

		$source_aspect_ratio = $source_width / $source_height;

		$desired_aspect_ratio = $width / $height;

		if ( $source_aspect_ratio > $desired_aspect_ratio ){

			$temp_height = $height;

			$temp_width = ( int ) ( $height * $source_aspect_ratio );

		} else {

			$temp_width = $width;

			$temp_height = ( int ) ( $width / $source_aspect_ratio );

		}

		$temp_gdim = imagecreatetruecolor( $temp_width, $temp_height );

		imagecopyresampled(

			$temp_gdim,

			$source_gdim,

			0, 0,

			0, 0,

			$temp_width, $temp_height,

			$source_width, $source_height

		);

		$x0 = ( $temp_width - $width ) / 2;

		$y0 = ( $temp_height - $height ) / 2;

		$desired_gdim = imagecreatetruecolor( $width, $height );

			imagecopy(

			$desired_gdim,

			$temp_gdim,

			0, 0,

			$x0, $y0,

			$width, $height

		);

		imagejpeg( $desired_gdim, $new_file, 100 );

		imagedestroy( $source_gdim );

		imagedestroy( $temp_gdim );

	}

	

	///////////////////////////////////////////

	// Create ZIP Package

	///////////////////////////////////////////

	if(class_exists('ZipArchive')){

		function themify_create_zip($files = array(),$destination = "",$overwrite = false) {

			if(file_exists($destination) && !$overwrite) { return false; }

				$valid_files = array();

				if(is_array($files)) {

					foreach($files as $file) {

						if(file_exists($file)) {

							$valid_files[] = $file;

						}

					}

				}

				if(count($valid_files)) {

					$zip = new ZipArchive();

					if($zip->open($destination,$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {

					return false;

				}

				foreach($valid_files as $file) {

					$zip->addFile($file,str_replace(array("../","./"),array("",""),$file));

				}

				$zip->close();

				return file_exists($destination);

			} else {

				return false;

			}

		}

	}

	

	///////////////////////////////////////////

	// Extract ZIP Package

	///////////////////////////////////////////

	if(class_exists('ZipArchive')){

		function themify_unzip($src_file, $dest_dir=false, $create_zip_name_dir=true, $overwrite=true){

					if(function_exists("zip_open")){   

						if(!is_resource(zip_open($src_file))){ 

							$src_file=dirname($_SERVER["SCRIPT_FILENAME"])."/".$src_file; 

						}

						if (is_resource($zip = zip_open($src_file))){          

							$splitter = ($create_zip_name_dir === true) ? "." : "/";

							if ($dest_dir === false) $dest_dir = substr($src_file, 0, strrpos($src_file, $splitter))."/";

							themify_create_dirs($dest_dir);

							while ($zip_entry = zip_read($zip)){

								$pos_last_slash = strrpos(zip_entry_name($zip_entry), "/");

								if ($pos_last_slash !== false){

									themify_create_dirs($dest_dir.substr(zip_entry_name($zip_entry), 0, $pos_last_slash+1));

								}

								if (zip_entry_open($zip,$zip_entry,"r")){

									$file_name = $dest_dir.zip_entry_name($zip_entry);

									if ($overwrite === true || $overwrite === false && !is_file($file_name)){

										$fstream = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));           

										if(!is_dir($file_name))            

										file_put_contents($file_name, $fstream );

										

										if(file_exists($file_name)){

											chmod($file_name, 0777);

											//echo "<span style=\"color:#1da319;\">file saved: </span>".$file_name."<br />";

										} else {

											//echo "<span style=\"color:red;\">file not found: </span>".$file_name."<br />";

										}

									}

									zip_entry_close($zip_entry);

								}      

							}

							zip_close($zip);

						} else {

							//echo "No Zip Archive Found.";

							return false;

						}

						themify_chmodr($dest_dir, 0755);

						return true;

					} else {

						return false;

					}

				}

				

			 	function themify_extract_zip($file){		

					$zip = zip_open($file);

					$dir = "temp/";

					if(is_resource($zip)){

						while($zip_entry = zip_read($zip)) {

							// echo $dir.basename(zip_entry_name($zip_entry));

							$fp = fopen($dir.basename(zip_entry_name($zip_entry)), "w");

							if(zip_entry_open($zip, $zip_entry, "r")) {

								$buf = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));

								fwrite($fp,"$buf");

								zip_entry_close($zip_entry);

								fclose($fp);

							}

						}

						zip_close($zip);

					} else {

						echo zipFileErrMsg($zip);		

					}

					if(file_exists($dir."custom-config.xml")){

						unlink("../custom-config.xml");

						rename($dir."custom-config.xml", "../custom-config.xml");

					}

					if(file_exists($dir."custom-modules.php")){

						unlink("../custom-modules.php");

						rename($dir."custom-modules.php","../custom-modules.php");

					}

					if(file_exists($dir."custom-functions.php")){

						unlink("../custom-functions.php");

						rename($dir."custom-functions.php","../custom-functions.php");

					}

					if(file_exists($dir."data_export.txt")){

						$handler = fopen($dir."data_export.txt", "r");

						$data = fread($handler, filesize($dir."data_export.txt"));

						set_data(unserialize($data));

						fclose($handler);

					}

				}

	}



	///////////////////////////////////////////

	// Force Download

	///////////////////////////////////////////

	function themify_force_download($file){ 

		if((isset($file))&&(file_exists($file))){ 

		   header("Content-type: application/force-download"); 

		   header('Content-Disposition: inline; filename="' . $file . '"'); 

		   header("Content-Transfer-Encoding: Binary"); 

		   header("Content-length: ".filesize($file)); 

		   header('Content-Type: application/octet-stream'); 

		   header('Content-Disposition: attachment; filename="' . $file . '"'); 

		   readfile("$file"); 

		} else {

			return false;

		}	

	}

	

	///////////////////////////////////////////

	// Build Custom Write Panels

	///////////////////////////////////////////

	function themify_build_write_panels($args){

		global $themify_write_panels;

		if(is_array($args)){

			$themify_write_panels = $args;

			add_action('admin_menu', 'themify_create_meta_boxes');  

			add_action('save_post', 'themify_save_postdata');

		}

	}

	

	///////////////////////////////////////////

	// Call Custom Write Panel

	///////////////////////////////////////////

	function themify_create_meta_boxes() {

		global $themify_write_panels, $theme_name;

		$themify_write_panels = apply_filters('themify_do_metaboxes', $themify_write_panels);

		if(function_exists('add_meta_box') && is_array($themify_write_panels)){

			foreach($themify_write_panels as $args){

				if($args['pages'] != ''){

					$themify_meta_page = $args['pages'];

				} else {

					$themify_meta_page = 'post';	

				}

				if($args['name'] != ''){

					$themify_meta_name = $args['name'];	

				} else {

					$themify_meta_name = 'Themify Options';

				}

				$pages = explode(",", $themify_meta_page);

				foreach($pages as $page){

					add_meta_box( 'themify-meta-boxes', __('Themify自定义面板', 'themify'), 'themify_meta_boxes', trim($page), 'normal', 'high' ); 

				}

			}

		}

	}  

	

	///////////////////////////////////////////

	// Build Custom Write Panel 

	///////////////////////////////////////////

	function themify_meta_boxes() {

		

		global $post, $themify_write_panels, $typenow;



echo '<div id="themify-meta-box-tabs">';		

		echo '<ul class="ilc-htabs themify-tabs-heading">';

		foreach($themify_write_panels as $write_panel){

			if( trim($write_panel['pages']) == $typenow )

				echo '<li><span><a id="'. sanitize_title($write_panel['name']) . 't" href="#'. sanitize_title($write_panel['name']) . '">' . $write_panel['name'] . '</a></span></li>';

		}

		echo '</ul>';

		echo '<div class="ilc-btabs themify-tabs-body">';

		foreach($themify_write_panels as $write_panel){

			

			$pages = explode(",", $write_panel['pages']);

			$check = false;

			

			foreach($pages as $page){

				if(get_post_type($post)){

					if(get_post_type($post) == $page){

						$check = true;	

					}

				} else {

					if((trim($page) == 'post' && $_GET['post_type'] == '') || $_GET['post_type'] == trim($page)){

						$check = true;	

					}

				}

			}

			

			if($check){

				

			?>

            <div id="<?php echo sanitize_title($write_panel['name']); ?>" class="ilc-tab themify_write_panel">

            

            <div class="inside">

            	

                <input type="hidden" name="themify_proper_save" value="true" />

				

               

                

                <?php $themify_custom_panel_nonce = wp_create_nonce("themify-custom-panel"); ?>

                <script type="text/javascript">

                    jQuery(function($){

                                  

                        var complete_status = false;

                        $(".themify_upload_image").click(function(e){

                            //$("#themify_upload_image").

                        });

                        

                        $(".themify_field .preview-icon").click(function(e){

                            e.preventDefault();

                            $(this).parent().find(".selected").removeClass("selected");

                            $(this).addClass("selected");

                            $(this).parent().find(".val").val($(this).find("img").attr("alt"));

                        });

                        

                        $(".themify_field .query_category_single, .themify_field .query_category").blur(function(e){

                            $(this).parent().find(".val").val($(this).val());

                        });

                        

                        <?php foreach($write_panel['options'] as $meta_box): ?>

                        <?php if($meta_box['type'] == "image"): ?>

                            $("#themify_upload_image_<?php echo $meta_box['name']; ?>").uploadify({

                                    "uploader": "<?php echo get_template_directory_uri(); ?>/themify/js/uploadify.swf",

                                    "script": "<?php echo get_template_directory_uri(); ?>/themify/themify-ajax.php?upload-wordpress=true",

                                    "folder": "uploads",

                                    "cancelImg": "",

                                    "height": "23",

                                    "width": "66",

                                    "method": "POST",

                                    "hideButton": true,

                                    "wmode": "transparent",

                                    "fileDesc": "Image Files",

                                    "fileExt": "*.jpg;*.jpeg;*.gif;*.png",

                                    "multi": true,

                                    "sizeLimit": 100 * 1024 * 1024,

                                    "auto": true,

                                    "scriptData" : {

                                		'postid' : <?php echo $post->ID; ?>,

                                		'customfield' : '<?php echo $meta_box['name']; ?>',

                                		'nonce' : '<?php echo $themify_custom_panel_nonce; ?>'

                                	}

                                });

                                $("#themify_upload_image_<?php echo $meta_box['name']; ?>").bind({

                                    "uploadifySelect": function (a, b, c) {

                                        showAlert();

                                    },

                                    "uploadifyOpen": function (a, b, c) {},

                                    "uploadifyError": function (a, b, c, d) {},

                                    "uploadifyProgress": function (a, b, c, d) {},

                                    "uploadifyCancel": function (a, b, c, d) {

                                        hideAlert();

                                    },

                                    "uploadifyComplete": function (a, b, c, d, e) {

                                        d = d.replace("%uFEFF","");

                                        var f = $.trim(decodeURI(d));

                                    	var file = f.replace("%3A",":");

                                        f = f.replace("%3A",":");

                                                   f = f.replace("%3A",":");

                                        hideAlert();

										$(this).parent().parent().find(".themify_upload_field").val(f);

										$(this).parent().parent().parent()

											.find(".themify_upload_preview").css('display', 'block');



										$(this).parent().parent().parent()

											.find(".themify_upload_preview")

											.html("<img src=\'" + f + "\' alt=\'" + f + "\' width='40'  />").fadeIn(200);

										$('.themify_featimg_remove').removeClass('hide');



                                    }

                                });

								$('.themify_featimg_remove a').click(function(e){

			                    	e.preventDefault();

			                    	

			                    	//Save value of this to use it on the response callback 

			                    	here = this;

			                    	

			                    	$.post(

										ajaxurl,

										{

											'action': 'themify_remove_post_image',

											'postid': <?php echo $post->ID; ?>,

											'customfield' : '<?php echo $meta_box['name']; ?>',

											'nonce' : '<?php echo $themify_custom_panel_nonce; ?>'

										},

										function(data) {

											$(here).parent().parent().find('.themify_upload_field').val('');

											$(here).parent().parent().find('.themify_upload_preview').remove();

											$('.themify_featimg_remove').addClass('hide');

										}

									);

			                    });

                            <?php endif; ?>

                            <?php endforeach; ?>

                            

                    function showAlert() {

                        $(".alert").addClass("busy").fadeIn(800)

                    }

                    function hideAlert() {

                        $(".alert").removeClass("busy").addClass("done").delay(800).fadeOut(800, function () {

                            $(this).removeClass("done")

                        })

                    }

                });

                </script>

                

                <!-- alerts -->

                <div class="alert"></div> 

                <!-- /alerts -->

                

                <?php foreach($write_panel['options'] as $meta_box): ?>

                    <?php $meta_value = get_post_meta($post->ID, $meta_box['name'], true); ?>

                    

                    <?php

					///////////////////////////////////////////

					// Image Template 

					///////////////////////////////////////////

					

					if($meta_box['type'] == 'image'){ ?>

					<div class="featimgcontrol">

                          <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />

                          <div class="themify_field_row clearfix">

                                                  

                                <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

                                

                                <div class="themify_field">

                                	

                                	<?php if($meta_value != '' || has_post_thumbnail()): ?>

										<div class="themify_upload_preview" style="display:block">

											<?php

											if( has_post_thumbnail() ){

$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'thumbnail' );

echo '<img src="' . $thumb['0'] .'" width="40"  alt="'.__('文章图片', 'themify').'" />';

											}

											else{

												//themify_image('w=40&h=40&src='.$meta_value);

												echo '<img src="' . $meta_value .'" width="40"  alt="'.__('文章图片', 'themify').'" />';

											}

											?>

										</div>

									<?php else: ?>

										<div class="themify_upload_preview"></div>

									<?php endif; ?>

                                	

                                    <input type="hidden" name="<?php echo $meta_box['name']; ?>" value="<?php echo $meta_value; ?>" size="55" class="themify_input_field themify_upload_field" />

                                    <?php

                                    // Check quota for this blog if multisite

									if ( is_multisite() && !is_upload_space_available() ) {

										echo '<p>' . sprintf( __( '对不起，您填写您的 %s 存储空间配额，以便上传已被禁用。', 'themify' ), get_space_allowed() ) . '</p>';

									} else {

                                    ?>

                                        <div class="themify_upload_buttons">

                                             <a href="#" class="button button-highlighted"><?php _e('上传', 'themify'); ?></a>

                                             <a href="#" id="themify_upload_image_<?php echo $meta_box['name']; ?>" class="button button-highlighted">swf</a>

                                        </div>

                                    <?php } ?>

                                    	<br/>

                                    	<div class="themify_featimg_remove <?php if( !has_post_thumbnail() && $meta_value == '' ) echo 'hide' ?>">

                                    		<a href="#"><?php _e('移除图片', 'themify'); ?></a>

                                    	</div>

                                    

                                    <br />

                                    <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>

                                </div>

                          

                          </div><!--/themify_field_row -->

                    </div><!-- Themify Image END -->

                   	<?php

					///////////////////////////////////////////

					// Image Size Dropdown Template 

					///////////////////////////////////////////

					?>

                    <?php } else if($meta_box['type'] == 'featimgdropdown'){

	                    /** Define WP Featured Image sizes + blank + Themify's img.php

		 				 * @var array */

						$themify_fi_sizes = array(

							array( 'value' => '', 'name' => '' ),

							array( 'value' => 'thumbnail', 'name' => __('缩略图', 'themify') ),

							array( 'value' => 'medium', 'name' => __('中', 'themify') ),

							array( 'value' => 'large', 'name' => __('大', 'themify') ),

							array( 'value' => 'full', 'name' => __('原始图片', 'themify') )

						);

                    	?>

                        <div <?php if(!themify_check('setting-img_settings_use') || 'hidden' == $meta_box['class']) echo 'style="display:none"'; ?> class="<?php echo $meta_box['type']; ?>">

                            <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />

                                <div class="themify_field_row clearfix">

        

                                     <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

                                     

                                     <div class="themify_field">

                                        <select name="<?php echo $meta_box['name']; ?>">

                                    <?php foreach($themify_fi_sizes as $option): ?>

                                            <?php if($option['value'] == $meta_value){ $selected = "selected='selected'"; } else { $selected = ""; } ?>

                                             <option value="<?php echo $option['value']; ?>" <?php echo $selected; ?>><?php echo $option['name']; ?></option>

                                            <?php endforeach; ?>   

                                        </select>

                                        <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>

                                    </div>

                              </div><!--/themify_field_row -->

                        </div>

                    <?php

					///////////////////////////////////////////

					// Dropdown Template 

					///////////////////////////////////////////

					?>

                    <?php } else if($meta_box['type'] == 'dropdown'){ ?>

                        

                            <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />

                                <div class="themify_field_row clearfix">

        

                                     <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

                                     

                                     <div class="themify_field">

                                        <select name="<?php echo $meta_box['name']; ?>">

                                    <?php foreach($meta_box['meta'] as $option): ?>

                                            <?php if($option['value'] == $meta_value){ $selected = "selected='selected'"; } else { $selected = ""; } ?>

                                             <option value="<?php echo $option['value']; ?>" <?php echo $selected; ?>><?php echo $option['name']; ?></option>

                                            <?php endforeach; ?>   

                                        </select>

                                        <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>

                                    </div>

                                    

                              </div><!--/themify_field_row -->

                        

                    <?php

					///////////////////////////////////////////

					// Textbox Template 

					///////////////////////////////////////////

					?>

                    <?php } else if($meta_box['type'] == 'textbox'){ ?>

                        

                            <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />

                                <div class="themify_field_row clearfix">

        

                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

        

                                    <div class="themify_field">

                                        <?php 

                                        if($meta_box['meta']['size'] != '' && $meta_box['meta']['size'] == 'small'){

                                            $class = "small";	

                                        } else {

                                            $class = "";

                                        }

                                        ?>

                                        <input type="text" name="<?php echo $meta_box['name']; ?>" value="<?php echo $meta_value; ?>" size="55" class="themify_input_field <?php echo $class; ?>" />

                                        <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>

                                    </div>

        

                              </div><!--/themify_field_row -->

                        

                    <?php

					///////////////////////////////////////////

					// Checkbox Template 

					///////////////////////////////////////////

					?>

                    <?php } else if($meta_box['type'] == 'checkbox'){ ?>

                        

                            <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />

                              <div class="themify_field_row clearfix">

        

                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

                                    <?php if($meta_value){ $checked = "checked='checked'"; } else { $checked = ""; } ?>

        

                                    <div class="themify_field">

                                        <input type="checkbox" name="<?php echo $meta_box['name']; ?>" <?php echo $checked; ?> class="" />

                                        <span class="themify_checkbox_description"><?php echo $meta_box['description']; ?></span>

                                    </div>

        

                              </div><!--/themify_field_row -->

        

                    <?php

					///////////////////////////////////////////

					// Layout Template 

					///////////////////////////////////////////

					?>

                    <?php } else if($meta_box['type'] == 'layout'){ ?>

                        

                        	<input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />

                            

                                <div class="themify_field_row clearfix">    

                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

                                    <div class="themify_field">

                                        <?php foreach($meta_box['meta'] as $options){ ?>

                                        	<?php 

											if(($meta_value == "" || !$meta_value || !isset($meta_value)) && $options['selected']){ 

                                            	$meta_value = $options['value'];

											}

											if($meta_value == $options['value']){ 

												$class = "selected";

											} else {

												$class = "";	

											}

											?>

                                            <a href="#" class="preview-icon <?php echo $class; ?>"><img src="<?php echo get_template_directory_uri()."/".$options['img']; ?>" alt="<?php echo $options['value']; ?>"  /></a>

                                        <?php } ?>

                                        <input type="hidden" name="<?php echo $meta_box['name']; ?>" value="<?php echo $meta_value; ?>" class="val" />

                                        <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>

                                    </div>

                                </div>

                                    

                    <?php

					///////////////////////////////////////////

					// Query Posts Template 

					///////////////////////////////////////////

					?>

                    <?php } else if($meta_box['type'] == 'query_category'){ ?>

                                

                             <input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />

                              

                                <div class="themify_field_row clearfix">    

                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

                                    <div class="themify_field">

                                        <?php echo preg_replace('/>/', '><option></option>', wp_dropdown_categories(array("class"=>"query_category_single","show_option_all"=>"All Categories","hide_empty"=>0, "echo"=>0,"name"=>$meta_box['name'],"selected"=>$meta_value)), 1);

                                        ?> or 

                                        <input type="text" class="query_category" value="<?php echo $meta_value; ?>" />

                                        <input type="hidden" value="<?php echo $meta_value; ?>" name="<?php echo $meta_box['name']; ?>" class="val" />

                                        <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>

                                    </div>

                                </div>

                    

                    <?php

					///////////////////////////////////////////

					// Sidebar Visibility Template 

					///////////////////////////////////////////

					?>

                    <?php } else if($meta_box['type'] == 'sidebar_visibility'){ ?>

                    

                    		<input type="hidden" name="<?php echo $meta_box['name']; ?>_noncename" id="<?php echo $meta_box['name']; ?>'_noncename" value="<?php echo wp_create_nonce( plugin_basename(__FILE__) ); ?>" />

                            

                                <div class="themify_field_row clearfix">    

                                    <div class="themify_field_title"><?php echo $meta_box['title']; ?></div>

                                    <div class="themify_field">

                                    <?php 

                                    $sidebars = get_option('sidebars_widgets');

									global $wp_registered_sidebars;

                                    foreach($sidebars as $sidebar => $val){

                                        if($sidebar != 'wp_inactive_widgets' && $sidebar != 'array_version' && strpos(strtolower($wp_registered_sidebars[$sidebar]['name']),'sidebar') !== false){ 

										$checked = "";

										if(get_post_meta($post->ID, $meta_box['name'], true) == "" || !get_post_meta($post->ID, $meta_box['name'], true)){

											$checked = "checked='checked'";

										} else {

											foreach($meta_value as $key => $val){

												if(str_replace("'","",$key) == $wp_registered_sidebars[$sidebar]['name']){

													$checked = "checked='checked'";

												}

											}

										}

										?>

                                        <input type="checkbox" name="<?php echo $meta_box['name']; ?>[<?php echo $wp_registered_sidebars[$sidebar]['name']; ?>]" class="" <?php echo $checked; ?> /> <?php echo $wp_registered_sidebars[$sidebar]['name']; ?><br />

                                    <?php		

                                        }

                                    }

                                    ?>

                                    <span class="themify_field_description"><?php echo $meta_box['description']; ?></span>

                                    </div>	

                                </div>

                            

                    <?php } ?>

                

                <?php endforeach; ?>

            </div>

            </div>

			<?php 

			}

		}

	echo '</div>';//end .ilc-btabs

echo '</div>';//end #themify-meta-box-tabs



echo '<script type="text/javascript">';

	echo 'jQuery(document).ready(function(){';

		echo 'if(jQuery(".ilc-htabs li").length > 1)';

			echo 'ilcTabs({ilctabs  : "#themify-meta-box-tabs"});';

		echo 'else{';

			echo 'jQuery(".ilc-tab").show();';

			echo 'jQuery(".ilc-htabs li").addClass("select");';

		echo '}';

	echo '});';

echo '</script>';



	}

	

	/**

	 * Save Custom Write Panel Data

	 * @param number

	 * @return mixed

	 */

	function themify_save_postdata( $post_id ) {  

		global $post, $themify_write_panels;  

		if(isset($_POST['themify_proper_save']) && $_POST['themify_proper_save'] != '') {

			foreach($themify_write_panels as $write_panel){

				

				foreach($write_panel['options'] as $meta_box) {  

					if ( 'page' == $_POST['post_type'] ) {  

						if ( !current_user_can( 'edit_page', $post_id ))  

						return $post_id;  

					} else {  

						if ( !current_user_can( 'edit_post', $post_id ))  

						return $post_id;  

					}  

					$data = $_POST[$meta_box['name']];

					

					if(get_post_meta($post_id, $meta_box['name']) == "")  

					add_post_meta($post_id, $meta_box['name'], $data, true);  

					elseif($data != get_post_meta($post_id, $meta_box['name'], true))  

					update_post_meta($post_id, $meta_box['name'], $data); 

				}  

			}

		} else {

			return $post->ID;	

		}

	}   

	

	/**

	 * Image Helper - Echoes themify_get_image

	 * @param string $options Format string.

	 */

	function themify_image($options){

		echo themify_get_image($options);

	}

	

	/**

	 * Returns the post image, either from Themify Custom Panel fields or from WordPress Featured Image.

	 * @param string $args Format string.

	 * @return string String with <img> tag and optional content prepended and/or appended

	 */

	function themify_get_image($args){

		global $post, $image_width, $image_height, $config, $post_query_category;

		$data = get_data();

		parse_str($args, $options);

		foreach($options as $key => $val){

			$$key = $val;	

		}

		if($alt == ""){

			$alt = get_the_title($post->ID);

		}

		if($crop == false || $crop == 'false'){

			$crop = "";

		} else {

			$crop = "&amp;zc=1";

		}

		if($a != "" && isset($a)){

			$a = "&amp;a=".$a;

		} else {

			if($data['setting-img_settings_crop_option'] != "" && $data['setting-img_settings_crop_option'])

				$a = "&amp;a=".$data['setting-img_settings_crop_option'];

			else

				$a = "";

		}

		$check = false;

		if($q != "" && isset($q)){

			$q = "&amp;q=".$q;

		} else {

			if($data['setting-img_settings_quality'] != "" && $data['setting-img_settings_quality'])

				$q = "&amp;q=".$data['setting-img_settings_quality'];

			else

				$q = "";

		}

		

		//$ignore = (!$ignore || !isset($ignore) || $ignore == "") ? false : true;

		if($src == '' || !isset($src) ){

			if($field_name != '' && isset($field_name)){

				$fields = explode(",", $field_name);

				foreach($fields as $field){

					$field = trim($field);

					if($field == "wp_thumb" && function_exists("has_post_thumbnail")){

						if(has_post_thumbnail() && !$check){

							$temp = themify_prep_image(get_the_post_thumbnail($post->ID));

							$src = $temp['src'];

							$class .= " ".$temp['class'];

							if($alt == "" && $temp['alt'] != '' && isset($temp['alt'])){

								$alt = $temp['alt'];									 

							}

							$check = true;

						}

					} else {

						if(get_post_meta($post->ID, $field, true) != '' && get_post_meta($post->ID, $field, true) && !$check){

							$src = get_post_meta($post->ID, $field, true);

							$check = true;

						}

					}

				}

			} else {

				

					$fields = array("Feature Image", "feature_image", "Post Image", "post_image", "image");

					foreach($fields as $field){

						if(get_post_meta($post->ID, $field, true) != '' && !$check){

							$src = get_post_meta($post->ID, $field, true);

							$check = true;	

						}

					}

					if(function_exists("has_post_thumbnail")){

						if(has_post_thumbnail() && !$check){

							$temp = themify_prep_image(get_the_post_thumbnail());

							$src = $temp['src'];

							$class .= " ".$temp['class'];

							if($alt == "" && $temp['alt'] != '' && isset($temp['alt'])){

								$alt = $temp['alt'];									 

							}

							$check = true;

						}

					}

					if(!$check){

						$tags = array("img","embed","iframe");

						$content = get_the_content();

						foreach($tags as $tag){

							$count = substr_count($content, '<'.$tag);

							if($count >= 1 && !$check){

								$start = strpos($content, '<'.$tag, 0);

								$pos = substr($content, $start);

								$end = strpos($pos, '>');

								$temp = themify_prep_image(substr($pos, 0, $end+1));

								$ext = explode(".", $temp['src']);

								$ext = strtolower($ext[(count($ext)-1)]);

								if(strpos($temp['src'],".") && ($ext == "jpg" || $ext == "jpeg" || $ext == "gif" || $ext == "png")){

									$check = true;

									$src = $temp['src'];

									$class .= $temp['class'];

									if($alt = "" && $temp['alt'] != '' && isset($temp['alt'])){

										$alt = $temp['alt'];									 

									}

								}

							}

						}

					}

				

			}

		}

		if( in_the_loop() && get_post_meta($post->ID, 'image_width', true) != '' && !$ignore){

			if($post_query_category != "")

				$width = $w;

			else

				$width = get_post_meta($post->ID, 'image_width', true);

		} elseif($data["setting-".$setting."_width"] != '' && $setting != ''){

			$width = $data["setting-".$setting."_width"];

		} elseif($image_width != '' && isset($image_width) && !$ignore){

			$width = $image_width;

		} else {

			if($w != '' && isset($w)){

				$width = $w;	

			}

		}

		if( in_the_loop() && get_post_meta($post->ID, 'image_width', true) != '' && !$ignore){

			if($post_query_category != "")

				$height = $h;

			else

				$height = get_post_meta($post->ID, 'image_height', true);

			

		} elseif($data["setting-".$setting."_height"] != '' && $setting != ''){

			$height = $data["setting-".$setting."_height"];

		} elseif($image_height != '' && isset($image_height) && !$ignore){

			$height = $image_height;

		} else {

			if($data['setting-img_settings_vertical_crop_option'] == "no"){

				$height = "";

			}

			else{

				if($h != '' && isset($h)){

					$height = $h;	

				}

			}

			

		}

		if($class != ''){	

			$class = "class='".$class."'";

		}

		if($id != ''){

			$id = "id='".$id."'";

		}

		

		$p_height = (isset($height) && $height != '') ? "height='".$height."'" : "";

		$p_width = (isset($width) && $width != '') ? "width='".$width."'" : "";

		

		/**

		 * User size selection: one of WP Featured Image sizes, img.php or blank

		 * @var string $feature_size

		 * @since 1.1.5

		 */

		$feature_size = '';

		global $feature_size_page, $wp_query;



		//check if global size is set

		if( themify_check('setting-img_settings_use') && '' != themify_get('setting-global_feature_size')) {

			//set feature size

			$feature_size = themify_get('setting-global_feature_size');

		} elseif( '' == themify_get('setting-global_feature_size') ) {

			$feature_size = 'medium';

		}

		//echo '<br/>global/default feature ',$feature_size;

		

		if( is_front_page() ){

			if( '' != themify_get('setting-image_post_feature_size') ){

				//override size with default index layout size

				$feature_size = themify_get('setting-image_post_feature_size');

				//echo '<br/>is home, using default index layout ',$feature_size;

			} else {

				//nothing in default index layout size

				//$feature_size = 'medium';

				//echo '<br/>is home, nothing in default index layout, using ',$feature_size;

			}

		}

		

		if( is_singular() && in_the_loop() ){

			//echo '<p>is singular</p>';

			//check if post size is set

			if( '' != themify_get('feature_size') ){

				//override global size with post's custom field size

				$feature_size = themify_get('feature_size');

				//echo '<br/>singular, size selected in post drop down ',$feature_size;

			}

			//check if default size for post layout is set

			elseif( '' != themify_get('setting-image_post_single_feature_size') ){

				//override global size with post's custom field size

				$feature_size = themify_get('setting-image_post_single_feature_size');

				//echo '<br/>singular, nothing selected in post drop down, using single post layout ',$feature_size;

			}

		}

		//are we on a page? is query category size set?

		if( '' != $post_query_category ){

			//echo '<p>is query category</p>';

			if( '' != themify_get('setting-image_post_feature_size') ){

				//override custom field size with default index layout size

				$feature_size = themify_get('setting-image_post_feature_size');

				//echo '<br/>default index layout ',$feature_size;

			}

			if( '' != $feature_size_page && isset($feature_size_page)){

				//override custom field size with query category size

				$feature_size = $feature_size_page;

			}

			//echo '<br/>query category page ',$feature_size_page;

		}

		//are we on an archive page

		if( is_archive() ){

			//echo '<p>is archive</p>';

			if( themify_check('setting-img_settings_use') ){

				//set feature size

				if ( '' != themify_get('setting-global_feature_size') ){

					$feature_size = themify_get('setting-global_feature_size');

				}

				elseif ( '' == $feature_size ){

					$feature_size = 'medium';

				}

				if ( '' != themify_get('setting-image_post_feature_size') ){

					$feature_size = themify_get('setting-image_post_feature_size');

				}

			}

			//echo '<br/>archive ',$feature_size;

		}

		

		/**

		 * For Themify custom post types slider, menu and highlights

		 */

		$thecpt = get_post_type($post->ID);

		$iscpt = in_array( $thecpt, themify_specific_post_types() );

		if( $iscpt ){

			global $feature_size_cpt;

			$cptquery = $thecpt . '_category';

			//echo '<br/>is a Themify custom post type';

			if( !isset($feature_size_cpt) ){

				if( '' != themify_get('setting-global_feature_size') ) {

					//echo '<br/>using global featured image size';

					$feature_size = themify_get('setting-global_feature_size');

				} elseif( '' == themify_get('setting-global_feature_size') ) {

					//echo '<br/>global featured image size, use medium';

					$feature_size = 'medium';

				}

	

				if( '' != themify_get('feature_size') ){

					//override global size with post's custom field size

					$feature_size = themify_get('feature_size');

					//echo '<br/>custom post type, size selected in cpt drop down ',$feature_size;

				}

			} else{

				//echo '<br/>is custom post type query category';

				//for pages like Rezo, that have an additional drop down menu

				$feature_size = $feature_size_cpt;

				//echo '<br/>custom post type, size selected in cpt Query drop down ',$feature_size;

			}

		}

		/* end themify custom post types  */

		



		//if the call has been made outside the loop

		if( !in_the_loop() )

			$feature_size = 'thumbnail';

		

		//if an image_size parameter was passed, for example

		if( isset($image_size) )

			$feature_size = $image_size;

		

		$intheloop = in_the_loop() ? 'Yes' : 'No';

		//echo '<br/><strong>In the loop? ' , $intheloop , '</strong>';

		//echo '<br/>Final size to be used is ' , $feature_size;

		

		//we have a path so let's proceed to show our image

		if($src != '' && $src && isset($src)){

			//is img.php enabled in theme settings and user did not selected a Featured Image size?

			if( '' == $data['setting-img_settings_use'] || !$data['setting-img_settings_use'] ){

				

				if( has_post_thumbnail($post->ID) && in_the_loop() ){

					

					// Obtain original file for featured image

					if( false != ( $src_full = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' ) ) ){

						

						// Parse original src file and original featured image

						$parse_full = parse_url($src_full[0]);

						$parse_src = parse_url($src);

						$info_full = pathinfo($parse_full['path']);

						$info_src = pathinfo($parse_src['path']);

						

						// Compare base filenames

						if( $info_full['filename'] == $info_src['filename'] ){

							// They are the same, let's check for a large size

							if( false != ( $src_large = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large' ) ) ){

								// Change src to use large size of featured image

								$src = $src_large[0];

							}

						}

					}

				}

				// if no large size is available, we simply use original one

				return stripslashes($before)."<img src='".get_bloginfo("template_directory")."/themify/img.php?src=".$src."&amp;w=".$width."&amp;h=".$height.$crop.$q.$a."' alt='".$alt."' ".$class." ".$id." $p_width $p_height />".stripslashes($after);

				

			} elseif( !in_the_loop() && null == $ignore ){

				return stripslashes($before)."<img src='".$src."' alt='".$alt."' ".$class." ".$id." $p_width $p_height />".stripslashes($after); 

			} else {

				//img.php is disabled in theme settings or user selected a Featured Image size

				

				//check if user entered certain dimensions

				$feature_width = themify_get('image_width');

				$feature_height = themify_get('image_height');

				

				//user did not selected a size

				if( '' == $feature_size || !has_post_thumbnail() ){

					//output original image, useful for backwards compatibility

					return /*'<p>No thumbnail set, using original</p>' .*/ stripslashes($before)."<img src='".$src."' alt='".$alt."' $id $class $p_width $p_height />".stripslashes($after);

				} else {

					//user selected a size, so let's assume he set up an image as featured image

					/**

					 * Store post thumbnail properties

					 * [0] => url [1] => width [2] => height

					 * @var array $thumb

					 */

					$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), $feature_size );

					//echo '<p>WP Feature image: '. $feature_size .'</p>';

					

					/**

					 * Start by clearing dimensions to avoid the math formula

					 * 

					 * For a singular post/page

					 * 		if dimensions are set in custom panel, use them

					 * 		else if dimensions are set in setting single post, use them

					 * 		else do nothing

					 * 

					 * For a query category page

					 * 		if dimensions are set in custom panel, use them

					 * 		else do nothing

					 * 

					 * For an archive page

					 * 		if dimensions are set in setting index layout, use them

					 * 		else do nothing

					 * 

					 * For a custom post type

					 * 		if dimensions are set in custom panel, use them

					 * 		else do nothing

					 * 		

					 */

					

					// Clear dimensions to start

					if( !$ignore ){

						$p_width = '';

						$p_height = '';

					}

					

					// For singular views

					if( !$ignore && is_singular() ){

						if( isset($feature_width) )

							$p_width = 'width="'.$feature_width.'"';

						elseif( '' != $data["setting-".$setting."_width"] && '' != $setting )

							$p_width = 'width="'.$data["setting-".$setting."_width"].'"';

							

						if( isset($feature_height) )

							$p_height = 'height="'.$feature_height.'"';

						elseif( '' != $data["setting-".$setting."_height"] && '' != $setting )

							$p_height = 'height="'.$data["setting-".$setting."_height"].'"';

					}

					

					// For query pages

					if( !$ignore && isset( $post_query_category ) ){

						global $feature_size_query_page;

						$queryw = get_post_meta($feature_size_query_page->ID, 'image_width', true);

						$queryh = get_post_meta($feature_size_query_page->ID, 'image_height', true);

						if( '' != $queryw ){

							$p_width = 'width="'.$queryw.'"';

						}

						if( '' != $queryh ){

							$p_height = 'height="'.$queryh.'"';

						}

					}

					

					// For archive pages and home archive

					if( !$ignore && (is_home() || is_archive()) ){

						if( '' != $data["setting-".$setting."_width"] && '' != $setting ){

							$p_width = 'width="'.$data["setting-".$setting."_width"].'"';

						}

						if( '' != $data["setting-".$setting."_height"] && '' != $setting ){

							$p_height = 'height="'.$data["setting-".$setting."_height"].'"';

						}

					}

					

					// For custom post types

					if( !$ignore && $iscpt ){

						// is it a custom post type query page?

						if( isset($feature_size_cpt) ){

							global $feature_size_query_page;

							$cptw = get_post_meta($feature_size_query_page->ID, $thecpt.'_image_width', true);

							$cpth = get_post_meta($feature_size_query_page->ID, $thecpt.'_image_height', true);

						}

						// is not a custom post type query page so grab the panel settings

						else {

							$cptw = get_post_meta($post->ID, 'image_width', true);

							$cpth = get_post_meta($post->ID, 'image_height', true);

						}

						if( '' != $cptw ){

							$p_width = 'width="'.$cptw.'"';

						}

						if( '' != $cpth ){

							$p_height = 'height="'.$cpth.'"';

						}

					}

					

					return stripslashes($before) . "<img src='{$thumb['0']}' alt='$alt' $id $class $p_width $p_height />" . stripslashes($after);

					

				}

			}

		}

	}



/**

 * Sets the WP Featured Image size selected for Query Category pages

 * @since 1.1.5 

 */

function themify_feature_size_page(){

	global $feature_size_page, $feature_size_cpt, $feature_size_query_page, $post;

	$feature_size_query_page = $post;

	/** Get size for WP Featured Image @var String $feature_size_page*/

	$feature_size_page = themify_get('feature_size_page');

	$types = themify_specific_post_types();

	foreach($types as $type){

		$fs_cpt = themify_get('feature_size_' . $type);

		if( isset($fs_cpt) )

			$feature_size_cpt = $fs_cpt;

	}

}

add_action( 'template_redirect', 'themify_feature_size_page' );

	/**

	 * Image Helper - Prep Image

	 * @param $tag

	 * @return array

	 */

	function themify_prep_image($tag){

		preg_match_all('/(alt|title|src|class)=("[^"]*")/i', $tag, $image);

		foreach($image[0] as $attr){

			parse_str($attr, $tempAttr);

			foreach($tempAttr as $key => $val){

				$tempArray[$key] = str_replace(array('"',"'"),array('',''),$val);	

			}

		}

		$image = $tempArray;

		if(strpos($image['src'],"youtube.com") || strpos($image['src'], "vimeo.com")){

			$image['src'] = themify_video_image($image['src']);

		}

		return array("src"=>trim($image['src'],"\\"), "alt"=>$image['alt'], "title"=>$image['title']);

	}

	

	///////////////////////////////////////////

	// Check if file exists

	///////////////////////////////////////////

	function themify_check_remote_file($url){

		if(function_exists("curl_init")){

			$ch = curl_init(); 

			curl_setopt($ch, CURLOPT_URL,$url);

			curl_setopt($ch, CURLOPT_NOBODY, 1);

			curl_setopt($ch, CURLOPT_FAILONERROR, 1);

			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 

			if(curl_exec($ch)!==FALSE){

				return true;

			} else {

				return false;

			}

		} else {

			return is_readable($url);

		}

	}



	///////////////////////////////////////////

	// Vimeo / Youtube Thumbnail grab

	///////////////////////////////////////////

	function themify_video_image($url){

		$image_url = parse_url($url);

		if($image_url['host'] == 'www.youtube.com' || $image_url['host'] == 'youtube.com'){

			parse_str($image_url['query'], $query);

			if(isset($query['v']) && $query['v'] != ""){

				$id = $query['v'];

			} else {

				$path = explode("/",$image_url['path']);

				$id = $path[count($path)-1];

			}

			return "http://img.youtube.com/vi/".$id."/hqdefault.jpg";				

		} else if($image_url['host'] == 'www.vimeo.com' || $image_url['host'] == 'vimeo.com' || $image_url['host'] == 'player.vimeo.com'){

			parse_str($image_url['query'], $query);

			if(isset($query['clip_id']) && $query['clip_id'] != ""){

				$id = $query['clip_id'];

			} else {

				$path = explode("/",$image_url['path']);

				$id = $path[(count($path)-1)];

			}

			if(function_exists("file_get_contents")){

				$hash = unserialize(file_get_contents("http://vimeo.com/api/v2/video/".$id.".php"));

				if(isset($hash[0]) && $hash[0] != ''){

					return $hash[0]["thumbnail_large"]; 

				}

			}

		}

	}

	

	///////////////////////////////////////////

	// Variable Checker

	///////////////////////////////////////////

	function themify_check($var){

		global $post;

		$data = get_data();

		if( isset($data[$var]) && $data[$var] != '' ){

			return true;

		} elseif(get_post_meta($post->ID, $var, true) != '' && get_post_meta($post->ID, $var, true)){

			return true;

		} else {

			return false;	

		}

	}

	

	///////////////////////////////////////////

	// Version Getter

	///////////////////////////////////////////

	function themify_get($var){

		global $post;

		$data = get_data();

		if($data[$var] != '' && isset($data[$var])){

			return $data[$var];

		} else if(get_post_meta($post->ID, $var, true) != ''){

			return get_post_meta($post->ID, $var, true);

		}

	}

	

	///////////////////////////////////////////

    // Themify Get Content

    ///////////////////////////////////////////

	function themify_get_content($more_link_text = '(more...)', $stripteaser = 0, $more_file = '')

	{

		$content = get_the_content($more_link_text, $stripteaser, $more_file);

		$content = apply_filters('the_content', $content);

		$content = str_replace(']]>', ']]&gt;', $content);

		return $content;

	}

	///////////////////////////////////////////

    // Themify Excerpt

    ///////////////////////////////////////////	

	function themify_excerpt($limit) {

		$excerpt = explode(' ', get_the_excerpt(), $limit);

		if (count($excerpt)>=$limit) {

			array_pop($excerpt);

			$excerpt = implode(" ",$excerpt).'...';

		} else {

			$excerpt = implode(" ",$excerpt);

		}

			$excerpt = preg_replace('`[[^]]*]`','',$excerpt);

		return $excerpt;

	}



	///////////////////////////////////////

	// Load theme languages

	///////////////////////////////////////

	load_theme_textdomain( 'themify', TEMPLATEPATH.'/languages' );



	///////////////////////////////////////

	// Page navigation

	///////////////////////////////////////

	function themify_pagenav($before = '', $after = '') {

		global $wpdb, $wp_query;

	

		$request = $wp_query->request;

		$posts_per_page = intval(get_query_var('posts_per_page'));

		$paged = intval(get_query_var('paged'));

		$numposts = $wp_query->found_posts;

		$max_page = $wp_query->max_num_pages;

	

		if(empty($paged) || $paged == 0) {

			$paged = 1;

		}

		$pages_to_show = apply_filters('themify_filter_pages_to_show', 8);

		$pages_to_show_minus_1 = $pages_to_show-1;

		$half_page_start = floor($pages_to_show_minus_1/2);

		$half_page_end = ceil($pages_to_show_minus_1/2);

		$start_page = $paged - $half_page_start;

		if($start_page <= 0) {

			$start_page = 1;

		}

		$end_page = $paged + $half_page_end;

		if(($end_page - $start_page) != $pages_to_show_minus_1) {

			$end_page = $start_page + $pages_to_show_minus_1;

		}

		if($end_page > $max_page) {

			$start_page = $max_page - $pages_to_show_minus_1;

			$end_page = $max_page;

		}

		if($start_page <= 0) {

			$start_page = 1;

		}

	

		if ($max_page > 1) {

			echo $before.'<div class="pagenav clearfix">';

			if ($start_page >= 2 && $pages_to_show < $max_page) {

				$first_page_text = "&laquo;";

				echo '<a href="'.get_pagenum_link().'" title="'.$first_page_text.'" class="number">'.$first_page_text.'</a>';

			}

			//previous_posts_link('&lt;');

			for($i = $start_page; $i  <= $end_page; $i++) {

				if($i == $paged) {

					echo ' <span class="number current">'.$i.'</span> ';

				} else {

					echo ' <a href="'.get_pagenum_link($i).'" class="number">'.$i.'</a> ';

				}

			}

			//next_posts_link('&gt;');

			if ($end_page < $max_page) {

				$last_page_text = "&raquo;";

				echo '<a href="'.get_pagenum_link($max_page).'" title="'.$last_page_text.'" class="number">'.$last_page_text.'</a>';

			}

			echo '</div>'.$after;

		}

	}



	///////////////////////////////////////////

	// Create Recursive Directories

	///////////////////////////////////////////

	function themify_create_dirs($path){

		if (!is_dir($path)){

			$directory_path = "";

			$directories = explode("/",$path);

			array_pop($directories);

			foreach($directories as $directory){

				$directory_path .= $directory."/";

				if (!is_dir($directory_path)){

					mkdir($directory_path);

					chmod($directory_path, 0777);

				}

			}

		}

	}

	

	///////////////////////////////////////////

	// Get Remote File Size

	///////////////////////////////////////////

	function themify_remote_filesize($url, $user = "", $pw = "") { 

		$ch = curl_init($url); 

		curl_setopt($ch, CURLOPTHEADER, 1); 

		curl_setopt($ch, CURLOPTNOBODY, 1); 

		curl_setopt($ch, CURLOPTRETURNTRANSFER, 1);

		if (!empty($user) && !empty($pw)) { 

			$headers = array('Authorization: Basic ' . base64encode("$user:$pw")); 

			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); 

		}

		$head = curl_exec($ch); 

		curl_close($ch);

		$regex = '/Content-Length:\s([0-9].+?)\s/'; 

		$count = preg_match($regex, $head, $matches);

		return isset($matches[1]) ? $matches[1] : false; 

	}

	

	///////////////////////////////////////////

	// Recursive folder & file chmod change

	///////////////////////////////////////////

	function themify_chmodr($path, $filemode){ 

		if (!is_dir($path)) 

			return chmod($path, $filemode); 

		$dh = opendir($path); 

		while (($file = readdir($dh)) !== false) { 

			if($file != '.' && $file != '..') { 

				$fullpath = $path.'/'.$file; 

				if(is_link($fullpath)) 

					return FALSE; 

				elseif(!is_dir($fullpath) && !chmod($fullpath, $filemode)) 

						return FALSE; 

				elseif(!themify_chmodr($fullpath, $filemode)) 

					return FALSE; 

			} 

		} 

		closedir($dh); 

		if(chmod($path, $filemode)){ 

			return TRUE; 

		} else { 

			return FALSE; 

		}

	}



/**

 * Check if user has available space in multisite installations

 * @param String $allowed Content to show if there is space available

 * @param Boolean $echo Flag establishing if content must be echoed or returned

 * @return String

 * @since 1.1.5 

 */

function themify_has_quota($allowed, $echo = false, $custom = ''){

	if ( is_multisite() && !is_upload_space_available() ) {

		if( '' != $custom ){

			$message = $custom;

		}

		else{

			$message = '<small>' . sprintf( __( '对不起，您填写您的%s MB存储空间配额，以便上传已被禁用。', 'themify' ), get_space_allowed() ) . '</small>';

		}

	}

	else{

		$message = $allowed;

	}

	if($echo){

		echo $message;

	}

	else{

		return $message;

	}

}



/**

 * Display select element with featured image sizes + blank slot

 * @param String $key setting name

 * @return String

 * @since 1.1.5

 */

function themify_feature_image_sizes_select($key = ''){

	/** Define WP Featured Image sizes + blank + Themify's img.php

	 * @var array */

	$themify_layout_feature_sizes = array(

		array( 'value' => 'blank', 'name' => '' ),

		array( 'value' => 'thumbnail', 'name' => __('缩略图', 'themify') ),

		array( 'value' => 'medium', 'name' => __('中', 'themify') ),

		array( 'value' => 'large', 'name' => __('大', 'themify') ),

		array( 'value' => 'full', 'name' => __('原始图片', 'themify') )

	);

	

	$output = '<p class="show_if_disabled_img_php">

				<span class="label">' . __('特色图片大小', 'themify') . '</span>

				<select name="setting-'.$key.'">';                                                                                              

	foreach($themify_layout_feature_sizes as $option){

		if($option['value'] == themify_get('setting-'.$key.'')){

			$output .= '<option value="'.$option['value'].'" selected="selected">';

				$output .= $option['name'];

			$output .= '</option>';

		} else {

			$output .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';

		}

	}

	$output .= '</select></p>';

	

	return $output;

}



/**

 * Check if the site is using an HTTPS scheme and returns the proper url

 * @param String $url requested url

 * @return String

 * @since 1.1.5

 */

function themify_https_esc($url = ''){

	if( isset($_SERVER['HTTPS']) && ( 'off' != $_SERVER['HTTPS'] ) ){

		$parsed_url = parse_url($url);

		$url = 'https://' . $parsed_url['host'] . $parsed_url['path'];

	}

	return $url;

}



/**

 * Returns an array with the post types managed by Themify,

 * where the Themify Custom Panel is initialized.

 * Filterable using themify_post_types

 * @param Array $types additional post types

 * @return Array

 * @since 1.1.5

 */

function themify_post_types($types = array()){

	$defaults = array( 'post', 'page', 'slider', 'highlights', 'menu' );

	return array_merge( apply_filters('themify_post_types', $defaults), $types );

}



/**

 * Returns an array with the post types that are specific to Themify,

 * where the Themify Custom Panel is initialized.

 * Filterable using themify_post_types

 * @param Array $types additional post types

 * @return Array

 * @since 1.1.5

 */

function themify_specific_post_types(){

	return array( 'slider', 'highlights', 'menu' );

}



/**

 * Hijacks themes passed for upgrade checking and remove those from Themify

 * @param Bool

 * @param Array $r List of themes

 * @param String $url URL of upgrade check

 * @return Array

 * @since 1.1.8

 */

function themify_hide_themes( $r, $url){

	if ( 0 !== strpos( $url, 'http://api.wordpress.org/themes/update-check' ) )

		return $r;

	$themes = unserialize( $r['body']['themes'] );

	$themes_list = themify_get_theme_names();

	foreach( $themes_list as $theme_name ){

		unset( $themes[ $theme_name ] );

	}

	unset( $themes[ get_option( 'template' ) ] );

    unset( $themes[ get_option( 'stylesheet' ) ] );

	$r['body']['themes'] = serialize( $themes );

	return $r;

}



/**

 * Get list of themes from Themify's versions.xml

 * @return Array List of themes

 * @since 1.1.8

 */

function themify_get_theme_names(){

	$themes_list = array();

	

	if ( false === ( $themes_list = get_transient( 'themify_themes_list' ) ) ) {

		

		$response = wp_remote_get( 'http://themify.me/versions/versions.xml' );

		if( is_wp_error( $response ) ) {

			echo '<h4>' . __('不能载入版本文件。', 'themify') . '</h4><p>' . $response->get_error_code(). '</p>';

			return;

		}

		$versionsxml = simplexml_load_string($response['body']);

		foreach($versionsxml->version as $version) {

			$themes_list[] = (string) $version->attributes()->name;

		}

	

	set_transient( 'themify_themes_list', $themes_list, 60*60 ); }

	

	return $themes_list;

}



/**

 * Display an additional column in categories list

 * @since 1.1.8

 */

function themify_custom_category_header($cat_columns){

    $cat_columns['cat_id'] = 'ID';

    return $cat_columns;

}

/**

 * Display ID in additional column in categories list

 * @since 1.1.8

 */

function themify_custom_category($null, $column, $termid){

	return $termid;

}



/**

 * Outputs Open Graph tags on page head.

 * @since 1.1.8

 */

function themify_open_graph(){

	$og = "\n<!-- Open Graph Tags -->\n";

	$og .= '<meta property="og:site_name" content="' . get_bloginfo('name') . '" />' . "\n";

	if ( is_home() || is_front_page() ){

		$type = 'website';

		$description = get_bloginfo('description');

		$url = home_url();

	} else {

		$type = 'article';

		$url = apply_filters( 'the_permalink', get_permalink() );

		if( is_category() || is_tag() || is_tax() ){

			$description = strip_tags(category_description());

		} elseif( is_search() ){

			$description = get_search_query();

		} else {

			$description = strip_tags( get_the_excerpt() );

			if( !$description ){

				global $post;

				$description = strip_tags($post->post_content);

				$excerpt_length = 55;

				$words = explode(' ', $description, $excerpt_length + 1);

				if(count($words) > $excerpt_length){

					array_pop($words);

					$words[] = '...';

					$description = implode(' ', $words);

				}

			}

		}

	}

	$og .= '<meta property="og:type" content="' . apply_filters('themify_og_type', $type) . '" />' . "\n";

	$og .= '<meta property="og:description" content="' . apply_filters('themify_og_description', $description) . '" />' . "\n";

	$og .= '<meta property="og:url" content="'. $url . '" />' . "\n";

	

	if( is_singular() ){

		if ( has_post_thumbnail() ){

			$imagesrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'medium' );

			$thumb = $imagesrc[0];

		} else {

			global $post;

			$thumb = get_post_meta($post->ID, 'post_image', true);

		}

		if( $thumb ){

			$og .= '<meta property="og:image" content="' . apply_filters('themify_og_image', $thumb) . '" />' . "\n";

		}

		$og .= '<meta property="og:title"  content="' . the_title_attribute( array( 'echo' => false ) ) . '" />' . "\n";

	}

	$og .= "<!-- End Open Graph Tags -->\n";

	echo apply_filters('themify_open_graph', $og);

}

add_action('wp_head', 'themify_open_graph');



/**

 * Performs a beautified dump of a variable

 * @param mixed $var By reference. Variable to dump.

 */

if(function_exists('dumpit')){

	function dumpit(&$var, $var_name = NULL, $indent = NULL, $reference = NULL){

		$do_dump_indent = "<span style='color:#666666;'>|</span> &nbsp;&nbsp; ";

		$reference = $reference.$var_name;

		$keyvar = 'the_do_dump_recursion_protection_scheme'; $keyname = 'referenced_object_name';

		echo "<div style='text-align:left; background-color:white; font: 100% monospace; color:black;'>";

		if (is_array($var) && isset($var[$keyvar])){

			$real_var = &$var[$keyvar];

			$real_name = &$var[$keyname];

			$type = ucfirst(gettype($real_var));

			echo "$indent$var_name <span style='color:#666666'>$type</span> = <span style='color:#e87800;'>&amp;$real_name</span><br>";

		}

		else{

			$var = array($keyvar => $var, $keyname => $reference);

			$avar = &$var[$keyvar];

			$type = ucfirst(gettype($avar));

			if($type == "String") $type_color = "<span style='color:green'>";

			elseif($type == "Integer") $type_color = "<span style='color:red'>";

			elseif($type == "Double"){ $type_color = "<span style='color:#0099c5'>"; $type = "Float"; }

			elseif($type == "Boolean") $type_color = "<span style='color:#92008d'>";

			elseif($type == "NULL") $type_color = "<span style='color:black'>";

			

			if(is_array($avar)){

				$count = count($avar);

				echo "$indent" . ($var_name ? "$var_name => ":"") . "<span style='color:#666666'>$type ($count)</span><br>$indent(<br>";

				$keys = array_keys($avar);

				foreach($keys as $name){

				    $value = &$avar[$name];

				    dumpit($value, "['$name']", $indent.$do_dump_indent, $reference);

				}

				echo "$indent)<br>";

			}

			elseif(is_object($avar)){

				echo "$indent$var_name <span style='color:#666666'>$type</span><br>$indent(<br>";

				foreach($avar as $name=>$value) dumpit($value, "$name", $indent.$do_dump_indent, $reference);

				echo "$indent)<br>";

			}

			elseif(is_int($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".htmlentities($avar)."</span><br>";

			elseif(is_string($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color\"".htmlentities($avar)."\"</span><br>";

			elseif(is_float($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".htmlentities($avar)."</span><br>";

			elseif(is_bool($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> $type_color".($avar == 1 ? "TRUE":"FALSE")."</span><br>";

			elseif(is_null($avar)) echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> {$type_color}NULL</span><br>";

			else echo "$indent$var_name = <span style='color:#666666'>$type(".strlen($avar).")</span> ".htmlentities($avar)."<br>";

			$var = $var[$keyvar];

		}

		echo '</div>';

	}

}



?>