<?php



/***************************************************************************/

/*

/* 	----------------------------------------------------------------------

/* 						DO NOT EDIT THIS FILE

/*	----------------------------------------------------------------------

/* 

/*  					http://themify.me

/*  				Copyright (C) 2010 Themify

/*

/***************************************************************************/



/* 



	Widgets Coded Primarily By: Jon Raasch

	

	Jon Raasch is a front-end web developer / UI designer with endless love 

	for user experience, performance tuning, jQuery & CSS3. He spends his days

	building client sites, consulting, and developing a variety of free jQuery, 

	JavaScript and WordPress tools. Check out Jon's blog (http://jonraasch.com/blog) 

	or follow him on Twitter @jonraasch.



*/



	///////////////////////////////////////////

	// Feature Posts Class

	///////////////////////////////////////////

	class Themify_Feature_Posts extends WP_Widget {

		

		///////////////////////////////////////////

		// Feature Posts

		///////////////////////////////////////////

		function Themify_Feature_Posts() {

			/* Widget settings. */

			$widget_ops = array( 'classname' => 'feature-posts', 'description' => __('文章列表，可以选择过滤器的类别。', 'themify') );

	

			/* Widget control settings. */

			$control_ops = array( 'id_base' => 'themify-feature-posts' );

	

			/* Create the widget. */

			$this->WP_Widget( 'themify-feature-posts', __('Themify - 精选文章', 'themify'), $widget_ops, $control_ops );

		}

		

		///////////////////////////////////////////

		// Widget

		///////////////////////////////////////////

		function widget( $args, $instance ) {

			

			extract( $args );

	

			/* User-selected settings. */

			$title 			= apply_filters('widget_title', $instance['title'] );

			$category 		= $instance['category'];

			$show_count 	= $instance['show_count'];

			$show_date 		= $instance['show_date'] ? true : false;

			$show_thumb 	= $instance['show_thumb'] ? true : false;

			$show_excerpt 	= $instance['show_excerpt'] ? true : false;

			$excerpt_length = $instance['excerpt_length'];

			$show_title 	= $instance['hide_title'] ? false : true;

			

			$query_opts = apply_filters('themify_query', array(

				'posts_per_page' => $show_count,

				'post_type' => 'post'

			));

			if ( $category ) $query_opts['cat'] = $category;

			

			$loop = get_posts($query_opts);

			

			if($loop) {

				

				/* Before widget (defined by themes). */

				echo $before_widget;

				

				/* Title of widget (before and after defined by themes). */

				if ( $title )

					echo $before_title . $title . $after_title;

				

				echo '<ul class="feature-posts-list">';

				

				global $post;

				foreach ($loop as $post) {

					setup_postdata($post);

					echo '<li>';

						

						if ( $show_thumb ) {

							themify_image('ignore=true&w='.$instance['thumb_width'].'&h='.$instance['thumb_height'].'&before=<a href="'.get_permalink().'">&after=</a>&class=post-img');

						}

								

						if ( $show_title ) echo '<a href="' . get_permalink() . '" class="feature-posts-title">' . get_the_title() . '</a> <br />';

						

						if ( $show_date ) echo '<small>' . get_the_time( apply_filters('themify_filter_widget_date', 'M d, Y') ) . '</small> <br />';

						

						if ( $show_excerpt ) {

							$the_excerpt = get_the_excerpt();

							

							if($excerpt_length != "") {

							// cut to character limit

							$the_excerpt = substr( $the_excerpt, 0, $excerpt_length );

							

							// cut to last space

							$the_excerpt = substr( $the_excerpt, 0, strrpos( $the_excerpt, ' '));

							}

							

							echo '<span class="post-excerpt">' . $the_excerpt . '</span>';

						}

					echo '</li>';

					wp_reset_postdata();

				}//end for each

				

				echo '</ul>';

	

				/* After widget (defined by themes). */

				echo $after_widget;

				

			}//end if $loop

			

		}

		

		

		///////////////////////////////////////////

		// Update

		///////////////////////////////////////////

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

	

			/* Strip tags (if needed) and update the widget settings. */

			$instance['title'] = strip_tags( $new_instance['title'] );

			$instance['category'] = $new_instance['category'];

			$instance['show_count'] = $new_instance['show_count'];

			$instance['show_date'] = $new_instance['show_date'];

			$instance['show_thumb'] = $new_instance['show_thumb'];

			$instance['show_excerpt'] = $new_instance['show_excerpt'];

			$instance['hide_title'] = $new_instance['hide_title'];

			$instance['thumb_width'] = $new_instance['thumb_width'];

			$instance['thumb_height'] = $new_instance['thumb_height'];

			$instance['excerpt_length'] = $new_instance['excerpt_length'];

	

			return $instance;

		}

		

		///////////////////////////////////////////

		// Form

		///////////////////////////////////////////

		function form( $instance ) {

	

			/* Set up some default widget settings. */

			$defaults = array( 'title' => __('最新文章', 'themify'), 'category' => 0, 'show_count' => 5, 'show_date' => false, 'show_thumb' => false, 'show_excerpt' => false, 'hide_title' => false, 'thumb_width' => 50, 'thumb_height' => 50, 'excerpt_length' => 55 );

			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('标题:', 'themify'); ?></label><br />

				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />

			</p>

	

			<p>

				<label for="<?php echo $this->get_field_id( 'category' ); ?>"><?php _e('分类:', 'themify'); ?></label>

				<select id="<?php echo $this->get_field_id( 'category' ); ?>" name="<?php echo $this->get_field_name( 'category' ); ?>">

					<option value="0" <?php if ( !$instance['category'] ) echo 'selected="selected"'; ?>>All</option>

					<?php

					$categories = get_categories(array('type' => 'post'));

					

					foreach( $categories as $cat ) {

						echo '<option value="' . $cat->cat_ID . '"';

						

						if ( $cat->cat_ID == $instance['category'] ) echo  ' selected="selected"';

						

						echo '>' . $cat->cat_name . ' (' . $cat->category_count . ')';

						

						echo '</option>';

					}

					?>

				</select>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>"><?php _e('显示:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>" value="<?php echo $instance['show_count']; ?>" size="2" /> <?php _e('文章', 'themify'); ?>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['hide_title'], 'on' ); ?> id="<?php echo $this->get_field_id( 'hide_title' ); ?>" name="<?php echo $this->get_field_name( 'hide_title' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'hide_title' ); ?>"><?php _e('隐藏文章标题', 'themify'); ?></label>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_date'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php _e('显示文章日期', 'themify'); ?></label>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_thumb'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_thumb' ); ?>" name="<?php echo $this->get_field_name( 'show_thumb' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_thumb' ); ?>"><?php _e('显示文章缩略图', 'themify'); ?></label>

			</p>

			

			<?php

			// only allow thumbnail dimensions if GD library supported

			if ( function_exists('imagecreatetruecolor') ) {

			?>

			<p>

			   <label for="<?php echo $this->get_field_id( 'thumb_width' ); ?>"><?php _e('缩略图尺寸', 'themify'); ?></label> <input type="text" id="<?php echo $this->get_field_id( 'thumb_width' ); ?>" name="<?php echo $this->get_field_name( 'thumb_width' ); ?>" value="<?php echo $instance['thumb_width']; ?>" size="3" /> x <input type="text" id="<?php echo $this->get_field_id( 'thumb_height' ); ?>" name="<?php echo $this->get_field_name( 'thumb_height' ); ?>" value="<?php echo $instance['thumb_height']; ?>" size="3" />

			</p>

			<?php

			}

			?>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_excerpt'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_excerpt' ); ?>" name="<?php echo $this->get_field_name( 'show_excerpt' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_excerpt' ); ?>"><?php _e('显示文章摘录', 'themify'); ?></label>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'excerpt_length' ); ?>"><?php _e('摘录字数限制:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'excerpt_length' ); ?>" name="<?php echo $this->get_field_name( 'excerpt_length' ); ?>" value="<?php echo $instance['excerpt_length']; ?>" size="5" /><br /><small><?php _e('(留空 = 全部摘要)', 'themify'); ?></small>

			</p>

			

			<?php

		}

	}

	

	///////////////////////////////////////////

	// List Pages Class

	///////////////////////////////////////////

	class Themify_List_Pages extends WP_Widget {

		

		///////////////////////////////////////////

		// List Pages

		///////////////////////////////////////////

		function Themify_List_Pages() {

			/* Widget settings. */

			$widget_ops = array( 'classname' => 'list-pages', 'description' => __('页面列表', 'themify') );

	

			/* Widget control settings. */

			$control_ops = array( 'id_base' => 'themify-list-pages' );

	

			/* Create the widget. */

			$this->WP_Widget( 'themify-list-pages', __('Themify - 列表页', 'themify'), $widget_ops, $control_ops );

		}

		

		///////////////////////////////////////////

		// Widget

		///////////////////////////////////////////

		function widget( $args, $instance ) {

			extract( $args );

	

			/* User-selected settings. */

			$title = apply_filters('widget_title', $instance['title'] );

			$parent = $instance['parent'];

			$depth = $instance['depth'];

			$orderby = isset( $instance['orderby'] ) ? $instance['orderby'] : false;

			$exclude = isset( $instance['exclude'] ) ? $instance['exclude'] : false;

	

			/* Before widget (defined by themes). */

			echo $before_widget;

	

			/* Title of widget (before and after defined by themes). */

			if ( $title )

				echo $before_title . $title . $after_title;

			

			echo '<ul class="pages-list">';

			

			wp_list_pages(array(

				'child_of'       => $parent,

				'depth'         => $depth,

				'sort_column'   => $orderby,

				'exclude'  => $exclude,

				'title_li' => ''

			));

			

			echo '</ul>';

			

			/* After widget (defined by themes). */

			echo $after_widget;

		}

		

		///////////////////////////////////////////

		// Update

		///////////////////////////////////////////

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

	

			/* Strip tags (if needed) and update the widget settings. */

			$instance['title'] = strip_tags( $new_instance['title'] );

			$instance['parent'] = $new_instance['parent'];

			$instance['depth'] = $new_instance['depth'];

			$instance['orderby'] = $new_instance['orderby'];

			$instance['exclude'] = $new_instance['exclude'];

	

			return $instance;

		}

		

		///////////////////////////////////////////

		// Form

		///////////////////////////////////////////

		function form( $instance ) {

	

			/* Set up some default widget settings. */

			$defaults = array( 'title' => __('页面', 'themify'), 'parent' => '', 'depth' => 0, 'orderby' => 'post_title', 'exclude' => '' );

			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('标题:', 'themify'); ?></label><br />

				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />

			</p>

	

			<p>

				<label for="<?php echo $this->get_field_id( 'parent' ); ?>"><?php _e('父类:', 'themify'); ?></label>

				<select id="<?php echo $this->get_field_id( 'parent' ); ?>" name="<?php echo $this->get_field_name( 'parent' ); ?>">

					<option value="0" <?php if ( 0 == $instance['parent'] ) echo 'selected="selected"'; ?>>All</option>

					<?php

					$pages = get_pages();

					

					foreach( $pages as $thepage ) {

						echo '<option value="' . $thepage->ID . '"';

						

						if ( $thepage->ID == $instance['parent'] ) echo  ' selected="selected"';

						

						echo '>' . $thepage->post_title;

						

						echo '</option>';

					}

					?>

				</select>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'depth' ); ?>"><?php _e('深入:', 'themify'); ?></label>

				<select id="<?php echo $this->get_field_id( 'depth' ); ?>" name="<?php echo $this->get_field_name( 'depth' ); ?>">

					<option value="0" <?php if ( 0 == $instance['depth'] ) echo 'selected="selected"'; ?>><?php _e('0 (默认)', 'themify'); ?></option>

					<option value="1" <?php if ( 1 == $instance['depth'] ) echo 'selected="selected"'; ?>>1</option>

					<option value="2" <?php if ( 2 == $instance['depth'] ) echo 'selected="selected"'; ?>>2</option>

					<option value="3" <?php if ( 3 == $instance['depth'] ) echo 'selected="selected"'; ?>>3</option>

					<option value="4" <?php if ( 4 == $instance['depth'] ) echo 'selected="selected"'; ?>>4</option>

				</select>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php _e('排序方式:', 'themify'); ?></label>

				<select id="<?php echo $this->get_field_id( 'orderby' ); ?>" name="<?php echo $this->get_field_name( 'orderby' ); ?>">

					<option value="id" <?php if ( 'id' == $instance['orderby'] ) echo 'selected="selected"'; ?>>ID</option>

					<option value="menu_order" <?php if ( 'menu_order' == $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('菜单顺序', 'themify'); ?></option>

					<option value="post_title" <?php if ( 'post_title' == $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('文章标题', 'themify'); ?></option>

					<option value="post_date" <?php if ( 'post_date' == $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('文章日期', 'themify'); ?></option>

					<option value="post_name" <?php if ( 'post_name' == $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('文章名称', 'themify'); ?></option>

				</select>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'exclude' ); ?>"><?php _e('排除:', 'themify'); ?></label><br />

				<input id="<?php echo $this->get_field_id( 'exclude' ); ?>" name="<?php echo $this->get_field_name( 'exclude' ); ?>" value="<?php echo $instance['exclude']; ?>" /><br />

				<small><?php _e('页面ID，用逗号隔开（如5,8）', 'themify'); ?></small>

			</p>

			

			<?php

		}

	}

	

	///////////////////////////////////////////

	// List Categories Class

	///////////////////////////////////////////

	class Themify_List_Categories extends WP_Widget {

		

		///////////////////////////////////////////

		// List Categories

		///////////////////////////////////////////

		function Themify_List_Categories() {

			/* Widget settings. */

			$widget_ops = array( 'classname' => 'list-categories', 'description' => __('分类列表', 'themify') );

	

			/* Widget control settings. */

			$control_ops = array( 'id_base' => 'themify-list-categories' );

	

			/* Create the widget. */

			$this->WP_Widget( 'themify-list-categories', __('Themify - 分类列表', 'themify'), $widget_ops, $control_ops );

		}

		

		///////////////////////////////////////////

		// Widget

		///////////////////////////////////////////

		function widget( $args, $instance ) {

			extract( $args );

	

			/* User-selected settings. */

			$title = apply_filters('widget_title', $instance['title'] );

			$parent = $instance['parent'];

			$depth = $instance['depth'];

			$orderby = $instance['orderby'];

			$exclude = $instance['exclude'];

			$show_dropdown = isset( $instance['show_dropdown'] ) ? $instance['show_dropdown'] : false;

			$show_counts = isset( $instance['show_counts'] ) ? $instance['show_counts'] : false;

			$show_hierarchy = isset( $instance['show_hierarchy'] ) ? $instance['show_hierarchy'] : false;

	

			/* Before widget (defined by themes). */

			echo $before_widget;

	

			/* Title of widget (before and after defined by themes). */

			if ( $title )

				echo $before_title . $title . $after_title;

			

			$args = array(

					'orderby'       => $orderby,

					'show_count'    => $show_counts,

					'child_of'      => $parent,

					'exclude'       => $exclude,

					'hierarchical'  => $show_hierarchy,

					'depth'         => $depth,

					'title_li'      => ''

				);

			

			if ( $show_dropdown ) {

				$args['show_option_none'] = __('选择分类', 'themify');

				wp_dropdown_categories($args);

			?>

			

			<script type='text/javascript'>

			/* <![CDATA[ */

				var dropdown = document.getElementById("cat");

				function onCatChange() {

					if ( dropdown.options[dropdown.selectedIndex].value > 0 ) {

						location.href = "<?php echo home_url(); ?>/?cat="+dropdown.options[dropdown.selectedIndex].value;

					}

				}

				dropdown.onchange = onCatChange;

			/* ]]> */

			</script>

			

			<?php

			}

			else {

				echo '<ul class="categories-list">';

				

				wp_list_categories($args);

				

				echo '</ul>';

			}

	

			/* After widget (defined by themes). */

			echo $after_widget;

		}

		

		///////////////////////////////////////////

		// Update

		///////////////////////////////////////////

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

	

			/* Strip tags (if needed) and update the widget settings. */

			$instance['title'] = strip_tags( $new_instance['title'] );

			$instance['parent'] = $new_instance['parent'];

			$instance['depth'] = $new_instance['depth'];

			$instance['orderby'] = $new_instance['orderby'];

			$instance['exclude'] = $new_instance['exclude'];

			$instance['show_dropdown'] = $new_instance['show_dropdown'];

			$instance['show_counts'] = $new_instance['show_counts'];

			$instance['show_hierarchy'] = $new_instance['show_hierarchy'];

	

			return $instance;

		}

		

		///////////////////////////////////////////

		// Form

		///////////////////////////////////////////

		function form( $instance ) {

	

			/* Set up some default widget settings. */

			$defaults = array( 'title' => __('分类', 'themify'), 'parent' => 0, 'depth' => 0, 'orderby' => 'name', 'exclude' => '', 'show_dropdown' => false, 'show_counts' => false, 'show_hierarchy' => true );

			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('标题:', 'themify'); ?></label><br />

				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />

			</p>

	

			<p>

				<label for="<?php echo $this->get_field_id( 'parent' ); ?>"><?php _e('父类:', 'themify'); ?></label>

				

				<?php

				wp_dropdown_categories( array(

					'show_option_all' => __('全部', 'themify'),

					'orderby'         => 'name',

					'hierarchical'    => 1,

					'selected'        => $instance['parent'],

					'id'              => $this->get_field_id( 'parent' ),

					'name'            => $this->get_field_name( 'parent' ),

				));

				?>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'depth' ); ?>"><?php _e('深度:', 'themify'); ?></label>

				<select id="<?php echo $this->get_field_id( 'depth' ); ?>" name="<?php echo $this->get_field_name( 'depth' ); ?>">

					<option value="0" <?php if ( 0 == $instance['depth'] ) echo 'selected="selected"'; ?>><?php _e('0 (默认)', 'themify'); ?></option>

					<option value="1" <?php if ( 1 == $instance['depth'] ) echo 'selected="selected"'; ?>>1</option>

					<option value="2" <?php if ( 2 == $instance['depth'] ) echo 'selected="selected"'; ?>>2</option>

					<option value="3" <?php if ( 3 == $instance['depth'] ) echo 'selected="selected"'; ?>>3</option>

					<option value="4" <?php if ( 4 == $instance['depth'] ) echo 'selected="selected"'; ?>>4</option>

				</select>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php _e('排序:', 'themify'); ?></label>

				<select id="<?php echo $this->get_field_id( 'orderby' ); ?>" name="<?php echo $this->get_field_name( 'orderby' ); ?>">

					<option value="id" <?php if ( 'id' == $instance['orderby'] ) echo 'selected="selected"'; ?>>ID</option>

					<option value="name" <?php if ( 'name' == $instance['orderby'] ) echo 'selected="selected"'; ?>>Name</option>

					<option value="slug" <?php if ( 'slug' == $instance['orderby'] ) echo 'selected="selected"'; ?>>Slug</option>

					<option value="count" <?php if ( 'count' == $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('统计数', 'themify'); ?></option>

				</select>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'exclude' ); ?>"><?php _e('排除:', 'themify'); ?></label><br />

				<input id="<?php echo $this->get_field_id( 'exclude' ); ?>" name="<?php echo $this->get_field_name( 'exclude' ); ?>" value="<?php echo $instance['exclude']; ?>" /><br />

				<small><?php _e('类别ID，用逗号隔开（如5,8）', 'themify'); ?></small>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_dropdown'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_dropdown' ); ?>" name="<?php echo $this->get_field_name( 'show_dropdown' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_dropdown' ); ?>"><?php _e('显示为下拉菜单', 'themify'); ?></label>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_counts'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_counts' ); ?>" name="<?php echo $this->get_field_name( 'show_counts' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_counts' ); ?>"><?php _e('显示文章数目', 'themify'); ?></label>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_hierarchy'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_hierarchy' ); ?>" name="<?php echo $this->get_field_name( 'show_hierarchy' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_hierarchy' ); ?>"><?php _e('显示层次结构', 'themify'); ?></label>

			</p>

			

			<?php

		}

	}

	

	///////////////////////////////////////////

	// Recent Comments Class

	///////////////////////////////////////////

	class Themify_Recent_Comments extends WP_Widget {

		

		///////////////////////////////////////////

		// Recent Comments

		///////////////////////////////////////////

		function Themify_Recent_Comments() {

			/* Widget settings. */

			$widget_ops = array( 'classname' => 'recent-comments', 'description' => __('最近的评论发表的所有文章列表', 'themify') );

	

			/* Widget control settings. */

			$control_ops = array( 'id_base' => 'themify-recent-comments' );

	

			/* Create the widget. */

			$this->WP_Widget( 'themify-recent-comments', __('Themify - 最新评论', 'themify'), $widget_ops, $control_ops );

		}

		

		///////////////////////////////////////////

		// Widget

		///////////////////////////////////////////

		function widget( $args, $instance ) {

			extract( $args );

	

			/* User-selected settings. */

			$title = apply_filters('widget_title', $instance['title'] );

			$show_count = $instance['show_count'];

			$show_avatar = isset( $instance['show_avatar'] ) ? $instance['show_avatar'] : false;

			$avatar_size = $instance['avatar_size'];

			$excerpt_length = $instance['excerpt_length'];



			$comments = get_comments(array(

				'number' => $show_count,

				'status' => 'approve',

				'type' => 'comment'

			));

			if($comments){

			

				/* Before widget (defined by themes). */

				echo $before_widget;

		

				/* Title of widget (before and after defined by themes). */

				if ( $title )

					echo $before_title . $title . $after_title;

				

				echo '<ul class="recent-comments-list">';

				

				foreach($comments as $comment){

					$p = get_post($comment->comment_post_ID);

					if( ! empty( $p->post_password ) ) continue;

					$comm_title = get_the_title($comment->comment_post_ID);

					$comm_link = get_comment_link($comment->comment_ID);

					?>

				

					<li>

						<?php

							if ( $show_avatar ) {

								echo '<a href="' . $comm_link . '">' . get_avatar($comment,$size=$avatar_size) . '</a>';

							}

						?>

						<a href="<?php echo($comm_link)?>"><strong class="comment-author"><?php echo($comment->comment_author)?></strong>:</a> <?php echo substr(get_comment_excerpt( $comment->comment_ID ), 0, $excerpt_length); ?>&hellip;

					</li> 

				

					<?php 

				}

				

				echo '</ul>';

	

				/* After widget (defined by themes). */

				echo $after_widget;

			}//end if $comments

		}

		

		///////////////////////////////////////////

		// Update

		///////////////////////////////////////////

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

	

			/* Strip tags (if needed) and update the widget settings. */

			$instance['title'] = strip_tags( $new_instance['title'] );

			$instance['show_count'] = $new_instance['show_count'];

			$instance['show_avatar'] = $new_instance['show_avatar'];

			$instance['avatar_size'] = $new_instance['avatar_size'];

			$instance['excerpt_length'] = $new_instance['excerpt_length'];

	

			return $instance;

		}

		

		///////////////////////////////////////////

		// Form

		///////////////////////////////////////////

		function form( $instance ) {

	

			/* Set up some default widget settings. */

			$defaults = array( 'title' => __('最新评论', 'themify'), 'show_count' => 3, 'show_avatar' => false, 'avatar_size' => 32, 'excerpt_length' => 60 );

			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('标题:', 'themify'); ?></label><br />

				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />

			</p>

	

			<p>

				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>"><?php _e('显示:', 'themify'); ?></label>

				<select id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>">

					<?php

					for ( $i = 1; $i < 11; $i++ ) {

						echo '<option' . ( $i == $instance['show_count'] ? ' selected="selected"' : '' ) . '>' . $i . '</option>';

					}

					?>

				</select>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_avatar'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_avatar' ); ?>" name="<?php echo $this->get_field_name( 'show_avatar' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'avatar' ); ?>"><?php _e('显示头像', 'themify'); ?></label>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'avatar_size' ); ?>"><?php _e('头像尺寸:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'avatar_size' ); ?>" name="<?php echo $this->get_field_name( 'avatar_size' ); ?>" value="<?php echo $instance['avatar_size']; ?>" size="4" /> px

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'excerpt_length' ); ?>"><?php _e('评论摘录:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'excerpt_length' ); ?>" name="<?php echo $this->get_field_name( 'excerpt_length' ); ?>" value="<?php echo $instance['excerpt_length']; ?>" size="4" /> <?php _e('characters', 'themify'); ?>

			</p>

			

			<?php

		}

	}

	

	///////////////////////////////////////////

	// Banners & Links Class

	///////////////////////////////////////////

	class Themify_Links extends WP_Widget {

		

		///////////////////////////////////////////

		// Themify Links

		///////////////////////////////////////////

		function Themify_Links() {

			/* Widget settings. */

			$widget_ops = array( 'classname' => 'links', 'description' => __('书签列表', 'themify') );

	

			/* Widget control settings. */

			$control_ops = array( 'id_base' => 'themify-links' );

	

			/* Create the widget. */

			$this->WP_Widget( 'themify-links', __('Themify - 横幅 &amp; 链接', 'themify'), $widget_ops, $control_ops );

		}

		

		///////////////////////////////////////////

		// Widget

		///////////////////////////////////////////

		function widget( $args, $instance ) {

			extract( $args );

	

			/* User-selected settings. */

			$title = apply_filters('widget_title', $instance['title'] );

			$category = $instance['category'];

			$orderby = $instance['orderby'];

			$show_count = $instance['show_count'];

			$show_thumb = isset( $instance['show_thumb'] ) ? $instance['show_thumb'] : false;

			$show_name = isset( $instance['show_name'] ) ? $instance['show_name'] : false;

			$show_desc = isset( $instance['show_desc'] ) ? $instance['show_desc'] : false;

	

			/* Before widget (defined by themes). */

			echo $before_widget;

	

			/* Title of widget (before and after defined by themes). */

			if ( $title )

				echo $before_title . $title . $after_title;

			

			echo '<ul class="links-list">';

			

			wp_list_bookmarks( array(

				'categorize'        => false,

				'title_li'          => false,

				'orderby'           => $orderby,

				'limit'             => $show_count,

				'category'          => $category,

				'show_images'       => $show_thumb,

				'show_name'         => $show_name,

				'show_description'  => $show_desc

			));

			

			echo '</ul>';

	

			/* After widget (defined by themes). */

			echo $after_widget;

		}

		

		///////////////////////////////////////////

		// Update

		///////////////////////////////////////////

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

	

			/* Strip tags (if needed) and update the widget settings. */

			$instance['title'] = strip_tags( $new_instance['title'] );

			$instance['category'] = $new_instance['category'];

			$instance['orderby'] = $new_instance['orderby'];

			$instance['show_count'] = $new_instance['show_count'];

			$instance['show_thumb'] = $new_instance['show_thumb'];

			$instance['show_name'] = $new_instance['show_name'];

			$instance['show_desc'] = $new_instance['show_desc'];

	

			return $instance;

		}

		

		///////////////////////////////////////////

		// Form

		///////////////////////////////////////////

		function form( $instance ) {

	

			/* Set up some default widget settings. */

			$defaults = array( 'title' => __('博客链接', 'themify'), 'category' => '', 'orderby' => 'rand', 'show_count' => 10, 'show_thumb' => false, 'show_name' => false, 'show_desc' => false );

			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('标题:', 'themify'); ?></label><br />

				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />

			</p>

	

			<p>

				<label for="<?php echo $this->get_field_id( 'category' ); ?>"><?php _e('分类:', 'themify'); ?></label>

				<select id="<?php echo $this->get_field_id( 'category' ); ?>" name="<?php echo $this->get_field_name( 'category' ); ?>">

					<option value="" <?php if ( '' == $instance['category'] ) echo 'selected="selected"'; ?>>All</option>

					<?php

					$categories = get_categories(array('type' => 'link'));

					

					foreach( $categories as $cat ) {

						echo '<option value="' . $cat->cat_ID . '"';

						

						if ( $cat->cat_ID == $instance['category'] ) echo  ' selected="selected"';

						

						echo '>' . $cat->cat_name . ' (' . $cat->category_count . ')';

						

						echo '</option>';

					}

					?>

				</select>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php _e('排序:', 'themify'); ?></label>

				<select id="<?php echo $this->get_field_id( 'orderby' ); ?>" name="<?php echo $this->get_field_name( 'orderby' ); ?>">

					<option value="id" <?php if ( 'id' == $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('ID', 'themify'); ?></option>

					<option value="name" <?php if ( 'name' == $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('名称', 'themify'); ?></option>

					<option value="rating" <?php if ( 'rating' == $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('等级', 'themify'); ?></option>

					<option value="rand" <?php if ( 'rand' == $instance['orderby'] ) echo 'selected="selected"'; ?>><?php _e('随机', 'themify'); ?></option>

				</select>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>"><?php _e('限制:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>" value="<?php echo $instance['show_count']; ?>" size="2" />

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_thumb'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_thumb' ); ?>" name="<?php echo $this->get_field_name( 'show_thumb' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_thumb' ); ?>"><?php _e('显示链接图片', 'themify'); ?></label>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_name'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_name' ); ?>" name="<?php echo $this->get_field_name( 'show_name' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_name' ); ?>"><?php _e('显示链接名称', 'themify'); ?></label>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_desc'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_desc' ); ?>" name="<?php echo $this->get_field_name( 'show_desc' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_desc' ); ?>"><?php _e('显示链接描述', 'themify'); ?></label>

			</p>

			

			<?php

		}

	}



	///////////////////////////////////////////

	// Twitter Class

	///////////////////////////////////////////

	class Themify_Twitter extends WP_Widget {

		

		///////////////////////////////////////////

		// Twitter

		///////////////////////////////////////////

		function Themify_Twitter() {

			/* Widget settings. */

			$widget_ops = array( 'classname' => 'twitter', 'description' => __('最新tweets列表', 'themify') );

	

			/* Widget control settings. */

			$control_ops = array( 'id_base' => 'themify-twitter' );

	

			/* Create the widget. */

			$this->WP_Widget( 'themify-twitter', __('Themify - Twitter', 'themify'), $widget_ops, $control_ops );

			

			if( is_active_widget(false, false, $this->id_base, true) ){

				wp_enqueue_script( 'jtweets', THEMIFY_URI . '/js/jquery.jtweetsanywhere-1.3.1.min.js', array('jquery'), false, true );

				wp_localize_script('jtweets', 'themify_jtweets', array(

					'more' => __('更多', 'themify'),

					'prev' => __('前一页', 'themify'),

					'next' => __('下一页', 'themify'),

					'newtweet' => __('new tweet', 'themify'),

					'newtweets' => __('new tweets', 'themify'),

					'ontwitter' => __('on Twitter', 'themify'),

					'secondago' => __('%secs% second ago', 'themify'),

					'secondsago' => __('%secs% seconds ago', 'themify'),

					'minuteago' => __('%mins% minute ago', 'themify'),

					'minutesago' => __('%mins% minutes ago', 'themify'),

					'hourago' => __('%hours% hour ago', 'themify'),

					'hoursago' => __('%hours% hours ago', 'themify'),

					'dayago' => __('%days% day ago', 'themify'),

					'daysago' => __('%days% days ago', 'themify'),

					'via' => __('via', 'themify'),

					'here' => __('here', 'themify'),

					'from' => __('from', 'themify'),

					'inreplyto' => __('in reply to', 'themify'),

					'andrtcother' => __('and %rtc% other', 'themify'),

					'andrtcothers' => __('and %rtc% others', 'themify'),

					'retweetedby' => __('Retweeted by', 'themify'),

					'reply' => __('Reply', 'themify'),

					'retweet' => __('Retweet', 'themify'),

					'favorite' => __('Favorite', 'themify'),

					'signout' => __('Sign out', 'themify'),

					'loading' => __('Loading...', 'themify'),

					'terror' => __('ERROR', 'themify'),

					'nomoredata' => __('No more data', 'themify'),

					'whatshappening' => __("What's happening?", 'themify'),

					'orfrom' => __('OR from:', 'themify'),

					'jan' => __('Jan', 'themify'),

					'feb' => __('Feb', 'themify'),

					'mar' => __('Mar', 'themify'),

					'apr' => __('Apr', 'themify'),

					'may' => __('May', 'themify'),

					'jun' => __('Jun', 'themify'),

					'jul' => __('Jul', 'themify'),

					'aug' => __('Aug', 'themify'),

					'sep' => __('Sep', 'themify'),

					'oct' => __('Oct', 'themify'),

					'nov' => __('Nov', 'themify'),

					'dec' => __('Dec', 'themify')

				));

			}

		}

		

		///////////////////////////////////////////

		// Widget

		///////////////////////////////////////////

		function widget( $args, $instance ) {

			extract( $args );

	

			/* User-selected settings. */

			$title = apply_filters('widget_title', $instance['title'] );

			$username = $instance['username'];

			$show_count = $instance['show_count'];

			$hide_timestamp = isset( $instance['hide_timestamp'] ) ? false : true;

			$show_follow = isset( $instance['show_follow'] ) ? $instance['show_follow'] : false;

	

			/* Before widget (defined by themes). */

			echo $before_widget;

	

			/* Title of widget (before and after defined by themes). */

			if ( $title )

				echo $before_title . $title . $after_title;

			

			echo '<div class="twitter-list twitter-block-'.$this->id.'"></div>';

			

			echo "<script type='text/javascript'>

			jQuery(document).ready(function(){

				jQuery('.twitter-block-$this->id').jTweetsAnywhere({

					username: '$username',

					count: $show_count,

					showTweetFeed: {

						showTimestamp: '$hide_timestamp',

						showTwitterBird: false,

						showActionReply: false,

						showInReplyTo: false,

						includeRetweets: false

					}

				});

			});</script>";

			

			if ( $show_follow ) echo '<div class="follow-user"><a href="http://twitter.com/' . $username . '">' . $instance['follow_text'] . '</a></div>';

	

			/* After widget (defined by themes). */

			echo $after_widget;

		}

		

		///////////////////////////////////////////

		// Update

		///////////////////////////////////////////

		function update( $new_instance, $old_instance ) {

			$instance = $old_instance;

	

			/* Strip tags (if needed) and update the widget settings. */

			$instance['title'] = strip_tags( $new_instance['title'] );

			$instance['username'] = $new_instance['username'];

			$instance['show_count'] = $new_instance['show_count'];

			$instance['hide_timestamp'] = $new_instance['hide_timestamp'];

			$instance['show_follow'] = $new_instance['show_follow'];

			$instance['follow_text'] = $new_instance['follow_text'];

	

			return $instance;

		}

		

		///////////////////////////////////////////

		// Form

		///////////////////////////////////////////

		function form( $instance ) {

	

			/* Set up some default widget settings. */

			$defaults = array( 'title' => __('Latest Tweets', 'themify'), 'username' => '', 'show_count' => 5, 'hide_timestamp' => false, 'hide_url' => false, 'show_follow' => true , 'follow_text' => '&rarr; Follow me' );

			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('标题:', 'themify'); ?></label><br />

				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />

			</p>

	

			<p>

				<label for="<?php echo $this->get_field_id( 'username' ); ?>"><?php _e('Twitter ID:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'username' ); ?>" name="<?php echo $this->get_field_name( 'username' ); ?>" value="<?php echo $instance['username']; ?>" type="text"/>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>"><?php _e('显示:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>" value="<?php echo $instance['show_count']; ?>" size="3" type="text" /> <?php _e('tweets', 'themify'); ?>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['hide_timestamp'], 'on' ); ?> id="<?php echo $this->get_field_id( 'hide_timestamp' ); ?>" name="<?php echo $this->get_field_name( 'hide_timestamp' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'hide_timestamp' ); ?>"><?php _e('隐藏时间戳', 'themify'); ?></label>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_follow'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_follow' ); ?>" name="<?php echo $this->get_field_name( 'show_follow' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_follow' ); ?>"><?php _e('显示follow me 按钮', 'themify'); ?></label>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'follow_text' ); ?>"><?php _e('Follow me文字:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'follow_text' ); ?>" name="<?php echo $this->get_field_name( 'follow_text' ); ?>" value="<?php echo $instance['follow_text']; ?>" type="text" />

			</p>

				

			

			<?php

		}

	}

	

	///////////////////////////////////////////

	// Flickr Class

	///////////////////////////////////////////

	class Themify_Flickr extends WP_Widget {

		

		///////////////////////////////////////////

		// Flickr

		///////////////////////////////////////////

		function Themify_Flickr() {

			/* Widget settings. */

			$widget_ops = array( 'classname' => 'flickr', 'description' => __('一个趔趄的最新照片来自Flickr', 'themify') );

	

			/* Widget control settings. */

			$control_ops = array( 'id_base' => 'themify-flickr' );

	

			/* Create the widget. */

			$this->WP_Widget( 'themify-flickr', __('Themify - Flickr照片', 'themify'), $widget_ops, $control_ops );

		}

		

		///////////////////////////////////////////

		// Widget

		///////////////////////////////////////////

		function widget( $args, $instance ) {

			extract( $args );

	

			/* User-selected settings. */

			$title = apply_filters('widget_title', $instance['title'] );

			$username = $instance['username'];

			$show_count = $instance['show_count'];

			$show_link = $instance['show_link'];

	

			/* Before widget (defined by themes). */

			echo $before_widget;

	

			/* Title of widget (before and after defined by themes). */

			if ( $title ) {

				echo $before_title . $title . $after_title;

			}

			

			echo '<div id="flickr_badge_wrapper" class="clearfix">

					<script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count='.$show_count.'.&amp;display=latest&amp;size=s&amp;layout=x&amp;source=user&amp;user='.$username.'"></script>

				</div>';

			if( $show_link )

				echo '<a href="http://www.flickr.com/photos/'.$username.'/">' . __('查看我的Flickr照片', 'themify') . '</a>';

	

			/* After widget (defined by themes). */

			echo $after_widget;

		}

		

        ///////////////////////////////////////////

        // Update

        ///////////////////////////////////////////

		function update( $new_instance, $old_instance ) {

			

            $instance = $old_instance;

	

			/* Strip tags (if needed) and update the widget settings. */

			$instance['title'] = strip_tags( $new_instance['title'] );

			$instance['username'] = $new_instance['username'];

			$instance['show_count'] = $new_instance['show_count'];

			$instance['show_link'] = $new_instance['show_link'];

			return $instance;

		}

		

        ///////////////////////////////////////////

        // Form

        ///////////////////////////////////////////

		function form( $instance ) {

	

			/* Set up some default widget settings. */

			$defaults = array( 'title' => __('最近照片', 'themify'), 'username' => '', 'show_count' => 10 );

			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('标题:', 'themify'); ?></label><br />

				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" width="100%" />

			</p>

	

			<p>

				<label for="<?php echo $this->get_field_id( 'username' ); ?>"><?php _e('Flickr ID:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'username' ); ?>" name="<?php echo $this->get_field_name( 'username' ); ?>" value="<?php echo $instance['username']; ?>" /><br />

				<small>* Find your Flickr ID: <a href="http://www.idgettr.com" target="_blank">idGettr</a></small>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>"><?php _e('显示:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>" value="<?php echo $instance['show_count']; ?>" size="2" /> <?php _e('photos', 'themify'); ?>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_link'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_link' ); ?>" name="<?php echo $this->get_field_name( 'show_link' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_link' ); ?>"><?php _e('显示链接到帐户', 'themify'); ?></label>

			</p>

	

			<?php

		}

	}



	/**

	 * @package themify

	 * @subpackage shortcodes

	 * @author Elio Rivero

	 * @access public

	 * @since 1.1.2

	 */

	class Themify_Most_Commented extends WP_Widget{

		

		function __construct(){

			$widget_ops = array( 'classname' => 'themify-most-commented', 'description' => __('评论文章最多的文章列表。', 'themify') );

			$control_ops = array( 'id_base' => 'themify-most-commented' );

			parent::__construct( 'themify-most-commented', __('Themify - 评论最多', 'themify'), $widget_ops, $control_ops );

		}

		

		function widget( $args, $instance ) {

			

			/**

			 *  Default Values

			 *  'title' => 'Most Commented Posts',

				'show_count' => 5,

				'show_excerpt'	=> false,

				'show_thumb' => false,

				'thumb_width' => 50,

				'thumb_height' => 50,

				'excerpt_length' => 55,

				'hide_title' => false

			 */

			extract( $args );

			extract( $instance );

			

			$loop = get_posts( array(

				'numberposts' => $show_count,

				'orderby' => 'comment_count',

				'post_type' => 'post',

				'order' => 'DESC' ) );

			$html = '';	

			

			if($loop) {

				

				/* Before widget (defined by themes). */

				echo $before_widget;

				

				/* Title of widget (before and after defined by themes). */

				if ( $title )

					echo $before_title . $title . $after_title;

				

				$html .= '<ul class="feature-posts-list">';

				global $post;

				foreach ($loop as $post) {

					setup_postdata($post);

					

					$post_excerpt = trim(strip_tags( $post->post_excerpt ));

					$post_title = trim(strip_tags( $post->post_title ));

					

					// cut to character limit

					$cut_excerpt = substr( $post_excerpt, 0, $excerpt_length );

					if( $cut_excerpt != $post_excerpt ){

						// cut to last space

						$post_excerpt = substr( $post_excerpt, 0, strrpos( $post_excerpt, ' '));

					}

					

					$html .= '<li>';

					

					if ( $show_thumb ) {

						$html .= themify_get_image('ignore=true&w='.$instance['thumb_width'].'&h='.$instance['thumb_height'].'&before=<a href="'.get_permalink().'">&after=</a>&class=post-img');

					}



					if( !$hide_title ){

						$html .= '<a href="' . get_permalink() . '" class="feature-posts-title">' . get_the_title() . '</a>';

					}

					

					if ( $show_comment_count ){

						$comment_string = (get_comments_number() > 1)? __('条评论', 'themify') : __('评论', 'themify');

						

						$html .= '<br/><small>' . get_comments_number() . ' ' . $comment_string . '</small> <br />';

					}

					if ( $show_excerpt ) {

						$the_excerpt = get_the_excerpt();

						

						if($excerpt_length != "") {

						// cut to character limit

						$the_excerpt = substr( $the_excerpt, 0, $excerpt_length );

						

						// cut to last space

						$the_excerpt = substr( $the_excerpt, 0, strrpos( $the_excerpt, ' '));

						}

						

						$html .= '<span class="post-excerpt">' . $the_excerpt . '</span>';

					}

						

					$html .= '</li>';

					wp_reset_postdata();

				}

				$html .= '</ul>';

				

				echo $html;

				

				echo $after_widget;

			}

			

		}

		

		function update( $new_instance, $old_instance ){

			$instance = $old_instance;

			

			$instance['title'] = strip_tags( $new_instance['title'] );

			$instance['show_count'] = $new_instance['show_count'];

			$instance['show_thumb'] = $new_instance['show_thumb'];

			$instance['thumb_width'] = $new_instance['thumb_width'];

			$instance['thumb_height'] = $new_instance['thumb_height'];

			$instance['show_excerpt'] = $new_instance['show_excerpt'];

			$instance['excerpt_length'] = $new_instance['excerpt_length'];

			$instance['hide_title'] = $new_instance['hide_title'];

			$instance['show_comment_count'] = $new_instance['show_comment_count'];

			

			return $instance;

		}

		

		function form( $instance ) {

	

			/* Set up some default widget settings. */

			$defaults = array(

						'title' => __('评论最多的文章', 'themify'),

						'show_count' => 5,

						'show_excerpt'	=> false,

						'show_thumb' => false,

						'thumb_width' => 50,

						'thumb_height' => 50,

						'excerpt_length' => 55,

						'hide_title' => false,

						'show_comment_count' => false

					);

			

			$instance = wp_parse_args( (array) $instance, $defaults ); ?>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('标题:', 'themify'); ?></label><br />

				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" type="text" class="widefat" />

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['hide_title'], 'on' ); ?> id="<?php echo $this->get_field_id( 'hide_title' ); ?>" name="<?php echo $this->get_field_name( 'hide_title' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'hide_title' ); ?>"><?php _e('隐藏文章标题', 'themify'); ?></label>

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_comment_count'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_comment_count' ); ?>" name="<?php echo $this->get_field_name( 'show_comment_count' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_comment_count' ); ?>"><?php _e('显示评论数目', 'themify'); ?></label>

			</p>

	

			<p>

				<label for="<?php echo $this->get_field_id( 'show_count' ); ?>"><?php _e('文章数目:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>" value="<?php echo $instance['show_count']; ?>" size="2" type="text" />

			</p>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_thumb'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_thumb' ); ?>" name="<?php echo $this->get_field_name( 'show_thumb' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_thumb' ); ?>"><?php _e('显示文章缩略图', 'themify'); ?></label>

			</p>

			

			<?php

			// only allow thumbnail dimensions if GD library supported

			if ( function_exists('imagecreatetruecolor') ) {

			?>

			<p>

			   <label for="<?php echo $this->get_field_id( 'thumb_width' ); ?>"><?php _e('缩略图尺寸', 'themify'); ?></label> <input type="text" id="<?php echo $this->get_field_id( 'thumb_width' ); ?>" name="<?php echo $this->get_field_name( 'thumb_width' ); ?>" value="<?php echo $instance['thumb_width']; ?>" size="3" /> x <input type="text" id="<?php echo $this->get_field_id( 'thumb_height' ); ?>" name="<?php echo $this->get_field_name( 'thumb_height' ); ?>" value="<?php echo $instance['thumb_height']; ?>" size="3" />

			</p>

			<?php

			}

			?>

			

			<p>

				<input class="checkbox" type="checkbox" <?php checked( $instance['show_excerpt'], 'on' ); ?> id="<?php echo $this->get_field_id( 'show_excerpt' ); ?>" name="<?php echo $this->get_field_name( 'show_excerpt' ); ?>" />

				<label for="<?php echo $this->get_field_id( 'show_excerpt' ); ?>"><?php _e('显示文章摘录', 'themify'); ?></label>

			</p>

			

			<p>

				<label for="<?php echo $this->get_field_id( 'excerpt_length' ); ?>"><?php _e('摘要字符的限制:', 'themify'); ?></label>

				<input id="<?php echo $this->get_field_id( 'excerpt_length' ); ?>" name="<?php echo $this->get_field_name( 'excerpt_length' ); ?>" value="<?php echo $instance['excerpt_length']; ?>" size="1" type="text" /><br/><small><?php _e('(留空 = 全部摘要)', 'themify'); ?></small>

			</p>

	

			<?php

		}

	}



	

	///////////////////////////////////////////

	// Register Widgets

	///////////////////////////////////////////

	function themify_register_widgets() {

		register_widget('Themify_Feature_Posts');

		register_widget('Themify_List_Pages');

		register_widget('Themify_List_Categories');

		register_widget('Themify_Recent_Comments');

		register_widget('Themify_Links');

		register_widget('Themify_Twitter');

		register_widget('Themify_Flickr');

		register_widget('Themify_Most_Commented');

	}

	add_action('widgets_init', 'themify_register_widgets', 1);



?>