<?php

/**

 * @package themify

 * @since 1.1.3

 * @author Elio Rivero

 * 

 * ----------------------------------------------------------------------

 * 					DO NOT EDIT THIS FILE

 * ----------------------------------------------------------------------

 * 				AJAX functions to:

 *	 				Save Settings

 *	 				Get Settings

 * 					Reset Settings

 * 					Reset Styling

 * 					Import / Export

 * 					Upload Images

 * 					Upload Files

 * 

 *  			http://themify.me

 *  			Copyright (C) 2011 Themify

 *

 ***************************************************************************/



function themify_remove_post_image(){

	check_ajax_referer( 'themify-custom-panel', 'nonce' );

	if( isset($_POST['postid']) && isset($_POST['customfield'])){

		//clear Themify custom field for post image

		update_post_meta($_POST['postid'], $_POST['customfield'], ''); 

		//clear hidden custom field

		update_post_meta($_POST['postid'], '_thumbnail_id', array());

	}

	else{

		echo 'Missing vars: post ID and custom field.';

	}

	die();

}

add_action('wp_ajax_themify_remove_post_image', 'themify_remove_post_image');



/**

 * Save user settings

 * @since 1.1.3

 * @package themify

 */

function themify_save(){

	check_ajax_referer( 'ajax-nonce', 'nonce' );

	$data = explode("&", $_POST['data']);

	$temp = array();

	foreach($data as $a){

		$v = explode("=", $a);

		$temp[$v[0]] = urldecode( str_replace("+"," ",preg_replace('/%([0-9a-f]{2})/ie', "chr(hexdec('\\1'))", urlencode($v[1]))) );

	}

	set_data($temp);

	_e('你的设置已保存', 'themify');

	die();

}

add_action('wp_ajax_themify_save', 'themify_save');



/**

 * Reset Styling

 * @since 1.1.3

 * @package themify

 */

function themify_reset_styling(){

	check_ajax_referer( 'ajax-nonce', 'nonce' );

	$data = explode("&", $_POST['data']);

	$temp_data = array();

	foreach($data as $a){

		$v = explode("=", $a);

		$temp_data[$v[0]] = str_replace("+"," ",preg_replace('/%([0-9a-f]{2})/ie', "chr(hexdec('\\1'))", $v[1]));

	}

	$temp = array();

	foreach($temp_data as $key => $val){

		if(strpos($key, 'styling') === false){

			$temp[$key] = $val;

		}

	}

	print_r(set_data($temp));

	die();

}

add_action('wp_ajax_themify_reset_styling', 'themify_reset_styling');



/**

 * Reset Settings

 * @since 1.1.3

 * @package themify

 */

function themify_reset_setting(){

	check_ajax_referer( 'ajax-nonce', 'nonce' );

	$data = explode("&", $_POST['data']);

	$temp_data = array();

	foreach($data as $a){

		$v = explode("=", $a);

		$temp_data[$v[0]] = str_replace("+"," ",preg_replace('/%([0-9a-f]{2})/ie', "chr(hexdec('\\1'))", $v[1]));

	}

	$temp = array();

	foreach($temp_data as $key => $val){

		if(strpos($key, 'setting') === false){

			$temp[$key] = $val;

		}

	}

	print_r(set_data($temp));

	die();

}

add_action('wp_ajax_themify_reset_setting', 'themify_reset_setting');



/**

 * Export Settings to zip file and prompt to download

 * NOTE: This function is not called through AJAX but it is kept here for consistency. 

 * @since 1.1.3

 * @package themify

 */

function themify_export(){

	//Check nonce of export feature

	check_admin_referer( 'themify_export_nonce' );



	global $theme;

	if(class_exists('ZipArchive')){

		

		$datafile = 'data_export.txt';

		$handler = fopen($datafile, 'w');

		fwrite($handler,serialize(get_data()));

		fclose($handler);

		$files_to_zip = array(

			'../wp-content/themes/' . $theme['Name'] . '/custom-modules.php',

			'../wp-content/themes/' . $theme['Name'] . '/custom-functions.php',

			'../wp-content/themes/' . $theme['Name'] . '/custom-config.xml',

			$datafile

		);

		print_r($files_to_zip);

		$file = $theme['Name'].'_themify_export_'.date("Y-m-d").'.zip';

		$result = themify_create_zip( $files_to_zip, $file, true );



		if($result){

			if((isset($file))&&(file_exists($file))){

				header("Pragma: public");

				header("Expires: 0"); 

				header("Content-type: application/zip"); 

				header('Content-Disposition: inline; filename="' . $file . '"'); 

				header("Content-Transfer-Encoding: Binary"); 

				header("Content-length: ".filesize($file)); 

				header('Content-Type: application/octet-stream'); 

				header('Content-Disposition: attachment; filename="' . $file . '"'); 

				ob_clean();

				flush();

				readfile($file);

			} else {

				return false;

			}

			unlink($datafile);

			unlink($file);

		}

	} else {

		if(ini_get('zlib.output_compression')) {

			ini_set('zlib.output_compression', 'Off');	

		}

		header('Pragma: public');

		header('Expires: 0');

		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');

		header('Cache-Control: private',false);

		header('Content-Type: application/force-download');

		header('Content-Disposition: attachment; filename="'.$theme['Name'].'_themify_export_'.date("Y-m-d").'.txt"');

		header('Content-Transfer-Encoding: binary');

		ob_clean();

		flush();

		echo serialize(get_data());

	}

	return;

}



/**

 * Import Settings from uploaded zip file

 * NOTE: This function is not called through AJAX but it is kept here for consistency. 

 * @since 1.1.3

 * @package themify

 */

function themify_import(){

	if(!empty($_FILES)) {

		if(!is_dir(TEMPLATEPATH.'/themify/temp')){		

			mkdir(TEMPLATEPATH.'/themify/temp', 0777);

		}

		if(move_uploaded_file($_FILES['Filedata']['tmp_name'], TEMPLATEPATH.'/themify/temp/'.basename($_FILES['Filedata']['name']))){

			$file = basename($_FILES['Filedata']['name']);

			$ext = substr(strrchr($file, '.'), 1);

			$dir = 'temp/';

			if($ext == 'zip' || $ext == 'rar'){

				themify_extract_zip(TEMPLATEPATH.'/themify/'.$dir.$file);

			} else if($ext == 'txt'){

				$handler = fopen($dir.$file, 'r');

				if(filesize($dir.$file) > 0){

					$data = fread($handler, filesize($dir.$file));

					set_data(unserialize($data));

				}

				fclose($fh);	

			}

			$handle = opendir('temp/');

			while($file = readdir($handle)){

  				if($file != '.' && $file != '..'){

        			unlink('temp/'.$file);

				}

			}

			rmdir('temp/');

			echo 'true';

		} else {

			echo 'false';

		}

	}	

}



/**

 * Pull data for inspection

 * @since 1.1.3

 * @package themify

 */

function themify_pull(){

	print_r(get_data());

	die();

}

add_action('wp_ajax_themify_pull', 'themify_pull');







?>