<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" lang="zh-CN">
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" lang="zh-CN">
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html lang="zh-CN">
<!--<![endif]-->
<head>
<meta charset="UTF-8" />
	<title>	
		<?php if ( is_paged() ){ ?><?php printf( __('Page %1$s of %2$s', ''), intval( get_query_var('paged')), $wp_query->max_num_pages); ?> — <?php } ?>
		<?php if ( is_home() ) { ?><? bloginfo('name'); ?> - <?php bloginfo('description'); ?><?php } ?>
		<?php if ( is_search() ) { ?>搜索"<?php echo $s; ?>"的结果<?php } ?>
		<?php if ( is_404() ) { ?>囧！404 错误<?php } ?>
		<?php if ( is_author() ) { ?><?php _e('post list : ', ''); ?> - <? bloginfo('name'); ?><?php } ?>
		<?php if ( is_single() ) { ?><?php wp_title(''); ?> - <? bloginfo('name'); ?><?php } ?>
		<?php if ( is_page() ) { ?><?php wp_title(''); ?> - <? bloginfo('name'); ?><?php } ?>
		<?php if ( is_category() ) { ?><?php single_cat_title(); ?> - <? bloginfo('name'); ?><?php } ?>
		<?php if ( is_month() ) { ?><?php the_time('F, Y'); ?> - <? bloginfo('name'); ?><?php } ?>
		<?php if ( is_day() ) { ?><?php the_time('F j, Y'); ?> - <? bloginfo('name'); ?><?php } ?>
		<?php if ( is_tag() ) { ?><?php single_tag_title(); ?> - <? bloginfo('name'); ?><?php } ?>
	</title>
	<?php if (is_single()) {
			if ($post->post_excerpt) {
				$description = $post->post_excerpt;
			} else {
				$description = mb_strimwidth(strip_tags(apply_filters('the_content', $post->post_content)), 0, 200,"...");
				}
				$tags = wp_get_post_tags($post->ID);
				foreach ($tags as $tag ) {
				$keywords = $tag->name;
				}
		} else if (is_category()) {
			$description = category_description();
	}?>
	<meta name="keywords" content="<?php if (is_home()) { echo get_option('huilang_keywords');} else echo $keywords;?>"/>
	<meta name="description" content="<?php if (is_home()) { echo get_option('huilang_description');} else echo $description;?>"/>
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
	<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<!--[if lt IE 9]>
		<link rel='stylesheet' id='twentythirteen-ie-css'  href='<?php bloginfo('template_directory');?>/css/ie.css' type='text/css' media='all' />
		<script src="<?php bloginfo('template_directory');?>/js/html5.js"></script>
	<![endif]-->
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<header class="header_wrap">
		<div class="header clearfix">
			<div class="logo">
				<a href="<?php bloginfo('url'); ?>" title="<? bloginfo('name'); ?>"><? bloginfo('name'); ?></a>
			</div>
			<nav class="nav_wrap">
				<?php wp_nav_menu( array('menu_class' => 'menu','theme_location' => 'header_menu','menu_id' => 'top-nav')); ?>
			</nav>
			<div class="header_search">
				<form role="search" method="get" id="searchbar" action="<?php bloginfo('url'); ?>">
					<label>
						<input type="text" size="16" name="s" placeholder="搜索.." required x-webkit-speech speech id="search" />	
					</label>
					<input type="submit" id="searchsubmit" value="" title="搜索" />	
				</form>
			</div>
		</div>
	</header>