<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title>
<?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	?>
</title>
<link rel="profile" href="http://gmpg.org/xfn/11" />

<link  rel='stylesheet' type='text/css' href='http://fonts.googleapis.com/css?family=Oswald&amp;subset=latin'>
<?php

 get_template_part('custom-skin'); 

?>
<?php wp_head(); ?>


<style type="text/css">

.jqueryslidemenu-top a, .sf-menu li a, h1,  h2, h3, h4, h5{
	font-family: 'Oswald', arial, serif; 	
	}
	
.jqueryslidemenu-top ul li ul, .jqueryslidemenu-top li.main-links.current-menu-item{
 behavior: url('<?php echo get_template_directory_uri('template_url')?>/lib/PIE/PIE.php');
 }
</style>

<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<?php if ( is_singular() ) wp_enqueue_script( "comment-reply" ); ?>
</head>

<body <?php body_class($class); ?>>
<div id="header_wrapper">
<a id="top"></a>


<div id="header">
 <div class="logo">
 <?php  $logo=get_option('logo'); ?>
                <?php if($logo) { ?>
                <a href="<?php echo home_url(); ?> "> <img src="<?php echo $logo; ?>" alt="<?php the_title(); ?>"   /> </a>
                <?php }else{ ?>
                <a href="<?php echo home_url(); ?> "> <img src="<?php echo get_template_directory_uri()?>/images/logo.png" alt="<?php the_title(); ?>"   /> </a>
                <?php } ?>
	</div>
 <div class="jqueryslidemenu-top">
            <?php  wp_nav_menu( array( 'container_id' => 'myslidemenu','theme_location' => 'primary') ); ?>
        </div> 
    </div>
</div>
<div id="main_container">