<?php
function create_portfolio(){
	register_post_type('portfolio', array(
		'labels' => array(
			'name' => _x('Portfolios', 'post type general name'),
			'singular_name' => _x('portfolio', 'post type singular name' ),
			'add_new' => _x('Add New', 'portfolio'),
			'add_new_item' => __('Add New portfolio' ),
			'edit_item' => __('Edit portfolio'),
			'new_item' => __('New portfolio'),
			'view_item' => __('View portfolio'),
			'search_items' => __('Search portfolios' ),
			'not_found' =>  __('No portfolios found'),
			'not_found_in_trash' => __('No portfolios found in Trash'), 
			'parent_item_colon' => '',
		),
		
		'singular_label' => __('portfolio'),
		'public' => true,
		'exclude_from_search' => false,
		'show_ui' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'rewrite' => array( 'with_front' => false ),
		'query_var' => false,
		'menu_icon' => get_stylesheet_directory_uri() . '/images/kaya_portfolios.png',
		'supports' => array('title', 'editor', 'excerpt', 'thumbnail', 'comments','custom-fields','page-attributes')
	));

	//register taxonomy for portfolio
	register_taxonomy('portfolio_category','portfolio',array(
		'hierarchical' => true,
		'labels' => array(
			'name' => _x( 'portfolio Categories', 'taxonomy general name' ),
			'singular_name' => _x( 'Portfolio Category', 'taxonomy singular name'),
			'search_items' =>  __( 'Search Categories'),
			'popular_items' => __( 'Popular Categories' ),
			'all_items' => __( 'All Categories'),
			'parent_item' => null,
			'parent_item_colon' => null,
			'edit_item' => __( 'Edit portfolio Category' ), 
			'update_item' => __( 'Update portfolio Category' ),
			'add_new_item' => __( 'Add New portfolio Category'),
			'new_item_name' => __( 'New portfolio Category Name' ),
			'separate_items_with_commas' => __( 'Separate Portfolio category with commas'),
			'add_or_remove_items' => __( 'Add or remove portfolio category'),
			'choose_from_most_used' => __( 'Choose from the most used portfolio category')
		),
		'show_ui' => true,
		'query_var' => true,
		'rewrite' => false,
	));
}
add_action('init','create_portfolio');
function edit_portfolio_columns() {
	$columns = array(
		"cb" => "<input type=\"checkbox\" />",
		"title" => _x('Portfolio Name', 'column name'),
		//"thumbnail" => __('Thumbnail'),
		"portfolio_category" => __('Categories'),
		"date" =>  __('Date')
		
	);

	return $columns;
}
add_filter('manage_edit-portfolio_columns', 'edit_portfolio_columns');

function manage_portfolio_columns($column) {
	global $post;
	
	if ($post->post_type == "portfolio") {
		switch($column){
		
			case "portfolio_category":
				$sub_portfolio = get_the_terms($post->ID, 'portfolio_category');
				
				if (! empty($sub_portfolio)) {
					foreach($sub_portfolio as $sub_cat)
						$return[] = "<a href='edit.php?post_type=portfolio&portfolio_tag=$sub_cat->slug'> " . esc_html(sanitize_term_field('name', $sub_cat->name, $sub_cat->term_id, 'portfolio_tag', 'display')) . "</a>";
					$return = implode(', ', $return);
				} else {
					$sub_cat = get_taxonomy('portfolio_category');
					$return = "No $sub_cat->label";
				}
				
				echo $return;
				break;
			
			/* case 'thumbnail':
				echo the_post_thumbnail('thumbnail');
				break;
				*/
		}
	}
}
add_action('manage_posts_custom_column', 'manage_portfolio_columns', 10, 2);

?>