<?php
class Popular_Posts_Widget extends WP_Widget 
{
	function Popular_Posts_Widget() 
	{  global $themename;

		$widget_ops = array('classname' => 'widget_popular_posts', 'description' => 'Popular posts');
		$this->WP_Widget('popular_posts', $themename.'-Popular posts', $widget_ops);
	}
	
	function Get_Popular_Posts($instance)
	{
		global $wpdb;
        $Type = trim($instance['post_type']);
        
        if ($Type == 'all')
        {
      		$Popular_Posts = $wpdb->get_results("SELECT id,guid,post_title 
                                                 FROM $wpdb->posts
                                                 WHERE post_status = 'publish'
                                                 AND comment_count > 0
                                                 ORDER BY comment_count 
                                                 DESC LIMIT 0 , ".$instance['limits']
                                                    );            
        }
        else
        {
      		$Popular_Posts = $wpdb->get_results("SELECT id,guid,post_title 
                                                 FROM $wpdb->posts
                                                 WHERE post_status = 'publish'
                                                 AND comment_count > 0
                                                 AND post_type = '".$Type."'
                                                 ORDER BY comment_count 
                                                 DESC LIMIT 0 , ".$instance['limits']
                                                    );
        }


		
		$PP_list= '<ul>';
		
		foreach ($Popular_Posts as $list)
		{
		                    
            if(get_the_post_thumbnail($list->id)) {
	     			 $thumb = get_post_thumbnail_id($list->id); 
 $image = vt_resize( $thumb, '', 50, 50, true );
		   
			$PP_list .= '<li><a href="'. $list->guid .'" title="'.$list->post_title.'">'.'<img class="img-border alignleft_custom" src="'.$image[url].'"   height="'.$height.'" width="'.$width.'" alt="" />'.''.$list->post_title.''.'</a></li>';
			}else{
			
			$PP_list .= '<li><a href="'. $list->guid .'" title="'.$list->post_title.'"><span>'.$list->post_title.'</span>'.'</a></li>';
			}
		}
		$PP_list .= '</ul>';
		
		return $PP_list;
	}
    
    function GetPostTypes($preselect)
    {
        $CustomPostTypes = get_post_types(array('exclude_from_search' => false));
        array_unshift($CustomPostTypes, 'all');

            foreach ($CustomPostTypes as $index => $type)
            {
                if ($type == 'all')
                {
                    $type_info = new stdClass();
                    $type_info->publish = 5;
                }
                else
                {
                    $type_info = wp_count_posts($type);
                }
                
                if ($type_info->publish > 0)
                {
                    if ($type == trim($preselect))
                    {
                        echo '<option value="'.$type.'" selected="selected">'.$type.'</option>';
                    }
                    else
                    {
                        echo '<option value="'.$type.'">'.$type.'</option>';
                    }
                }
            }
        return;
    }

	function widget($args, $instance) 
	{
		extract($args);

		 echo "<li class='popularposts'>";
		$title = strip_tags($instance['title']);
		echo $before_title . $title . $after_title;
		echo $this->Get_Popular_Posts($instance);
		echo "</li>";
	}

	function update($new_instance, $old_instance) 
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['limits'] = trim(strip_tags($new_instance['limits']));
        $instance['post_type'] = strip_tags($new_instance['post_type']);

		return $instance;
	}

	function form($instance) 
	{
		$instance = wp_parse_args((array)$instance, array('title' => 'Popular posts', 'limits' => 5, 'ulclass' => '','post_type' => ''));
		$title = strip_tags($instance['title']);
		$limits = strip_tags($instance['limits']);
        $PostType = strip_tags($instance['post_type']);
?>
			<p><label for="<?php echo $this->get_field_id('title'); ?>">Title: <input  id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></label></p>
			<p><label for="<?php echo $this->get_field_id('limits'); ?>">Number of Dispaly: <input  id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo esc_attr($limits); ?>" /></label></p>
			<p><label for="<?php echo $this->get_field_id('post_type'); ?>">Post type: <select id="<?php echo $this->get_field_id('post_type'); ?>" name="<?php echo $this->get_field_name('post_type'); ?>">
                                                                                        <?php $this->GetPostTypes($PostType); ?>
                                                                                        </select>
                                                                                        </label></p>
<?php
	}
}
add_action('widgets_init', 'widget_init');
function widget_init() {
	register_widget('Popular_Posts_Widget');
}
?>