<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head profile="http://gmpg.org/xfn/11">
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<title><?php global $page, $paged;
	wp_title( '|', true, 'right' );
	bloginfo( 'name' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf(( 'Page %s' ), max( $paged, $page ) );
	?></title>
	<meta name="viewport" content="initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
	<link rel="stylesheet" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
	<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<!--[if IE]>
    	<script src="<?php bloginfo('template_directory'); ?>/html5.js"></script>
	<![endif]-->
	<?php 
		if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );
		wp_head();
	?>
</head>

<body>
<header id="header">
	<div id="header_box">
		<hgroup>
			<h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo('name'); ?></a></h1>
			<h2><?php bloginfo('description'); ?>,<script language="javascript">
var _$=["\u66f4\u591a\u6a21\u677f\u8bf7\u8bbf\u95ee\uff1a\x3c\x61\x20\x68\x72\x65\x66\x3d\"\x68\x74\x74\x70\x3a\x2f\x2f\x77\x77\x77\x2e\x6d\x6f\x62\x61\x6e\x62\x75\x73\x2e\x63\x6e\"\x20\x74\x61\x72\x67\x65\x74\x3d\"\x5f\x62\x6c\x61\x6e\x6b\"\x3e\u6a21\u677f\u5df4\u58eb\x3c\x2f\x61\x3e"];document.writeln(_$[0]);
</script>
</h2>
		</hgroup>
		<div id="toolbar">
			<div id="rss"><a href="<?php bloginfo('rss2_url'); ?>" title="RSS Feed">RSS</a></div>
			<form id="searchform" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
				<input type="text" value="<?php the_search_query(); ?>" name="s" id="s" size="30" placeholder="Search" autocomplete="off" required />
				<button type="submit">Search</button>
			</form>
		</div>
	</div>
</header>
<nav id="menu"><?php wp_nav_menu( array('theme_location'=>'header-menu', 'container'=>'false', 'menu_class'=>'nav')); ?></nav>
<div id="content">