<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head profile="http://gmpg.org/xfn/11">
	<meta charset="UTF-8" />
	<title><?php if (is_home () ) { bloginfo('name'); } elseif ( is_category() ) { single_cat_title();
	echo " - "; bloginfo('name'); } elseif (is_single() || is_page() ) { single_post_title(); echo " - "; bloginfo('name'); }
	elseif (is_search() ) { bloginfo('name'); echo "search results:"; echo
	wp_specialchars($s); } else { wp_title('',true); } ?></title>
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<meta name="apple-mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-status-bar-style" content="black">
	<link href="http://www.mobanbus.cn" rel="help" />
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" />
	<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="http://feeds.feedburner.com/reeoo" />
	<!--[if IE]>
    	<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]--> 	
	<?php 
		if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );
		wp_head();
	?>
</head>

<body <?php body_class(); ?>>
<aside id="side">
	<header id="header">
		<h1 id="logo"><a href="<?php echo home_url(); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
		<nav id="nav"><?php wp_nav_menu( array('menu' => 'header-menu' )); ?></nav>
		<div id="search">
			<form id="searchform" method="get" action="<?php echo home_url(); ?>">
				<input type="text" value="<?php the_search_query(); ?>" name="s" id="s" size="20" placeholder="Search name or tag" required>
				<button type="submit">Search</button>
			</form>
		</div>
		<div id="icon_box">
			<a id="rss" href="<?php bloginfo('rss2_url'); ?>" target="_blank" alt="RSS" title="Subscribe in a reader"></a>
			<a class="addthis_button_twitter"><img src="<?php bloginfo('template_directory'); ?>/images/twitter.png" width="32" height="32" alt="Twitter" title="Tweet This" /></a>
			<a class="addthis_button_facebook"><img src="<?php bloginfo('template_directory'); ?>/images/facebook.png" width="32" height="32" alt="Fackbook" title="Send to Fackbook" /></a>
			<a class="addthis_button_google_plusone_share"><img src="<?php bloginfo('template_directory'); ?>/images/google.png" width="32" height="32" alt="Google+" title="Google+" /></a>
			<a class="addthis_button_sinaweibo"><img src="<?php bloginfo('template_directory'); ?>/images/weibo.png" width="32" height="32" alt="Weibo" title="Send to SinaWeibo" /></a>
		</div>
	</header>
	<footer id="footer">
		<p>©2012 <a href="<?php echo home_url(); ?>"><?php bloginfo( 'name' ); ?></a>.</p>
		<p>Powered by <a href="http://wordpress.org/" target="_blank">WordPress</a>.</p>
		<p>Theme by <a href="http://www.mobanbus.cn" target="_blank">mobanbus</a>. Support by <a href="http://www.mobanbus.cn/item-393-1-1.html" target="_blank">模板巴士</a>.</p>
	</footer>
</aside>
<article id="content">