<?php get_header(); ?>
<article id="main">
	<?php if (is_search()) : ?>
		<div class="mini_nav">Search:<strong><?php the_search_query(); ?></strong></div>
	<?php elseif (is_tag()) : ?>
		<div class="mini_nav">Tag:<strong><?php single_tag_title(); ?></strong></div>
	<?php elseif (is_day()) : ?>
		<div class="mini_nav">Daily:<strong><?php the_time('Y-m-d'); ?></strong></div>
	<?php elseif ( is_month() ) : ?>
		<div class="mini_nav">Monthly:<strong><?php the_time('Y-m'); ?></strong></div>
	<?php elseif ( is_year() ) : ?>
		<div class="mini_nav">Yearly:<strong><?php the_time('Y'); ?></strong></div>
	<?php endif; ?>
	<article>
		<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
		<section <?php post_class() ?>>
			<h1><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h1>
			<article class="thumb">
				<a href="<?php the_permalink() ?>"><img src="<?php bloginfo( 'template_directory' ); ?>/timthumb.php?src=<?php echo wp_catch_first_image('m'); ?>&amp;w=300&amp;h=200&amp;zc=1" alt="<?php the_title(); ?>" tile="<?php the_title(); ?>" /></a>
			</article>
			<div class="addthis_toolbox" addthis:url="<?php the_permalink() ?>" addthis:title="<?php the_title(); ?>">
				<a class="addthis_button_twitter"></a>
				<a class="addthis_button_facebook"></a>
				<a class="addthis_button_sinaweibo"></a>
			</div>
		</section>
		<?php endwhile; endif; ?>
		<nav class="navigation"><?php previous_posts_link('&laquo;') ?><?php next_posts_link('&raquo;') ?></nav>
	</article>
</article>
<?php get_footer(); ?>