<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */

global $query_string, $wp;


$args = wp_parse_args($query_string);

// Remove Unneeded scrips
add_action('wp_footer', 'kolor_404_footer');

function kolor_404_footer(){
	wp_dequeue_script('jquery_easing');
	wp_dequeue_script('transit');
	wp_dequeue_script('ba_hashchange');
	wp_dequeue_script('masonry');
	
	wp_dequeue_script('greensock');
	wp_dequeue_script('greensock_easing');
	
	wp_dequeue_script('kolor_hover');
	wp_dequeue_script('kolor_winres');
	wp_dequeue_script('kolor_mediahelper');
	wp_dequeue_script('kolor_mobilemenu');
	wp_dequeue_script('kolor_ancarousel');
}
		

// Custom Title for 404 Page
$pagename = isset($args['name']) ? $args['name'] : _x('the requested URL', 'When 404 title is missing', TD);
$custom_title = sprintf(__('Nothing found for %s', TD), $pagename);

define('TITLE_ALTERNATE', $custom_title);

// Header
get_header();


?>
<!-- content -->
<div class="page_404 centered_div"><!-- adding class "centered_div will autocenter the div -->
	
	<i class="warning"></i>
	<h1>404</h1>
	
	<p><?php echo get_option('kolor_404_line_1'); ?></p>
	<p><a href="<?php echo site_url(); ?>"><?php echo get_option('kolor_404_go_to_homepage_link_text');?></a>
	
</div>
<!-- content -->
<?php


// Footer
get_footer();