<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	Template Name: Archive
 */


# This file is used as replacement of
# wp_link_pages(); for archives page

global $wp, $query_string;


// Post Id
$archives_post_id = get_the_ID();

# Archives Array
$archives = array();

$all_posts = new WP_Query(array('post_type' => 'post', 'posts_per_page' => -1));

while($all_posts->have_posts()):
	
	$all_posts->the_post();
	
	$post_id 	= get_the_ID();
	$post_title = get_the_title();
	$post_link 	= get_permalink($post_id);
	$post_date	= strtotime(get_the_date('r'));
	$post_month = get_the_date('F');
	$post_year 	= get_the_date('Y');
	
	$post_entry	= array('ID' => $post_id, 'title' => $post_title, 'permalink' => $post_link, 'date' => $post_date);
	
	
	$archives["{$post_year}"]["{$post_month}"][] = $post_entry;
	
endwhile;


// Post Id
$post_id = $archives_post_id;

function _count_for_year($entries_for_month)
{
	$total = 0;
	
	foreach($entries_for_month as $month_entries)
	{
		$total += count($month_entries);
	}
	
	return $total;
}

# Enqueue Archives Script
wp_enqueue_script('ba_hashchange');
wp_enqueue_script('kolor_archives');

// Header
get_header();


$phc_visible = get_post_meta($post_id, 'phc_visible', TRUE);

if($phc_visible == 0)
	$phc_visible = get_option('kolor_pagehead_captions_enable') == 'true' ? 1 : -1;

if($phc_visible == 1):
?>
<div class="bg_absolute content_page_bg bg_02">
	<!-- stripped border -->
	<div class="stripped_border"></div>
	<!-- end: stripped border -->		
</div>
<?php
endif;
?>
	
<!-- site header -->
<div class="site_header bg_02">
<?php

	// Main Menu (optionally with sliders)
	get_template_part('tpls/header', 'menu');

	// Page Head Caption
	get_template_part('tpls/blocks', 'pageheadcaption');

?>
</div>
<!-- end: site header -->

<?php if($phc_visible != 1): ?>
<!-- stripped border -->
<div class="stripped_border<?php echo $phc_visible != 1 ? ' margin_bottom_double' : ''; ?>"></div>
<!-- end: stripped border -->
<?php endif; ?>

<!-- content block (archives env) -->
<div class="container white_block content_block archives_env">
	
	<!-- content block title -->
	<h2 class="ct_title">
		<i class="archives"></i>
		Archives
	</h2>
	<!-- end: content block title -->
	
	<div class="lists">
		
		<ul class="display_years">
			<!-- archive entry (title) -->
			<li class="title"><?php _e('Year'); ?></li>
			
			<?php
			# Start Showing All Items
			foreach($archives as $year => $entries_for_month)
			{
				?>
				<li>
					<a href="#"><?php echo $year; ?> <span>(<?php echo _count_for_year($entries_for_month); ?>)</span></a>
				<?php
				
				# Show Months for the current year
				if(count($entries_for_month))
				{
					?>
					<ul class="display_months">
						<li class="title"><?php _e('Month'); ?></li>
					<?php
					foreach($entries_for_month as $month => $entries)
					{
						$entries_count = count($entries);
						
						?>
						<li>
							<a href="#"><?php echo $month; ?> <span>(<?php echo $entries_count; ?>)</span></a>

							<ul class="display_articles">
								<li class="title"><?php echo sprintf(_n('Total %d article during %s', 'Total %d articles during %s', $entries_count), $entries_count, $month); ?></li>
							<?php
							foreach($entries as $entry)
							{
								?>
								<li><a href="<?php echo $entry['permalink']; ?>"><?php echo $entry['title']; ?></a></li>
								<?php
							}
						
						?>
							</ul>
						</li>
						<?php
					}
					?>
					</ul>
					<?php
				}
			}
			?>
			</li>
		</ul>
		
	</div>
	
			
</div>
<!-- end: content block -->

<?php 
	


// Footer Clients Block
get_template_part('tpls/blocks', 'footerclients');


// Footer Blocks
get_template_part('footer', 'block');


// Footer
get_footer();