<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */



/* Constants */
define('THEMEDIR', 	get_template_directory() . '/');
define('THEMEURL', 	get_template_directory_uri() . '/');
define('WPURL', 	site_url('/'));
define('URL', 		home_url('/'));
define('TD', 		'kolor');
define('KOLOR_DEV',	0);


/* Theme Content Width */
if ( ! isset( $content_width ) )
	$content_width = 960;


/* Start The Session */
session_start();


/* Theme Support */
add_theme_support('menus');
add_theme_support('automatic-feed-links');

/* Theme Textdomain */
load_theme_textdomain(TD, get_template_directory() . '/languages');

/* Includes */
if(is_admin()) get_template_part('inc/administrative_functions');
if(is_admin()) get_template_part('inc/acera-options/options-init');

if( ! is_admin()) get_template_part('inc/kolor_menu_walker');

get_template_part('inc/global_functions');

# Zebra Image Library
get_template_part('inc/Zebra_Image');


get_template_part('inc/laborator_simpleads');
get_template_part('inc/laborator_contact_form');
get_template_part('inc/laborator_dataopt');
get_template_part('inc/laborator_image_resizer');

get_template_part('inc/laborator_inline_media_metabox');
get_template_part('inc/laborator_gallery');
get_template_part('inc/gallery-ordering/simple-page-ordering');


# Decent Comments plugin developed by itthinx - http://www.itthinx.com/plugins/decent-comments
get_template_part('inc/decent-comments/decent-comments');


 
/* Kolor Theme Activation */
if( is_admin() && isset($_GET['activated'] ) && $pagenow == "themes.php" )
{
	// Activate/Setup theme for the first time..
	kolor_activate_theme();
}


/* Modules Instances */
	
	
	/* ! Features Tabs (Homepage) */
	$tabs_icons = array(
		'photography' 			=> 'Photography Icon',
		'favorites' 			=> 'Favorites (Heart) Icon',
		'wireless' 				=> 'Wireless Icon',
		'features_cloudsharing'	=> 'Cloud Icon',
		'_uploaded_icon'		=> ':: Upload Icon ::'
	);
	
	$fields = array();
	
	$fields['icon'] 				= array('field_type' => 'select',	'field_name' => 'Tab Icon', 'required' => TRUE, 'options' => $tabs_icons, 'desc' => 'Choose from pre-defined icons for Features Tabs');
	$fields['title']				= array('field_type' => 'text', 	'field_name' => 'Title', 'required' => TRUE);
	$fields['uploaded_icon'] 		= array('field_type' => 'image', 	'field_name' => 'Upload Icon', 'image_sizes' => array('th' => array(34,60,1)));
	$fields['retina_icon'] 			= array('field_type' => 'image', 	'field_name' => 'Retina Icon (optional)', 'image_sizes' => array('th' => array(68,120,1)), 'desc' => 'Upload icons only if you selected <b>:: Upload Icon ::</b><br>Required size: 34x60, Retina: 68x120<br>Download <a href="' . site_url('wp-content/themes/kolor/inc/features_tabs_icon_template.psd') . '">PSD Template</a> or <a href="' . site_url('wp-content/themes/kolor/inc/features_tabs_retina_icon_template.psd') . '">PSD Retina Size</a>');
	$fields['url']					= array('field_type' => 'text', 	'field_name' => 'URL <em>(optional)</em>', 'required' => FALSE, 'desc' => 'When users click on the tab circle', 'placeholder' => 'http://');
	$fields['short_text']			= array('field_type' => 'textarea',	'field_name' => 'Short text', 'required' => TRUE);
	$fields['hover_title']			= array('field_type' => 'text', 	'field_name' => 'Hover Title', 'params' => array('heading' => 'Popup on hover (optional)'));
	$fields['hover_text']			= array('field_type' => 'textarea',	'field_name' => 'Text to display', 'params' => array('rows' => 10, 'cols' => 80));
	$fields['hover_image'] 			= array('field_type' => 'image', 	'field_name' => 'Image', 'image_sizes' => array('th' => array(450,450)), 'desc' => 'Image will show inline with the text');
	$fields['hover_image_position'] = array('field_type' => 'select', 	'field_name' => 'Image align', 'required' => TRUE, 'options' => array('left' => 'Left', 'right' => 'Right'));
	$fields['popup_visible']		= array('field_type' => 'checkbox', 'field_name' => 'Popup is visible', 'params' => array('checked' => FALSE));
	
	$features_tabs_instance = new LaboratorDataOpt(array(
		'parent_slug'				=> 'kolor_options', 
		'menu_slug' 				=> 'features_tabs_homepage', 
		'access_global'				=> 'kolor_features_tabs_homepage',
		'title' 					=> 'Features Tabs', 
		'fields' 					=> $fields,
		'table_fields'				=> 'title',
		'sortable'					=> TRUE,
		'sortable_column' 			=> 1,
		'max_items'					=> 4,
		'multilang'					=> TRUE,
		'labels'					=> array(
										'singluar' => 'Feature Tab',
										'add_new' => 'Add New'
									),
		'on_edit_return_to_main'	=> FALSE
	));
	
	function get_all_features_tabs()
	{
		global $features_tabs_instance;
		
		return $features_tabs_instance->get_entries();
	}
	
	
	
	/* ! Clients Carousel (NEW) */
	$fields = array();
	
	$fields['logo_image'] 	= array('field_type' => 'image', 'field_name' => 'Logo Image', 'required' => TRUE, 'image_sizes' => array('th' => array(135,0,TRUE,2)), 'desc' => 'Images will be resized to width: 135 pixels');
	$fields['name']			= array('field_type' => 'text', 'field_name' => 'Name', 'required' => TRUE);
	$fields['link'] 		= array('field_type' => 'text', 'field_name' => 'Link', 'required' => FALSE, 'placeholder' => 'http://');
	
	$clients_carousel_instance = new LaboratorDataOpt(array(
		'parent_slug'				=> 'kolor_options', 
		'menu_slug' 				=> 'laborator_client_module', 
		'access_global'				=> 'kolor_clients_carousel',
		'title' 					=> 'Clients Carousel', 
		'fields' 					=> $fields,
		'table_fields'				=> array('logo_image' => array('width' => 160), 'name'),
		'sortable'					=> TRUE,
		'sortable_column' 			=> -1,
		'order' 					=> 'DESC',
		'labels'					=> array(
										'singluar' => 'Client Logo',
										'add_new' => 'Add Client'
									),
		'on_edit_return_to_main'	=> FALSE
	));
	
	function get_clients_carousel()
	{
		global $clients_carousel_instance;
		
		return $clients_carousel_instance->get_entries();
	}
	


	/* Contact Form */
	new LaboratorContactForm('kolor_options');
	
	
	
	/* ! Client Testimonials */
	$fields = array();
	
	$fields['name'] 		= array('field_type' => 'text', 'field_name' => 'Client Name', 'required' => TRUE);
	$fields['link'] 		= array('field_type' => 'text', 'field_name' => 'Link to', 'required' => FALSE, 'placeholder' => 'http://');
	$fields['second_line']	= array('field_type' => 'text', 'field_name' => 'Second Line Text');
	$fields['client_image'] = array('field_type' => 'image', 'field_name' => 'Client Image', 'image_sizes' => array('th' => array(90,93,TRUE)), 'required' => TRUE, 'desc' => 'Recommended size: 92x95');
	$fields['testimonial'] 	= array('field_type' => 'textarea', 'field_name' => 'Testimonial', 'required' => TRUE);
	
	$testimonials_instance = new LaboratorDataOpt(array(
		'parent_slug'				=> 'kolor_options', 
		'menu_slug' 				=> 'client_testimonials', 
		'access_global'				=> 'kolor_client_testimonials',
		'title' 					=> 'Client Testimonials', 
		'fields' 					=> $fields,
		'table_fields'				=> array('client_image' => array('width' => 120), 'name'),
		'sortable'					=> TRUE,
		'sortable_column' 			=> -1,
		'multilang'					=> TRUE,
		'order' 					=> 'DESC',
		'labels'					=> array(
										'singluar' => 'Testimonial',
										'add_new' => 'Add New'
									),
		'on_edit_return_to_main'	=> FALSE
	));
	
	function get_all_testimonials()
	{
		global $testimonials_instance;
		
		return $testimonials_instance->get_entries();
	}
	
	
	
	/* Laborator Simple Ads */
	new LaboratorSimpleAds('kolor_options'); # Parent menu item slug parameter
 

/* Register Menus */
register_nav_menu('header-menu', 'Header Menu');
	

/* On Init */
add_action('init', 'kolor_init');

function kolor_init()
{
	get_template_part('inc/init');
}



/* Theme Setup */
add_action('init', 'kolor_theme_setup');
add_action('excerpt_more', 'kolor_excerpt_more');

function kolor_theme_setup()
{
	global $wp_rewrite;
	
	/* Register Portfolio Categories */
	$labels = array(
		'name' 					=> _x( 'Portfolio Categories', 'taxonomy general name' ),
		'singular_name' 		=> _x( 'Category', 'taxonomy singular name' ),
		'search_items' 			=> __( 'Search Categories' ),
		'all_items' 			=> __( 'All Categories' ),
		'parent_item' 			=> __( 'Parent Category' ),
		'parent_item_colon' 	=> __( 'Parent Genre:' ),
		'edit_item' 			=> __( 'Edit Category' ), 
		'update_item' 			=> __( 'Update Category' ),
		'add_new_item' 			=> __( 'Add New Category' ),
		'new_item_name' 		=> __( 'New Category Name' ),
		'menu_name' 			=> __( 'Categories' ),
	); 	
	
	register_taxonomy('portfolio-category', array('portfolio'), array(
		'hierarchical'	=> TRUE,
		'labels' 		=> $labels,
		'show_ui' 		=> TRUE,
		'query_var' 	=> TRUE,
		'rewrite' 		=> array( 'slug' => 'portfolio-category' ),
	));
	
	
	
	/* Register Portfolio Content Type */
	$labels = array(
		'name' 					=> _x('Portfolio', 'post type general name', TD),
		'singular_name' 		=> _x('Portfolio Item', 'post type singular name', TD),
		'add_new' 				=> _x('Add Portfolio Item', 'portfolio', TD),
		'add_new_item' 			=> __('Add New Item', TD),
		'edit_item' 			=> __('Edit Item', TD),
		'new_item' 				=> __('New Item', TD),
		'all_items' 			=> __('Portoflio Items', TD),
		'view_item' 			=> __('View Item', TD),
		'search_items' 			=> __('Search Portfolio', TD),
		'not_found' 			=> __('No portfolio items found', TD),
		'not_found_in_trash' 	=> __('No portfolio items found in Trash', TD), 
		'parent_item_colon'		=> '',
		'menu_name' 			=> __('Portfolio', TD)
	);
	
	$portfolio_args = array(
		'labels' 				=> $labels,
		'public' 				=> TRUE,
		'publicly_queryable'	=> TRUE,
		'show_ui' 				=> TRUE, 
		'show_in_menu' 			=> TRUE, 
		'query_var' 			=> 'portfolio',
		'rewrite'				=> array( 'slug' => 'portfolio', 'with_front' => false ),
		'capability_type' 		=> 'post',
		'has_archive' 			=> TRUE, 
		'hierarchical' 			=> FALSE,
		'menu_position' 		=> NULL,
		'supports' 				=> array( 'title', 'editor', 'thumbnail', 'page-attributes' ),
		'menu_icon'				=> THEMEURL . 'images/admin/portfolio.png'
	);
	
	register_post_type('portfolio', $portfolio_args);
	
	# Redirect Portfolio Taxonomy tempalte to portfolio.php
	add_action('template_redirect', 'kolor_template_redirect');
	
	function kolor_template_redirect()
	{
		global $query_string;
		
		if(is_tax('portfolio-category'))
		{
			get_template_part('portfolio');
			die();
		}
		
		if(is_category() || is_tag() || is_author())
		{
			$default_blog_columns = get_option('kolor_default_blog_columns');
			
			if($default_blog_columns == 'two_columns')
				get_template_part('blog-2');
			else
				get_template_part('blog');
				
			die();
		}
	}
	
	
	/* Register Gallery Type */
	$labels = array(
		'name' 					=> _x('Gallery', 'post type general name', TD),
		'singular_name' 		=> _x('Album', 'post type singular name', TD),
		'add_new' 				=> _x('Create New Album', 'gallery', TD),
		'add_new_item' 			=> __('Add New Album', TD),
		'edit_item' 			=> __('Edit Album', TD),
		'new_item' 				=> __('New Album', TD),
		'all_items' 			=> __('Gallery', TD),
		'view_item' 			=> __('View Album', TD),
		'search_items' 			=> __('Search Gallery', TD),
		'not_found' 			=> __('No albums found', TD),
		'not_found_in_trash' 	=> __('No albums found in Trash', TD), 
		'parent_item_colon'		=> '',
		'menu_name' 			=> __('Gallery', TD)
	);
	
	$gallery_args = array(
		'labels' 				=> $labels,
		'public' 				=> TRUE,
		'publicly_queryable'	=> TRUE,
		'show_ui' 				=> TRUE, 
		'show_in_menu' 			=> TRUE, 
		'query_var' 			=> 'gallery',
		'rewrite'				=> array( 'slug' => 'gallery', 'with_front' => false ),
		'capability_type' 		=> 'post',
		'has_archive' 			=> TRUE, 
		'hierarchical' 			=> FALSE,
		'menu_position' 		=> NULL,
		'supports' 				=> array( 'title', 'thumbnail', 'page-attributes' ),
		'menu_icon'				=> THEMEURL . 'images/admin/gallery.png'
	);
	
	register_post_type('gallery', $gallery_args);
	
	
	
	/* Support For Post Thumbnails & Featured Image */
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'featured-image' );
	
		# For Portfolio (Kolor: Deprecated)
		/*
		add_image_size('min-thumb', 60, 60, true);
		add_image_size('portfolio-thumb-1', 210, 142, true);
		add_image_size('portfolio-thumb-2', 230, 155, true);
		add_image_size('portfolio-thumb-3', 300, 200, true);
		add_image_size('portfolio-thumb-4', 450, 260, true);
		add_image_size('portfolio-big-image', 620, 0, false);
		*/
		
		# For Portfolio (Laborator Image Size)
		laborator_img_add_size('min-thumb', 60, 60, true);
		laborator_img_add_size('portfolio-thumb-1', 210, 142, true);
		laborator_img_add_size('portfolio-thumb-2', 230, 155, true);
		laborator_img_add_size('portfolio-thumb-3', 300, 200, true);
		laborator_img_add_size('portfolio-thumb-4', 450, 260, true);
		laborator_img_add_size('portfolio-big-image', 620, 0, true);

		
		# For Posts (Kolor: Deprecated)
		/*
		add_image_size('post-thumb-big', 670, 177, true);
		add_image_size('post-thumb-single', 670, 410, true);
		add_image_size('post-thumb-middle', 310, 159, true);
		*/
		
		laborator_img_add_size('post-thumb-big', 670, 177, true);
		laborator_img_add_size('post-thumb-single', 670, 410, true);
		laborator_img_add_size('post-thumb-middle', 310, 159, true);
		
		# add_image_size('post-image', 700); (Kolor: Deprecated)

		laborator_img_add_size('post-image', 310, 159, true);
		
		# For Gallery (Kolor: Deprecated)
		/*
		add_image_size('gallery-big-img', 661, 405);
		add_image_size('gallery-list-thumb', 186, 125, true);
		*/
		
		laborator_img_add_size('gallery-big-img', 661, 405);
		laborator_img_add_size('gallery-list-thumb', 186, 125, true);
}

/* Documentation */
add_action('admin_menu', 'laborator_docs_menu');

function laborator_docs_menu()
{
	add_submenu_page('kolor_options', 'Help &amp; Documentation', 'Help', 0, 'kolor_docs', 'laborator_documentation');
}

function laborator_documentation()
{
	$docs_url = 'http://documentation.laborator.co/kolor/';
	
	?>
	<style>
		#laborator_docs {
			margin-top: 0px;
			margin-bottom: 0px;
		}
		
		#wpcontent {
			margin-left: 146px;
		}
		
		#wpbody-content {
			padding-bottom: 38px;
		}
	</style>
	<iframe frameborder="0" width="100%" height="94%" id="laborator_docs" src="<?php echo $docs_url; ?>"></iframe>
	<?php
}


/* Widgets */
get_template_part('inc/' . TD . '/laborator_twitter_widget');
get_template_part('inc/' . TD . '/laborator_blog_stats_widget');
get_template_part('inc/' . TD . '/laborator_subscribe_widget');
get_template_part('inc/' . TD . '/laborator_portfolio_latest_widget');
get_template_part('inc/' . TD . '/register_widgets');


/* Post Password Modify the Form */
add_filter('the_password_form', 'kolor_post_password_form');


/* Shortcodes */
get_template_part("inc/" . TD . "/shortcodes");


/* Likes (for posts) */
get_template_part("inc/" . TD . "/laborator_likes");


/* Views Count (for posts) */
get_template_part("inc/" . TD . "/laborator_views_counter");


/* SEO Settings Meta Box */
get_template_part("inc/laborator_seo");


/* Portfolio & Gallery Meta Box */
add_action('add_meta_boxes', 'portfolio_meta_box');
add_action('save_post', 'portfolio_save_post');


function portfolio_meta_box()
{
	global $post, $post_id;
	
	# PAGE TEMPLATE
	$page_template = get_post_meta($post_id, '_wp_page_template', TRUE);
	
	
	# Checklist Field
	add_meta_box('portfolio_checklist', 'Checklist (Project Features List)', 'portfolio_metabox_checklist', 'portfolio');
	
	# Portfolio Page Options
	if($page_template == 'portfolio.php')
	{
		define("PORTFOLIO_SPECIFIC_CATEGORY", TRUE);
		add_meta_box('portfolio_page_options', 'Portfolio Page Options', 'portfolio_metabox_page_options', 'page', 'side', 'high');
	}
	else
	if($page_template == 'gallery.php')
	{
		add_meta_box('portfolio_page_options', 'Gallery Page Options', 'portfolio_metabox_page_options', 'page', 'side', 'high');
	}
	else
	# Page with sidebar
	if($page_template == 'page-with-sidebar.php')
	{
		add_meta_box('page_with_sidebar', 'Page Options', 'page_with_sidebar_metabox', 'page', 'side');
	}
	else
	# Blog page
	if($page_template == 'blog.php' || $page_template == 'blog-2.php' || $page_template == 'index.php')
	{
		add_meta_box('blog_custom_query', 'Custom Query', 'blog_custom_query_metabox', 'page', 'side');
	}
}


function portfolio_save_post($post_id)
{
	global $post;
	
	$page_template = get_post_meta($post_id, '_wp_page_template', TRUE);
	
	# Portfolio Options
	if(isset($post->post_type) && $post->post_type == 'portfolio')
	{
		# Set Checklist Details
		update_post_meta($post->ID, 'checklist', (isset($_POST['checklist']) ? $_POST['checklist'] : ''));
	}
	else
	if(isset($post->post_type) && $post->post_type == 'page' && $page_template == 'portfolio.php')
	{
		# Set Portfolio Columns Type
		update_post_meta($post->ID, 'portfolio_columns', (isset($_POST['portfolio_columns']) ? $_POST['portfolio_columns'] : ''));
		
		# Set Slider Timeout
		update_post_meta($post->ID, 'portfolio_bottom_titles', ((isset($_POST['portfolio_bottom_titles']) && $_POST['portfolio_bottom_titles'] != '') ? 1 : 0));
		
		# Set Slider Timeout
		update_post_meta($post->ID, 'slider_timeout', $_POST['slider_timeout']);
		
		# Infinite Scroll
		update_post_meta($post->ID, 'infinite_scroll', $_POST['infinite_scroll']);
		update_post_meta($post->ID, 'infinite_scroll_manual', $_POST['infinite_scroll_manual']);
		
		# Portfolio Category
		update_post_meta($post->ID, 'browse_portfolio_category', $_POST['browse_portfolio_category']);
	}
	else
	if(isset($post->post_type) && $post->post_type == 'page' && $page_template == 'gallery.php')
	{
		# Set Portfolio Columns Type
		update_post_meta($post->ID, 'portfolio_columns', $_POST['portfolio_columns']);
		
		# Set Portfolio Bottom Titles
		update_post_meta($post->ID, 'portfolio_bottom_titles', $_POST['portfolio_bottom_titles'] ? 1 : 0);
		
		# Set Slider Timeout
		update_post_meta($post->ID, 'slider_timeout', $_POST['slider_timeout']);
		
		# Infinite Scroll
		update_post_meta($post->ID, 'infinite_scroll', $_POST['infinite_scroll']);
	}
	else
	if(isset($post->post_type) && $post->post_type == 'page' && $page_template == 'page-with-sidebar.php')
	{
		$sidebar_color = $_REQUEST['sidebar_color'];
		update_post_meta($post_id, 'sidebar_color', $sidebar_color);
	}
	else
	if(isset($post->post_type) && $post->post_type == 'page' && ($page_template == 'blog.php' || $page_template == 'blog-2.php' || $page_template == 'index.php'))
	{
		$category_filter = $_REQUEST['category_filter'];
		update_post_meta($post_id, 'category_filter', $category_filter);
	}
}


# Checklist Field
function portfolio_metabox_checklist($post)
{	
	$post_id = $post->ID;
	
	$value = get_post_meta($post_id, 'checklist', TRUE);
	
	?>
	<textarea rows="7" style="width: 100%" name="checklist" placeholder="List each detail per row..."><?php echo $value; ?></textarea>
	<?php
}


# Portfolio Page Options
function portfolio_metabox_page_options()
{
	global $post, $post_id;
	
	$portfolio_columns 			= get_post_meta($post_id, 'portfolio_columns', TRUE);
	$portfolio_bottom_titles	= get_post_meta($post_id, 'portfolio_bottom_titles', TRUE);
	$slider_timeout 			= get_post_meta($post_id, 'slider_timeout', TRUE);
	$infinite_scroll 			= get_post_meta($post_id, 'infinite_scroll', TRUE);
	$infinite_scroll_manual		= get_post_meta($post_id, 'infinite_scroll_manual', TRUE);
	$browse_portfolio_category	= get_post_meta($post_id, 'browse_portfolio_category', TRUE);
	
	$columns = array(
		4 => '4 columns (standard images)',
		3 => '3 columns (medium images)',
		2 => '2 columns (larger images)'
	);
	
	?>
	
	<div class="misc-pub-section">
		<p>
			<strong>Columns per Row</strong>
		</p>
		<p>
			<select name="portfolio_columns">
			<?php
			foreach($columns as $column_type => $column):
			?>
			<option<?php echo $portfolio_columns == $column_type ? ' selected="selected"' : ''; ?> value="<?php echo $column_type; ?>"><?php echo $column; ?></option>
			<?php
			endforeach;
			?>
			</select>
		</p>
	</div>
	
	
	<div class="misc-pub-section">
		<?php if($portfolio_columns == 4 && $portfolio_bottom_titles): ?>
		<div id="message" class="updated below-h2">
			<p>Portfolio titles are available only with 2 and 3 columns!</p>
		</div>
		<?php endif; ?>
		
		<p>
			<label for="portfolio_bottom_titles"><strong>Item titles</strong></label>
		</p>
		
		<p>
			<label>
				<input type="checkbox" name="portfolio_bottom_titles" id="portfolio_bottom_titles" value="1" <?php echo $portfolio_bottom_titles ? ' checked="checked"' : ''; ?> />
				Show titles below the portfolio image
			</label>
		</p>
	</div>
	
	<div class="misc-pub-section">
		<p>
			<label for="slider_timeout"><strong>Slider timeout</strong></label>
		</p>
		
		<p>
			<input type="number" name="slider_timeout" id="slider_timeout" placeholder="number of seconds" min="0" value="<?php echo $slider_timeout; ?>" />
		</p>
	</div>
	
	<div class="misc-pub-section">
		<p>
			<label for="infinite_scroll"><strong>Infinite Scrolling Pagination</strong></label>
		</p>
		
		<p>
			
			<input type="checkbox" name="infinite_scroll" id="infinite_scroll" value="1" <?php echo $infinite_scroll ? ' checked="checked"' : ''; ?> />
			<label for="infinite_scroll">Endless scrolling till the last page.</label>
			
			<div id="infinite_scroll_manual_div">
				<input type="checkbox" name="infinite_scroll_manual" id="infinite_scroll_manual" value="1" <?php echo $infinite_scroll_manual ? ' checked="checked"' : ''; ?> />
				<label for="infinite_scroll_manual">Do not load items automatically.</label>
			</div>
				
		</p>
	</div>
		
	
	<?php if(defined("PORTFOLIO_SPECIFIC_CATEGORY")): ?>		
	<div>
		<p>
			<label for="browse_portfolio_category"><strong>Select Items from Category </strong></label>
		</p>
		
		<p>
			<select name="browse_portfolio_category">
				<option value="">* Show All Categories *</option>
			<?php
			$portfolio_terms = get_terms('portfolio-category');
			
			foreach($portfolio_terms as $category)
			{
				?>
				<option<?php echo $browse_portfolio_category == $category->slug ? ' selected' : ''; ?> value="<?php echo $category->slug; ?>"><?php echo $category->name; ?></option>
				<?php
			}
			?>
			</select>
		</p>
	</div>
	<?php endif; ?>
		
		<style>
			#infinite_scroll_manual_div {
				display: none;
			}
		</style>
		
		<script type="text/javascript">
		jQuery(function()
		{
			var infinite_scroll = jQuery("#infinite_scroll");
			var infinite_scroll_manual_div = jQuery("#infinite_scroll_manual_div");
			
			if(infinite_scroll.is(':checked'))
			{
				infinite_scroll_manual_div.show();
			}
			
			infinite_scroll.change(function()
			{
				var checked = jQuery(this).is(':checked');
				
				infinite_scroll_manual_div.hide();
				
				if(checked)
				{
					infinite_scroll_manual_div.show();
				}
			})
		});
		</script>
		
	<?php
}


# Page with Sidebar
function page_with_sidebar_metabox()
{
	global $post, $post_id;
	
	$sidebar_color = get_post_meta($post_id, 'sidebar_color', TRUE);
	
	?>
	<style>
		#page_with_sidebar .inside {
			padding: 0px;
			margin: 0px;
		}
	</style>
	
	<div class="misc-pub-section">
		<p>
			<label for="sidebar_color"><strong>Sidebar Color</strong></label>
		</p>
		
		<p>
			<select name="sidebar_color">
				<option value="1">Dark</option>
				<option value="2"<?php echo $sidebar_color == 2 ? ' selected="selected"' : ''; ?>>Light</option>
			</select>
		</p>
	</div>
	<?php
}

function blog_custom_query_metabox()
{
	global $post, $post_id;
	
	$terms = get_terms('category');
	
	$category_filter = get_post_meta($post_id, 'category_filter', TRUE);
	
	if( ! is_array($category_filter))
		$category_filter = array();
	
	
	?>
	<style>
		#blog_custom_query .inside {
			padding: 0px;
			margin: 0px;
		}
		
		.block {
			display: block;
			margin-bottom: 5px;
		}
		
		.tabs-panel-border {
			border: 1px solid #DFDFDF;
			padding: 8px;
			padding-bottom: 3px;
		}
		
		.tabs-panel-border em {
			display: block;
			padding-bottom: 5px;
		}
	</style>
	
	<div class="misc-pub-section">
	
		<p>
			<label><strong>Select Only from Category</strong></label>
		</p>
		
		<div class="tabs-panel tabs-panel-border">
		<?php
		if(count($terms)):
		
		foreach($terms as $term):
		
			$id = $term->term_id;
			$name = $term->name;
			
			$is_checked = in_array($id, $category_filter);
		?>
		<label class="block">
			<input type="checkbox" name="category_filter[]" id="category_filter_<?php echo $id; ?>" value="<?php echo $id; ?>"<?php echo $is_checked ? ' checked="checked"' : ''; ?> />
			<?php echo $name; ?>
		</label>
		<?php
		
		endforeach;
		else: 
			echo '<em>There are no created categories</em>';
		endif;
		?>
		</div>
		
	</div>
	<?php
}



/* Add Inline Media Gallery  */
add_action('admin_init', 'setup_inline_media_metabox');

function setup_inline_media_metabox()
{	
	$post_id = isset($_GET['post']) ? $_GET['post'] : 0;
	
	if(isset($_GET['post_id']))
		$post_id = $_GET['post_id'];
	
	if(isset($_POST['post_ID']))
		$post_id = $_POST['post_ID'];
	
	if($post_id && ($post = get_post($post_id)))
	{
		$page_template = get_post_meta($post_id, '_wp_page_template', TRUE);
		
		# Add homepage settings metabox
		# Add Inline media gallery for: Wide Slider
		if($page_template == 'index.php')
		{
			add_meta_box('homepage_settings', 'Homepage Settings', 'homepage_settings_metabox', 'page', 'normal');
			add_meta_box('homepage_slider_type', 'Slider Type', 'homepage_slider_type', 'page', 'side');
			
			add_action('save_post', 'homepage_settings_save_post');
		}
		
		# Inline Page Gallery
		if(in_array($page_template, array('index.php','portfolio.php','gallery.php')))
		{
			new LaboratorInlineMediaMetabox($post_id, 'Slider Manager');
		}
		
		# Page Head Caption
		$supported_pages = array('archives.php','blog.php','blog-2.php','page.php','page-with-sidebar.php','default','');
		
		if(in_array($post->post_type, array('page','post'))):

			foreach($supported_pages as $page_name)
			{
				if($page_template == $page_name)
				{
					add_meta_box('page_head_caption', 'Page Head Caption', 'page_head_caption_metabox', $post->post_type, 'normal');
					
					add_action('save_post', 'page_head_caption_save');
				}
			}
		
		endif;
	}
	
}



/* Homepage Slider Type Metabox */
function homepage_slider_type($post)
{
	$post_id = $post->ID;
	
	# Get Post Meta
	$enable_slider	 	= get_post_meta($post_id, 'enable_slider', TRUE);
	$slider_type		= get_post_meta($post_id, 'slider_type', TRUE);
	$slider_timeout	 	= get_post_meta($post_id, 'slider_timeout', TRUE);
	
	?>
	<style>
	#homepage_slider_type .inside {
		padding: 0px;
		margin: 0px;
	}
	</style>
	
	<div class="misc-pub-section">
		<p>
			<label for="enable_slider"><strong>Enable Slider</strong></label>
		</p>
		
		<p>
			<select name="enable_slider">
				<option value="1"<?php echo $enable_slider == 1 ? ' selected="selected"' : ''; ?>>Yes</option>
				<option value="-1"<?php echo $enable_slider == -1 ? ' selected="selected"' : ''; ?>>No</option>
			</select>
		</p>
	</div>
	
	<div class="misc-pub-section">
		<p>
			<label for="slider_type"><strong>Slider Type</strong></label>
		</p>
		
		<p>
			<select name="slider_type">
				<option value="1">Wide Slider</option>
				<option value="2"<?php echo $slider_type == 2 ? ' selected="selected"' : ''; ?>>AsyncSlider</option>
				<option value="3"<?php echo $slider_type == 3 ? ' selected="selected"' : ''; ?>>Roundabout Slider</option>
			</select>
		</p>
	</div>
	
	<div class="misc-pub-section">
		<p>
			<label for="slider_timeout"><strong>Slider Autoswitch Interval</strong></label>
		</p>
		
		<p>
			<input type="number" name="slider_timeout" id="slider_timeout" placeholder="number of seconds" min="0" value="<?php echo esc_attr($slider_timeout); ?>" />
		</p>
		<p>
			<em>(0 to disable)</em>
		</p>
	</div>
	<?php
}



/* Homepage Settings Metabox */
function homepage_settings_metabox($post)
{
	$post_id = $post->ID;
	
	wp_enqueue_script(array('jquery-ui-core','jquery-ui-sortable'));
	
	$sections_to_order = array(
		'featured_tabs'	=> 'Featured Tabs',
		'portfolio' 	=> 'Portfolio',
		'blog_sidebar'	=> 'Blog and Sidebar',
		'content_block'	=> 'Content Block'
	);
	
	
	# Get Post Meta
	$blog_posts_per_page 		= get_post_meta($post_id, 'blog_posts_per_page', TRUE);
	$portfolio_rows 			= get_post_meta($post_id, 'portfolio_rows', TRUE);
	$sidebar_color 				= get_post_meta($post_id, 'sidebar_color', TRUE);
	$clients_logos_show 		= get_post_meta($post_id, 'clients_logos_show', TRUE);
	$homepage_sections_ordering	= get_post_meta($post_id, 'homepage_sections_ordering', TRUE);
	
	
	$visible_sections			= get_post_meta($post_id, 'visible_sections', TRUE);
	
	if( ! $portfolio_rows)
		$portfolio_rows = 2;
	
	# Set new ordering for $sections_to_order
	if(is_array($homepage_sections_ordering) && count($sections_to_order) == count($homepage_sections_ordering))
	{
		$sections_to_order_new = array();
	
		foreach($homepage_sections_ordering as $section_id)
		{
			$sections_to_order_new[$section_id] = $sections_to_order[$section_id];
		}
		
		$sections_to_order = $sections_to_order_new;
	}
	?>
	
	<style>
		#homepage_settings .inside {
			padding: 0px;
			margin: 0px;
		}
		
		.laborator_sections_ordering {
			
		}
		
		.laborator_sections_ordering .section {
			padding: 10px;
			border: 1px solid #EEE;
			margin-bottom: 4px;
			background: #FFF url(<?php echo THEMEURL; ?>images/admin/sort.gif) no-repeat 99% center;
			cursor: move;
		}
		
		.laborator_sections_ordering .ui-sortable-helper {
			box-shadow: 0px 0px 5px rgba(0,0,0,.1);
			opacity: 0.7;
		}
		
		.laborator_sections_ordering .ui-sortable-placeholder {
			border: 2px dashed #CCC;
			background: #f6f6f6;
			height: 25px;
			display: block !important;
			visibility: visible !important;
			padding: 5px 0px;
		}
		
		.laborator_sections_ordering select {
			float: right;
			margin-right: 25px;
			position: relative;
			top: -5px;
			width: 100px;
		}
	</style>
	
	<script type="text/javascript">
		jQuery(function($)
		{
			$(".laborator_sections_ordering").sortable({
				axis: 'y',
				update: function()
				{
					var new_order = $(this).sortable('toArray');
					
					$.post(ajaxurl, {action: 'homepage_sections_ordering', post_id: <?php echo $post_id; ?>, new_order: new_order}, function(resp)
					{
						console.log(resp);
					})
				}
			});
		})
	</script>
	
	<div class="misc-pub-section">
		<p>
			<label for="blog_posts_per_page"><strong>Blog Posts per Page</strong></label>
		</p>
		
		<p>
			<input type="number" name="blog_posts_per_page" id="blog_posts_per_page" placeholder="5" min="0" value="<?php echo esc_attr($blog_posts_per_page); ?>" />
			<em>default: 5</em>
		</p>
	</div>
	
	<div class="misc-pub-section">
		<p>
			<label for="portfolio_rows"><strong>Portfolio Items</strong></label>
		</p>
		
		<p>
			<select name="portfolio_rows">
				<option value="1">1 Row</option>
				<option value="2"<?php echo $portfolio_rows == 2 ? ' selected="selected"' : ''; ?>>2 Rows</option>
				<option value="3"<?php echo $portfolio_rows == 3 ? ' selected="selected"' : ''; ?>>3 Rows</option>
				<option value="4"<?php echo $portfolio_rows == 4 ? ' selected="selected"' : ''; ?>>4 Rows</option>
				<option value="5"<?php echo $portfolio_rows == 5 ? ' selected="selected"' : ''; ?>>5 Rows</option>
				<option value="6"<?php echo $portfolio_rows == 6 ? ' selected="selected"' : ''; ?>>6 Rows</option>
				<option value="7"<?php echo $portfolio_rows == 7 ? ' selected="selected"' : ''; ?>>7 Rows</option>
				<option value="8"<?php echo $portfolio_rows == 8 ? ' selected="selected"' : ''; ?>>8 Rows</option>
			</select>
		</p>
	</div>
	
	<div class="misc-pub-section">
		<p>
			<label for="sidebar_color"><strong>Sidebar Color</strong></label>
		</p>
		
		<p>
			<select name="sidebar_color">
				<option value="1">Dark</option>
				<option value="2"<?php echo $sidebar_color == 2 ? ' selected="selected"' : ''; ?>>Light</option>
			</select>
		</p>
	</div>
	
	
	<div class="misc-pub-section">
		<p>
			<label for="clients_logos_show"><strong>Clients Logos</strong></label>
		</p>
		
		<p>
			<select name="clients_logos_show">
				<option value="inherit">Inherit from Options</option>
				<option value="1"<?php echo $clients_logos_show == 1 ? ' selected="selected"' : ''; ?>>Show (Force to show)</option>
				<option value="-1"<?php echo $clients_logos_show == -1 ? ' selected="selected"' : ''; ?>>Don't show</option>
			</select>
		</p>
	</div>
	
	
	
	<div class="misc-pub-section">
		<p>
			<label for="blog_posts_per_page"><strong>Sections Ordering</strong></label>
		</p>
		
		<div class="laborator_sections_ordering">
		<?php
			foreach($sections_to_order as $section_id => $section_name):
			
			?>
			<div class="section clearfix" id="<?php echo $section_id; ?>">
			
				<select name="visible_sections[<?php echo $section_id; ?>]">
					<option value="1">Visible</option>
					<option value="0"<?php echo isset($visible_sections[$section_id]) && $visible_sections[$section_id] == 0 ? ' selected="selected"' : ''; ?>>Not Visible</option>
				</select>
				
				<?php echo $section_name; ?>
			</div>
			<?php
			
			endforeach;
		?>
		</div>
	</div>
	<?php
}


# Process Homepage Sections Sorting / New Order
add_action('wp_ajax_homepage_sections_ordering', 'ajax_homepage_sections_ordering');

function ajax_homepage_sections_ordering()
{
	$post_id = $_REQUEST['post_id'];
	$new_order = $_REQUEST['new_order'];
	
	update_post_meta($post_id, 'homepage_sections_ordering', $new_order);
	
	die();
}

# Process Homepage Settings Save Post
function homepage_settings_save_post($post_id)
{
	global $post;
	
	$enable_slider = $_POST['enable_slider'];
	update_post_meta($post_id, 'enable_slider', $enable_slider != -1 ? 1 : -1);
	
	
	$slider_timeout = $_REQUEST['slider_timeout'];
	
	if( ! is_numeric($slider_timeout))
		$slider_timeout = '';
		
	update_post_meta($post_id, 'slider_timeout', $slider_timeout);
	
	$blog_posts_per_page = $_REQUEST['blog_posts_per_page'];
	if( ! is_numeric($blog_posts_per_page))
		$blog_posts_per_page = '';
		
	update_post_meta($post_id, 'blog_posts_per_page', $blog_posts_per_page);
	
	$portfolio_rows = $_REQUEST['portfolio_rows'];
	update_post_meta($post_id, 'portfolio_rows', $portfolio_rows);
	
	$sidebar_color = $_REQUEST['sidebar_color'];
	update_post_meta($post_id, 'sidebar_color', $sidebar_color);
	
	$clients_logos_show = $_REQUEST['clients_logos_show'];
	update_post_meta($post_id, 'clients_logos_show', $clients_logos_show);
	
	$visible_sections = $_REQUEST['visible_sections'];
	update_post_meta($post_id, 'visible_sections', $visible_sections);
	
	$slider_type = $_REQUEST['slider_type'];
	update_post_meta($post_id, 'slider_type', $slider_type);
}


/* Page Head Caption Metabox (For supported pages) */
function page_head_caption_metabox($post)
{
	$post_id = $post->ID;

	$phc_title		 		= get_post_meta($post_id, 'phc_title', TRUE);
	$phc_description 		= get_post_meta($post_id, 'phc_description', TRUE);
	$phc_visible	 		= get_post_meta($post_id, 'phc_visible', TRUE);
	$phc_custom_content		= get_post_meta($post_id, 'phc_custom_content', TRUE);
	
	
	$default_phc_title 			= get_option('kolor_pagehead_captions_title');
	$default_phc_description 	= get_option('kolor_pagehead_captions_description');
	?>
	<style>
		.fields_hide {
			display: none;
		}
	</style>
	
	<script type="text/javascript">
		jQuery(document).ready(function($)
		{
			$("input#phc_custom_content").change(function()
			{
				var checked = $(this).is(':checked');
				
				if( ! checked)
				{
					$(".custom_content_fields").stop().slideUp('normal');
				}
				else
				{
					$(".custom_content_fields").stop().slideDown('normal');
				}
			})
		});
	</script>
	
	<p>
		<label for="phc_visible"><strong>Show Page Head Caption</strong></label>
	</p>
	
	<p>	
		<select name="phc_visible">
			<option value="0">Inherit from Options</option>
			<option value="1"<?php echo $phc_visible == 1 ? ' selected="selected"' : ''; ?>>Yes</option>
			<option value="-1"<?php echo $phc_visible == -1 ? ' selected="selected"' : ''; ?>>No</option>
		</select>
	</p>
	
	<p>
		<label for="phc_custom_content"><strong>Use Custom Content</strong></label>
	</p>
	<p>
		<input type="checkbox" id="phc_custom_content" name="phc_custom_content"<?php echo $phc_custom_content ? ' checked="checked"' : ''; ?> value="1">
	</p>
	
	
	<div class="custom_content_fields<?php echo ! $phc_custom_content ? ' fields_hide' : ''; ?>">
		<p>
			<label for="phc_title"><strong>Title</strong></label>
		</p>
		<p>
			<input type="text" class="large-text" id="phc_title" name="phc_title" value="<?php echo esc_attr($phc_title); ?>">
		</p>
		
		<p>
			<label for="phc_description"><strong>Description</strong></label>
		</p>
		<p>
			<textarea rows="7" style="width: 100%" id="phc_description" name="phc_description"><?php echo $phc_description; ?></textarea>
		</p>
	</div>
	<?php
}


/* Process Page Head Caption Data*/
function page_head_caption_save($post_id)
{		
	# Page Head Caption - Visibilty
	$phc_visible = $_REQUEST['phc_visible'];
	update_post_meta($post_id, 'phc_visible', $phc_visible);
	
	
	# Page Head Caption - Set Custom Text
	$phc_custom_content = isset($_REQUEST['phc_custom_content']) && $_REQUEST['phc_custom_content'] != '' ? 1 : 0;
	update_post_meta($post_id, 'phc_custom_content', $phc_custom_content);
	
	
	# Page Head Caption - Title
	$phc_title = $_REQUEST['phc_title'];
	update_post_meta($post_id, 'phc_title', $phc_title);
	
	
	# Page Head Caption - Description
	$phc_description = $_REQUEST['phc_description'];
	update_post_meta($post_id, 'phc_description', $phc_description);
}


/* Flush rewrite rules for when post is saved */
add_action('save_post', 'laborator_flush_rewrite_rules');

/* Flush your rewrite rules */
function laborator_flush_rewrite_rules() {
	global $wp_rewrite;
	
	$wp_rewrite->flush_rules();
}


/* WPML Functions */
if(is_wpml())
{
	get_template_part('inc/kolor-wpml');
}


/* Endless Scrolling */
get_template_part('inc/endless_scrolling');
get_template_part('inc/themes');

/* Define Months for Translation */
__('January', TD);
__('February', TD);
__('March', TD);
__('April', TD);
__('May', TD);
__('June', TD);
__('July', TD);
__('August', TD);
__('September', TD);
__('October', TD);
__('November', TD);
__('December', TD);

__('Jan', TD);
__('Feb', TD);
__('Mar', TD);
__('Apr', TD);
__('May', TD);
__('Jun', TD);
__('Jul', TD);
__('Aug', TD);
__('Sep', TD);
__('Oct', TD);
__('Nov', TD);
__('Dec', TD);