<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */

$post_id = get_the_ID(); 

# SEO
$custom_page_title 	= get_post_meta($post_id, 'custom_page_title', TRUE);
$meta_description 	= get_post_meta($post_id, 'laborator_meta_description', TRUE);
$meta_keywords 		= get_post_meta($post_id, 'laborator_meta_keywords', TRUE);
$meta_robots_index	= get_post_meta($post_id, 'laborator_meta_robots_index', TRUE);
$meta_robots_follow	= get_post_meta($post_id, 'laborator_meta_robots_follow', TRUE);

# META Description & Keywords
$meta_description 	= str_replace(PHP_EOL, ' ', $meta_description);

if( ! $meta_description)
	$meta_description = trim(get_option('kolor_default_meta_description'));
	
if( ! $meta_keywords)
	$meta_keywords = trim(get_option('kolor_default_meta_keywords'));

# META Robots
$meta_robots = array();

if(! $meta_robots_index || $meta_robots_index == 1)
	$meta_robots[] = 'index';
else
	$meta_robots[] = 'noindex';
	

if(! $meta_robots_follow || $meta_robots_follow == 1)
	$meta_robots[] = 'follow';
else
	$meta_robots[] = 'nofollow';



# Favicons
$favicon = get_option('kolor_favicon_16x16');
$apple_touch = get_option('kolor_apple_touch_114px114');


# Default Favicons
if( ! $favicon)
	$favicon = THEMEURL . 'images/favicon.png';
	
if( ! $apple_touch)
	$apple_touch = THEMEURL . 'images/kolor-apple-touch.png';

?>
<!DOCTYPE html>
<!--[if lt IE 7 ]><html class="ie ie6" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 7 ]><html class="ie ie7" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8 ]><html class="ie ie8" <?php language_attributes(); ?>> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!--><html <?php language_attributes(); ?>> <!--<![endif]-->
<head>

	<!-- Basic Page Needs -->
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<title><?php
		
		// Output Site Title
		$site_title = get_bloginfo('title');
		$page_title = $custom_page_title ? $custom_page_title : get_the_title();
		
		if($page_title == '-')
			$page_title = '';
		
		$title_separator = get_option('kolor_title_separator');
		
		# Alternate Title
		if(defined('TITLE_ALTERNATE'))
			$page_title = TITLE_ALTERNATE;
		
		switch(get_option('kolor_title_type'))
		{	
			case 'site_title_right':
				$title = "{$page_title} {$title_separator} {$site_title}";
				
				if( ! $page_title)
					$title = $site_title;					
				break;
			
			case 'only_site_title':
				$title = "{$site_title}";
				break;
				
			case 'only_page_title':
				$title = "{$page_title}";
				break;
			
			case 'site_title_left':
			default:
				
				$title = "{$site_title} {$title_separator} {$page_title}";
				
				if( ! $page_title)
					$title = $site_title;
				
		}
		
		echo $title;
		
	?></title>
	
	<?php if($meta_description): ?>
	<meta name="description" content="<?php echo esc_attr($meta_description); ?>">
	<?php endif; ?>
	
	<?php if($meta_keywords): ?>
	<meta name="keywords" content="<?php echo esc_attr($meta_keywords); ?>">
	<?php endif; ?>
	
	<?php if(get_option('blog_public')): ?>
	<meta name="robots" content="<?php echo implode(',', $meta_robots); ?>">
	<?php endif; ?>

	<!-- Mobile Specific Metas -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	
	<?php if(KOLOR_DEV): ?>
	<!-- less styles -->
	<link rel="stylesheet/less" type="text/css" href="<?php echo THEMEURL; ?>css/kolor.less">
	<link rel="stylesheet/less" type="text/css" href="<?php echo THEMEURL; ?>css/layout.less">
	<?php endif; ?>
	
<?php if(is_user_logged_in()): ?>
	<link rel="stylesheet/less" type="text/css" href="<?php echo THEMEURL; ?>css/frontend-logged.css">
<?php endif; ?>
		

	<!--[if lt IE 9]>
		<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->

	<!-- Favicons -->
	<link rel="shortcut icon" href="<?php echo $favicon; ?>">
	<link rel="apple-touch-icon" href="<?php echo $apple_touch; ?>">
	<link rel="apple-touch-icon" sizes="72x72" href="<?php echo $apple_touch; ?>">
	<link rel="apple-touch-icon" sizes="114x114" href="<?php echo $apple_touch; ?>">
	
	<?php 
		# Show Custom Styling
		show_custom_css(); 
	?>
	
	<?php wp_head(); ?>
	
</head>
<body <?php body_class(); ?>>
