<?php
/**
 *	Laborator
 *
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	Gallery post type metaboxes
 */


define('GALLERY_POST_TYPE_SLUG', 'gallery');

add_action('add_meta_boxes', 'laborator_gallery_metaboxes');
add_action('save_post', 'laborator_gallery_save');

add_action('admin_print_scripts-media-upload-popup', 'laborator_gallery_iframe_resize');

add_filter('image_send_to_editor', 'laborator_insert_image', 10, 3);
add_filter('manage_posts_columns', 'laborator_table_gallery_images_count');

function laborator_gallery_metaboxes()
{
	global $post;
	
	# Require jQuery UI & Edit Frame Size
	if($post->post_type == GALLERY_POST_TYPE_SLUG)
	{
		wp_enqueue_script(array('jquery-ui-core', 'jquery-ui-datepicker'));
		wp_enqueue_style('jquery-style', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css');
	}
	
	
	# Add Meta Boxes
	add_meta_box('laborator_' . GALLERY_POST_TYPE_SLUG . '_album_images_metabox', 'Album Images', 'laborator_gallery_album_images', GALLERY_POST_TYPE_SLUG, 'advanced');
	
	add_meta_box('laborator_' . GALLERY_POST_TYPE_SLUG . '_details_metabox', 'Other Details', 'laborator_gallery_type', GALLERY_POST_TYPE_SLUG, 'advanced');
}


function laborator_gallery_type($post)
{
	$post_id = $post->ID;
	
	// Place
	$album_place = get_post_meta($post_id, 'album_place', TRUE);
	
	// Date
	$album_date = get_post_meta($post_id, 'album_date', TRUE);
	
	// Description
	$album_description = get_post_meta($post_id, 'album_description', TRUE);
	
	?>
	<p>
		<label for="album_place">Place:</label>
	</p>
	
	<p>
		<input type="text" name="album_place" id="album_place" class="regular_text" value="<?php echo esc_attr($album_place); ?>" placeholder="" />
	</p>
	
	
	<p>
		<label for="album_date">Album Date:</label>
	</p>
	
	<p>
		<input type="text" name="album_date" id="album_date" class="regular_text" value="<?php echo esc_attr($album_date); ?>" placeholder="" />
	</p>
	
	
	<strong>Description:</strong>
	
	<?php echo wp_editor($album_description, 'album_description'); ?>
	
	
	<script type="text/javascript">
	jQuery(document).ready(function()
	{
		jQuery("#album_date").datepicker();
		
	});
	</script>
	<?php
}



function laborator_gallery_album_images($post)
{
	$post_id = $post->ID;
	
	?>
	<style>
		#laborator_gallery_album_images_metabox .inside {
			margin: 0px;
			padding: 0px;
		}
		
		
		#laborator_gallery_images_iframe {
			width: 100%;
			min-height: 400px;
			background: transparent;
		}
		
		.mceIframeContainer {
			background: #FFF !important;
		}
	</style>
	<iframe id="laborator_gallery_images_iframe" scrolling="yes" frameborder="0" src="<?php echo admin_url("media-upload.php?post_id={$post_id}&tab=gallery"); ?>"></iframe>
	<?php
}

/* Process Post Save */
function laborator_gallery_save($post_id)
{
	global $post;
	
	if(isset($post->post_type) && $post->post_type == GALLERY_POST_TYPE_SLUG)
	{
		$album_place = $_POST['album_place'];
		$album_date = $_POST['album_date'];
		$album_description = $_POST['album_description'];
		
		update_post_meta($post_id, 'album_place', $album_place);
		update_post_meta($post_id, 'album_date', $album_date);
		update_post_meta($post_id, 'album_description', $album_description);
	}
}


function laborator_gallery_iframe_resize()
{
	$post_id = $_GET['post_id'];
	
	$post = get_post($post_id);
	
	if($post->post_type == GALLERY_POST_TYPE_SLUG)
	{
		wp_enqueue_script('jquery');
		
		add_filter('media_upload_tabs', 'gallery_media_upload_tabs');
		
		function gallery_media_upload_tabs($tabs)
		{
			unset($tabs['type_url']);
			unset($tabs['library']);
			
			return $tabs;
		}
	?>
<style>
#gallery-settings, tr.image-size, tr.url, tr.align {
	display: none;
}

</style>
<script type="text/javascript">
window.onload = function()
{	
	// Other Customizations
	jQuery("#gallery-settings").hide();
	jQuery(".savesend .button").attr('value', 'Add to album');
	jQuery("#gallery-form .savesend .button").attr('value', 'Remove from album');
	
	
	var doc_height = document.height + 25;
	var iframe_parent = parent.document.getElementById('laborator_gallery_images_iframe');
	
	if(iframe_parent && iframe_parent.hasOwnProperty('height'))
	{
		iframe_parent.height = doc_height + 'px';
	}
}
</script>
	<?php
	}
}


function laborator_insert_image($html)
{
	$post_id = $_GET['post_id'];
	
	if(get_post($post_id)->post_type == GALLERY_POST_TYPE_SLUG)
	{
		$send = $_REQUEST['send'];
		
		foreach($send as $attachment_id => $text)
		{
			# Check if it already included in the album
			$is_included = get_post($attachment_id)->post_parent;
			
			wp_update_post(array('ID' => $attachment_id, 'post_parent' => ($is_included ? 0 : $post_id)));
		}
		
		wp_redirect(admin_url("media-upload.php?post_id={$post_id}&tab=gallery"));
	}
	
	return $html;
}


function laborator_table_gallery_images_count($columns)
{
	global $post_type;
	
	$post_type = $_GET['post_type'];
	
	# Add Value Column corresponding to this column
	add_action('manage_posts_custom_column', 'gallery_manage_posts_custom_column');
	
	function gallery_manage_posts_custom_column($column_name)
	{
		global $post;
		
		if($column_name == 'images_count')
		{
			$count = get_children(array('post_parent' => $post->ID, 'post_type' => 'attachment', 'numberposts' => -1));
			
			echo count($count);
		}
	}
	
	# Add 'images_count' column
	if($post_type == GALLERY_POST_TYPE_SLUG)
	{
		$new_columns = array();
		
		foreach($columns as $column_name => $column)
		{
			if($column_name == 'date')
			{
				$new_columns['images_count'] = 'Images';
			}
			
			$new_columns[$column_name] = $column;
		}
		
		return $new_columns;
	}
	
	return $columns;
}