<?php
/**
 *	Laborator - SEO Settings for Posts Types
 *
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */


add_action('add_meta_boxes', 'laborator_seo_meta_box');
add_action('save_post', 'laborator_seo_save_post');


function laborator_seo_meta_box()
{
	$meta_box_title = 'SEO Settings';
	
	add_meta_box('laborator_seo_settings', $meta_box_title, 'laborator_seo_html', 'page', 'normal');
	add_meta_box('laborator_seo_settings', $meta_box_title, 'laborator_seo_html', 'post', 'normal');
	add_meta_box('laborator_seo_settings', $meta_box_title, 'laborator_seo_html', 'portfolio', 'normal');
	add_meta_box('laborator_seo_settings', $meta_box_title, 'laborator_seo_html', 'gallery', 'normal');
}


function laborator_seo_html($post)
{
	$post_id = $post->ID;
	

	# Fields
	$custom_page_title 				= get_post_meta($post_id, 'custom_page_title', TRUE);
	$laborator_meta_description		= get_post_meta($post_id, 'laborator_meta_description', TRUE);
	$laborator_meta_keywords 		= get_post_meta($post_id, 'laborator_meta_keywords', TRUE);
	$laborator_meta_robots_index 	= get_post_meta($post_id, 'laborator_meta_robots_index', TRUE);
	$laborator_meta_robots_follow 	= get_post_meta($post_id, 'laborator_meta_robots_follow', TRUE);
	
?>
<style>
	#laborator_seo_settings  .inside {
		margin: 0px;
		padding: 0px;
	}
	
	.laborator_seo_settings {
	}
	
	.laborator_seo_settings > label {
		width: 180px;
		display: inline-block;
		float: left;
		font-weight: bold;
	}

	
	.laborator_seo_settings .field {
		float: left;
	}
	
	.laborator_seo_settings .field label {
		margin-right: 10px;
	}
	
	.laborator_seo_settings .field input[type="text"], .laborator_seo_settings .field textarea {
		width: 500px !important;
	}
	
	.laborator_seo_settings .desc {
		display: block;
		padding-left: 182px;
		color: #999;
		font-style: italic;
		margin-top: 8px;
	}
	
	.laborator_seo_settings .clear {
		clear: both;
	}
	
</style>

<div class="misc-pub-section laborator_seo_settings">
	
	<label for="custom_page_title">Custom Title</label>
	
	<div class="field">
		<input type="text" name="custom_page_title" id="custom_page_title" class="regular-text" value="<?php echo esc_attr($custom_page_title); ?>" />
	</div>
	
	<div class="clear"></div>
	
	<div class="desc">Leave empty if you want to use this post title as page title</div>
	
</div>

<div class="misc-pub-section laborator_seo_settings">
	
	<label for="laborator_meta_description">Meta Description</label>
	
	<div class="field">
		<textarea name="laborator_meta_description" id="laborator_meta_description" rows="5" cols="60"><?php echo $laborator_meta_description; ?></textarea>
	</div>
	
	<div class="clear"></div>
	
	<div class="desc">Describe correctly (and briefly - up to 160 chars) your <strong>post content</strong> and have more chances to rank higher in Search Engines</div>

</div>

<div class="misc-pub-section laborator_seo_settings">
	
	<label for="laborator_meta_keywords">Meta Keywords</label>
	
	<div class="field">
		<input type="text" name="laborator_meta_keywords" id="laborator_meta_keywords" class="regular-text" value="<?php echo esc_attr($laborator_meta_keywords); ?>" />
	</div>
	
	<div class="clear"></div>
	
	<div class="desc">Enter (comma-separated) your top keywords used in the content</div>
	
</div>


<div class="misc-pub-section laborator_seo_settings">
	
	<label for="laborator_meta_robots_index_yes">Meta Robots Index</label>
	
	<div class="field">
		<label>
			<input type="radio" name="laborator_meta_robots_index" id="laborator_meta_robots_index_yes" class="radio" value="1"<?php echo ! $laborator_meta_robots_index || $laborator_meta_robots_index == 1 ? ' checked="checked"' : ''; ?> />
			&nbsp;index
		</label>

		<label>
			<input type="radio" name="laborator_meta_robots_index" id="laborator_meta_robots_index_no" class="radio" value="-1"<?php echo $laborator_meta_robots_index == -1 ? ' checked="checked"' : ''; ?> />
			&nbsp;noindex
		</label>
	</div>
	
	<div class="clear"></div>
	
	<div class="desc">Allow search engines to index this page</div>
	
</div>



<div class="misc-pub-section laborator_seo_settings">
	
	<label for="laborator_meta_robots_follow_yes">Meta Robots Follow:</label>
	
	<div class="field">
		<label>
			<input type="radio" name="laborator_meta_robots_follow" id="laborator_meta_robots_follow_yes" class="radio" value="1"<?php echo ! $laborator_meta_robots_follow || $laborator_meta_robots_follow == 1 ? ' checked="checked"' : ''; ?> />
			&nbsp;follow
		</label>

		<label>
			<input type="radio" name="laborator_meta_robots_follow" id="laborator_meta_robots_follow_no" class="radio" value="-1"<?php echo $laborator_meta_robots_follow == -1 ? ' checked="checked"' : ''; ?> />
			&nbsp;nofollow
		</label>
	</div>
	
	<div class="clear"></div>
	
	<div class="desc">Allow search engines to follow thinks in this page</div>
	
</div>

<?php

}


function laborator_seo_save_post($post_id)
{
	# Set Field Contents
	$custom_page_title 				= isset($_POST['custom_page_title']) ? $_POST['custom_page_title'] : '';
	$laborator_meta_description 	= isset($_POST['laborator_meta_description']) ? $_POST['laborator_meta_description'] : '';
	$laborator_meta_keywords 		= isset($_POST['laborator_meta_keywords']) ? $_POST['laborator_meta_keywords'] : '';
	$laborator_meta_robots_index 	= isset($_POST['laborator_meta_robots_index']) ? $_POST['laborator_meta_robots_index'] : '';
	$laborator_meta_robots_follow	= isset($_POST['laborator_meta_robots_follow']) ? $_POST['laborator_meta_robots_follow'] : '';
	
	update_post_meta($post_id, 'custom_page_title', $custom_page_title);
	update_post_meta($post_id, 'laborator_meta_description', trim($laborator_meta_description));
	update_post_meta($post_id, 'laborator_meta_keywords', trim($laborator_meta_keywords));
	update_post_meta($post_id, 'laborator_meta_robots_index', trim($laborator_meta_robots_index));
	update_post_meta($post_id, 'laborator_meta_robots_follow', trim($laborator_meta_robots_follow));
}