
var archives, 
	display_years, 
	current_me, 
	current_ae;

var mob_archives,
	mob_display_years;
	
var no_hash = false;
var silent_hash = false;


jQuery(function()
{
	// Definings
	archives = jQuery(".archives_env .lists");
	display_years = archives.find(".display_years > li");

	// Generate Mobile Version
	mob_archives = archives.clone().addClass('mobile');
	
	archives.before(mob_archives).addClass('normal');
	
	var extra_top = -1;
	
	var y_height = 0;
	var m_height = 0;
	var a_height = 0;
	
	y_height = display_years.parent().height();
	
	display_years.each(function(i)
	{
		var y_top = i + 1;
		
		var year_entry = jQuery(this);
		var year_entry_a = year_entry.find('> a');
			
		var display_months = year_entry.find('.display_months > li');
		
		m_height = display_months.parent().height();
		
		// Move Top Months
		display_months.parent().css({
			top: -y_top * year_entry.height() + extra_top * i,
			visibility: 'hidden'
		});
		
		year_entry.data({yearsHeight: y_height, monthsHeight: m_height});
		
		// Setup Click Event
		year_entry_a.on('click', function(ev)
		{
			ev.preventDefault();
			
			showYear(year_entry, i);
		});
		
		display_months.each(function(j)
		{
			var m_top = j + 1;
			
			var month_entry = jQuery(this);
			var month_entry_a = month_entry.find('> a');
			
			var display_articles = month_entry.find('.display_articles > li');
			
			a_height = display_articles.parent().height();
			
			// Move Top Articles
			display_articles.parent().css({
				top: -m_top * month_entry.height() + extra_top * j,
				visibility: 'hidden'
			});
			
			month_entry.data({articlesHeight: a_height});
			
			// Setup Click Event
			month_entry_a.on('click', function(ev)
			{
				ev.preventDefault();
				
				showMonth(month_entry, i, j);
			});
			
			display_articles.each(function(k)
			{
				var a_top = i + j + k + 1;
				
				var article_entry = jQuery(this);
			});
		});
		
	});
	
	
	// Execute Hash
	checkHashChange();
	
	jQuery(window).hashchange(function()
	{
		if(silent_hash)
		{
			silent_hash = false;
			return;
		}
			
		no_hash = true;
		checkHashChange();
		no_hash = false;
	});
	
});

function checkHashChange()
{
	var hash = window.location.hash.toString().replace('#', '');
	var match = [];
	
	
	if(match = hash.match(/^yr-([0-9]+)$/))
	{
		var year_entry = jQuery( display_years.get(match[1]) );
		
		showYear(year_entry);
	}
	else
	if(match = hash.match(/^yr-([0-9]+),mo-([0-9]+)$/))
	{
		var year_entry = jQuery( display_years.get(match[1]) );
		
		
		var month_entry = jQuery( year_entry.find('.display_months > li').get(match[2]) );
		
		showYear(year_entry);
		showMonth(month_entry);
	}
}


// Mob Archives
jQuery(function()
{
	mob_display_years = mob_archives.find(".display_years > li");
	
	mob_display_years.each(function(i)
	{		
		var year_entry = jQuery(this);
		var year_entry_a = year_entry.find('> a');
			
		var display_months = year_entry.find('.display_months > li');
		
		// Hide Months
		var months = display_months.parent();
		months.hide();
		
		// Setup Click Event
		year_entry_a.on('click', function(ev)
		{
			ev.preventDefault();
			
			if(display_months.length)
			{
				mob_display_years.removeClass('active');
				mob_display_years.find('> ul').hide();
				
				year_entry_a.parent().addClass('active');
				
				months.show();
			}
			
			//showYear(year_entry);
		});
		
		display_months.each(function(j)
		{
			var month_entry = jQuery(this);
			var month_entry_a = month_entry.find('> a');
			
			var display_articles = month_entry.find('.display_articles > li');
			
			
			// Hide Articles
			var articles = display_articles.parent();
			articles.hide();
			
			// Setup Click Event
			month_entry_a.on('click', function(ev)
			{
				ev.preventDefault();
				
				if(true || display_articles.length > 0)
				{
					display_months.removeClass('active');
					display_months.find('> ul').hide();
					
					month_entry.addClass('active');
					articles.show();
				}
			});
		});
		
	});
});

function showYear(ye, _yr_index)
{
	var months_height = ye.data('monthsHeight');
	var months = ye.find('> ul');
	
	
	if(months_height)
	{
		archives.find('li.active').removeClass();
		ye.addClass('active');
			
		if(current_me)
			current_me.css('visibility', 'hidden');
		
		if(current_ae)
			current_ae.css('visibility', 'hidden');
		
		months.css({
			visibility: 'visible'
		}).fadeTo(0,0);		
		
		var t = new TimelineMax();
		
		t.append( TweenMax.to(archives, .25, {css: {height: months_height}}) );
		t.append( TweenMax.to(months, .25, {css: {autoAlpha: 1}}) );
		
		//archives.height(months_height);
		
		// Set Hash
		if(no_hash == false && typeof _yr_index == 'number')
		{
			var top = jQuery(window).scrollTop();
			window.location.hash = '#yr-' + _yr_index;
			
			jQuery(window).scrollTop(top);
		}
		
		
		current_me = months;
	}
}


function showMonth(me, _yr_index, _mo_index)
{
	var months_height = me.parent().parent().data('monthsHeight');
	var articles_height = me.data('articlesHeight');
	
	var articles = me.find('> ul');
	
	if(articles.css('visibility') == 'visible')
	{
		return false;
	}
	
	if(articles_height)
	{	
		archives.find('.display_months li.active').removeClass();
		me.addClass('active');
				
		if(current_ae)
			current_ae.css('visibility', 'hidden');
		
		var height_to_set = Math.max(articles_height, months_height);
		
		articles.css({
			visibility: 'visible'
		}).fadeTo(0,0);
			
		
		var t = new TimelineMax();
		
		t.append( TweenMax.to(archives, .25, {css: {height: height_to_set}}) );
		t.append( TweenMax.to(articles, .25, {css: {autoAlpha: 1}}) );
		
		//archives.height(height_to_set);
		
		
		// Set Hash
		if(no_hash == false && typeof _yr_index == 'number' && typeof _mo_index == 'number')
		{
			var top = jQuery(window).scrollTop();
			silent_hash = true;
			window.location.hash = '#yr-' + _yr_index + ',mo-' + _mo_index;
			
			jQuery(window).scrollTop(top);
		}
		
		current_ae = articles;
	}
}
