// Contact Page
// Developed by Arlind Nushi

function initialize() 
{
	var mapDiv = document.getElementById('map-env');
	
	var _kolor_map_coords = kolor_map_coords.split(';');
	
	var pos = new google.maps.LatLng(_kolor_map_coords[0], _kolor_map_coords[1]);
	
	var map = new google.maps.Map(mapDiv, {
		center: pos,
		zoom: kolor_map_zoom_lvl,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		scrollwheel: false,
		mapTypeControl: false,
		scaleControl: false,
		zoomControl: false,
		panControl: false,
		overviewMapControl: false
	});
	
	var grayscale = [
		{
			featureType: "all",
			elementType: "all",
			stylers: [
				{ saturation: -100 }
			]
		}
	];
	
	var mapType = new google.maps.StyledMapType(grayscale, { name:"Grayscale Map" });    
	map.mapTypes.set('grayscale', mapType);
	map.setMapTypeId('grayscale');
	
	
	// Marker
	var marker = new google.maps.Marker({map: map, position: pos, icon: kolorurl + 'images/map_pin.png'});
	
	// Click Enable Scroll
	google.maps.event.addListener(map, 'click', function(event)
	{
		map.setOptions({scrollwheel: true})
	});
	
	google.maps.event.addListener(map, 'dragend', function(event)
	{
		map.setOptions({scrollwheel: true})
	})
	
	// Hover Out Disable Scroll
	mapDiv.onmouseout = function(event)
	{
		map.setOptions({scrollwheel: false})
	};
	
	
	// Resize Event
	jQuery(window).bind('afterresize', function(ev)
	{	
		map.panTo(pos);
	});
}

google.maps.event.addDomListener(window, 'load', initialize);