/** 
 *	Element Mangifier (DIV size increaser)
 *
 *	Plugin by: Arlind Nushi 
 */

(function($)
{
	
	$.fn.elementMagnifier = function(options, params)
	{
		// Defaults
		var o = {
			magnify: 15,
			itemSelector: '> li',
			duration: 50,
			easing: 'easeInOutQuad',
			maxZ: 5,
			minZ: 4,
			hoverClass: 'hovered',
			
			// Animation Engine
			animationEngine: 'jquery' // jquery or gsap
		};
		
		
		$.extend(o, options);
		
		return this.each(function()
		{			
			var container = $(this);
			
			// Exec Methods
			if(typeof options == 'string')
			{
				var instance = container.data('instance');
				
				if(instance && instance[options])
				{
					instance[options](params);
				}
				
				return;
			}
			
			var items = container.find(o.itemSelector);
			
			if(items.length > 0)
			{
				var z_incrementor = 0;
				items.each(function(i)
				{
					var item = $(this);
					
					item.data({width: item.width(), height: item.height()}); // this can be updated when media screen is changed
					item.css({position: 'relative'});
					
					var cloned = item.clone();
					
					cloned.css({position: 'absolute', left: item.position().left, top: item.position().top});
					
					item.after(cloned);
					item.data('cloned', cloned);
					
					var animation_opts = {
						duration: o.duration,
						easing: o.easing
					};
					
					cloned.on('mouseover', function(ev)
					{						
						var w = item.data('width');
						var h = item.data('height');
						
						
						var ratio = w > h ? h/w : w/h;
						
						var nw = w + o.magnify * 2;
						var nh = nw * ratio;
						
						cloned
							.stop(true, true)
							.addClass(o.hoverClass)
							.css({zIndex: o.maxZ + z_incrementor})
								
						if(o.animationEngine == 'gsap')
						{
							TweenLite.to(cloned, o.duration / 1000, {css: {marginLeft: -o.magnify, marginTop: -o.magnify/2, width: nw, height: nh}});
						}
						else
						{
							cloned.animate({marginLeft: -o.magnify, marginTop: -o.magnify/2, width: nw, height: nh}, animation_opts);
						}
						
						z_incrementor++;
					});
					
					cloned.on('mouseleave', function(ev)
					{
						var w = item.data('width');
						var h = item.data('height');
						
						cloned
							.stop(true, true)
							.removeClass(o.hoverClass)
							.css({zIndex: o.minZ});
								
						if(o.animationEngine == 'gsap')
						{
							TweenLite.to(cloned, o.duration / 1000, {css: {marginLeft: 0, marginTop: 0, width: w, height: h}});
						}
						else
						{
							cloned.animate({marginLeft: 0, marginTop: 0, width: w, height: h}, animation_opts);
						}
					});
					
					container.data('is-setup', true);
				});
				
				container.height(container.height());
				
				var relative_items = items.detach();
				var absolute_items = container.find(o.itemSelector);
				
				
				var methods = {
					
					enable: function()
					{
						container.height(container.height());
						
						relative_items.detach();
						container.append(absolute_items);
					},
					
					disable: function()
					{
						absolute_items.detach();
						container.append(relative_items);
						
						container.height('auto');
					}
				};
				
				
				container.data({original_items: relative_items, cloned_items: absolute_items, instance: methods});
			}
		});
	};

})(jQuery);