<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	General Page Template
 */
 
global $wp, $query_string;

// Post Id
$post_id = get_the_ID();

// Header
get_header();


$phc_visible = get_post_meta($post_id, 'phc_visible', TRUE);

if($phc_visible == 0)
	$phc_visible = get_option('kolor_pagehead_captions_enable') == 'true' ? 1 : -1;

if($phc_visible == 1):
?>
<div class="bg_absolute content_page_bg bg_02">
	<!-- stripped border -->
	<div class="stripped_border"></div>
	<!-- end: stripped border -->		
</div>
<?php
endif;
?>
	
<!-- site header -->
<div class="site_header bg_02">
<?php

	// Main Menu (optionally with sliders)
	get_template_part('tpls/header', 'menu');

	// Page Head Caption
	get_template_part('tpls/blocks', 'pageheadcaption');
?>
</div>
<!-- end: site header -->

<?php if($phc_visible != 1): ?>
<!-- stripped border -->
<div class="stripped_border<?php echo $phc_visible != 1 ? ' margin_bottom_double' : ''; ?>"></div>
<!-- end: stripped border -->
<?php endif; ?>

<?php 
	
	while(have_posts()): the_post(); 
		$content_text = do_shortcode(get_the_content());
		
		// Plain Page (without Block)
		if( ! strstr($content_text, 'white_block'))
		{
			?>
			<div class="container white_block content_block">
				
				<h2 class="ct_title"><?php the_title(); ?></h2>
				
				<?php echo wpautop($content_text); ?>
				
			</div>
			<?php
		}
		else
		{
			echo wpautop($content_text);
		}
		
	endwhile; 



// Footer Clients Block
get_template_part('tpls/blocks', 'footerclients');


// Footer Blocks
get_template_part('footer', 'block');


// Footer
get_footer();