<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	General Page Template
 */
 
global $wp, $query_string;

# Get Images
$post_id = get_the_ID();

# Set Post Impression (view)
portfolio_item_set_impression($post_id);

# Gallery Images
$gallery_images = get_posts(array('post_type' => 'attachment', 'post_parent' => $post_id, 'orderby' => 'menu_order', 'order' => 'ASC'));
$gallery_images_count = count($gallery_images);

# Filter Gallery Images (remove mime types != image)
foreach($gallery_images as $i => $gallery_image)
{
	if( ! strstr($gallery_image->post_mime_type, "image"))
	{
		unset($gallery_images[$i]);
	}
}


# Vars
$gallery_options = get_gallery_options();

extract($gallery_options);

# Import Gallery Plugin
wp_enqueue_script('ba_hashchange');
wp_enqueue_script('kolor_angallery');

// Header
get_header();

?>
<!-- sitebg -->
<div class="bg_absolute bg_02">
		
	<!-- stripped border -->
	<div class="stripped_border"></div>
	<!-- end: stripped border -->
	
</div>
<!-- end: sitebg -->
	
<!-- site header -->
<div class="site_header bg_02">
<?php

	// Main Menu (optionally with sliders)
	get_template_part('tpls/header', 'menu');

?>
</div>
<!-- end: site header -->


<!-- content block -->
<div class="container white_block content_block gallery_env margin_top_double">
	
	<!-- content block title -->
	<h2 class="ct_title">
		<i class="gallery"></i>
		<?php _e('View Album', TD); ?>
	</h2>
	<!-- end: content block title -->
	
	
	<?php while(have_posts()): the_post(); 
			
			$album_date = get_post_meta($post_id, 'album_date', TRUE);
			$album_place = get_post_meta($post_id, 'album_place', TRUE);
			$album_description = get_post_meta($post_id, 'album_description', TRUE);
			
			if($album_date)
			{
				$album_date = strtotime($album_date);
				$album_date = date("d F Y", $album_date);
			}
			
			$likes = get_portfolio_item_likes($post_id, TRUE);
			$views = get_portfolio_item_views($post_id, TRUE);
	?>
	<!-- showing image & album info -->
	<div class="image_and_album_info">
	
		<!-- focused image (large) -->
		<div class="showing_image<?php echo $gallery_images_count == 0 ? ' no_gallery_images' : ''; ?>">
			<?php if($gallery_images_count == 0): ?>
			<h4><?php _e('There are no images in this album!'); ?>
			<?php endif; ?>
		</div>
		<!-- end: focused image (large) -->
		
		<!-- album details -->
		<div class="album_info">
			
			<h2 class="album_title"><?php the_title(); ?></h2>
			
			<?php if($album_place): ?>
			<h5 class="info">
				<i class="place"></i>
				<span><?php _e('Place', TD); ?>:</span> <?php echo $album_place; ?>
			</h5>
			<?php endif; ?>
			
			<?php if($album_date): ?>
			<h5 class="info">
				<i class="date"></i>
				<span><?php _e('Date', TD); ?>:</span> <?php echo $album_date; ?>
			</h5>
			<?php endif; ?>
			
			<?php if($allow_likes): ?>
			<h5 class="info">
				<i class="likes"></i>
				<span><?php _e('Likes', TD); ?>:</span> <?php echo number_format($likes); ?>
			</h5>
			<?php endif; ?>
			
			<?php if($show_views): ?>
			<h5 class="info">
				<i class="views"></i>
				<span><?php _e('Views', TD); ?>:</span> <?php echo number_format($views); ?>
			</h5>
			<?php endif; ?>
			
			<?php if($album_description): ?>
			<h5 class="info">
				<span><?php _e('Description', TD); ?></span>
			</h5>
			
			<div class="description">
				<?php echo $album_description; ?>
			</div>
			<?php endif; ?>
			
		</div>
		<!-- end: album details -->
		
	</div>
	<!-- end: showing image & album info -->		
	
	
	<!-- gallery items -->
	<div class="gallery_items" id="an_gallery">
		
		<?php
		# Browse Images
		foreach($gallery_images as $gallery_image):
		
			$attachment_id = $gallery_image->ID;
			
			$large_image 	= $gallery_image->guid;
			
			$small_image 	= laborator_show_img($large_image, 'gallery-list-thumb');
			$medium_image 	= laborator_img($large_image, 'gallery-big-img');
			
			
		?>
		<!-- image entry -->
		<a href="<?php echo $medium_image; ?>" data-large="<?php echo $large_image; ?>" class="gallery_item">
			<?php echo $small_image; ?>
		</a>
		<!-- end: image entry -->
		<?php
		endforeach;
		?>		
		
	</div>
	<!-- end: gallery items -->
	<?php endwhile; ?>
	
	
</div>
<!-- end: content block -->

<?php 


// Footer Clients Block
get_template_part('tpls/blocks', 'footerclients');


// Footer Blocks
get_template_part('footer', 'block');


// Footer
get_footer();