<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	View Portfolio Item
 */

global $wpdb;

# Post ID
$post_id = get_the_ID();

# Set Post Impression (view)
portfolio_item_set_impression($post_id);

# Vars
$portfolio_options = get_portfolio_options();
$portfolio_item_likes = get_portfolio_item_likes($post_id, TRUE);
$portfolio_item_views = get_portfolio_item_views($post_id, TRUE);

extract($portfolio_options);

# Import Required Resources
wp_enqueue_script(array('flexslider', 'shadowbox', 'kolor_hover'));
wp_enqueue_style(array('flexslider', 'shadowbox'));



# Next and Previous post (portfolio item)
$prev_posts = $wpdb->get_row("SELECT * FROM $wpdb->posts WHERE post_type = 'portfolio' AND post_status = 'publish' AND ID < $post_id ORDER BY ID DESC");
$next_posts = $wpdb->get_row("SELECT * FROM $wpdb->posts WHERE post_type = 'portfolio' AND post_status = 'publish' AND ID > $post_id ORDER BY ID ASC");

$prev_post_link = get_permalink($prev_posts->ID);
$next_post_link = get_permalink($next_posts->ID);





# Get Portfolio Item Image Gallery
$args = array(
	'post_type' => 'attachment',
	'numberposts' => null,
	'post_status' => null,
	'post_parent' => $post_id
); 

$attachments = get_posts($args);

// Header
get_header();

?>
<!-- sitebg -->
<div class="bg_absolute content_page_bg bg_02">
		
	<!-- stripped border -->
	<div class="stripped_border"></div>
	<!-- end: stripped border -->
	
</div>
<!-- end: sitebg -->
	
<!-- site header -->
<div class="site_header">
<?php 
	get_template_part('tpls/header', 'menu'); 
?>

	<div class="container">
	
		<!-- project header -->
		<div class="project_header">
			
			<div class="ten columns alpha project_title">
				<h1><?php the_title(); ?></h1>
				<h2><?php the_terms(get_the_ID(), 'portfolio-category'); ?></h2>
			</div>
			
			<div class="six columns prev_next">
				
				<a href="<?php echo $prev_post_link; ?>" class="next"><span><?php _e('Previous Project', TD); ?></span></a>
				<a href="<?php echo $next_post_link; ?>" class="prev"><span><?php _e('Next Project', TD); ?></span></a>
				
			</div>
			
		</div>
		<!-- end: project header -->
		
	</div>
	
</div>
<!-- end: site header -->


<?php while(have_posts()): the_post(); 
	
		$checklist = trim(get_post_meta($post_id, 'checklist', TRUE));
		$checklist = explode("\n", $checklist);		
?>
<!-- project view -->
<div class="container view_project">
	
	<div class="ten columns white_block project_showcase alpha">
		
		<!-- portfolio images -->
		<div id="portfolio_showcase">
		
			<?php if(count($attachments)): ?>
			<ul class="slides">
			
				<?php
				
				foreach($attachments as $attachment):
					$attachment_id = $attachment->ID;
					
					# Use for videos
					$alt_text = get_post_meta($attachment_id, '_wp_attachment_image_alt', TRUE);
					
					$guid = $attachment->guid;
					$big_image = preg_replace('/width=.[0-9]+.|height=.[0-9]+./', '', wp_get_attachment_image($attachment_id, 'portfolio-big-image'));
					
					$rel = 'shadowbox[portfolio_gallery];';
		
					# Detect Video Link
					if($alt_text_video_link = get_video_frames_links($alt_text))
					{
						$guid = $alt_text_video_link;
						$rel .= 'width=700;height=450';
					}
				?>
				<!-- portfolio image -->
				<li>
					<a href="<?php echo $guid; ?>" rel="<?php echo $rel; ?>" target="_blank"><?php echo $big_image; ?></a>
				</li>
				<!-- end: portfolio image -->
				<?php
				endforeach;
				?>
				
			</ul>
			<?php else: ?>
			<div class="no_portfolio_images"><?php _e('There are no images for this project!', TD); ?></div>
			<?php endif; ?>
			
		</div>
		<!-- end: portfolio images -->
		
	</div>
	
	<!-- project details block -->
	<div class="six columns project_details">
		
		<div class="white_block">
		
			<!-- project description and features -->
			
			<?php if(trim(get_the_content())): ?>
			<div class="block info first">
				<h5><?php _e('Project Info', TD); ?></h5>
					
				<?php
					echo the_content(); 
				?>
			</div>
			<?php endif; ?>
			
			<?php if(count($checklist) && reset($checklist)): ?>
			<div class="block features">
				<h5><?php _e('Checklist', TD); ?></h5>
				
				<ul>
					<?php foreach($checklist as $feature): ?>
					<li><?php echo $feature; ?></li>
					<?php endforeach; ?>
				</ul>
				
			</div>
			<?php endif; ?>
			
			<!-- end: project description and features -->
			
		</div>
		
		<!-- likes and views -->
		<div class="buttons">
			
			<?php if($allow_likes): ?>
			<a href="#" data-id="<?php echo $post_id; ?>" data-nonce="<?php echo wp_create_nonce('LaboratorLikePortfolioItem'); ?>" class="likes<?php echo is_portfolio_item_liked($post_id) == 1 ? ' liked' : ''; ?>">
				<i></i>
				<?php echo sprintf( _n('<span>%d</span> Like', '<span>%d</span> Likes', $portfolio_item_likes, TD), $portfolio_item_likes); ?>
			</a>
			<?php endif; ?>
			
			<?php if($show_views == 'true'): ?>
			<a class="views">
				<i></i>
				<?php echo sprintf( _n('<span>%d</span> View', '<span>%d</span> Views', $portfolio_item_views, TD), $portfolio_item_views); ?>
			</a>
			<?php endif; ?>
			
		</div>
		<!-- end: likes and views -->
		
	</div>
	<!-- end: project details block -->
	
</div>
<!-- end: project view -->
<?php endwhile; ?>


<?php 

// Get Latest Portfolio Items (excluding the current one)
get_template_part('tpls/blocks', 'portfoliolatest'); 



// Footer Clients Block
get_template_part('tpls/blocks', 'footerclients');


// Footer Blocks
get_template_part('footer', 'block');


// Footer
get_footer();