<?php
	global $paged, $wp_query, $query_string;

	$max_pages = ceil($wp_query->found_posts / $wp_query->query_vars['posts_per_page']);
	
	
	# Title Header Options
	$query_string_arr = wp_parse_args($query_string);
	
	
	if(isset($query_string_arr['category_name']))
	{
		$category_name = $query_string_arr['category_name'];
		$term = get_term_by('slug', $category_name, 'category');
	}
		
	if(isset($query_string_arr['tag']))
	{
		$tag_name = $query_string_arr['tag'];
		$term = get_term_by('slug', $tag_name, 'post_tag');
	}
		
	if(isset($query_string_arr['author_name']))
	{
		$user_name = $query_string_arr['author_name'];
		
		$author = get_user_by('slug', $user_name)->data->display_name;
	}
		
		
	# Default Sidebar Color
	$sidebar_color = get_option('kolor_sidebar_color');
	
?>

<!-- page head title -->
<div class="container white_block head_title">
		
	<h2 class="block_title">
		<i class="blog"></i>
		<?php 
		$sep = ' - ';
		
		if(is_category()): 
			echo __('Browse by Category', TD) . $sep . $term->name;
		elseif(is_tag()):
			echo __('Browse by Tag', TD) . $sep . $term->name;
		elseif(is_author() || $author):
			echo sprintf(__('Browse by Author - %s', TD), $author);
		else:
			_e('Blog Posts', TD);
		endif; 
		?>
	</h2>
	
</div>
<!-- end: page head title -->

<!-- blog entries & sidebars -->
<div class="container blog_entries_block two_columns">
	
	<!-- blog entries -->
	<div class="eleven columns blog_entries">
		
		<?php
		
		
		if(have_posts()): 
		
			global $posts;
			add_filter('excerpt_length', 'kolor_excerpt_length_2');
		
			$i = 1;
			while(have_posts()): 
				the_post();
			
				get_template_part('tpls/blocks', 'blogentry2');
				
				if($i%2 == 0)
					echo '<div class="clear"></div>';
				
				$i++;
			endwhile;
		else:
		
			if(is_category()):
				echo '<h3 class="no_blog_entries">' . __('There are no blog posts matching this category!', TD) . '</h3>';
			elseif(is_tag()):
				echo '<h3 class="no_blog_entries">' . __('There are no blog posts matching this tag!', TD) . '</h3>';
			else:
				echo '<h3 class="no_blog_entries">' . __('There are no blog posts here!', TD) . '</h3>';
			endif;
			
		
		endif;
		
		remove_filter('excerpt_length', 'kolor_excerpt_length');
		
		
		$np_link = previous_posts(false);
		$pp_link = next_posts(null, false);
		
			
		if($paged >= $max_pages)
			$pp_link = '';
		
		if($paged < 2)
			$np_link = '';
		
		?>
		
		<?php if($pp_link || $np_link): ?>
		<!-- blog pagination -->
		<div class="pagination_prev_next">
			
			<?php if($pp_link): ?><a href="<?php echo $pp_link; ?>" class="previous"><?php _e('Previous Posts', TD); ?></a><?php endif; ?>
			<?php if($np_link): ?><a href="<?php echo $np_link; ?>" class="next"><?php _e('Newer Posts', TD); ?></a><?php endif; ?>
			
		</div>
		<!-- end: blog pagination -->
		<?php endif; ?>
		
	
	</div>
	<!-- end: blog entries -->
	
	<!-- sidebars -->
	<div class="five columns sidebar standalone <?php echo $sidebar_color == 'light_sidebar' ? 'gray_sidebar' : 'dark_sidebar'; ?>">
		
		<?php get_sidebar(); ?>
		
	</div>
	<!-- end: sidebars -->
	
</div>
<!-- end: blog entries & sidebars -->
