<?php

	global $posts, $post;
	
	// Post Vars
	$post_id = get_the_ID();
	
	$date = strtotime($post->post_date);
	$post_tags = wp_get_post_tags($post_id);
	
	$has_thumb = false;
	$show_post_thumbnails = get_option('kolor_show_post_thumbnails') == 'true';
	
?>
<!-- blog post entry -->
<div <?php post_class('blog_post'); ?>>
	
	<?php 
	if(has_post_thumbnail($post_id) && $show_post_thumbnails):
		$has_thumb = TRUE;
		
	
	?>
	<!-- post image -->
	<a href="<?php the_permalink(); ?>" class="image hover">
		<?php  if($show_post_thumbnails) echo laborator_show_img($post_id, 'post-thumb-big');  ?>
	</a>
	<?php
	else:
	?>
	<div class="no_post_image"></div>
	<?php
	endif;
	?>
	
	<!-- post date (do not remove .ribbon) -->
	<div class="date<?php echo ! $has_thumb ? ' no_thumbnail' : ''; ?>">
		<?php echo date('d', $date); ?>
		<span title="<?php the_date(); ?>"><?php echo __(date('F', $date), TD); ?></span>
		<div class="ribbon"></div>					
	</div>
	
	<!-- number of comments -->
	<a href="<?php echo get_permalink() . '#comments'; ?>" class="num_comments"><?php echo $post->comment_count; ?></a>
	
	<!-- post title -->
	<h1>
		<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
	</h1>
	
	<div class="separator"></div>
	
	<!-- post content -->
	<div class="content">
		<?php the_excerpt(); ?>
	</div>
	
	
	<!-- post meta -->
	<div class="post_meta">
		
		<!-- list of categories -->
		<div class="categories">
			<?php the_category(' , '); ?>
		</div>
		
		<!-- list of tags -->
		<div class="tags">
			<?php the_tags('', ' , '); ?>
		</div>
		
		<!-- post link (full read) -->
		<a href="<?php the_permalink(); ?>" class="read_more"><?php _e('Read more', TD); ?></a>
		
	</div>
	<!-- end: post meta -->
	
</div>
<!-- end: blog post entry -->