<?php
	
	# Require JavaScript Plugin
	wp_enqueue_script(array('kolor_hpfeatures'));
	
	$features_tabs = get_all_features_tabs();	
	
	if(count($features_tabs)):
?>
<!-- features tabs -->
<div class="container features_tabs">
	
	<div class="row">
	
		<?php 
		foreach($features_tabs as $features_tab):
			
			$features_tab_defaults = array(
				'hover_title' => '',
				'hover_text' => '',
				'hover_image' => '',
				'hover_image_position' => '',
				'popup_visible' => '',
			);
			
			$features_tab = array_merge($features_tab_defaults, $features_tab);
			
			$icon 			= $features_tab['icon'];
			$title 			= $features_tab['title'];
			$url			= $features_tab['url'];
			$short_text		= trim($features_tab['short_text']);
			
			$uploaded_icon	= $features_tab['uploaded_icon'];
			$retina_icon	= $features_tab['retina_icon'];
			
			$custom_icon		= '';
			$custom_retina_icon	= '';
			
			if($icon == '_uploaded_icon' && $uploaded_icon['th'])
			{
				$custom_icon = site_url($uploaded_icon['th']);
				
				if($retina_icon)
				{
					$custom_retina_icon = site_url($retina_icon['th']);
					$custom_icon = $custom_retina_icon;
				}
			}
			
			$hover_title	= $features_tab['hover_title'];
			$hover_text		= trim($features_tab['hover_text']);
			$hover_image	= $features_tab['hover_image'];
			$image_position	= $features_tab['hover_image_position'];
			
			$popup_visible	= $features_tab['popup_visible'];			
			
		?>
		<!-- feature item -->
		<div class="four columns">
			
			<div class="feature_item"<?php echo $url ? " data-url=\"{$url}\"" : ''; ?>>
				
				<i class="<?php echo $icon; ?>"<?php echo $custom_icon ? (' style="background: url(' . $custom_icon . ') top center no-repeat; ' . ($custom_retina_icon ? ' background-size: 34px;' : '') . ' "' ) : ''; ?>></i>
				<h2><?php echo $title; ?></h2>
				<div class="separator"></div>
				
				<div class="feature_content">
					<?php echo $short_text; ?>
					
					<?php if($popup_visible): ?>
					<!-- more description text -->
					<div class="more">
						<h2><?php echo $hover_title; ?></h2>
						
						<?php if($hover_image): ?>
						<img src="<?php echo site_url($hover_image['th']); ?>" class="<?php echo $image_position; ?>" />
						<?php endif; ?>
						
						<?php echo wpautop($hover_text); ?>
					</div>
					<!-- end: more description text -->
					<?php endif; ?>
					
				</div>
				
			</div>
			
		</div>
		<!-- end: feature item -->
		<?php
		endforeach;
		?>
		
		
	
	</div>
	
</div>
<!-- end: features tabs -->
<?php endif; ?>