<?php

	global $post;
	
	// Post Vars
	$post_id = get_the_ID();
	
	$date = strtotime($post->post_date);
	$post_tags = wp_get_post_tags($post_id);
	
	$show_post_thumbnails = get_option('kolor_show_post_thumbnails') == 'true';
	
	while(have_posts()): the_post();
	
	
?>
<!-- blog post entry -->
<div <?php post_class('blog_post single'); ?>>
	
	<!-- post image -->
	<?php 
	$has_thumb = false;
	
	if(has_post_thumbnail($post_id) && $show_post_thumbnails):
		$has_thumb = true;
		
		# Use for videos
		$alt_text = get_post_meta(get_post_thumbnail_id($post_id), '_wp_attachment_image_alt', TRUE);

		$large_image = laborator_img($post_id, 'post-image');
		
		# Default: Image link
		$href = $large_image;
		$rel = 'shadowbox';
		
		# Detect Video Link
		if($alt_text_video_link = get_video_frames_links($alt_text))
		{
			$href = $alt_text_video_link;
			$rel .= ';width=700;height=450';
		}
		
	?>
	<!-- post image -->
	<a href="<?php echo $href; ?>" class="image hover" rel="<?php echo $rel; ?>" title="<?php echo esc_attr(get_the_title()); ?>">
		<?php echo laborator_show_img($post_id, 'post-thumb-single'); ?>
	</a>
	<?php
	else:
	?>
	<div class="no_post_image"></div>
	<?php
	endif;
	?>
	
	<!-- post date (do not remove .ribbon) -->
	<div class="date<?php echo ! $has_thumb ? ' no_thumbnail' : ''; ?>">
		<?php echo date('d', $date); ?>
		<span><?php echo __(date('F', $date), TD); ?></span>
		<div class="ribbon"></div>					
	</div>
	
	<!-- number of comments -->
	<a href="<?php echo get_permalink() . '#comments'; ?>" class="num_comments"><?php echo $post->comment_count; ?></a>
	
	<!-- post title -->
	<h1>
		<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
	</h1>
	
	
	<!-- post meta -->
	<div class="post_meta">
				
		<!-- list of categories -->
		<div class="categories">
			<?php _e('Category', TD); ?>:
			<?php the_category(' , '); ?>
		</div>
		
		<!-- post author -->
		<div class="author">
			<?php _e('Posted by', TD); ?>:
			<a href="<?php echo get_author_posts_url(get_the_author_meta( 'ID' )); ?>"><?php echo get_the_author(); ?></a>
		</div>
		
		<!-- list of tags -->
		<div class="tags">
			<?php the_tags(__('Tags', TD) . ':', ' , '); ?>
		</div>
		
	</div>
	<!-- end: post meta -->
	
	<!-- post content -->
	<div class="content">
	
		<?php the_content(); ?>
		
	</div>
	<!-- end: post content -->
	
</div>
<!-- end: blog post entry -->
<?php endwhile; ?>