<?php

	# Get Slides from global[slider_items]
	global $post_id, $slider_items;

	
	# Filter Slider Items (remove mime types != image)
	foreach($slider_items as $i => $slider_item)
	{
		if( ! strstr($slider_item->post_mime_type, "image"))
		{
			unset($slider_items[$i]);
		}
	}

	if(count($slider_items)):
		
		# Auto Switcher
		$slider_timeout = 5; # Seconds
		
		# Get Slider Timeout from Post Meta
		$post_slider_timeout = get_post_meta($post_id, 'slider_timeout', TRUE);
		
		if($post_slider_timeout === 0 || $post_slider_timeout > 0)
		{
			$slider_timeout = $post_slider_timeout;
		}
		
	
?>
<div class="container">
	
	<!-- slider env -->
	<div class="sixteen columns relative">
		
		<!-- slider[roundabout slider] -->
		<ul class="roundabout_slider" data-autoplay="<?php echo $slider_timeout > 0 ? 'true' : 'false'; ?>" data-autoswitch="<?php echo $slider_timeout * 1000; ?>" data-pause-on-hover="true"><!-- slider options -->
						
			<?php 
			foreach($slider_items as $i => $slider_item):
				
				$id = $slider_item->ID;
				
				$title = $slider_item->post_title;
				$caption = $slider_item->post_excerpt;
				$content = $slider_item->post_content;
				
				$content = $caption . $content;
				
				$guid = $slider_item->guid;
				
				$alt_text = get_post_meta($id, '_wp_attachment_image_alt', TRUE);
				
				if($link_to_post_id = get_post_meta($id, 'link_to_post_id', TRUE))
				{
					$alt_text = get_permalink($link_to_post_id);
				}
				
					
			?>
			<!-- slide item -->
			<li>
				<a href="<?php echo $alt_text; ?>">
					<img src="<?php echo $guid; ?>" alt="asyncslider_image_0<?php echo $i; ?>">
				</a>
					
				<!-- caption -->
				<div class="caption">
					<span><?php echo $title; ?></span>
					<?php echo $content; ?>
				</div>
				<!-- end: caption -->
			</li>
			<!-- end: slide item -->		
			<?php
			endforeach;
			?>
		</ul>
		
		<!-- ras caption env (do not remove) -->
		<div class="ras_caption"></div>
		<!-- end: ras caption env -->
		
		<!-- ras slider nav (remove if you dont want the slider nav) -->
		<div class="ras_slider_nav"></div>
		<!-- end: ras slider nav -->
		
		<!-- ras next/prev nav -->
		<a href="#" class="ras_nav next"><?php _e('Next'); ?></a>
		<a href="#" class="ras_nav prev"><?php _e('Previous'); ?></a>
		<!-- end: ras next/prev nav -->
		
	</div>

</div>
<!-- end: slider env [asyncslider] -->
<?php endif; ?>