<?php
class dmeng_option_class{

	var $options;
	var $pageinfo;
	var $database_options;
	var $saved_optionname;
	
	//类的构建函数
	function dmeng_option_class($options, $pageinfo) {
		$this->options = $options;
		$this->pageinfo = $pageinfo;
		$this->make_data_available(); //准备设置选项数据

		add_action( 'admin_menu', array(&$this, 'add_admin_menu') );
		
		if( isset($_GET['page']) && ($_GET['page'] == $this->pageinfo['filename']) ) {
			//加载css js
			add_action('admin_init', array(&$this, 'enqueue_head'));	
		}
	}
	
	function enqueue_head() {
		//加载的js路径
		$jsUrl = get_bloginfo('template_url').'/include/options.js';
		$cssUrl = get_bloginfo('template_url').'/include/options.css';
		wp_enqueue_script('dmeng_options_js',$jsUrl); 
		wp_enqueue_style('dmeng_options_css',$cssUrl); 
		wp_enqueue_script('thickbox');
		wp_enqueue_style('thickbox');
	}
	
	//创建菜单项函数
	function add_admin_menu() {
		//添加顶级菜单项
		$top_level = $this->pageinfo['full_name'];
		if(!$this->pageinfo['child']) {
			add_menu_page($top_level, $top_level, 'edit_themes', $this->pageinfo['filename'], array(&$this, 'initialize'));
			define('TOP_LEVEL_BASEAME', $this->pageinfo['filename']);
		}else{
			add_submenu_page(TOP_LEVEL_BASEAME, $this->pageinfo['full_name'], $this->pageinfo['full_name'], 'edit_themes', $this->pageinfo['filename'], array(&$this, 'initialize'));
		}
	}
	
	function make_data_available() {
		global $dmeng_option; //申明全局变量
		
		foreach ($this->options as $option) {
			if( isset($option['std']) ) {
				$dmeng_option_std[$this->pageinfo['optionname']][$option['id']] = $option['std'];
			}
		}
		//选项组名称
		$this->saved_optionname = 'dmeng_'.$this->pageinfo['optionname'];
		$dmeng_option[$this->pageinfo['optionname']] = get_option($this->saved_optionname);
		
		//合并数组
		$dmeng_option[$this->pageinfo['optionname']] = array_merge((array)$dmeng_option_std[$this->pageinfo['optionname']], (array)$dmeng_option[$this->pageinfo['optionname']]);
		
		//html实体转换
		$dmeng_option[$this->pageinfo['optionname']] = $this->htmlspecialchars_deep($dmeng_option[$this->pageinfo['optionname']]);
	
	}
	
	//使用递归将预定义html实体转换为字符
	function htmlspecialchars_deep($mixed, $quote_style = ENT_QUOTES, $charset = 'UTF-8') {
	    if (is_array($mixed) || is_object($mixed)) {
	        foreach($mixed as $key => $value) {
	            $mixed[$key] = $this->htmlspecialchars_deep($value, $quote_style, $charset);
	        }
	    }
	    elseif (is_string($mixed)) {
	        $mixed = htmlspecialchars_decode($mixed, $quote_style);
	    }
	    return $mixed;
	} 
	
	function initialize() {
		$this->get_save_options();
		$this->display();
	}
	
	//显示表单项函数
	function display() {	
		$saveoption = false;
		echo '<div class="wrap">';
		echo '<div class="icon32" id="icon-options-general"><br/></div>';
		echo '<h2>'.$this->pageinfo['full_name'].'</h2>';
		echo '<form method="post" action="">';
		
		//根据选项类型执行对应函数
		foreach ($this->options as $option) {
			if (method_exists($this, $option['type'])) {
				$this->$option['type']($option);
				$saveoption = true;
			}
		}
		if($saveoption) {
			echo '<p class="submit">';
			echo '<input type="hidden" value="1" name="save_my_options"/>';
			echo '<input type="submit" name="Submit" class="button-primary autowidth" value="保存设置" /></p>';
		}
		echo '</form></div>';
	}
	
	//更新数据
	function get_save_options() {
		$options = $newoptions  = get_option($this->saved_optionname);
		if ( isset( $_POST['save_my_options'] ) ) {
			echo '<div class="updated fade" id="message" style=""><p><strong>设置保存成功</strong></p></div>';
			$opion_count = 0;
			foreach ($_POST as $key => $value) {
				if( preg_match("/^(numbers_)/", $key, $result) ){
					$numbers = explode( ',', $value );
					$newoptions[$key] = $numbers;
				}elseif( preg_match("/^(tinymce_)/", $key, $result) ){
					$value = stripslashes($value);
					$newoptions[$key] = $value;
				}elseif( preg_match("/^(checkbox_)/", $key, $result) ){
					$newoptions[$key] = $value;
				}else{
					$value = stripslashes($value);
					$newoptions[$key] = htmlspecialchars($value, ENT_QUOTES,"UTF-8");
				}
			}
		}
			
		if ( $options != $newoptions ) {
			$options = $newoptions;
			update_option($this->saved_optionname, $options);
		}
		
		if($options) {
			foreach ($options as $key => $value) {
				$options[$key] = empty($options[$key]) ? false : $options[$key];
			}
		}
		
		$this->database_options = $options;
	}
		
	/************开头***************/
	function open($values) {
		if(!isset($values['desc'])) $values['desc'] = "";
		
		echo '<table class="widefat" style="margin-bottom:20px;">';
		echo '<thead><tr><th colspan="2">'.$values['desc'].'&nbsp;</th></tr></thead>';
	}
	
	/***************结尾**************/
	function close($values) {
		echo '<tfoot><tr><th colspan="2">&nbsp;</th></tr></tfoot></table>';
	}

	/**********标题***********************/
	function title($values) {
		echo '<h3>'.$values['name'].'</h3>';
		if (isset($values['desc'])) echo '<p>'.$values['desc'].'</p>';
	}

	/*****************************文本域**********************************/
	function textarea($values) {
		if(isset($this->database_options[$values['id']]))
			$values['std'] = $this->database_options[$values['id']];

		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		echo '<textarea name="'.$values['id'].'" cols="60" rows="7" id="'.$values['id'].'" style="width: 80%; font-size: 12px;" class="code">';
		echo $values['std'].'</textarea><br/>';
	    echo '<br/></td>';
		echo '</tr>';
	}
	
	/*********************文本框**************************/
	function text($values) {	
		if(isset($this->database_options[$values['id']])) $values['std'] = $this->database_options[$values['id']];
		
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		echo '<input type="text" size="'.$values['size'].'" value="'.$values['std'].'" id="'.$values['id'].'" name="'.$values['id'].'"/>';
	    echo '<br/><br/></td>';
		echo '</tr>';
	}
	

	/**************复选框*******************/
	function checkbox($values) {
		if(isset($this->database_options[$values['id']])) $values['std'] = $this->database_options[$values['id']];
		
		echo '<tr valign="top">';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		
		foreach( $values['buttons'] as $key=>$value ) {
			$checked ="";
			if( is_array($values['std']) && in_array($key,$values['std'])) {
				$checked = 'checked = "checked"';
			}
			echo '<input '.$checked.' type="checkbox" class="kcheck" value="'.$key.'" name="'.$values['id'].'[]"/>'.$value;
		}

		
		echo '<label for="'.$values['id'].'">'.$values['desc'].'</label><br/>';
	    echo '<br/></td>';
		echo '</tr>';
	}

	/**********************单选框******************************/
	function radio($values) {
		if(isset($this->database_options[$values['id']])) $values['std'] = $this->database_options[$values['id']];
		
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		
		foreach($values['buttons'] as $key=>$value) {	
			$checked ="";
			if(isset($values['std']) && ($values['std'] == $key)) {
				$checked = 'checked = "checked"';
			}
		
			echo '<p><input '.$checked.' type="radio" class="kcheck" value="'.$key.'" name="'.$values['id'].'"/> ';
			echo '<label for="'.$values['id'].'">'.$value.'</label></p>';
		}
		
	    echo '<br/></td>';
		echo '</tr>';
	}
	/*****************数组***********************/
	function numbers_array($values){
		if(isset($this->database_options[$values['id']]))
			$values['std'] = $this->database_options[$values['id']];
		else
			$values['std']=array();

		$nums = implode( ',', $values['std'] );
		
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		echo '<input type="text" size="'.$values['size'].'" value="'.$nums.'" id="'.$values['id'].'" name="'.$values['id'].'"/>';
	    echo '<br/><br/></td>';
		echo '</tr>';
	}

	/********************下拉框*********************/
	function dropdown($values) {	
		if(!isset($this->database_options[$values['id']]) && isset($values['std'])) $this->database_options[$values['id']] = $values['std'];
				
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		
			if($values['subtype'] == 'page') {
				$select = 'Select page';
				$entries = get_pages('title_li=&orderby=name');
			}else if($values['subtype'] == 'sidebar'){
				global $wp_registered_sidebars;
				$select = 'Select a special sidebar';
				$entries = $wp_registered_sidebars;
			}else if($values['subtype'] == 'cat'){
				$select = 'Select category';
				$entries = get_categories('title_li=&orderby=name&hide_empty=0');
			}
			else
			{	
				$select = '请选择';
				$entries = $values['subtype'];
			}
		
			echo '<select class="postform" id="'. $values['id'] .'" name="'. $values['id'] .'"> ';
			echo '<option value="">'.$select .'</option>  ';

			foreach ($entries as $key => $entry) {
				if($values['subtype'] == 'page')
				{
					$id = $entry->ID;
					$title = $entry->post_title;
				}else if($values['subtype'] == 'cat'){
					$id = $entry->term_id;
					$title = $entry->name;
				}else if($values['subtype'] == 'sidebar'){
					$id = $entry['id'];
					$title = $entry['name'];
				}
				else
				{
					$id = $key;	
					$title = $entry;		
				}

				if ($this->database_options[$values['id']] == $id )
				{
					$selected = "selected='selected'";	
				}
				else
				{
					$selected = "";		
				}
				
				echo"<option $selected value='". $id."'>". $title."</option>";
			}
		
		echo '</select>';
		 
	    echo '<br/><br/></td>';
		echo '</tr>';
	}
	
	/*******************上传*****************************/
	function upload($values) {	
		$prevImg = '';
		if(isset($this->database_options[$values['id']])) $values['std'] = $this->database_options[$values['id']];
		if($values['std'] != ''){$prevImg = '<img src='.$values['std'].' alt="" />';}
		
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>';
		echo '<div class="preview_pic_optionspage" id="'.$values['id'].'_div">'.$prevImg.'</div>';
		echo $values['desc'].'<br/>';
		echo '<input type="text" size="60" value="'.$values['std'].'" name="'.$values['id'].'" class="upload_pic_input" />';
		echo '&nbsp;<a onclick="return false;" title="" class="k_hijack button thickbox" id="'.$values['id'].'" href="media-upload.php?type=image&amp;hijack_target='.$values['id'].'&amp;TB_iframe=true">选择或上传</a>';
		
	    echo '<br/><br/></td>';
		echo '</tr>';
	}
	//编辑器
	function tinymce($values){
		if(isset($this->database_options[$values['id']]))
			$values['std'] = $this->database_options[$values['id']];
			
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		wp_editor( $values['std'], $values['id'],$settings=array('tinymce'=>1,'media_buttons'=>0,) );
	    echo '<br/></td>';
		echo '</tr>';
	}

}
?>