<?php



/*-----------------------------------------------------------------------------------*/

/*	Buttons

/*-----------------------------------------------------------------------------------*/



if (!function_exists('webbu_button')) {

	function webbu_button( $atts, $content = null ) {

		extract(shortcode_atts(array(

			'url' => '#',

			'target' => '_self',

			'color' => '',

			'size' => 'btn-small'

	    ), $atts));

		

	   if($color == "normal"){

		   return '<a target="'.$target.'" class="btn '.$size.'" href="'.$url.'">' . do_shortcode($content) . '</a>';

	   }elseif($color == "normal" and $size == "normal"){

		   return '<a target="'.$target.'" class="btn" href="'.$url.'">' . do_shortcode($content) . '</a>';   

	   }elseif($size == "normal"){

		   return '<a target="'.$target.'" class="btn '.$color.'" href="'.$url.'">' . do_shortcode($content) . '</a>';

	   }else{

		   return '<a target="'.$target.'" class="btn '.$color.' '.$size.'" href="'.$url.'">' . do_shortcode($content) . '</a>';   

	   }

		

	   

	}

	add_shortcode('webbu_button', 'webbu_button');

}





/*-----------------------------------------------------------------------------------*/

/*	Badges

/*-----------------------------------------------------------------------------------*/



if (!function_exists('webbu_badge')) {

	function webbu_badge( $atts, $content = null ) {

		extract(shortcode_atts(array(

			'color' => 'badge-warning'

	    ), $atts));

		

	   return '<span class="badge '.$color.' ">' . do_shortcode($content) . '</span>';

	}

	add_shortcode('webbu_badge', 'webbu_badge');

}







/*-----------------------------------------------------------------------------------*/

/*	Blockquotes

/*-----------------------------------------------------------------------------------*/



if (!function_exists('webbu_blockquote')) {

	function webbu_blockquote( $atts, $content = null ) {

		extract(shortcode_atts(array(

			'direction' => ''

	    ), $atts));

	   

	   if($direction <> ""){

	   return '<div><blockquote class="'.$direction.'"><p>' . do_shortcode($content) . '</p></blockquote></div>';

	   }else{

		return '<div><blockquote><p>' . do_shortcode($content) . '</p></blockquote></div>';   

	   }

	}

	add_shortcode('webbu_blockquote', 'webbu_blockquote');

}



/*-----------------------------------------------------------------------------------*/

/*	Columns

/*-----------------------------------------------------------------------------------*/



if (!function_exists('webbu_columns')) {

	function webbu_columns( $atts, $content = null ) {

		extract(shortcode_atts(array(

			'direction' => '',

			'lastbox' => 'off'

	    ), $atts));

	   

	   if($lastbox == "on"){

	  		return '<div class="webbu-'.$direction.' lastbox">' . do_shortcode($content) . '</div>';

	   }else{

		    return '<div class="webbu-'.$direction.'">' . do_shortcode($content) . '</div>';

	   }

	}

	add_shortcode('webbu_columns', 'webbu_columns');

}





/*-----------------------------------------------------------------------------------*/

/*	Labels

/*-----------------------------------------------------------------------------------*/



if (!function_exists('webbu_label')) {

	function webbu_label( $atts, $content = null ) {

		extract(shortcode_atts(array(

			'color' => 'label-warning'

	    ), $atts));

		

	   return '<span class="label '.$color.' ">' . do_shortcode($content) . '</span>';

	}

	add_shortcode('webbu_label', 'webbu_label');

}





/*-----------------------------------------------------------------------------------*/

/*	Alerts

/*-----------------------------------------------------------------------------------*/



if (!function_exists('webbu_alert')) {

	function webbu_alert( $atts, $content = null ) {

		extract(shortcode_atts(array(

			'style'   => 'white'

	    ), $atts));

		

	   return '<div class="alert '.$style.'"><button type="button" class="close" data-dismiss="alert">x</button>' . do_shortcode($content) . '</div>';

	}

	add_shortcode('webbu_alert', 'webbu_alert');

}





/*-----------------------------------------------------------------------------------*/

/*	Toggle Shortcodes

/*-----------------------------------------------------------------------------------*/



if (!function_exists('webbu_toggle')) {

	function webbu_toggle( $atts, $content = null ) {

	    extract(shortcode_atts(array(

			'title'    	 => 'Title goes here',

			'state'		 => 'open'

	    ), $atts));

	

		return "<div data-id='".$state."' class=\"webbu-toggle\"><span class=\"webbu-toggle-title\">". $title ."</span><div class=\"webbu-toggle-inner\">". do_shortcode($content) ."</div></div>";

	}

	add_shortcode('webbu_toggle', 'webbu_toggle');

}





/*-----------------------------------------------------------------------------------*/

/*	Tabs Shortcodes

/*-----------------------------------------------------------------------------------*/

function webbu_tabs( $atts, $content = null ) {

    

    if( isset($GLOBALS['tabs_count']) )

      $GLOBALS['tabs_count']++;

    else

      $GLOBALS['tabs_count'] = 0;



    $defaults = array();

    extract( shortcode_atts( $defaults, $atts ) );

    

    // Extract the tab titles for use in the tab widget.

    preg_match_all( '/tab title="([^\"]+)"/i', $content, $matches, PREG_OFFSET_CAPTURE );

    

    $tab_titles = array();

    if( isset($matches[1]) ){ $tab_titles = $matches[1]; }

    

    $output = '';

    

    if( count($tab_titles) ){

      $output .= '<ul class="nav nav-tabs" id="custom-tabs-'. rand(1, 100) .'">';

      

      $i = 0;

      foreach( $tab_titles as $tab ){

        if($i == 0)

          $output .= '<li class="active">';

        else

          $output .= '<li>';

		if( isset($GLOBALS['tabs_count']) )

      $GLOBALS['tabs_count']++;

    else

      $GLOBALS['tabs_count'] = 0;

        $output .= '<a href="#custom-tab-' . $GLOBALS['tabs_count'] . '"  data-toggle="tab">' .$tab[0] . '</a></li>';

        $i++;

      }

        $GLOBALS['tabs_count'] = 0;

        $output .= '</ul>';

        $output .= '<div class="tab-content">';

        $output .= do_shortcode( $content );

        $output .= '</div>';

    } else {

      $output .= do_shortcode( $content );

    }

    
	
    return $output;
	
 }

add_shortcode('webbu_tabs', 'webbu_tabs');





function webbu_tab( $atts, $content = null ) {

	
	  

    if( !isset($GLOBALS['current_tabs']) ) {

      $GLOBALS['current_tabs'] = $GLOBALS['tabs_count'];

      $state = 'active';

    } else {



      if( $GLOBALS['current_tabs'] == $GLOBALS['tabs_count'] ) {

        $state = ''; 

      } else {

        $GLOBALS['current_tabs'] = $GLOBALS['tabs_count'];

        //$state = 'active'; 

      }

    }



    $defaults = array( 'title' => 'Tab');

    extract( shortcode_atts( $defaults, $atts ) );

	if( isset($GLOBALS['tabs_count']) or $GLOBALS['tabs_count'] == 0 )

      $GLOBALS['tabs_count']++;

    else

      $GLOBALS['tabs_count'] = 0;


    $deger = '<div id="custom-tab-' . $GLOBALS['tabs_count'] . '" class="tab-pane ' . $state . '">'. do_shortcode( $content ) .'</div>';

	$deger = str_replace("<p>", "", $deger);

	$deger = str_replace("</p>", "", $deger);

	return $deger;

}



add_shortcode('webbu_tab', 'webbu_tab');





/*-----------------------------------------------------------------------------------*/

/*	Accordion Shortcodes

/*-----------------------------------------------------------------------------------*/





function webbu_collapsibles( $atts, $content = null ) {

    

    if( isset($GLOBALS['collapsibles_count']) )

      $GLOBALS['collapsibles_count']++;

    else

      $GLOBALS['collapsibles_count'] = 0;



    $defaults = array();

    extract( shortcode_atts( $defaults, $atts ) );

    

    // Extract the tab titles for use in the tab widget.

    preg_match_all( '/collapse title="([^\"]+)"/i', $content, $matches, PREG_OFFSET_CAPTURE );

    

    $tab_titles = array();

    if( isset($matches[1]) ){ $tab_titles = $matches[1]; }

    


  //  if( count($tab_titles) ){

      $output .= '<div class="accordion" id="accordion-' . $GLOBALS['collapsibles_count'] . '">';

      $output .= do_shortcode( $content );

      $output .= '</div>';

  //  } else {

  //    $output .= do_shortcode( $content );

  //  }

    return $output;

  }

  add_shortcode('webbu_toggles', 'webbu_collapsibles');  





  function webbu_collapse( $atts, $content = null ) {



    if( !isset($GLOBALS['current_collapse']) )

      $GLOBALS['current_collapse'] = 0;

    else 

      $GLOBALS['current_collapse']++;





    $defaults = array( 'title' => 'Tab', 'state' => '');

    extract( shortcode_atts( $defaults, $atts ) );

    

    if (!empty($state)) 

      $state = 'in';



    return '

    <div class="accordion-group">

      <div class="accordion-heading">

        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion-' . $GLOBALS['collapsibles_count'] . '" href="#collapse_' . $GLOBALS['current_collapse'] . '">

          ' . $title . ' 

        </a>

      </div>

      <div id="collapse_' . $GLOBALS['current_collapse'] . '" class="accordion-body collapse ' . $state . '">

        <div class="accordion-inner">

          ' . do_shortcode($content) . ' 

        </div>

      </div>

    </div>

    ';

  }

  

  add_shortcode('webbu_toggle', 'webbu_collapse');

  



/*-----------------------------------------------------------------------------------*/

/*	Table Shortcodes

/*-----------------------------------------------------------------------------------*/

  

  function webbu_table( $atts ) {

      extract( shortcode_atts( array(

          'cols' => 'none',

          'data' => 'none',

          'type' => 'type'

      ), $atts ) );

      $cols = explode(',',$cols);

      $data = explode(',',$data);

      $total = count($cols);

      $output = '';

      $output .= '<table class="table table-'. $type .' table-bordered"><tr>';

      foreach($cols as $col):

          $output .= '<th>'.$col.'</th>';

      endforeach;

      $output .= '</tr><tr>';

      $counter = 1;

      foreach($data as $datum):

          $output .= '<td>'.$datum.'</td>';

          if($counter%$total==0):

              $output .= '</tr>';

          endif;

          $counter++;

      endforeach;

          $output .= '</table>';

      return $output;

  }

  

  add_shortcode('webbu_table', 'webbu_table');





/*-----------------------------------------------------------------------------------*/

/*	Icon Shortcodes

/*-----------------------------------------------------------------------------------*/



  function webbu_icon( $atts, $content = null ) {

    extract(shortcode_atts(array(

      "title" => 'title',

	  "color" => '#000000',

	  "size" => '12',

	  "demo" => ''

    ), $atts));

	

	if($demo == ""){

    	return '<i class="' . $title . '" style="font-size:'.$size.'px; color:'.$color.'"></i>';

	}else{

		return '<i class="' . $title . ' demoicons" style="font-size:'.$size.'px; color:'.$color.'"></i>';

	}

  }

  add_shortcode('webbu_icon', 'webbu_icon');



/*-----------------------------------------------------------------------------------*/

/*	Well Shortcodes

/*-----------------------------------------------------------------------------------*/

  

function webbu_well( $atts, $content = null ) {

      extract(shortcode_atts(array(

        "size" => 'size'

      ), $atts));



      return '<div class="well well-' . $size . '">' . do_shortcode( $content ) . '</div>';

    }

	add_shortcode('webbu_well', 'webbu_well');



/*-----------------------------------------------------------------------------------*/

/*	Google Map

/*-----------------------------------------------------------------------------------*/

function webbu_googlemap( $atts ) {

      extract(shortcode_atts(array(

        "address" => '',

		"height" => ''

      ), $atts));

	  

	  return '<div class="map-container"><iframe style="width:100%; height: ' . $height . 'px;" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="http://maps.google.com/maps?q=' . $address . '&output=embed"></iframe></div>';

    }

	add_shortcode('webbu_googlemap', 'webbu_googlemap');



/*-----------------------------------------------------------------------------------*/

/*	Twitter Page

/*-----------------------------------------------------------------------------------*/

function webbu_twitter( $atts ) {

      extract(shortcode_atts(array(

        "username" => '',

		"tweetnumber" => ''

      ), $atts));

	  

	  

	  $twitterpage= '

	  <!-- Twitter page begin -->

	  <script src="'.get_template_directory_uri().'/js/twitter.php?tu='.$username.'&tn='.$tweetnumber.'"></script>

	  <div style=" padding-bottom:10px;">

	  <a href="https://twitter.com/'.$username.'" class="twitter-follow-button" data-show-count="false">Follow @'.$username.'</a>

	  </div>

    <!-- Follow end -->

                        

    <!-- Twitter Begin -->

    <div id="jstwitter">

    </div>

    <!-- Twitter End -->';

	  

	  return $twitterpage;

    }

	add_shortcode('webbu_twitter', 'webbu_twitter');

	

/*-----------------------------------------------------------------------------------*/

/*	Divider Shortcodes

/*-----------------------------------------------------------------------------------*/

  

function webbu_divider( $atts, $content = null ) {

      extract(shortcode_atts(array(

        "style" => '7'

      ), $atts));



      return '<div class="dividert divider' . $style . '"></div>';

    }

	add_shortcode('webbu_divider', 'webbu_divider');



/*-----------------------------------------------------------------------------------*/

/*	Clearfix Shortcodes

/*-----------------------------------------------------------------------------------*/

  

function webbu_clearfix() {return '<div class="clearfix"></div>';}

	add_shortcode('webbu_clearfix', 'webbu_clearfix');



/*-----------------------------------------------------------------------------------*/

/*	Image Shortcodes

/*-----------------------------------------------------------------------------------*/

  

function webbu_image( $atts, $content = null ) {

      extract(shortcode_atts(array(

        "type" => 'polaroid',

		"align" => 'left',

		"alt" => '',

		"url" => ''

      ), $atts));

	  

	  if($align=="center"){

		 return '<img src="'.$url.'" class="img-'.$type.' resimg'.$align.'" alt="'.$alt.'" />';

	  }else{

		 return '<img src="'.$url.'" class="img-'.$type.' align-'.$align.' '.$align.' resimg'.$align.'" alt="'.$alt.'" />'; 

	  }

      

    }

	add_shortcode('webbu_image', 'webbu_image');

	

/*-----------------------------------------------------------------------------------*/

/*	Button Group Shortcodes

/*-----------------------------------------------------------------------------------*/  

function webbu_buttong( $atts, $content = null ) {

      extract(shortcode_atts(array(

	  'align' => ''

      ), $atts));



      return '<div class="btn-toolbar '.$align.'"><div class="btn-group">' . do_shortcode( $content ) . '</div></div>';

    }

	add_shortcode('webbu_buttong', 'webbu_buttong');

	

// [video type="" src=""][/video]-------------------------------------------------------------------------------

function webbu_video($atts, $shortcodecontent = null) { 

	extract(shortcode_atts(array( 

		"type" => '',

		"src" => ''

    ), $atts));

	

	if ( $type == "youtube"){

	$output = '<div><iframe class="VimeoPlayer" src="http://www.youtube.com/embed/' . $src . '?hd=1&wmode=opaque&autohide=1&showinfo=0"/></iframe></div>'; 

	}elseif ( $type == "vimeo"){

	$output = '<div><iframe class="VimeoPlayer" src="http://player.vimeo.com/video/' . $src . '?api=1&player_id=player_1"/></iframe></div>'; 

	}

	return $output; 

};  

add_shortcode( 'webbu_video', 'webbu_video' );







/*-----------------------------------------------------------------------------------*/

/*	Image Tile Shortcodes

/*-----------------------------------------------------------------------------------*/	

function webbu_imgtile( $atts, $content = null ) {

      extract(shortcode_atts(array(

		"color" => 'white',

		"url" => '',

		"pi" => '',

		"size" => '',

		"iurl" => '',

		"alt" => '',

		"sname" => '',

		"sicon" => '',

		"scolor" => ''

      ), $atts));

	  

	  

	  	  

		  if($url != "" or $pi != ""){

	  	  $output = "<a";

		  

			  if($url != ""){ $output .= " href='".$url."' "; }

			  

			  if($pi != "" and $url == ""){ $output .= " href='?page_id=".$pi."' "; }

			  

		  }elseif($url == "" and $pi == ""){

			  

			  $output = "<div";

		  }

		  

		  $output .= " class='tile";

		  

		  if($color != ""){ $output .= " ".$color.""; }

		  

		  

		  if($size != ""){ $output .= " ".$size.""; }

		  

		  

		  $output .= " image'>";

		  

		  //Tags End

	  

	  

	  $output .= "<div class='boxContent'>";

	  $output .= "<img src='".$content."' alt='".$alt."'>";

	  $output .= "</div>";

	  

	  $output .= "<div class='tilename ".$scolor."'>";

	  

	  if($sicon == ""){ $output .= "<div class='name'>".$sname."</div>"; }else{ $output .= "<div class='icon'><i class='".$sicon."'></i></div>"; };

	  

	  $output .= "</div>";

	  

	  if($url != "" or $pi != ""){

	  	$output .= "</a>";

	  }else{

		$output .= "</div>";

	  }

      

	  return $output;

    }

	add_shortcode('webbu_imgtile', 'webbu_imgtile');

	

/*-----------------------------------------------------------------------------------*/

/*	Video Tile Shortcodes

/*-----------------------------------------------------------------------------------*/	

function webbu_videotile( $atts, $content = null ) {

      extract(shortcode_atts(array(

		"size" => '',

		"type" => '',

		"src" => ''

      ), $atts));

	  

	  

	  	  

		 

		  $output = "<div";

		  $output .= " class='tile";



		  if($size != ""){ $output .= " ".$size.""; }

		  

		  $output .= " image'>";

		  

		  //Tags End

	  

	  

		  $output .= "<div class='boxContent'>";

				if ( $type == "youtube"){

				$output .= '<div><iframe class="videotile" src="http://www.youtube.com/embed/' . $src . '?hd=1&wmode=opaque&autohide=1&showinfo=0"/></iframe></div>'; 

				}elseif ( $type == "vimeo"){

				$output .= '<div><iframe class="videotile" src="http://player.vimeo.com/video/' . $src . '?api=1&player_id=player_1"/></iframe></div>'; 

				}

		  $output .= "</div>";

	

		  $output .= "</div>";



      

	  return $output;

    }

	add_shortcode('webbu_videotile', 'webbu_videotile');



/*-----------------------------------------------------------------------------------*/

/*	Map Tile Shortcodes

/*-----------------------------------------------------------------------------------*/	

function webbu_maptile( $atts, $content = null ) {

      extract(shortcode_atts(array(

		"size" => '',

		"type" => '',

		"src" => '',

		"address" => ''

      ), $atts));

	  

	  

	  	  

		 

		  $output = "<div";

		  $output .= " class='tile";



		  if($size != ""){ $output .= " ".$size.""; }

		  

		  $output .= " image'>";

		  

		  //Tags End

	  

	  

		  $output .= "<div class='boxContent'>";

				$output .= '<iframe class="maptile" scrolling="no" src="http://maps.google.com/maps?q=' . $address . '&output=embed"></iframe>'; 

		  $output .= "</div>";

	

		  $output .= "</div>";



      

	  return $output;

    }

	add_shortcode('webbu_maptile', 'webbu_maptile');

	

/*-----------------------------------------------------------------------------------*/

/*	Icon Tile Shortcodes

/*-----------------------------------------------------------------------------------*/	

function webbu_icontile( $atts, $content = null ) {

      extract(shortcode_atts(array(

		"color" => 'white',

		"url" => '',

		"pi" => '',

		"size" => '',

		"iurl" => '',

		"sname" => '',

		"sicon" => '',

		"scolor" => '',

		"imgicon" => ''

      ), $atts));

	  

	  

	  	  

		  if($url != "" or $pi != ""){

			  $output = "<a";

			  

			  if($url != ""){ $output .= " href='".$url."' "; }

			  

			  if($pi != "" and $url == ""){ $output .= " href='?page_id=".$pi."' "; }

		  }elseif($url == "" and $pi == ""){

			  

			  $output = "<div";

		  }

		  

		  $output .= " class='tile";

		  

		  if($color != ""){ $output .= " ".$color.""; }

		  

		  

		  if($size != ""){ $output .= " ".$size.""; }

		  

		  

		  $output .= " iconmain'>";

		  

		  //Tags End

	  

	  

	  $output .= "<div class='boxContent'>";

	  if($imgicon == ""){

	  $output .= "<i class='".$content."'></i>";

	  }else{

	  $output .= "<img src='".$imgicon."' class='resimgicon' alt=''/>";

	  }

	  $output .= "</div>";

	  

	  $output .= "<div class='tilename ".$scolor."'>";

	  

	  if($sicon == ""){ $output .= "<div class='name'>".$sname."</div>"; }else{ $output .= "<div class='icon'><i class='".$sicon."'></i></div>"; };

	  

	  $output .= "</div>";

	  

	  if($url != "" or $pi != ""){

	  	$output .= "</a>";

	  }else{

		$output .= "</div>";

	  }

      

	  return $output;

    }

	add_shortcode('webbu_icontile', 'webbu_icontile');	



/*-----------------------------------------------------------------------------------*/

/*	Image Slider Tile Shortcodes

/*-----------------------------------------------------------------------------------*/	

function webbu_slidertile( $atts, $content = null ) {

      extract(shortcode_atts(array(

		"color" => 'white',

		"url" => '',

		"pi" => '',

		"size" => '',

		"st" => '7000',

		"tp" => '1500',

      ), $atts));

	  

	  	  $random = substr(md5(time() * rand()),0,10);

		  

	  	  $output ="<script>";

		  $output .="jQuery(function(){";

		  $output .="jQuery('.".$random."').camera({";

		  $output .="height: 'auto',";

		  $output .="loader: 'bar',";

		  $output .="pagination: false,";

		  $output .="thumbnails: false,";

		  $output .="time: ".$st.",";

		  $output .="transPeriod: ".$tp.",";

		  $output .="});";

		  $output .="});";

		  $output .="</script>";

		  

		  if($url != "" or $pi != ""){

			  $output .= "<a";

			  

			  if($url != ""){ $output .= " href='".$url."' "; }

			  

			  if($pi != "" and $url == ""){ $output .= " href='?page_id=".$pi."' "; }

		  

		  }elseif($url == "" and $pi == ""){

			  

			  $output .= "<div";

			  

		  }

		  

		  

		  $output .= " class='tile";

		  

		  if($color != ""){ $output .= " ".$color.""; }

		  

		  

		  if($size != ""){ $output .= " ".$size.""; }

		  

		  

		  $output .= "'>";

		  

		  $output .= "<div class='boxContent ".$random." camera_wrap' style='padding:0px;'>";

	  

	  

	  $output .= do_shortcode($content);

	  

	  if($url != "" or $pi != ""){

		$output .= "</div>";

	  	$output .= "</a>";

	  }else{

		$output .= "</div>";

		$output .= "</div>";

	  }

      

	  return $output;

    }

	add_shortcode('webbu_slidertile', 'webbu_slidertile');

	

	

	function webbu_simgtile( $atts, $content = null ) {

      extract(shortcode_atts(array(), $atts));

	  

	  


	  

	  $output = "<div data-src='".$content."'></div>";

		  

	  return $output;

    }

	add_shortcode('webbu_simgtile', 'webbu_simgtile');







?>