(function ()
{
	// create webbuShortcodes plugin
	tinymce.create("tinymce.plugins.webbuShortcodes",
	{
		init: function ( ed, url )
		{
			ed.addCommand("webbuPopup", function ( a, params )
			{
				var popup = params.identifier;
				
				// load thickbox
				tb_show("Insert Webbu Shortcode", url + "/popup.php?popup=" + popup + "&width=" + 800);
			});
		},

		createControl: function ( btn, e )
		{
			if ( btn == "webbu_button" )
			{	
				var a = this;
				
				var btn = e.createSplitButton('webbu_button', {
                    title: "Insert Webbu Shortcode",
					image: webbuShortcodes.plugin_folder +"/tinymce/images/icon.png",
					icons: false
                });

                btn.onRenderMenu.add(function (c, b)
				{	
					a.addWithPopup( b, "Tile with Image", "tileimage" );
					a.addWithPopup( b, "Tile with Icon", "tileicon" );
					a.addWithPopup( b, "Tile with Slider", "tileslider" );
					a.addWithPopup( b, "Tile with Video", "tilevideo" );
					a.addWithPopup( b, "Tile with Map", "tilemap" );
					
					a.addWithPopup( b, "Image", "image" );
					a.addWithPopup( b, "Clear", "clear" );
					a.addWithPopup( b, "Dividers", "dividers" );				
					a.addWithPopup( b, "Alerts", "alert" );
					a.addWithPopup( b, "Button Group", "buttong" );
					a.addWithPopup( b, "Buttons", "button" );
					a.addWithPopup( b, "Badges", "badges" );
					a.addWithPopup( b, "Labels", "labels" );
					a.addWithPopup( b, "Blockquote", "blockquote" );
					a.addWithPopup( b, "Columns", "columns" );
					a.addWithPopup( b, "Tabs", "tabs" );
					a.addWithPopup( b, "Toggle", "toggle" );
					a.addWithPopup( b, "Table", "table" );
					a.addWithPopup( b, "Icon", "icon" );
					a.addWithPopup( b, "Well Box", "wells" );
					a.addWithPopup( b, "Google Map", "googlemap" );
					a.addWithPopup( b, "Twitter Page", "twitter" );
					a.addWithPopup( b, "Video", "video" );

				});
                
               return btn;
				
				
			}
			
				
			
			return null;
		},
		
		addWithPopup: function ( ed, title, id ) {
			ed.add({
				title: title,
				onclick: function () {
					tinyMCE.activeEditor.execCommand("webbuPopup", false, {
						title: title,
						identifier: id
					})
				}
			})
		},
		addImmediate: function ( ed, title, sc) {
			ed.add({
				title: title,
				onclick: function () {
					tinyMCE.activeEditor.execCommand( "mceInsertContent", false, sc )
				}
			})
		},
		getInfo: function () {
			return {
				longname: 'Webbu Shorcodes',
				author: 'Webbu',
				authorurl: 'http://themeforest.net/user/Webbu/',
				infourl: '',
				version: "1.0"
			}
		}
	});
	
	// add webbuShortcodes plugin
	tinymce.PluginManager.add("webbuShortcodes", tinymce.plugins.webbuShortcodes);

})();

