<?php
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');

	if ( post_password_required() ) { ?>
		<p class="nocomments"><?php printf ( __( 'This post is password protected. Enter the password to view comments.' , THEME_NAME ));?></p>
	<?php
		return;
	}
?>
<?php //You can start editing here. ?>

	<div class="post-title">
		<b><?php printf ( __( 'Comments' , THEME_NAME ));?></b>
	</div>
<?php if ( have_comments() && comments_open()) : ?>

		<ol>
			<?php wp_list_comments('type=comment&callback=orangethemes_comment'); ?>
		</ol>

 <?php else : // this is displayed if there are no comments so far ?>

	<?php if ( comments_open() ) : ?>
		<!-- If comments are open, but there are no comments. -->
		<div class="no-comments">
		<p><span><?php printf ( __( 'No comments yet.' , THEME_NAME ));?></span></p>
		<p><?php printf ( __( 'Be first to leave your comment!' , THEME_NAME ));?></p>
		</div>
	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
		<p class="no-comments"><?php printf ( __( 'Comments are closed' , THEME_NAME ));?></p>

	<?php endif; ?>
<?php endif; ?>


<?php if ( comments_open() ) : ?>


<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
<p><?php printf ( __( 'Only <a href="%1$s"> registered </a> users can comment.', THEME_NAME ), wp_login_url( get_permalink() ));?> </p>
<?php else : ?>

	<!-- BEGIN .add-comment -->
	<div class="add-comment">
	<a href="#" name="respond"></a>
		<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
		
			<table>
			<?php if ( is_user_logged_in() ) : ?>
				<p><?php printf ( __( 'Logged in as <a href="%1$s/wp-admin/profile.php"> %2$s </a>. <a href="%3$s" title="Log out of this account">Log out &raquo;</a>', THEME_NAME ), get_option('siteurl'), $user_identity, wp_logout_url(get_permalink()));?></p>

			<?php else : ?>
			
				<tr>
					<td class="label"><?php printf ( __( 'Nickname' , THEME_NAME ));?>:</td>
					<td><p><input type="text" name="author" id="author" value="<?php echo esc_attr($comment_author); ?>" <?php if ($req) echo "aria-required='true'"; ?> class="input-text-1" /></p></td>
				</tr>
				<tr><td class="spacer-1" colspan="2"></td></tr>
				<tr>
					<td class="label"><?php printf ( __( 'E-mail' , THEME_NAME ));?>:</td>
					<td><p><input type="text" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>" <?php if ($req) echo "aria-required='true'"; ?> class="input-text-1" /></p></td>
				</tr>
				<tr><td class="spacer-1" colspan="2"></td></tr>
				<tr>
					<td class="label"><?php printf ( __( 'Homepage' , THEME_NAME ));?>:</td>
					<td><p><input type="text" name="url" id="url" value="<?php echo $comment_author_url ?>" <?php if ($req) echo "aria-required='true'"; ?> class="input-text-1" /></p></td>
				</tr>
				<tr><td class="spacer-1" colspan="2"></td></tr>
			<?php endif; // If registration required and not logged in ?>
				
				<tr>
					<td class="label"><?php printf ( __( 'Your comment' , THEME_NAME ));?>:</td>
					<td>
						<textarea name="comment" id="comment" class="text-area-1"></textarea>
					</td>
				</tr>
				<tr><td class="spacer-2" colspan="2"></td></tr>
				<tr>
					<td></td>
					<td><p class="show-all"><a href="#" onclick="document.getElementById('commentform').submit(); return false;" class="btn-1 btn-1-color-default"><span><?php printf ( __( 'Add your comment' , THEME_NAME ));?></span></a></p></td>
				</tr>
			</table>
			<?php comment_id_fields(); ?>
			<?php do_action('comment_form', $post->ID); ?>
			
		</form>
	<!-- END .add-comment -->
	</div>

<?php endif; // if you delete this the sky will fall on your head ?>

<?php endif; ?>