<?php

$homepage = get_option( 'show_on_front');
$meta = get_post_custom_values("_wp_page_template",get_option( 'page_on_front'));
if($homepage == "page" && $meta[0] == "template-homepage.php") {$has_homepage=true;} else {$has_homepage=false;}

	
function register_my_menus() {
	if ( function_exists( 'register_nav_menus' ) ) {
		register_nav_menus(
			array( 'top_menu' => __( 'Top Menu' ))
		);
	}	
}

function create_gallery() {
	$gallery_args = array(
    	'label' => __('Gallery'),
    	'singular_label' => __('Gallery'),
    	'public' => true,
    	'show_ui' => true,
    	'capability_type' => 'post',
    	'hierarchical' => false,
    	'rewrite' => true,
    	'supports' => array('title', 'editor', 'thumbnail')
    );
	register_post_type('gallery',$gallery_args);
}


function orange_register_sidebar($name, $id){
	register_sidebar(array('name'=>$name,
		'id' => $id,
		'before_widget' => '<div class="sidebar-item">',
        'after_widget' => '</div>',
        'before_title' => '<div class="sidebar-title"><b>',
        'after_title' => '</b></div>'
	));
}


/* -------------------------------------------------------------------------*
 * 							DEFAULT SIDEBARS								*
 * -------------------------------------------------------------------------*/

$orange_sidebars=array(array('name'=>'Default Sidebar', 'id'=>'default'));	
	
$sidebar_strings = get_option(THEME_NAME.'_sidebar_names');
$generated_sidebars = explode("|*|", $sidebar_strings);
array_pop($generated_sidebars);
$orange_generated_sidebars=array();
	
foreach($generated_sidebars as $sidebar) {
	$orange_sidebars[]=array('name'=>$sidebar, 'id'=>convert_to_class($sidebar));
	$orange_generated_sidebars[]=array('name'=>$sidebar, 'id'=>convert_to_class($sidebar));
}
 
 /* -------------------------------------------------------------------------*
 * 							REGISTER ALL SIDEBARS
 * -------------------------------------------------------------------------*/

if (function_exists('register_sidebar')) {
	
	//register the sidebars
	foreach($orange_sidebars as $sidebar){
		orange_register_sidebar($sidebar['name'], $sidebar['id']);
	}
	
}

add_action('init', 'create_gallery');
add_action('init', 'register_my_menus' );
add_theme_support( 'post-thumbnails' );
?>