<?php
add_action('widgets_init', create_function('', 'return register_widget("kernel_triple_box");'));

class kernel_triple_box extends WP_Widget {
	function kernel_triple_box() {
		 parent::WP_Widget(false, $name = 'Kernel Triple Box');	
	}

	function form($instance) {
		 $title = esc_attr($instance['title']);
		 $count = esc_attr($instance['count']);
        ?>
            <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php printf ( __( 'Title:' , 'kernel' )); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>			
			
			<p><label for="<?php echo $this->get_field_id('count'); ?>"><?php printf ( __( 'Post count:' , 'kernel' )); ?> <input class="widefat" id="<?php echo $this->get_field_id('count'); ?>" name="<?php echo $this->get_field_name('count'); ?>" type="text" value="<?php echo $count; ?>" /></label></p>
			
        <?php 
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['count'] = strip_tags($new_instance['count']);
		return $instance;
	}

	function widget($args, $instance) {
		extract( $args );
        $title = apply_filters('widget_title', $instance['title']);
		$count = $instance['count'];
		$widget_id = $args['widget_id'];
		
        ?>
		
				
				<?php echo $before_widget; ?>
								<!-- BEGIN .latest-activity -->
								<div class="latest-activity">

									<!-- BEGIN .main-title -->
									<div class="sidebar-title">
										<b><?php if ( $title ) { echo $title; } ?></b>
									<!-- END .main-title -->
									</div>
									<!-- BEGIN .tabs-1 -->
									<div class="tabs-1">
										<table>
											<tr>
												<td><a href="#" class="tab-1 kernel_triple_btn active" id="kernel_triple_popular_btn_<?php echo $widget_id;?>"><span><?php printf ( __( 'Popular' , 'kernel' ));?></span></a></td>
												<td><a href="#" class="tab-1 tab-1-disabled kernel_triple_btn" id="kernel_triple_recent_btn_<?php echo $widget_id;?>"><span><?php printf ( __( 'Recent' , 'kernel' ));?></span></a></td>
												<td><a href="#" class="tab-1 tab-1-disabled kernel_triple_btn" id="kernel_triple_comments_btn_<?php echo $widget_id;?>"><span><?php printf ( __( 'Comments' , 'kernel' ));?></span></a></td>
											</tr>
										</table>
									<!-- END .tabs-1 -->
									</div>
								
									
									<div id="kernel_triple_popular_<?php echo $widget_id;?>">
											<?php
												add_filter( 'posts_where', 'filter_where' );
												$args=array(
												   'posts_per_page' => $count,
												   'orderby' => 'comment_count',
												   'post_type'=> 'post'
												);
												$the_query = new WP_Query($args);
												$myposts = get_posts( $args );	
												$count_total = count($myposts);
												remove_filter( 'posts_where', 'filter_where' );
											?>
											<?php $counter=1; ?>
											<div class="last">
											<?php if ($the_query->have_posts()) : while ($the_query->have_posts()) : $the_query->the_post(); ?>
											<!-- BEGIN .item -->
											<div class="item">
												<div class="image">
												<?php $image = get_post_thumb($the_query->post->ID,60,60); ?>
													<a href="<?php the_permalink();?>"><img src="<?php if($image['src']) { echo $image['src']; } ?>" alt="<?php the_title();?>" width="60" height="60" /></a>
												</div>
												<div class="text">
													<h5><a href="<?php the_permalink();?>"><?php the_title();?></a></h5>
													<p><a href="<?php the_permalink();?>" class="more-link"><span><?php printf ( __( 'Read more' , 'kernel' ));?></span></a></p>
												</div>
											<!-- END .item -->
											</div>
											

											<?php $counter++; ?>
											<?php endwhile; else: ?>
											<p><?php printf ( __( 'No posts where found' , 'kernel' ));?></p>
											<?php endif; ?>
											</div>
									</div>
									<div id="kernel_triple_recent_<?php echo $widget_id;?>" style="display: none;">
											<?php
												$args=array(
												   'posts_per_page'=> $count,
												   'post_type'=> 'post'
												);
												$the_query = new WP_Query($args);
												$myposts = get_posts( $args );	
												$count_total = count($myposts);
											?>
											<?php $counter=1; ?>
											<div class="last">
											<?php if ($the_query->have_posts()) : while ($the_query->have_posts()) : $the_query->the_post(); ?>
											<!-- BEGIN .activity-item -->
											<div class="item">
												<div class="image">
												<?php $image = get_post_thumb($the_query->post->ID,60,60); ?>
													<a href="<?php the_permalink();?>"><img src="<?php if($image['src']) { echo $image['src']; } ?>" alt="<?php the_title();?>" width="60" height="60" /></a>
												</div>
												<div class="text">
													<h5><a href="<?php the_permalink();?>"><?php the_title();?></a></h5>
													<p><a href="<?php the_permalink();?>" class="more-link"><span><?php printf ( __( 'Read more' , 'kernel' ));?></span></a></p>
												</div>
											<!-- END .item -->
											</div>
											
											<?php $counter++; ?>
											<?php endwhile; else: ?>
											<p><?php printf ( __( 'No posts where found' , 'kernel' ));?></p>
											<?php endif; ?>
											</div>
									</div>
									<div id="kernel_triple_comments_<?php echo $widget_id;?>" style="display: none;">
											<?php
											
												$comments = get_comments( 
													array(
														'status' => 'approve', 
														'order' => 'DESC',
														'number' => '30'
													)
												);
												
												if ( $comments ) {
													foreach($comments as $c) {
														$ids[] = $c->comment_post_ID ;
														
													}
													
													$ids=array_unique($ids);
													$ids=array_slice($ids, 0, $count);
												} else {
													$ids=0;
												}
												$args=array(
												'post__in' => $ids,
												   'posts_per_page'=> $count,
												   'post_type'=> 'any',
												   'order'=> 'ASC'
												);
												
												$myposts = get_posts( $args );	
												$count_total = count($myposts);
												
												$the_query = new WP_Query($args);
												
											?>
											<?php $counter=1; ?>
											<div class="list">
											<?php if ($the_query->have_posts()) : while ($the_query->have_posts()) : $the_query->the_post(); ?>
											<!-- BEGIN .item -->
											
											<div class="item">
												<div class="image">
												<?php $image = get_post_thumb($the_query->post->ID,60,60); ?>
													<a href="<?php the_permalink();?>"><img src="<?php if($image['src']) { echo $image['src']; } ?>" alt="<?php the_title();?>" width="60" height="60" /></a>
												</div>
												<div class="text">
													<h5><a href="<?php the_permalink();?>"><?php the_title();?></a></h5>
													<p><a href="<?php the_permalink();?>" class="more-link"><span><?php printf ( __( 'Read more' , 'kernel' ));?></span></a></p>
												</div>
											<!-- END .activity-item -->
											</div>
											<?php $counter++; ?>
											<?php endwhile; else: ?>
											<p><?php printf ( __( 'No posts where found' , 'kernel' )); ?></p>
											<?php endif; ?>
									
											</div>
									</div>
								<!-- END .latest-activity -->
								</div>
					
					

				<?php echo $after_widget; ?>

        <?php
	}
}
?>