<?php

$kopa_layout = array(
    'home' => array(
        'title'      => __( 'Home', kopa_get_domain() ),
        'thumbnails' => 'home-page.jpg',
        'positions'  => array(
            'position_1',
            'position_2',
            'position_3',
            'position_4',
            'position_5',
            'position_6',
            'position_7',
            'position_8',
            'position_9',
            'position_10',
            'position_11',        
            'position_12',        
            'position_13'        
        )
    ),
    'blog' => array(
        'title'      => __( 'Blog Right Sidebar', kopa_get_domain() ),
        'thumbnails' => 'blog.jpg',
        'positions'  => array(
            'position_1',
            'position_14',
            'position_10',
            'position_11',
            'position_12',
            'position_13'
        )
    ),
    'page-right-sidebar' => array(
        'title'      => __( 'Page Right Sidebar', kopa_get_domain() ),
        'thumbnails' => 'page.jpg',
        'positions'  => array(
            'position_1',
            'position_16',
            'position_10',
            'position_11',
            'position_12',
            'position_13'
        )
    ),
    'single-right-sidebar' => array(
        'title'      => __( 'Single Right Sidebar', kopa_get_domain() ),
        'thumbnails' => 'single.jpg',
        'positions'  => array(
            'position_1',
            'position_15',
            'position_10',
            'position_11',
            'position_12',
            'position_13'
        )
    ),
    'error-404' => array(
        'title' => __( '404 Page', kopa_get_domain() ),
        'thumbnails' => 'error-404.jpg',
        'positions' => array(
            'position_1',
            'position_10',
            'position_11',
            'position_12',
            'position_13',
        ),
    ),
);

$kopa_sidebar_position = array(
    'position_1'  => array('title' => '工具栏 1'),
    'position_2'  => array('title' => '工具栏 2'),
    'position_3'  => array('title' => '工具栏 3'),
    'position_4'  => array('title' => '工具栏 4'),
    'position_5'  => array('title' => '工具栏 5'),
    'position_6'  => array('title' => '工具栏 6'),
    'position_7'  => array('title' => '工具栏 7'),
    'position_8'  => array('title' => '工具栏 8'),
    'position_9'  => array('title' => '工具栏 9'),
    'position_10' => array('title' => '工具栏 10'),
    'position_11' => array('title' => '工具栏 11'),
    'position_12' => array('title' => '工具栏 12'),
    'position_13' => array('title' => '工具栏 13'),
    'position_14' => array('title' => '工具栏 14'),
    'position_15' => array('title' => '工具栏 15'),
    'position_16' => array('title' => '工具栏 16'),
    'position_17' => array('title' => '工具栏 17')
);

$kopa_template_hierarchy = array(
    'home'       => array(
        'title'  => __( '博客', kopa_get_domain() ),
        'layout' => array('blog')
    ),
    'front-page' => array(
        'title'  => __( '首页', kopa_get_domain() ),
        'layout' => array('home')
    ),
    'post'       => array(
        'title'  => __( '文章', kopa_get_domain() ),
        'layout' => array('single-right-sidebar')
    ),
    'page'       => array(
        'title'  => __( '页面', kopa_get_domain() ),
        'layout' => array('home', 'page-right-sidebar')
    ),
    'taxonomy'   => array(
        'title'  => __( '分类', kopa_get_domain() ),
        'layout' => array('blog')
    ),
    'search'     => array(
        'title'  => __( '搜索', kopa_get_domain() ),
        'layout' => array('blog')
    ),
    'archive'    => array(
        'title'  => __( '存档', kopa_get_domain() ),
        'layout' => array('blog')
    ),
    '_404'    => array(
        'title'  => __( '404', kopa_get_domain() ),
        'layout' => array('error-404')
    )
);

define('KOPA_INIT_VERSION', 'forceful-setting-version-7');
define('KOPA_LAYOUT', serialize($kopa_layout));
define('KOPA_SIDEBAR_POSITION', serialize($kopa_sidebar_position));
define('KOPA_TEMPLATE_HIERARCHY', serialize($kopa_template_hierarchy));

function kopa_initial_database() {
    $kopa_is_database_setup = get_option('kopa_is_database_setup');
    if ($kopa_is_database_setup !== KOPA_INIT_VERSION) {
        $kopa_setting = array(
            'home' => array(
                'layout_id' => 'blog',
                'sidebars'  => array(
                    'sidebar_1',
                    'sidebar_14',
                    'sidebar_10',
                    'sidebar_11',
                    'sidebar_12',
                    'sidebar_13'
                )
            ),
            'front-page' => array(
                'layout_id' => 'home',
                'sidebars'  => array(
                    'sidebar_1',
                    'sidebar_2',
                    'sidebar_3',
                    'sidebar_4',
                    'sidebar_5',
                    'sidebar_6',
                    'sidebar_7',
                    'sidebar_8',
                    'sidebar_9',
                    'sidebar_10',
                    'sidebar_11',
                    'sidebar_12',
                    'sidebar_13'
                )
            ),
            'post' => array(
                'layout_id' => 'single-right-sidebar',
                'sidebars'  => array(
                    'sidebar_1',
                    'sidebar_15',
                    'sidebar_10',
                    'sidebar_11',
                    'sidebar_12',
                    'sidebar_13'
                )
            ),
            'page' => array(
                'layout_id' => 'page-right-sidebar',
                'sidebars'  => array(
                    'sidebar_1',
                    'sidebar_16',
                    'sidebar_10',
                    'sidebar_11',
                    'sidebar_12',
                    'sidebar_13'
                )
            ),
            'taxonomy' => array(
                'layout_id' => 'blog',
                'sidebars'  => array(
                    'sidebar_1',
                    'sidebar_17',
                    'sidebar_10',
                    'sidebar_11',
                    'sidebar_12',
                    'sidebar_13'
                )
            ),
            'search' => array(
                'layout_id' => 'blog',
                'sidebars'  => array(
                    'sidebar_1',
                    'sidebar_17',
                    'sidebar_10',
                    'sidebar_11',
                    'sidebar_12',
                    'sidebar_13'
                )
            ),
            'archive' => array(
                'layout_id' => 'blog',
                'sidebars'  => array(
                    'sidebar_1',
                    'sidebar_17',
                    'sidebar_10',
                    'sidebar_11',
                    'sidebar_12',
                    'sidebar_13'
                )
            ),
            '_404' => array(
                'layout_id' => 'error-404',
                'sidebars'  => array(
                    'sidebar_1',
                    'sidebar_10',
                    'sidebar_11',
                    'sidebar_12',
                    'sidebar_13'
                )
            ),
        );
        $kopa_sidebar = array(
            'sidebar_hide' => '-- 无 --',
            'sidebar_1'    => '工具栏 1',
            'sidebar_2'    => '工具栏 2',
            'sidebar_3'    => '工具栏 3',
            'sidebar_4'    => '工具栏 4',
            'sidebar_5'    => '工具栏 5',
            'sidebar_6'    => '工具栏 6',
            'sidebar_7'    => '工具栏 7',
            'sidebar_8'    => '工具栏 8',
            'sidebar_9'    => '工具栏 9',
            'sidebar_10'   => '工具栏 10',
            'sidebar_11'   => '工具栏 11',
            'sidebar_12'   => '工具栏 12',
            'sidebar_13'   => '工具栏 13',
            'sidebar_14'   => '工具栏 14',
            'sidebar_15'   => '工具栏 15',
            'sidebar_16'   => '工具栏 16',
            'sidebar_17'   => '工具栏 17'
        );
        update_option('kopa_setting', $kopa_setting);
        update_option('kopa_sidebar', $kopa_sidebar);
        update_option('kopa_is_database_setup', KOPA_INIT_VERSION);
    }

    $kopa_sidebar = get_option('kopa_sidebar');

    foreach ($kopa_sidebar as $key => $value) {
        if ('sidebar_hide' != $key) {
            register_sidebar(array(
                'name'          => $value,
                'id'            => $key,
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h4 class="widget-title">',
                'after_title'   => '</h4>'
            ));
        }
    }
}