/*
* Post rating for dynamically generate rating fields in post meta box
* version 1.0 - 24/09/2013
*/

(function(){
    jQuery('#kopa-rating-add').on('click', function(e){
        e.preventDefault();
        var fieldWrapperList = jQuery('#kopa-rating-wrapper .kopa-field-wrapper'),
            intId = fieldWrapperList.length ? fieldWrapperList.last().data('id') + 1 : 0,
            fieldWrapper = jQuery('<p id="kopa-rating-field-'+intId+'" class="kopa-field-wrapper" data-id="'+intId+'">'),
            fieldLabel = jQuery('<label for="">Rating Name: </label>'),
            fieldInput = jQuery('<input name="kopa_editor_post_rating['+intId+'][name]" type="text">'),
            fieldSelect = jQuery('<select name="kopa_editor_post_rating['+intId+'][value]">'+
                '<option value="1">1 星</option>'+
                '<option value="2">2 星</option>'+
                '<option value="3">3 星</option>'+
                '<option value="4">4 星</option>'+
                '<option value="5">5 星</option>'+
                '</select>'),
            removeButton = jQuery('<button class="button kopa-remove-rating">删除</button>');
        
        // remove event for dynamic added content
        removeButton.on('click', function(e){
            e.preventDefault();

            if ( window.confirm('你确定你想要删除吗?') ) {
                jQuery(this).parent().remove();
            }
        });
        
        fieldWrapper.append(fieldLabel)
            .append(fieldInput)
            .append(fieldSelect)
            .append(removeButton);
        
        jQuery('#kopa-rating-wrapper').append(fieldWrapper);
        
    });
    
    jQuery('#kopa-rating-remove-all').on('click', function(e){
        e.preventDefault();
        if ( window.confirm('你确定要删除所有评分吗?') ) {
            jQuery('#kopa-rating-wrapper').children().remove();
        }
    });
    
    jQuery('.kopa-remove-rating').on('click', function(e){
        e.preventDefault();
        if ( window.confirm('你确定你想要删除吗?') ) {
            jQuery(this).parent().remove();
        }
    });
}());